/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xmi.framework;

import com.ibm.xmi.framework.ClassifierImpl;
import com.ibm.xmi.framework.Feature;
import com.ibm.xmi.framework.NoFeatureException;
import com.ibm.xmi.framework.XMIClass;
import com.ibm.xmi.framework.XMIException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Vector;

public class XMIClassImpl
extends ClassifierImpl
implements XMIClass {
    private static final String copyright = "Licensed Materials-Property of IBM\n(C) Copyright IBM Corp. 1999-2002. All Rights Reserved.\nUS Government Users Restricted Rights-Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    private Vector subclasses;
    private Vector superclasses;
    private Collection features;

    public XMIClassImpl(String string) {
        super(string);
    }

    public XMIClassImpl(String string, Collection collection) {
        super(string);
        this.features = collection;
    }

    public void add(Feature feature) {
        if (this.features == null) {
            this.features = new ArrayList(5);
        }
        this.features.add(feature);
        feature.setXMIOwner(this);
    }

    public void addSubclass(XMIClass xMIClass) {
        if (this.subclasses == null) {
            this.subclasses = new Vector(5);
        }
        this.subclasses.addElement(xMIClass);
    }

    public void addSuperclass(XMIClass xMIClass) {
        if (this.superclasses == null) {
            this.superclasses = new Vector(5);
        }
        this.superclasses.addElement(xMIClass);
    }

    public void delete(Feature feature) throws XMIException {
        if (this.features == null) {
            throw new NoFeatureException(feature);
        }
        boolean bl = this.features.remove(feature);
        if (!bl) {
            throw new NoFeatureException(feature);
        }
    }

    public void deleteSubclass(XMIClass xMIClass) {
        if (this.subclasses == null) {
            return;
        }
        this.subclasses.removeElement(xMIClass);
    }

    public void deleteSuperclass(XMIClass xMIClass) {
        if (this.superclasses == null) {
            return;
        }
        this.superclasses.removeElement(xMIClass);
    }

    public Collection getXMIFeatures() {
        if (this.features == null) {
            return new ArrayList(0);
        }
        return this.features;
    }

    public Feature getXMIFeature(String string) {
        if (this.features == null) {
            return null;
        }
        Iterator iterator = this.features.iterator();
        while (iterator.hasNext()) {
            Feature feature = (Feature)iterator.next();
            if (!feature.getXMIName().equals(string)) continue;
            return feature;
        }
        return null;
    }

    public Collection getXMISubclasses() {
        if (this.subclasses == null) {
            return new Vector(1);
        }
        return Collections.unmodifiableCollection(this.subclasses);
    }

    public Collection getXMISuperclasses() {
        if (this.superclasses == null) {
            return new Vector(1);
        }
        return Collections.unmodifiableCollection(this.superclasses);
    }

    public String toString() {
        String string = "XMIClass " + this.getXMIName();
        if (this.getXMIOwner() != null) {
            string = string + " owner: [" + this.getXMIOwner() + "]";
        }
        return string;
    }
}

