/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.application.studio;

import java.util.EventObject;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.freehep.application.studio.StudioListener;

public class EventSender {
    private Set listeners = new HashSet();

    EventSender() {
    }

    public void broadcast(EventObject event) {
        Iterator i = this.listeners.iterator();
        while (i.hasNext()) {
            ListenerEntry l = (ListenerEntry)i.next();
            if (!l.getEntryClass().isAssignableFrom(event.getClass())) continue;
            l.getListener().handleEvent(event);
        }
    }

    public boolean hasListeners(Class c) {
        return true;
    }

    public void addEventListener(StudioListener l, Class c) {
        this.listeners.add(new ListenerEntry(l, c));
    }

    public void removeEventListener(StudioListener l, Class c) {
        this.listeners.remove(new ListenerEntry(l, c));
    }

    private class ListenerEntry {
        private StudioListener l;
        private Class c;

        ListenerEntry(StudioListener l, Class c) {
            this.l = l;
            this.c = c;
        }

        public boolean equals(Object o) {
            if (o instanceof ListenerEntry) {
                ListenerEntry that = (ListenerEntry)o;
                return this.l == that.l && this.c == that.c;
            }
            return false;
        }

        public int hashCode() {
            return this.l.hashCode() + this.c.hashCode();
        }

        Class getEntryClass() {
            return this.c;
        }

        StudioListener getListener() {
            return this.l;
        }
    }
}

