/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.emf;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.io.IOException;
import java.io.InputStream;
import org.freehep.graphicsio.emf.EMFConstants;
import org.freehep.graphicsio.emf.EMFHeader;
import org.freehep.graphicsio.emf.EMFTagSet;
import org.freehep.util.io.ActionHeader;
import org.freehep.util.io.TagHeader;
import org.freehep.util.io.TaggedInputStream;

public class EMFInputStream
extends TaggedInputStream
implements EMFConstants {
    public static int DEFAULT_VERSION = 1;
    private EMFHeader header;

    public EMFInputStream(InputStream is) throws IOException {
        this(is, DEFAULT_VERSION);
    }

    public EMFInputStream(InputStream is, int version) throws IOException {
        this(is, new EMFTagSet(version));
    }

    public EMFInputStream(InputStream is, EMFTagSet tagSet) throws IOException {
        super(is, tagSet, null, true);
    }

    public int readDWORD() throws IOException {
        long i = this.readUnsignedInt();
        return (int)i;
    }

    public int[] readDWORD(int size) throws IOException {
        int[] x = new int[size];
        for (int i = 0; i < x.length; ++i) {
            x[i] = this.readDWORD();
        }
        return x;
    }

    public int readWORD() throws IOException {
        return this.readUnsignedShort();
    }

    public int readLONG() throws IOException {
        return this.readInt();
    }

    public int[] readLONG(int size) throws IOException {
        int[] x = new int[size];
        for (int i = 0; i < x.length; ++i) {
            x[i] = this.readLONG();
        }
        return x;
    }

    public float readFLOAT() throws IOException {
        return this.readFloat();
    }

    public int readUINT() throws IOException {
        return (int)this.readUnsignedInt();
    }

    public int readULONG() throws IOException {
        return (int)this.readUnsignedInt();
    }

    public Color readCOLORREF() throws IOException {
        Color c = new Color(this.readUnsignedByte(), this.readUnsignedByte(), this.readUnsignedByte());
        this.readByte();
        return c;
    }

    public Color readCOLOR16() throws IOException {
        return new Color(this.readShort() >> 8, this.readShort() >> 8, this.readShort() >> 8, this.readShort() >> 8);
    }

    public AffineTransform readXFORM() throws IOException {
        return new AffineTransform(this.readFLOAT(), this.readFLOAT(), this.readFLOAT(), this.readFLOAT(), this.readFLOAT(), this.readFLOAT());
    }

    public Rectangle readRECTL() throws IOException {
        int x = this.readLONG();
        int y = this.readLONG();
        int w = this.readLONG() - x;
        int h = this.readLONG() - y;
        return new Rectangle(x, y, w, h);
    }

    public Point readPOINTL() throws IOException {
        int x = this.readLONG();
        int y = this.readLONG();
        return new Point(x, y);
    }

    public Point[] readPOINTL(int size) throws IOException {
        Point[] p = new Point[size];
        for (int i = 0; i < p.length; ++i) {
            p[i] = this.readPOINTL();
        }
        return p;
    }

    public Point readPOINTS() throws IOException {
        short x = this.readShort();
        short y = this.readShort();
        return new Point(x, y);
    }

    public Point[] readPOINTS(int size) throws IOException {
        Point[] p = new Point[size];
        for (int i = 0; i < p.length; ++i) {
            p[i] = this.readPOINTS();
        }
        return p;
    }

    public Dimension readSIZEL() throws IOException {
        return new Dimension(this.readLONG(), this.readLONG());
    }

    public int readBYTE() throws IOException {
        return this.readByte();
    }

    public byte[] readBYTE(int size) throws IOException {
        byte[] x = new byte[size];
        for (int i = 0; i < x.length; ++i) {
            x[i] = (byte)this.readBYTE();
        }
        return x;
    }

    public boolean readBOOLEAN() throws IOException {
        return this.readBYTE() != 0;
    }

    public String readWCHAR(int size) throws IOException {
        byte[] bytes = this.readByte(2 * size);
        int length = 2 * size;
        for (int i = 0; i < 2 * size; i += 2) {
            if (bytes[i] != 0 || bytes[i + 1] != 0) continue;
            length = i;
            break;
        }
        return new String(bytes, 0, length, "UTF-16LE");
    }

    protected TagHeader readTagHeader() throws IOException {
        int tagID = this.read();
        if (tagID == -1) {
            return null;
        }
        tagID |= this.readUnsignedByte() << 8;
        tagID |= this.readUnsignedByte() << 16;
        long length = this.readDWORD();
        return new TagHeader(tagID |= this.readUnsignedByte() << 24, length - 8L);
    }

    protected ActionHeader readActionHeader() throws IOException {
        return null;
    }

    public EMFHeader readHeader() throws IOException {
        if (this.header == null) {
            this.header = new EMFHeader(this);
        }
        return this.header;
    }

    public int getVersion() {
        return DEFAULT_VERSION;
    }
}

