/*
 * Decompiled with CFR 0.152.
 */
package com.baselet.control.util;

import com.baselet.control.constants.SystemInfo;
import com.baselet.control.enums.Os;
import com.baselet.control.enums.Program;
import com.baselet.element.interfaces.GridElement;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Path {
    private static final Logger log = LoggerFactory.getLogger(Path.class);
    private static String tempDir;
    private static String homeProgramDir;

    public static boolean hasOsConformConfig() {
        try {
            File file = new File(Path.osConformConfig());
            return file.exists();
        }
        catch (Exception e) {
            log.error("Cannot load os conform config or cannot create UMLet parent dir in os conform home dir", (Throwable)e);
            return false;
        }
    }

    public static String osConformConfig() {
        String programConfigDir = Path.combine(Path.osConformConfigDirectory(), Program.getInstance().getProgramName());
        Path.ensureDirectoryIsExisting(programConfigDir);
        return Path.combine(programConfigDir, Program.getInstance().getConfigName());
    }

    @Deprecated
    public static boolean hasLegacyConfig() {
        File file = new File(Path.legacyConfig());
        return file.exists();
    }

    @Deprecated
    public static String legacyConfig() {
        String programConfigDirectory = Path.combine(Path.userHomeDirectory(), Program.getInstance().getProgramName());
        return Path.combine(programConfigDirectory, Program.getInstance().getConfigName());
    }

    private static void ensureDirectoryIsExisting(String path) {
        File file = new File(path);
        if (!file.exists()) {
            Path.safeMkDir(file, true);
        }
    }

    private static String osConformConfigDirectory() {
        String configDir = Path.userHomeDirectory();
        if (SystemInfo.OS == Os.WINDOWS) {
            configDir = Path.windowsConfigDirectory();
        } else if (SystemInfo.OS == Os.MAC) {
            configDir = Path.macOSXConfigDirectory();
        } else if (SystemInfo.OS == Os.LINUX || SystemInfo.OS == Os.UNIX) {
            configDir = Path.xgdConfigDirectory();
        }
        return configDir;
    }

    private static String windowsConfigDirectory() {
        String configPath = System.getenv("LOCALAPPDATA");
        if (configPath == null) {
            configPath = Path.userHomeDirectory();
        }
        return configPath;
    }

    private static String macOSXConfigDirectory() {
        return Path.combine(Path.userHomeDirectory(), "Library/Preferences");
    }

    private static String xgdConfigDirectory() {
        String configPath = System.getenv("XDG_CONFIG_HOME");
        if (configPath == null) {
            configPath = Path.combine(Path.userHomeDirectory(), ".config");
        }
        return configPath;
    }

    private static String userHomeDirectory() {
        return System.getProperty("user.home");
    }

    private static String combine(String path, String childPath) {
        return new File(path, childPath).getPath();
    }

    public static String customElements() {
        return Path.homeProgram() + "custom_elements/";
    }

    public static String temp() {
        if (tempDir == null) {
            String tmp = System.getProperty("java.io.tmpdir");
            if (!tmp.endsWith(File.separator)) {
                tmp = tmp + File.separator;
            }
            tempDir = tmp;
        }
        return tempDir;
    }

    public static String homeProgram() {
        return homeProgramDir;
    }

    public static void setHomeProgram(String homeProgramDir) {
        Path.homeProgramDir = homeProgramDir;
    }

    public static String executable() {
        return Path.executableHelper(Path.class);
    }

    public static String executableShared() {
        return Path.executableHelper(GridElement.class);
    }

    private static String executableHelper(Class<?> c) {
        String path = null;
        URL codeSourceUrl = c.getProtectionDomain().getCodeSource().getLocation();
        try {
            path = codeSourceUrl.toURI().getPath();
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        if (path == null) {
            path = codeSourceUrl.getPath().replace("%20", " ");
        }
        return path;
    }

    public static void safeCreateFile(File file, boolean errorIfFileExists) {
        try {
            boolean success = file.createNewFile();
            if (!success && errorIfFileExists) {
                throw new RuntimeException("Cannot create file " + file.getAbsolutePath() + " because it already exists");
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot create file " + file.getAbsolutePath());
        }
    }

    public static void safeDeleteFile(File file, boolean errorIfFailed) {
        boolean success = file.delete();
        if (!success && errorIfFailed) {
            throw new RuntimeException("Cannot delete file " + file.getAbsolutePath());
        }
    }

    public static void safeMkDir(File file, boolean errorIfFailed) {
        boolean success = file.mkdir();
        if (!success && errorIfFailed) {
            throw new RuntimeException("Cannot make dir " + file.getAbsolutePath());
        }
    }
}

