/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search;

import java.io.IOException;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.text.Text;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.shard.ShardId;

public class SearchShardTarget
implements Writeable,
Comparable<SearchShardTarget> {
    private final Text nodeId;
    private final ShardId shardId;

    public SearchShardTarget(StreamInput in) throws IOException {
        this.nodeId = in.readBoolean() ? in.readText() : null;
        this.shardId = ShardId.readShardId(in);
    }

    public SearchShardTarget(String nodeId, ShardId shardId) {
        this.nodeId = nodeId == null ? null : new Text(nodeId);
        this.shardId = shardId;
    }

    public SearchShardTarget(String nodeId, Index index, int shardId) {
        this(nodeId, new ShardId(index, shardId));
    }

    @Nullable
    public String getNodeId() {
        return this.nodeId.string();
    }

    public Text getNodeIdText() {
        return this.nodeId;
    }

    public String getIndex() {
        return this.shardId.getIndexName();
    }

    public ShardId getShardId() {
        return this.shardId;
    }

    @Override
    public int compareTo(SearchShardTarget o) {
        int i = this.shardId.getIndexName().compareTo(o.getIndex());
        if (i == 0) {
            i = this.shardId.getId() - o.shardId.id();
        }
        return i;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        if (this.nodeId == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.writeText(this.nodeId);
        }
        this.shardId.writeTo(out);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SearchShardTarget that = (SearchShardTarget)o;
        if (!this.shardId.equals(that.shardId)) {
            return false;
        }
        return !(this.nodeId != null ? !this.nodeId.equals(that.nodeId) : that.nodeId != null);
    }

    public int hashCode() {
        int result = this.nodeId != null ? this.nodeId.hashCode() : 0;
        result = 31 * result + (this.shardId.getIndexName() != null ? this.shardId.getIndexName().hashCode() : 0);
        result = 31 * result + this.shardId.hashCode();
        return result;
    }

    public String toString() {
        if (this.nodeId == null) {
            return "[_na_]" + this.shardId;
        }
        return "[" + this.nodeId + "]" + this.shardId;
    }
}

