/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.conflict.tags;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GraphicsEnvironment;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.ExpertToggleAction;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.TagCollection;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.ConditionalOptionPaneUtil;
import org.openstreetmap.josm.gui.DefaultNameFormatter;
import org.openstreetmap.josm.gui.conflict.tags.CombinePrimitiveResolver;
import org.openstreetmap.josm.gui.conflict.tags.RelationMemberConflictResolver;
import org.openstreetmap.josm.gui.conflict.tags.RelationMemberConflictResolverModel;
import org.openstreetmap.josm.gui.conflict.tags.TagConflictResolutionUtil;
import org.openstreetmap.josm.gui.conflict.tags.TagConflictResolver;
import org.openstreetmap.josm.gui.conflict.tags.TagConflictResolverModel;
import org.openstreetmap.josm.gui.help.ContextSensitiveHelpAction;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.gui.widgets.AutoAdjustingSplitPane;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.InputMapUtils;
import org.openstreetmap.josm.tools.StreamUtils;
import org.openstreetmap.josm.tools.UserCancelException;
import org.openstreetmap.josm.tools.WindowGeometry;

public class CombinePrimitiveResolverDialog
extends JDialog {
    private AutoAdjustingSplitPane spTagConflictTypes;
    private final TagConflictResolverModel modelTagConflictResolver;
    protected TagConflictResolver pnlTagConflictResolver;
    private final RelationMemberConflictResolverModel modelRelConflictResolver;
    protected RelationMemberConflictResolver pnlRelationMemberConflictResolver;
    private final CombinePrimitiveResolver primitiveResolver;
    private boolean applied;
    private JPanel pnlButtons;
    protected transient OsmPrimitive targetPrimitive;
    private ContextSensitiveHelpAction helpAction;
    private JButton btnApply;

    public CombinePrimitiveResolverDialog(Component component) {
        this(component, new TagConflictResolverModel(), new RelationMemberConflictResolverModel());
    }

    public CombinePrimitiveResolverDialog(Component component, TagConflictResolverModel tagConflictResolverModel, RelationMemberConflictResolverModel relationMemberConflictResolverModel) {
        super((Window)GuiHelper.getFrameForComponent(component), Dialog.ModalityType.DOCUMENT_MODAL);
        this.modelTagConflictResolver = tagConflictResolverModel;
        this.modelRelConflictResolver = relationMemberConflictResolverModel;
        this.primitiveResolver = new CombinePrimitiveResolver(tagConflictResolverModel, relationMemberConflictResolverModel);
        this.build();
    }

    public OsmPrimitive getTargetPrimitive() {
        return this.targetPrimitive;
    }

    public void setTargetPrimitive(OsmPrimitive osmPrimitive) {
        this.setTargetPrimitive(osmPrimitive, true);
    }

    private void setTargetPrimitive(OsmPrimitive osmPrimitive, boolean bl) {
        this.targetPrimitive = osmPrimitive;
        if (bl) {
            GuiHelper.runInEDTAndWait(this::updateTitle);
        }
    }

    protected void updateTitle() {
        if (this.targetPrimitive == null) {
            this.setTitle(I18n.tr("Conflicts when combining primitives", new Object[0]));
            return;
        }
        if (this.targetPrimitive instanceof Way) {
            this.setTitle(I18n.tr("Conflicts when combining ways - combined way is ''{0}''", this.targetPrimitive.getDisplayName(DefaultNameFormatter.getInstance())));
            this.helpAction.setHelpTopic(HelpUtil.ht("/Action/CombineWay#ResolvingConflicts"));
            this.getRootPane().putClientProperty("help", HelpUtil.ht("/Action/CombineWay#ResolvingConflicts"));
            this.pnlRelationMemberConflictResolver.initForWayCombining();
        } else if (this.targetPrimitive instanceof Node) {
            this.setTitle(I18n.tr("Conflicts when merging nodes - target node is ''{0}''", this.targetPrimitive.getDisplayName(DefaultNameFormatter.getInstance())));
            this.helpAction.setHelpTopic(HelpUtil.ht("/Action/MergeNodes#ResolvingConflicts"));
            this.getRootPane().putClientProperty("help", HelpUtil.ht("/Action/MergeNodes#ResolvingConflicts"));
            this.pnlRelationMemberConflictResolver.initForNodeMerging();
        }
    }

    protected final void build() {
        this.getContentPane().setLayout(new BorderLayout());
        this.updateTitle();
        this.spTagConflictTypes = new AutoAdjustingSplitPane(0);
        this.spTagConflictTypes.setTopComponent(this.buildTagConflictResolverPanel());
        this.spTagConflictTypes.setBottomComponent(this.buildRelationMemberConflictResolverPanel());
        this.pnlButtons = this.buildButtonPanel();
        this.getContentPane().add((Component)this.pnlButtons, "South");
        this.addWindowListener(new AdjustDividerLocationAction());
        HelpUtil.setHelpContext(this.getRootPane(), HelpUtil.ht("/"));
        InputMapUtils.addEscapeAction(this.getRootPane(), new CancelAction());
    }

    protected JPanel buildTagConflictResolverPanel() {
        this.pnlTagConflictResolver = new TagConflictResolver(this.modelTagConflictResolver);
        return this.pnlTagConflictResolver;
    }

    protected JPanel buildRelationMemberConflictResolverPanel() {
        this.pnlRelationMemberConflictResolver = new RelationMemberConflictResolver(this.modelRelConflictResolver);
        return this.pnlRelationMemberConflictResolver;
    }

    protected ApplyAction buildApplyAction() {
        return new ApplyAction();
    }

    protected JPanel buildButtonPanel() {
        JPanel jPanel = new JPanel(new FlowLayout(1));
        ApplyAction applyAction = this.buildApplyAction();
        this.modelTagConflictResolver.addPropertyChangeListener(applyAction);
        this.modelRelConflictResolver.addPropertyChangeListener(applyAction);
        this.btnApply = new JButton(applyAction);
        this.btnApply.setFocusable(true);
        jPanel.add(this.btnApply);
        CancelAction cancelAction = new CancelAction();
        jPanel.add(new JButton(cancelAction));
        this.helpAction = new ContextSensitiveHelpAction();
        jPanel.add(new JButton(this.helpAction));
        return jPanel;
    }

    public TagConflictResolverModel getTagConflictResolverModel() {
        return this.modelTagConflictResolver;
    }

    public RelationMemberConflictResolverModel getRelationMemberConflictResolverModel() {
        return this.modelRelConflictResolver;
    }

    public boolean isResolvedCompletely() {
        return this.modelTagConflictResolver.isResolvedCompletely() && this.modelRelConflictResolver.isResolvedCompletely();
    }

    protected List<Command> buildTagChangeCommand(OsmPrimitive osmPrimitive, TagCollection tagCollection) {
        return this.primitiveResolver.buildTagChangeCommand(osmPrimitive, tagCollection);
    }

    public List<Command> buildResolutionCommands() {
        List<Command> list = this.primitiveResolver.buildResolutionCommands(this.targetPrimitive);
        Command command = this.pnlRelationMemberConflictResolver.buildTagApplyCommands(this.modelRelConflictResolver.getModifiedRelations(this.targetPrimitive));
        if (command != null) {
            list.add(command);
        }
        return list;
    }

    public void prepareDefaultDecisions() {
        this.prepareDefaultDecisions(true);
    }

    private void prepareDefaultDecisions(boolean bl) {
        this.modelTagConflictResolver.prepareDefaultTagDecisions(bl);
        this.modelRelConflictResolver.prepareDefaultRelationDecisions(bl);
    }

    protected JPanel buildEmptyConflictsPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add(new JLabel(I18n.tr("No conflicts to resolve", new Object[0])));
        return jPanel;
    }

    protected void prepareGUIBeforeConflictResolutionStarts() {
        this.getContentPane().removeAll();
        if (this.modelRelConflictResolver.getNumDecisions() > 0 && this.modelTagConflictResolver.getNumDecisions() > 0) {
            this.spTagConflictTypes.setTopComponent(this.pnlTagConflictResolver);
            this.spTagConflictTypes.setBottomComponent(this.pnlRelationMemberConflictResolver);
            this.getContentPane().add((Component)this.spTagConflictTypes, "Center");
        } else if (this.modelRelConflictResolver.getNumDecisions() > 0) {
            this.getContentPane().add((Component)this.pnlRelationMemberConflictResolver, "Center");
        } else if (this.modelTagConflictResolver.getNumDecisions() > 0) {
            this.getContentPane().add((Component)this.pnlTagConflictResolver, "Center");
        } else {
            this.getContentPane().add((Component)this.buildEmptyConflictsPanel(), "Center");
        }
        this.getContentPane().add((Component)this.pnlButtons, "South");
        this.validate();
        this.adjustDividerLocation();
        this.pnlRelationMemberConflictResolver.prepareForEditing();
    }

    protected void setApplied(boolean bl) {
        this.applied = bl;
    }

    public boolean isApplied() {
        return this.applied;
    }

    @Override
    public void setVisible(boolean bl) {
        if (bl) {
            this.prepareGUIBeforeConflictResolutionStarts();
            this.setMinimumSize(new Dimension(400, 400));
            new WindowGeometry(this.getClass().getName() + ".geometry", WindowGeometry.centerInWindow(Main.parent, new Dimension(800, 600))).applySafe(this);
            this.setApplied(false);
            this.btnApply.requestFocusInWindow();
        } else if (this.isShowing()) {
            new WindowGeometry(this).remember(this.getClass().getName() + ".geometry");
        }
        super.setVisible(bl);
    }

    private void adjustDividerLocation() {
        int n = this.modelTagConflictResolver.getNumDecisions();
        int n2 = this.modelRelConflictResolver.getNumDecisions();
        if (n > 0 && n2 > 0) {
            double d = 1.0 + (double)n;
            double d2 = 2.5 + (double)n2;
            this.spTagConflictTypes.setDividerLocation(d / (d + d2));
        }
    }

    public static List<Command> launchIfNecessary(TagCollection tagCollection, Collection<? extends OsmPrimitive> collection, Collection<? extends OsmPrimitive> collection2) throws UserCancelException {
        LinkedList<Command> linkedList;
        block9: {
            RelationMemberConflictResolverModel relationMemberConflictResolverModel;
            TagConflictResolverModel tagConflictResolverModel;
            block8: {
                CheckParameterUtil.ensureParameterNotNull(tagCollection, "tagsOfPrimitives");
                CheckParameterUtil.ensureParameterNotNull(collection, "primitives");
                CheckParameterUtil.ensureParameterNotNull(collection2, "targetPrimitives");
                TagCollection tagCollection2 = new TagCollection(tagCollection);
                TagConflictResolutionUtil.applyAutomaticTagConflictResolution(tagCollection2);
                TagConflictResolutionUtil.normalizeTagCollectionBeforeEditing(tagCollection2, collection);
                TagCollection tagCollection3 = new TagCollection(tagCollection2);
                TagConflictResolutionUtil.completeTagCollectionForEditing(tagCollection3);
                Set<Relation> set = OsmPrimitive.getParentRelations(collection);
                if (!ExpertToggleAction.isExpert()) {
                    if (!tagCollection2.isApplicableToPrimitive()) {
                        CombinePrimitiveResolverDialog.informAboutTagConflicts(collection, tagCollection2);
                    }
                    if (!set.isEmpty()) {
                        CombinePrimitiveResolverDialog.informAboutRelationMembershipConflicts(collection, set);
                    }
                }
                linkedList = new LinkedList<Command>();
                tagConflictResolverModel = new TagConflictResolverModel();
                relationMemberConflictResolverModel = new RelationMemberConflictResolverModel();
                tagConflictResolverModel.populate(tagCollection3, tagCollection2.getKeysWithMultipleValues(), false);
                relationMemberConflictResolverModel.populate(set, collection, false);
                tagConflictResolverModel.prepareDefaultTagDecisions(false);
                relationMemberConflictResolverModel.prepareDefaultRelationDecisions(false);
                if (!tagConflictResolverModel.isResolvedCompletely() || !relationMemberConflictResolverModel.isResolvedCompletely()) break block8;
                CombinePrimitiveResolver combinePrimitiveResolver = new CombinePrimitiveResolver(tagConflictResolverModel, relationMemberConflictResolverModel);
                for (OsmPrimitive osmPrimitive : collection2) {
                    linkedList.addAll(combinePrimitiveResolver.buildResolutionCommands(osmPrimitive));
                }
                break block9;
            }
            if (GraphicsEnvironment.isHeadless()) break block9;
            CombinePrimitiveResolverDialog combinePrimitiveResolverDialog = new CombinePrimitiveResolverDialog(Main.parent, tagConflictResolverModel, relationMemberConflictResolverModel);
            if (collection2.size() == 1) {
                combinePrimitiveResolverDialog.setTargetPrimitive(collection2.iterator().next(), false);
            } else {
                combinePrimitiveResolverDialog.setTargetPrimitive(null, false);
            }
            GuiHelper.runInEDTAndWait(() -> {
                tagConflictResolverModel.fireTableDataChanged();
                relationMemberConflictResolverModel.fireTableDataChanged();
                combinePrimitiveResolverDialog.updateTitle();
            });
            combinePrimitiveResolverDialog.setVisible(true);
            if (!combinePrimitiveResolverDialog.isApplied()) {
                throw new UserCancelException();
            }
            for (OsmPrimitive osmPrimitive : collection2) {
                combinePrimitiveResolverDialog.setTargetPrimitive(osmPrimitive, false);
                linkedList.addAll(combinePrimitiveResolverDialog.buildResolutionCommands());
            }
        }
        return linkedList;
    }

    protected static void informAboutRelationMembershipConflicts(Collection<? extends OsmPrimitive> collection, Set<Relation> set) throws UserCancelException {
        String string = I18n.trn("You are about to combine {1} object, which is part of {0} relation:<br/>{2}Combining these objects may break this relation. If you are unsure, please cancel this operation.<br/>If you want to continue, you are shown a dialog to decide how to adapt the relation.<br/><br/>Do you want to continue?", "You are about to combine {1} objects, which are part of {0} relations:<br/>{2}Combining these objects may break these relations. If you are unsure, please cancel this operation.<br/>If you want to continue, you are shown a dialog to decide how to adapt the relations.<br/><br/>Do you want to continue?", set.size(), set.size(), collection.size(), DefaultNameFormatter.getInstance().formatAsHtmlUnorderedList(set, 20));
        if (!ConditionalOptionPaneUtil.showConfirmationDialog("combine_tags", Main.parent, "<html>" + string + "</html>", I18n.tr("Combine confirmation", new Object[0]), 0, 3, 0)) {
            throw new UserCancelException();
        }
    }

    protected static void informAboutTagConflicts(Collection<? extends OsmPrimitive> collection, TagCollection tagCollection) throws UserCancelException {
        String string2 = tagCollection.getKeysWithMultipleValues().stream().map(string -> CombinePrimitiveResolverDialog.getKeyDescription(string, tagCollection)).collect(StreamUtils.toHtmlList());
        String string3 = I18n.trn("You are about to combine {0} objects, but the following tags are used conflictingly:<br/>{1}If these objects are combined, the resulting object may have unwanted tags.<br/>If you want to continue, you are shown a dialog to fix the conflicting tags.<br/><br/>Do you want to continue?", "You are about to combine {0} objects, but the following tags are used conflictingly:<br/>{1}If these objects are combined, the resulting object may have unwanted tags.<br/>If you want to continue, you are shown a dialog to fix the conflicting tags.<br/><br/>Do you want to continue?", collection.size(), collection.size(), string2);
        if (!ConditionalOptionPaneUtil.showConfirmationDialog("combine_tags", Main.parent, "<html>" + string3 + "</html>", I18n.tr("Combine confirmation", new Object[0]), 0, 3, 0)) {
            throw new UserCancelException();
        }
    }

    private static String getKeyDescription(String string2, TagCollection tagCollection) {
        String string3 = tagCollection.getValues(string2).stream().map(string -> string == null || string.isEmpty() ? I18n.tr("<i>missing</i>", new Object[0]) : string).collect(Collectors.joining(I18n.tr(", ", new Object[0])));
        return I18n.tr("{0} ({1})", string2, string3);
    }

    class AdjustDividerLocationAction
    extends WindowAdapter {
        AdjustDividerLocationAction() {
        }

        @Override
        public void windowOpened(WindowEvent windowEvent) {
            CombinePrimitiveResolverDialog.this.adjustDividerLocation();
        }
    }

    protected class ApplyAction
    extends AbstractAction
    implements PropertyChangeListener {
        public ApplyAction() {
            this.putValue("ShortDescription", I18n.tr("Apply resolved conflicts", new Object[0]));
            this.putValue("Name", I18n.tr("Apply", new Object[0]));
            new ImageProvider("ok").getResource().attachImageIcon(this);
            this.updateEnabledState();
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            CombinePrimitiveResolverDialog.this.setApplied(true);
            CombinePrimitiveResolverDialog.this.setVisible(false);
            CombinePrimitiveResolverDialog.this.pnlTagConflictResolver.rememberPreferences();
        }

        protected final void updateEnabledState() {
            this.setEnabled(CombinePrimitiveResolverDialog.this.modelTagConflictResolver.isResolvedCompletely() && CombinePrimitiveResolverDialog.this.modelRelConflictResolver.isResolvedCompletely());
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName().equals(TagConflictResolverModel.NUM_CONFLICTS_PROP)) {
                this.updateEnabledState();
            }
            if (propertyChangeEvent.getPropertyName().equals(RelationMemberConflictResolverModel.NUM_CONFLICTS_PROP)) {
                this.updateEnabledState();
            }
        }
    }

    protected class CancelAction
    extends AbstractAction {
        public CancelAction() {
            this.putValue("ShortDescription", I18n.tr("Cancel conflict resolution", new Object[0]));
            this.putValue("Name", I18n.tr("Cancel", new Object[0]));
            new ImageProvider("cancel").getResource().attachImageIcon(this);
            this.setEnabled(true);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            CombinePrimitiveResolverDialog.this.setVisible(false);
        }
    }
}

