/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs.layer;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.InputEvent;
import java.awt.event.MouseWheelEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSlider;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.SideButton;
import org.openstreetmap.josm.gui.dialogs.IEnabledStateUpdating;
import org.openstreetmap.josm.gui.dialogs.LayerListDialog;
import org.openstreetmap.josm.gui.layer.ImageryLayer;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Utils;

public final class LayerVisibilityAction
extends AbstractAction
implements IEnabledStateUpdating,
Layer.LayerAction {
    private static final int SLIDER_STEPS = 100;
    private static final int SLIDER_WHEEL_INCREMENT = 5;
    private static final double MAX_SHARPNESS_FACTOR = 2.0;
    private static final double MAX_COLORFUL_FACTOR = 2.0;
    private final LayerListDialog.LayerListModel model;
    private final JPopupMenu popup;
    private SideButton sideButton;
    private final JCheckBox visibilityCheckbox;
    final OpacitySlider opacitySlider = new OpacitySlider();
    private final ArrayList<FilterSlider<?>> sliders = new ArrayList();

    public LayerVisibilityAction(LayerListDialog.LayerListModel layerListModel) {
        this.model = layerListModel;
        this.popup = new JPopupMenu();
        this.popup.addMouseWheelListener(InputEvent::consume);
        JPanel jPanel = new JPanel();
        this.popup.add(jPanel);
        jPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        jPanel.setLayout(new GridBagLayout());
        new ImageProvider("dialogs/layerlist", "visibility").getResource().attachImageIcon(this, true);
        this.putValue("ShortDescription", I18n.tr("Change visibility of the selected layer.", new Object[0]));
        this.visibilityCheckbox = new JCheckBox(I18n.tr("Show layer", new Object[0]));
        this.visibilityCheckbox.addChangeListener(changeEvent -> this.setVisibleFlag(this.visibilityCheckbox.isSelected()));
        jPanel.add((Component)this.visibilityCheckbox, GBC.eop());
        this.addSlider(jPanel, this.opacitySlider);
        this.addSlider(jPanel, new ColorfulnessSlider());
        this.addSlider(jPanel, new GammaFilterSlider());
        this.addSlider(jPanel, new SharpnessSlider());
    }

    private void addSlider(JPanel jPanel, FilterSlider<?> filterSlider) {
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        jPanel2.add((Component)new JLabel(filterSlider.getIcon()), GBC.std().span(1, 2).insets(0, 0, 5, 0));
        jPanel2.add((Component)new JLabel(filterSlider.getLabel()), GBC.eol());
        jPanel2.add(filterSlider, GBC.eol());
        jPanel.add((Component)jPanel2, GBC.eop());
        jPanel2.addMouseWheelListener(filterSlider::mouseWheelMoved);
        this.sliders.add(filterSlider);
    }

    void setVisibleFlag(boolean bl) {
        for (Layer layer : this.model.getSelectedLayers()) {
            layer.setVisible(bl);
        }
        this.updateValues();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.updateValues();
        if (actionEvent.getSource() == this.sideButton) {
            this.popup.show(this.sideButton, 0, this.sideButton.getHeight());
        } else {
            this.popup.show(Main.parent, Main.parent.getWidth() / 2, (Main.parent.getHeight() - this.popup.getHeight()) / 2);
        }
    }

    void updateValues() {
        List<Layer> list = this.model.getSelectedLayers();
        this.visibilityCheckbox.setEnabled(!list.isEmpty());
        boolean bl = true;
        boolean bl2 = true;
        for (Layer object : list) {
            bl &= object.isVisible();
            bl2 &= !object.isVisible();
        }
        this.visibilityCheckbox.setSelected(bl && !bl2);
        for (FilterSlider filterSlider : this.sliders) {
            filterSlider.updateSlider(list, bl2);
        }
    }

    @Override
    public boolean supportLayers(List<Layer> list) {
        return !list.isEmpty();
    }

    @Override
    public Component createMenuComponent() {
        return new JMenuItem(this);
    }

    @Override
    public void updateEnabledState() {
        this.setEnabled(!this.model.getSelectedLayers().isEmpty());
    }

    public void setCorrespondingSideButton(SideButton sideButton) {
        this.sideButton = sideButton;
    }

    private class ColorfulnessSlider
    extends FilterSlider<ImageryLayer> {
        ColorfulnessSlider() {
            super(0.0, 2.0, ImageryLayer.class);
            this.setToolTipText(I18n.tr("Adjust colorfulness of the layer.", new Object[0]));
        }

        @Override
        protected void updateSliderWhileEnabled(Collection<? extends Layer> collection, boolean bl) {
            this.setRealValue(((ImageryLayer)collection.iterator().next()).getFilterSettings().getColorfulness());
        }

        @Override
        protected void applyValueToLayer(ImageryLayer imageryLayer) {
            imageryLayer.getFilterSettings().setColorfulness(this.getRealValue());
        }

        @Override
        public ImageIcon getIcon() {
            return ImageProvider.get("dialogs/layerlist", "colorfulness");
        }

        @Override
        public String getLabel() {
            return I18n.tr("Colorfulness", new Object[0]);
        }
    }

    private class SharpnessSlider
    extends FilterSlider<ImageryLayer> {
        SharpnessSlider() {
            super(0.0, 2.0, ImageryLayer.class);
            this.setToolTipText(I18n.tr("Adjust sharpness/blur value of the layer.", new Object[0]));
        }

        @Override
        protected void updateSliderWhileEnabled(Collection<? extends Layer> collection, boolean bl) {
            this.setRealValue(((ImageryLayer)collection.iterator().next()).getFilterSettings().getSharpenLevel());
        }

        @Override
        protected void applyValueToLayer(ImageryLayer imageryLayer) {
            imageryLayer.getFilterSettings().setSharpenLevel(this.getRealValue());
        }

        @Override
        public ImageIcon getIcon() {
            return ImageProvider.get("dialogs/layerlist", "sharpness");
        }

        @Override
        public String getLabel() {
            return I18n.tr("Sharpness", new Object[0]);
        }
    }

    private class GammaFilterSlider
    extends FilterSlider<ImageryLayer> {
        GammaFilterSlider() {
            super(-1.0, 1.0, ImageryLayer.class);
            this.setToolTipText(I18n.tr("Adjust gamma value of the layer.", new Object[0]));
        }

        @Override
        protected void updateSliderWhileEnabled(Collection<? extends Layer> collection, boolean bl) {
            double d = ((ImageryLayer)collection.iterator().next()).getFilterSettings().getGamma();
            this.setRealValue(this.mapGammaToInterval(d));
        }

        @Override
        protected void applyValueToLayer(ImageryLayer imageryLayer) {
            imageryLayer.getFilterSettings().setGamma(this.mapIntervalToGamma(this.getRealValue()));
        }

        @Override
        public ImageIcon getIcon() {
            return ImageProvider.get("dialogs/layerlist", "gamma");
        }

        @Override
        public String getLabel() {
            return I18n.tr("Gamma", new Object[0]);
        }

        private double mapIntervalToGamma(double d) {
            return (1.0 + d) / (1.0 - d);
        }

        private double mapGammaToInterval(double d) {
            return (d - 1.0) / (d + 1.0);
        }
    }

    class OpacitySlider
    extends FilterSlider<Layer> {
        OpacitySlider() {
            super(0.0, 1.0, Layer.class);
            this.setToolTipText(I18n.tr("Adjust opacity of the layer.", new Object[0]));
        }

        @Override
        protected void onStateChanged() {
            if (this.getRealValue() <= 0.001 && !this.getValueIsAdjusting()) {
                LayerVisibilityAction.this.setVisibleFlag(false);
            } else {
                super.onStateChanged();
            }
        }

        @Override
        protected void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
            if (!this.isEnabled() && !this.filterLayers(LayerVisibilityAction.this.model.getSelectedLayers()).isEmpty() && mouseWheelEvent.getPreciseWheelRotation() < 0.0) {
                mouseWheelEvent.consume();
                LayerVisibilityAction.this.setVisibleFlag(true);
            } else {
                super.mouseWheelMoved(mouseWheelEvent);
            }
        }

        @Override
        protected void applyValueToLayer(Layer layer) {
            layer.setOpacity(this.getRealValue());
        }

        @Override
        protected void updateSliderWhileEnabled(Collection<? extends Layer> collection, boolean bl) {
            double d = 0.0;
            for (Layer layer : collection) {
                d += layer.getOpacity();
            }
            if ((d /= (double)collection.size()) == 0.0) {
                d = 1.0;
                LayerVisibilityAction.this.setVisibleFlag(true);
            }
            this.setRealValue(d);
        }

        @Override
        public String getLabel() {
            return I18n.tr("Opacity", new Object[0]);
        }

        @Override
        public ImageIcon getIcon() {
            return ImageProvider.get("dialogs/layerlist", "transparency");
        }

        @Override
        public String toString() {
            return "OpacitySlider [getRealValue()=" + this.getRealValue() + ']';
        }
    }

    private abstract class FilterSlider<T extends Layer>
    extends JSlider {
        private final double minValue;
        private final double maxValue;
        private final Class<T> layerClassFilter;

        FilterSlider(double d, double d2, Class<T> clazz) {
            super(0);
            this.minValue = d;
            this.maxValue = d2;
            this.layerClassFilter = clazz;
            this.setMaximum(100);
            int n = this.convertFromRealValue(1.0);
            this.setMinorTickSpacing(n);
            this.setMajorTickSpacing(n);
            this.setPaintTicks(true);
            this.addChangeListener(changeEvent -> this.onStateChanged());
        }

        protected void onStateChanged() {
            Collection<T> collection = this.filterLayers(LayerVisibilityAction.this.model.getSelectedLayers());
            for (Layer layer : collection) {
                this.applyValueToLayer(layer);
            }
        }

        protected void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
            mouseWheelEvent.consume();
            if (!this.isEnabled()) {
                return;
            }
            double d = -1.0 * mouseWheelEvent.getPreciseWheelRotation();
            double d2 = (double)this.getValue() + d * 5.0;
            d2 = d < 0.0 ? Math.floor(d2) : Math.ceil(d2);
            this.setValue(Utils.clamp((int)d2, this.getMinimum(), this.getMaximum()));
        }

        abstract void applyValueToLayer(T var1);

        protected double getRealValue() {
            return this.convertToRealValue(this.getValue());
        }

        protected double convertToRealValue(int n) {
            double d = (double)n / 100.0;
            return d * this.maxValue + (1.0 - d) * this.minValue;
        }

        protected void setRealValue(double d) {
            this.setValue(this.convertFromRealValue(d));
        }

        protected int convertFromRealValue(double d) {
            int n = (int)((d - this.minValue) / (this.maxValue - this.minValue) * 100.0 + 0.5);
            return Utils.clamp(n, this.getMinimum(), this.getMaximum());
        }

        public abstract ImageIcon getIcon();

        public abstract String getLabel();

        public void updateSlider(List<Layer> list, boolean bl) {
            Collection<T> collection = this.filterLayers(list);
            if (collection.isEmpty() || bl) {
                this.setEnabled(false);
            } else {
                this.setEnabled(true);
                this.updateSliderWhileEnabled(collection, bl);
            }
        }

        protected Collection<T> filterLayers(List<Layer> list) {
            return Utils.filteredCollection(list, this.layerClassFilter);
        }

        protected abstract void updateSliderWhileEnabled(Collection<? extends Layer> var1, boolean var2);
    }
}

