/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.util;

import java.util.Locale;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.tools.Geometry;
import org.openstreetmap.josm.tools.SubclassFilteredCollection;
import org.openstreetmap.josm.tools.Utils;

@FunctionalInterface
public interface RotationAngle {
    public static final RotationAngle NO_ROTATION = new StaticRotationAngle(0.0);

    public double getRotationAngle(OsmPrimitive var1);

    public static RotationAngle buildStaticRotation(double d) {
        return new StaticRotationAngle(d);
    }

    public static RotationAngle buildStaticRotation(String string) {
        try {
            return RotationAngle.buildStaticRotation(RotationAngle.parseCardinalRotation(string));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IllegalArgumentException("Invalid string: " + string, illegalArgumentException);
        }
    }

    public static double parseCardinalRotation(String string) {
        switch (string.toLowerCase(Locale.ENGLISH)) {
            case "n": 
            case "north": {
                return 0.0;
            }
            case "ne": 
            case "northeast": {
                return Math.toRadians(45.0);
            }
            case "e": 
            case "east": {
                return Math.toRadians(90.0);
            }
            case "se": 
            case "southeast": {
                return Math.toRadians(135.0);
            }
            case "s": 
            case "south": {
                return Math.PI;
            }
            case "sw": 
            case "southwest": {
                return Math.toRadians(225.0);
            }
            case "w": 
            case "west": {
                return Math.toRadians(270.0);
            }
            case "nw": 
            case "northwest": {
                return Math.toRadians(315.0);
            }
        }
        throw new IllegalArgumentException("Unexpected cardinal direction " + string);
    }

    public static RotationAngle buildWayDirectionRotation() {
        return new WayDirectionRotationAngle();
    }

    public static final class StaticRotationAngle
    implements RotationAngle {
        private final double angle;

        private StaticRotationAngle(double d) {
            this.angle = d;
        }

        @Override
        public double getRotationAngle(OsmPrimitive osmPrimitive) {
            return this.angle;
        }

        public String toString() {
            return this.angle + "rad";
        }

        public int hashCode() {
            int n = 1;
            long l = Double.doubleToLongBits(this.angle);
            n = 31 * n + (int)(l ^ l >>> 32);
            return n;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            StaticRotationAngle staticRotationAngle = (StaticRotationAngle)object;
            return Double.doubleToLongBits(this.angle) == Double.doubleToLongBits(staticRotationAngle.angle);
        }
    }

    public static final class WayDirectionRotationAngle
    implements RotationAngle {
        @Override
        public double getRotationAngle(OsmPrimitive osmPrimitive) {
            if (!(osmPrimitive instanceof Node)) {
                return 0.0;
            }
            Node node = (Node)osmPrimitive;
            SubclassFilteredCollection<OsmPrimitive, Way> subclassFilteredCollection = Utils.filteredCollection(node.getReferrers(), Way.class);
            if (subclassFilteredCollection.isEmpty()) {
                return 0.0;
            }
            Way way = subclassFilteredCollection.iterator().next();
            int n = way.getNodes().indexOf(node);
            if (n == 0) {
                return -Geometry.getSegmentAngle(node.getEastNorth(), way.getNode(n + 1).getEastNorth());
            }
            return -Geometry.getSegmentAngle(way.getNode(n - 1).getEastNorth(), node.getEastNorth());
        }

        public String toString() {
            return "way-direction";
        }

        public int hashCode() {
            return 1;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            return this.getClass() == object.getClass();
        }
    }
}

