/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.stdlib;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.instrumentation.EventBinding;
import com.oracle.truffle.api.instrumentation.ExecutionEventNode;
import com.oracle.truffle.api.instrumentation.Instrumenter;
import com.oracle.truffle.api.instrumentation.SourceSectionFilter;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.source.SourceSection;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLongArray;
import org.jruby.truffle.RubyContext;

public class CoverageManager {
    public static final long NO_CODE = -1L;
    private final Instrumenter instrumenter;
    private EventBinding<?> binding;
    private final Map<Source, AtomicLongArray> counters = new ConcurrentHashMap<Source, AtomicLongArray>();
    private final Map<Source, BitSet> linesHaveCode = new HashMap<Source, BitSet>();
    private boolean enabled;

    public CoverageManager(RubyContext context, Instrumenter instrumenter) {
        this.instrumenter = instrumenter;
        if (context.getOptions().COVERAGE_GLOBAL) {
            this.enable();
        }
    }

    public synchronized void setLineHasCode(Source source, int line) {
        BitSet bitmap = this.linesHaveCode.get(source);
        if (bitmap == null) {
            bitmap = new BitSet(source.getLineCount());
            this.linesHaveCode.put(source, bitmap);
        }
        bitmap.set(line - 1);
    }

    private boolean getLineHasCode(Source source, int line) {
        BitSet bitmap = this.linesHaveCode.get(source);
        if (bitmap == null) {
            return false;
        }
        return bitmap.get(line - 1);
    }

    @CompilerDirectives.TruffleBoundary
    public synchronized void enable() {
        if (this.enabled) {
            return;
        }
        this.binding = this.instrumenter.attachFactory(SourceSectionFilter.newBuilder().tagIs(LineTag.class).build(), eventContext -> new ExecutionEventNode(){
            @CompilerDirectives.CompilationFinal
            private boolean configured;
            @CompilerDirectives.CompilationFinal
            private int lineNumber;
            @CompilerDirectives.CompilationFinal
            private AtomicLongArray counters;

            @Override
            protected void onEnter(VirtualFrame frame) {
                if (!this.configured) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    SourceSection sourceSection = eventContext.getInstrumentedSourceSection();
                    if (CoverageManager.this.getLineHasCode(sourceSection.getSource(), sourceSection.getStartLine())) {
                        this.lineNumber = sourceSection.getStartLine() - 1;
                        this.counters = CoverageManager.this.getCounters(sourceSection.getSource());
                    }
                    this.configured = true;
                }
                if (this.counters != null) {
                    this.counters.incrementAndGet(this.lineNumber);
                }
            }
        });
        this.enabled = true;
    }

    @CompilerDirectives.TruffleBoundary
    public synchronized void disable() {
        if (!this.enabled) {
            return;
        }
        this.binding.dispose();
        this.linesHaveCode.clear();
        this.counters.clear();
        this.enabled = false;
    }

    private synchronized AtomicLongArray getCounters(Source source) {
        if (source.getName() == null) {
            return null;
        }
        AtomicLongArray c = this.counters.get(source);
        if (c == null) {
            c = new AtomicLongArray(source.getLineCount());
            this.counters.put(source, c);
        }
        return c;
    }

    public synchronized Map<Source, long[]> getCounts() {
        if (!this.enabled) {
            return null;
        }
        HashMap<Source, long[]> counts = new HashMap<Source, long[]>();
        for (Map.Entry<Source, AtomicLongArray> entry : this.counters.entrySet()) {
            BitSet hasCode = this.linesHaveCode.get(entry.getKey());
            long[] array = new long[entry.getValue().length()];
            for (int n = 0; n < array.length; ++n) {
                array[n] = hasCode != null && hasCode.get(n) ? entry.getValue().get(n) : -1L;
            }
            counts.put(entry.getKey(), array);
        }
        return counts;
    }

    public void print(PrintStream out) {
        int maxCountDigits = Long.toString(this.getMaxCount()).length();
        String countFormat = "%" + maxCountDigits + "d";
        char[] noCodeChars = new char[maxCountDigits];
        Arrays.fill(noCodeChars, ' ');
        noCodeChars[maxCountDigits - 1] = 45;
        String noCodeString = new String(noCodeChars);
        for (Map.Entry<Source, AtomicLongArray> entry : this.counters.entrySet()) {
            BitSet hasCode = this.linesHaveCode.get(entry.getKey());
            out.println(entry.getKey().getName());
            for (int n = 0; n < entry.getValue().length(); ++n) {
                String line = entry.getKey().getCode(n + 1);
                if (line.length() > 60) {
                    line = line.substring(0, 60);
                }
                out.print("  ");
                if (hasCode != null && hasCode.get(n)) {
                    out.printf(countFormat, entry.getValue().get(n));
                } else {
                    out.print(noCodeString);
                }
                out.printf("  %s%n", line);
            }
        }
    }

    private long getMaxCount() {
        long max = 0L;
        for (Map.Entry<Source, AtomicLongArray> entry : this.counters.entrySet()) {
            for (int n = 0; n < entry.getValue().length(); ++n) {
                max = Math.max(max, entry.getValue().get(n));
            }
        }
        return max;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public class LineTag {
    }
}

