# From 3.0 to 3.1
*Make sure you view this [upgrade guide from the `master` branch](https://gitlab.com/gitlab-org/gitlab-ce/tree/master/doc/update/3.0-to-3.1.md) for the most up to date instructions.*

**IMPORTANT!**

In this release **we moved Resque jobs under own gitlab namespace**

Despite a lot of advantages it requires from our users to **replace gitolite post-receive hook with new one**.

Most of projects has post-receive file as symlink to gitolite `/home/git/.gitolite/hooks/post-receive`. But some of them may have a real file. In this case you should rewrite it with symlink to gitolite hook.

I wrote a bash script which will do it automatically for you. Just make sure all path inside is valid for you

## 1. Stop server & resque

    sudo service gitlab stop

## 2. Update GitLab

```bash
# Get latest code
sudo -u gitlab -H git fetch
sudo -u gitlab -H git checkout v3.1.0

# Install new charlock_holmes
sudo gem install charlock_holmes --version '0.6.9'

# The Modernizr gem was yanked from RubyGems. It is required for GitLab >= 2.8.0
# Edit `Gemfile` and change `gem "modernizr", "2.5.3"` to
# `gem "modernizr-rails", "2.7.1"``
sudo -u gitlab -H vim Gemfile

# Install gems for MySQL
sudo -u gitlab -H bundle install --without development test postgres sqlite


# Migrate db
sudo -u gitlab -H bundle exec rake db:migrate RAILS_ENV=production

```

## 3. Update post-receive hooks

### Gitolite 3

Step 1: Rewrite post-receive hook

```bash
# Rewrite hook for gitolite 3
sudo cp ./lib/hooks/post-receive /home/git/.gitolite/hooks/common/post-receive
sudo chown git:git /home/git/.gitolite/hooks/common/post-receive
```

Step 2: Rewrite hooks in all projects to symlink gitolite hook

```bash
# 1. Check for valid path
sudo -u gitlab -H vim lib/support/rewrite-hooks.sh

# 2. Run script
sudo -u git -H lib/support/rewrite-hooks.sh
```

### Gitolite v2

Step 1: rewrite post-receive hook for gitolite 2

```
sudo cp ./lib/hooks/post-receive /home/git/share/gitolite/hooks/common/post-receive
sudo chown git:git /home/git/share/gitolite/hooks/common/post-receive
```

Step 2: Replace symlinks in project to valid place

    #!/bin/bash
    src="/home/git/repositories"
    for dir in `ls "$src/"`
    do
      if [ -d "$src/$dir" ]; then

        if [ "$dir" = "gitolite-admin.git" ]
        then
          continue
        fi

        project_hook="$src/$dir/hooks/post-receive"
        gitolite_hook="/home/git/share/gitolite/hooks/common/post-receive"

        ln -s -f $gitolite_hook $project_hook
      fi
    done

## 4. Check app status

```bash
# Check APP Status
sudo -u gitlab -H bundle exec rake gitlab:app:status RAILS_ENV=production
```

## 5. Start all

    sudo service gitlab start
