/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.da.comp.writer4latex;

import com.sun.star.awt.XContainerWindowEventHandler;
import com.sun.star.awt.XControl;
import com.sun.star.awt.XControlContainer;
import com.sun.star.awt.XControlModel;
import com.sun.star.awt.XDialog;
import com.sun.star.awt.XDialogProvider2;
import com.sun.star.awt.XWindow;
import com.sun.star.beans.XPropertySet;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.lang.XMultiComponentFactory;
import com.sun.star.lang.XServiceInfo;
import com.sun.star.lib.uno.helper.WeakBase;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.RuntimeException;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XComponentContext;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Vector;
import org.openoffice.da.comp.w2lcommon.helper.DialogAccess;
import org.openoffice.da.comp.w2lcommon.helper.FilePicker;
import org.openoffice.da.comp.writer4latex.ExternalApps;
import org.openoffice.da.comp.writer4latex.StreamGobbler;

public final class ApplicationsDialog
extends WeakBase
implements XServiceInfo,
XContainerWindowEventHandler {
    private XComponentContext xContext;
    private FilePicker filePicker;
    private ExternalApps externalApps;
    public static String __serviceName = "org.openoffice.da.writer4latex.ApplicationsDialog";
    public static String __implementationName = "org.openoffice.da.comp.writer4latex.ApplicationsDialog";

    public ApplicationsDialog(XComponentContext xContext) {
        this.xContext = xContext;
        this.externalApps = new ExternalApps(xContext);
        this.filePicker = new FilePicker(xContext);
    }

    public boolean callHandlerMethod(XWindow xWindow, Object event, String sMethod) throws WrappedTargetException {
        try {
            if (sMethod.equals("external_event")) {
                return this.handleExternalEvent(xWindow, event);
            }
            if (sMethod.equals("ApplicationChange")) {
                return this.changeApplication(xWindow);
            }
            if (sMethod.equals("BrowseClick")) {
                return this.browseForExecutable(xWindow);
            }
            if (sMethod.equals("ExecutableUnfocus")) {
                return this.updateApplication(xWindow);
            }
            if (sMethod.equals("OptionsUnfocus")) {
                return this.updateApplication(xWindow);
            }
            if (sMethod.equals("AutomaticClick")) {
                return this.autoConfigure(xWindow);
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (com.sun.star.uno.Exception e) {
            throw new WrappedTargetException(sMethod, (Object)this, (Object)e);
        }
        return false;
    }

    public String[] getSupportedMethodNames() {
        String[] sNames = new String[]{"external_event", "ApplicationChange", "BrowseClick", "ExecutableUnfocus", "OptionsUnfocus", "AutomaticClick"};
        return sNames;
    }

    public boolean supportsService(String sServiceName) {
        return sServiceName.equals(__serviceName);
    }

    public String getImplementationName() {
        return __implementationName;
    }

    public String[] getSupportedServiceNames() {
        String[] sSupportedServiceNames = new String[]{__serviceName};
        return sSupportedServiceNames;
    }

    private boolean handleExternalEvent(XWindow xWindow, Object aEventObject) throws com.sun.star.uno.Exception {
        try {
            String sMethod = AnyConverter.toString((Object)aEventObject);
            if (sMethod.equals("ok")) {
                this.externalApps.save();
                return true;
            }
            if (sMethod.equals("back") || sMethod.equals("initialize")) {
                this.externalApps.load();
                return this.changeApplication(xWindow);
            }
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Method external_event requires a string in the event object argument.", (Object)this, -1);
        }
        return false;
    }

    private boolean changeApplication(XWindow xWindow) {
        String sAppName = this.getSelectedAppName(xWindow);
        if (sAppName != null) {
            String[] s = this.externalApps.getApplication(sAppName);
            this.setComboBoxText(xWindow, "Executable", s[0]);
            this.setComboBoxText(xWindow, "Options", s[1]);
        }
        return true;
    }

    private boolean browseForExecutable(XWindow xWindow) {
        String sPath = this.filePicker.getPath();
        if (sPath != null) {
            try {
                this.setComboBoxText(xWindow, "Executable", new File(new URI(sPath)).getCanonicalPath());
            }
            catch (IOException e) {
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
            this.updateApplication(xWindow);
        }
        return true;
    }

    private boolean updateApplication(XWindow xWindow) {
        String sAppName = this.getSelectedAppName(xWindow);
        if (sAppName != null) {
            this.externalApps.setApplication(sAppName, this.getComboBoxText(xWindow, "Executable"), this.getComboBoxText(xWindow, "Options"));
        }
        return true;
    }

    private boolean hasApp(String sAppName) {
        try {
            Vector<String> command = new Vector<String>();
            command.add("which");
            command.add(sAppName);
            ProcessBuilder pb = new ProcessBuilder(command);
            Process proc = pb.start();
            StreamGobbler errorGobbler = new StreamGobbler(proc.getErrorStream(), "ERROR");
            StreamGobbler outputGobbler = new StreamGobbler(proc.getInputStream(), "OUTPUT");
            errorGobbler.start();
            outputGobbler.start();
            return proc.waitFor() == 0;
        }
        catch (InterruptedException e) {
            return false;
        }
        catch (IOException e) {
            return false;
        }
    }

    private boolean configureApp(String sName, String sAppName, String sArguments) {
        if (this.hasApp(sAppName)) {
            this.externalApps.setApplication(sName, sAppName, sArguments);
            return true;
        }
        this.externalApps.setApplication(sName, "???", "???");
        return false;
    }

    private boolean configureApp(String sName, String sAppName, String sArguments, StringBuilder info) {
        if (this.hasApp(sAppName)) {
            this.externalApps.setApplication(sName, sAppName, sArguments);
            info.append("Found " + sAppName + " - OK\n");
            return true;
        }
        this.externalApps.setApplication(sName, "???", "???");
        info.append("Failed to find " + sAppName + "\n");
        return false;
    }

    private boolean configureApp(String sName, String[] sAppNames, String sArguments, StringBuilder info) {
        for (String sAppName : sAppNames) {
            if (!this.configureApp(sName, sAppName, sArguments)) continue;
            info.append("Found " + sName + ": " + sAppName + " - OK\n");
            return true;
        }
        info.append("Failed to find " + sName + "\n");
        return false;
    }

    private boolean containsExecutable(String sPath, String sExecutable) {
        File dir = new File(sPath);
        if (dir.exists() && dir.canRead()) {
            File exe = new File(dir, sExecutable);
            return exe.exists();
        }
        return false;
    }

    private boolean configureMikTeX(String sPath, String sName, String sAppName, String sArguments, StringBuilder info, boolean bRequired) {
        File app = new File(new File(sPath), sAppName + ".exe");
        if (app.exists()) {
            this.externalApps.setApplication(sName, sAppName, sArguments);
            info.append("  Found " + sName + ": " + sAppName + " - OK\n");
            return true;
        }
        if (bRequired) {
            this.externalApps.setApplication(sName, "???", "???");
            info.append("  Failed to find " + sName + "\n");
        }
        return false;
    }

    private boolean autoConfigure(XWindow xWindow) {
        String sOsName = System.getProperty("os.name");
        String sOsVersion = System.getProperty("os.version");
        String sOsArch = System.getProperty("os.arch");
        StringBuilder info = new StringBuilder();
        info.append("Results of configuration:\n\n");
        info.append("Your system identifies itself as " + sOsName + " version " + sOsVersion + " (" + sOsArch + ")\n\n");
        if (sOsName.startsWith("Windows")) {
            String[] sPaths;
            String sMikTeXPath = null;
            for (String s : sPaths = System.getenv("PATH").split(";")) {
                if (s.toLowerCase().indexOf("miktex") <= -1 || !this.containsExecutable(s, "latex.exe")) continue;
                sMikTeXPath = s;
                break;
            }
            if (sMikTeXPath == null) {
                for (String s : sPaths) {
                    if (!this.containsExecutable(s, "latex.exe")) continue;
                    sMikTeXPath = s;
                    break;
                }
            }
            boolean bFoundTexworks = false;
            if (sMikTeXPath != null) {
                info.append("Found MikTeX\n");
                this.configureMikTeX(sMikTeXPath, "LaTeX", "latex", "--interaction=batchmode %s", info, true);
                this.configureMikTeX(sMikTeXPath, "PdfLaTeX", "pdflatex", "--interaction=batchmode %s", info, true);
                this.configureMikTeX(sMikTeXPath, "XeLaTeX", "xelatex", "--interaction=batchmode %s", info, true);
                this.configureMikTeX(sMikTeXPath, "Dvips", "dvips", "%s", info, true);
                this.configureMikTeX(sMikTeXPath, "BibTeX", "bibtex", "%s", info, true);
                this.configureMikTeX(sMikTeXPath, "Makeindex", "makeindex", "%s", info, true);
                this.configureMikTeX(sMikTeXPath, "DVIViewer", "yap", "--single-instance %s", info, true);
                bFoundTexworks = this.configureMikTeX(sMikTeXPath, "PdfViewer", "texworks", "%s", info, true);
            } else {
                info.append("Failed to find MikTeX\n");
                info.append("Writer4LaTeX has been configured to work if MikTeX is added to your path\n");
                this.externalApps.setApplication("LaTeX", "latex", "--interaction=batchmode %s");
                this.externalApps.setApplication("PdfLaTeX", "pdflatex", "--interaction=batchmode %s");
                this.externalApps.setApplication("XeLaTeX", "xelatex", "--interaction=batchmode %s");
                this.externalApps.setApplication("Dvips", "dvips", "%s");
                this.externalApps.setApplication("BibTeX", "bibtex", "%s");
                this.externalApps.setApplication("Makeindex", "makeindex", "%s");
                this.externalApps.setApplication("DVIViewer", "yap", "--single-instance %s");
            }
            info.append("\n");
            String sGsview = null;
            String sProgramFiles = System.getenv("ProgramFiles");
            if (sProgramFiles != null && this.containsExecutable(sProgramFiles + "\\ghostgum\\gsview", "gsview32.exe")) {
                sGsview = sProgramFiles + "\\ghostgum\\gsview\\gsview32.exe";
            }
            if (sGsview != null) {
                info.append("Found gsview - OK\n");
            } else {
                info.append("Failed to find gsview\n");
                sGsview = "gsview32.exe";
            }
            if (!bFoundTexworks) {
                this.externalApps.setApplication("PdfViewer", sGsview, "-e \"%s\"");
            }
            this.externalApps.setApplication("PostscriptViewer", sGsview, "-e \"%s\"");
        } else {
            this.configureApp("LaTeX", "latex", "--interaction=batchmode %s", info);
            this.configureApp("PdfLaTeX", "pdflatex", "--interaction=batchmode %s", info);
            this.configureApp("XeLaTeX", "xelatex", "--interaction=batchmode %s", info);
            this.configureApp("Dvips", "dvips", "%s", info);
            this.configureApp("BibTeX", "bibtex", "%s", info);
            this.configureApp("Makeindex", "makeindex", "%s", info);
            String[] sDviViewers = new String[]{"evince", "okular", "xdvi"};
            this.configureApp("DVIViewer", sDviViewers, "%s", info);
            String[] sPdfViewers = new String[]{"evince", "okular", "xpdf"};
            this.configureApp("PdfViewer", sPdfViewers, "%s", info);
            String[] sPsViewers = new String[]{"evince", "okular", "ghostview"};
            this.configureApp("PostscriptViewer", sPsViewers, "%s", info);
        }
        this.displayAutoConfigInfo(info.toString());
        this.changeApplication(xWindow);
        return true;
    }

    private String getSelectedAppName(XWindow xWindow) {
        short nItem = this.getListBoxSelectedItem(xWindow, "Application");
        switch (nItem) {
            case 0: {
                return "LaTeX";
            }
            case 1: {
                return "PdfLaTeX";
            }
            case 2: {
                return "XeLaTeX";
            }
            case 3: {
                return "Dvips";
            }
            case 4: {
                return "BibTeX";
            }
            case 5: {
                return "Makeindex";
            }
            case 6: {
                return "DVIViewer";
            }
            case 7: {
                return "PdfViewer";
            }
            case 8: {
                return "PostscriptViewer";
            }
        }
        return "???";
    }

    private XDialog getDialog(String sDialogName) {
        XMultiComponentFactory xMCF = this.xContext.getServiceManager();
        try {
            Object provider = xMCF.createInstanceWithContext("com.sun.star.awt.DialogProvider2", this.xContext);
            XDialogProvider2 xDialogProvider = (XDialogProvider2)UnoRuntime.queryInterface(XDialogProvider2.class, (Object)provider);
            String sDialogUrl = "vnd.sun.star.script:" + sDialogName + "?location=application";
            return xDialogProvider.createDialogWithHandler(sDialogUrl, (Object)this);
        }
        catch (Exception e) {
            return null;
        }
    }

    private void displayAutoConfigInfo(String sText) {
        XDialog xDialog = this.getDialog("W4LDialogs.AutoConfigInfo");
        if (xDialog != null) {
            DialogAccess info = new DialogAccess(xDialog);
            info.setTextFieldText("Info", sText);
            xDialog.execute();
            xDialog.endExecute();
        }
    }

    private XPropertySet getControlProperties(XWindow xWindow, String sControlName) {
        XControlContainer xContainer = (XControlContainer)UnoRuntime.queryInterface(XControlContainer.class, (Object)xWindow);
        XControl xControl = xContainer.getControl(sControlName);
        XControlModel xModel = xControl.getModel();
        XPropertySet xPropertySet = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)xModel);
        return xPropertySet;
    }

    private String getComboBoxText(XWindow xWindow, String sControlName) {
        XPropertySet xPropertySet = this.getControlProperties(xWindow, sControlName);
        try {
            return (String)xPropertySet.getPropertyValue("Text");
        }
        catch (Exception e) {
            return "";
        }
    }

    private void setComboBoxText(XWindow xWindow, String sControlName, String sText) {
        XPropertySet xPropertySet = this.getControlProperties(xWindow, sControlName);
        try {
            xPropertySet.setPropertyValue("Text", (Object)sText);
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    private short getListBoxSelectedItem(XWindow xWindow, String sControlName) {
        XPropertySet xPropertySet = this.getControlProperties(xWindow, sControlName);
        try {
            short[] selection = (short[])xPropertySet.getPropertyValue("SelectedItems");
            return selection[0];
        }
        catch (Exception e) {
            return -1;
        }
    }
}

