/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.options;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.RoundRectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.text.JTextComponent;
import org.netbeans.modules.options.Bundle;
import org.netbeans.modules.options.CategoryModel;
import org.netbeans.modules.options.OptionsDisplayerImpl;
import org.netbeans.modules.options.advanced.AdvancedPanel;
import org.netbeans.modules.options.ui.VariableBorder;
import org.openide.awt.Mnemonics;
import org.openide.awt.QuickSearch;
import org.openide.awt.StatusDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.HelpCtx;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.openide.windows.WindowManager;

public class OptionsPanel
extends JPanel {
    private JPanel pCategories;
    private JPanel pCategories2;
    private JScrollPane categoriesScrollPane;
    private JPanel pOptions;
    private JPanel quickSearch;
    private Color origForeground;
    private String hintText;
    private JTextComponent searchTC;
    private String text2search = "";
    private boolean clearSearch = false;
    private CardLayout cLayout;
    private int selectedTabIndex = -1;
    private HashMap<String, JTabbedPane> categoryid2tabbedpane = new HashMap();
    private HashMap<String, ArrayList<String>> categoryid2words = new HashMap();
    private HashMap<String, HashMap<Integer, TabInfo>> categoryid2tabs = new HashMap();
    private ArrayList<String> disabledCategories = new ArrayList();
    private ArrayList<FileObject> advancedFOs = new ArrayList();
    private HashMap<String, Integer> dublicateKeywordsFOs = new HashMap();
    private HashMap<FileObject, Integer> fo2index = new HashMap();
    private Map<String, CategoryButton> buttons = new LinkedHashMap<String, CategoryButton>();
    private final boolean isMac = UIManager.getLookAndFeel().getID().equals("Aqua");
    private static final boolean isNimbus = UIManager.getLookAndFeel().getID().equals("Nimbus");
    private static final boolean isMetal = UIManager.getLookAndFeel() instanceof MetalLookAndFeel;
    private final boolean isGTK = UIManager.getLookAndFeel().getID().equals("GTK");
    private Color selected = this.isMac ? new Color(221, 221, 221) : OptionsPanel.getSelectionBackground();
    private Color selectedB = this.isMac ? new Color(183, 183, 183) : new Color(149, 106, 197);
    private Color highlighted = this.isMac ? new Color(221, 221, 221) : OptionsPanel.getHighlightBackground();
    private Color highlightedB = new Color(152, 180, 226);
    private Color iconViewBorder = new Color(127, 157, 185);
    private ControllerListener controllerListener = new ControllerListener();
    private final Color borderMac = new Color(141, 141, 141);
    private final Font labelFontMac = new Font("Lucida Grande", 0, 10);
    private CategoryModel categoryModel;
    private boolean applyPressed = false;
    private static final int BORDER_WIDTH = 4;
    private static final Border selBorder = new CompoundBorder(new CompoundBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4), new NimbusBorder()), BorderFactory.createEmptyBorder(4, 4, 4, 4));
    private static final Border normalBorder = BorderFactory.createEmptyBorder(9, 9, 11, 11);
    private static final short STATUS_NORMAL = 0;
    private static final short STATUS_SELECTED = 1;
    private static final short STATUS_HIGHLIGHTED = 2;
    private static final Color COL_GRADIENT1 = new Color(244, 245, 249);
    private static final Color COL_GRADIENT2 = new Color(163, 184, 203);
    private static final Color COL_GRADIENT3 = new Color(206, 227, 246);
    private static final Color COL_OVER_GRADIENT1 = new Color(244, 245, 249, 128);
    private static final Color COL_OVER_GRADIENT2 = new Color(163, 184, 203, 128);
    private static final Color COL_OVER_GRADIENT3 = new Color(206, 227, 246, 128);
    private static final boolean isDefaultTabBackground = Color.white.equals(OptionsPanel.getTabPanelBackground());

    private static String loc(String string) {
        return NbBundle.getMessage(OptionsPanel.class, (String)string);
    }

    public OptionsPanel(CategoryModel categoryModel) {
        this(null, categoryModel);
    }

    public OptionsPanel(String string, CategoryModel categoryModel) {
        this.categoryModel = categoryModel;
        this.initUI(string);
        if (this.getActionMap().get("SEARCH_OPTIONS") == null) {
            InputMap inputMap = this.getInputMap(2);
            if (Utilities.isMac()) {
                inputMap.put(KeyStroke.getKeyStroke(70, 4), "SEARCH_OPTIONS");
                this.hintText = Bundle.Filter_Textfield_Hint("\u2318+F");
            } else {
                inputMap.put(KeyStroke.getKeyStroke(70, 2), "SEARCH_OPTIONS");
                this.hintText = Bundle.Filter_Textfield_Hint("Ctrl+F");
            }
            this.getActionMap().put("SEARCH_OPTIONS", new SearchAction());
        }
    }

    private String getCategoryID(String string) {
        return string == null ? this.categoryModel.getCurrentCategoryID() : string;
    }

    void initCurrentCategory(final String string, final String string2) {
        boolean bl = "General".equals(this.getCategoryID(string));
        if (this.categoryModel.isLookupInitialized() || bl) {
            this.setCurrentCategory(this.categoryModel.getCategory(this.getCategoryID(string)), string2);
            this.initActions();
        } else {
            RequestProcessor.getDefault().post(new Runnable(){

                @Override
                public void run() {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            Frame[] frameArray = Frame.getFrames();
                            if (frameArray == null || frameArray.length == 0) {
                                return;
                            }
                            Frame frame = frameArray[0];
                            Cursor cursor = frame.getCursor();
                            frame.setCursor(Cursor.getPredefinedCursor(3));
                            OptionsPanel.this.setCursor(Cursor.getPredefinedCursor(3));
                            OptionsPanel.this.setCurrentCategory(OptionsPanel.this.categoryModel.getCategory(OptionsPanel.this.getCategoryID(string)), string2);
                            OptionsPanel.this.initActions();
                            frame.setCursor(cursor);
                            OptionsPanel.this.setCursor(cursor);
                        }
                    });
                }
            }, 500);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setCurrentCategory(CategoryModel.Category category, String string) {
        this.setCursor(Cursor.getPredefinedCursor(3));
        try {
            if (category == null) {
                JPanel jPanel = new JPanel(new BorderLayout());
                JLabel jLabel = new JLabel(OptionsPanel.loc("CTL_Options_Search_Nothing_Found"));
                jLabel.setHorizontalAlignment(0);
                jLabel.setHorizontalTextPosition(0);
                jPanel.add((Component)jLabel, "Center");
                jPanel.setSize(this.pOptions.getSize());
                jPanel.setPreferredSize(this.pOptions.getPreferredSize());
                Dimension dimension = jPanel.getSize();
                if (jPanel.getParent() == null || !this.pOptions.equals(jPanel.getParent())) {
                    this.pOptions.add((Component)jPanel, jLabel.getText());
                }
                this.cLayout.show(this.pOptions, jLabel.getText());
                this.checkSize(dimension);
                this.firePropertyChange("buranhelpCtx", null, null);
            } else {
                CategoryModel.Category category2 = this.categoryModel.getCurrent();
                if (category2 != null) {
                    this.buttons.get(category2.getID()).setNormal();
                }
                if (category != null) {
                    this.buttons.get(category.getID()).setSelected();
                }
                this.categoryModel.setCurrent(category);
                JComponent jComponent = category.getComponent();
                category.update(this.controllerListener, false);
                Dimension dimension = jComponent.getSize();
                if (jComponent.getParent() == null || !this.pOptions.equals(jComponent.getParent())) {
                    this.pOptions.add((Component)jComponent, category.getCategoryName());
                }
                this.cLayout.show(this.pOptions, category.getCategoryName());
                this.checkSize(dimension);
                this.firePropertyChange("buranhelpCtx", null, null);
                if (string != null) {
                    category.setCurrentSubcategory(string);
                }
            }
        }
        finally {
            this.setCursor(null);
        }
    }

    public void setCategoryInstance(CategoryModel categoryModel) {
        this.categoryModel = categoryModel;
    }

    HelpCtx getHelpCtx() {
        if (this.categoryModel == null) {
            return null;
        }
        return this.categoryModel.getHelpCtx();
    }

    void update() {
        if (this.categoryModel == null) {
            return;
        }
        this.categoryModel.update(this.controllerListener, true);
    }

    void save(boolean bl) {
        if (this.categoryModel == null) {
            return;
        }
        this.applyPressed = bl;
        this.save();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (OptionsPanel.this.applyPressed) {
                    OptionsPanel.this.categoryModel.update(OptionsPanel.this.controllerListener, false);
                }
                OptionsPanel.this.applyPressed = false;
            }
        });
    }

    void save() {
        if (this.categoryModel == null) {
            return;
        }
        this.categoryModel.save();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (OptionsPanel.this.categoryModel == null) {
                    return;
                }
                OptionsPanel.this.clearSearchField();
                if (!OptionsPanel.this.applyPressed) {
                    OptionsPanel.this.categoryModel = null;
                }
            }
        });
    }

    void cancel() {
        if (this.categoryModel == null) {
            return;
        }
        this.clearSearchField();
        this.categoryModel.cancel();
        this.categoryModel = null;
    }

    boolean dataValid() {
        if (this.categoryModel == null) {
            return false;
        }
        return this.categoryModel.dataValid();
    }

    boolean isChanged() {
        if (this.categoryModel == null) {
            return false;
        }
        return this.categoryModel.isChanged();
    }

    boolean needsReinit() {
        if (this.categoryModel == null) {
            return false;
        }
        return this.categoryModel.needsReinit();
    }

    private void initUI(String string) {
        this.getAccessibleContext().setAccessibleDescription(OptionsPanel.loc("ACS_OptionsPanel"));
        this.pOptions = new JPanel();
        this.cLayout = new CardLayout();
        this.pOptions.setLayout(this.cLayout);
        this.pOptions.setPreferredSize(this.getUserSize());
        JLabel jLabel = new JLabel(OptionsPanel.loc("CTL_Loading_Options"));
        jLabel.setHorizontalAlignment(0);
        this.pOptions.add((Component)jLabel, jLabel.getText());
        this.pCategories2 = new JPanel(new GridBagLayout());
        this.pCategories2.setBackground(OptionsPanel.getTabPanelBackground());
        this.pCategories2.setBorder(null);
        this.addCategoryButtons();
        this.quickSearch = new JPanel(new FlowLayout(2, 0, 0));
        this.quickSearch.setBackground(OptionsPanel.getTabPanelBackground());
        QuickSearch quickSearch = QuickSearch.attach((JComponent)this.quickSearch, null, (QuickSearch.Callback)new OptionsQSCallback());
        quickSearch.setAlwaysShown(true);
        JComponent jComponent = (JComponent)this.quickSearch.getComponent(0);
        jComponent.setToolTipText(Bundle.Filter_Textfield_Tooltip());
        this.searchTC = (JTextComponent)jComponent.getComponent(jComponent.getComponentCount() - 1);
        this.searchTC.setToolTipText(Bundle.Filter_Textfield_Tooltip());
        this.searchTC.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                OptionsPanel.this.showHint(false);
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                if (OptionsPanel.this.text2search.trim().isEmpty()) {
                    OptionsPanel.this.showHint(true);
                } else {
                    OptionsPanel.this.showHint(false);
                }
                if (focusEvent.getOppositeComponent() != null && focusEvent.getOppositeComponent().equals(OptionsPanel.this.quickSearch) && !OptionsPanel.this.clearSearch) {
                    OptionsPanel.this.searchTC.requestFocusInWindow();
                } else {
                    OptionsPanel.this.clearSearch = false;
                    if (focusEvent.getOppositeComponent() != null && focusEvent.getOppositeComponent().equals(OptionsPanel.this.quickSearch)) {
                        OptionsPanel.this.pOptions.requestFocusInWindow();
                    }
                }
            }
        });
        this.showHint(true);
        this.pCategories = new JPanel(new BorderLayout());
        this.pCategories.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, Color.lightGray));
        this.pCategories.setBackground(OptionsPanel.getTabPanelBackground());
        this.categoriesScrollPane = new JScrollPane(this.pCategories2, 21, 30);
        this.categoriesScrollPane.setBorder(null);
        this.categoriesScrollPane.getHorizontalScrollBar().setUnitIncrement(16);
        this.pCategories.add("Center", this.categoriesScrollPane);
        this.pCategories.add("East", this.quickSearch);
        this.pCategories.setPreferredSize(new Dimension(this.pCategories.getPreferredSize().width, this.pCategories.getPreferredSize().height + this.categoriesScrollPane.getHorizontalScrollBar().getPreferredSize().height));
        this.setLayout(new BorderLayout(10, 10));
        this.pOptions.setBorder(new CompoundBorder(new VariableBorder(null, null, this.borderMac, null), BorderFactory.createEmptyBorder(0, 5, 5, 5)));
        this.add((Component)this.pCategories, "North");
        this.add((Component)this.pOptions, "Center");
        string = this.getCategoryID(string);
        if (string != null) {
            CategoryModel.Category category = this.categoryModel.getCategory(this.getCategoryID(string));
            CategoryButton categoryButton = this.buttons.get(string);
            if (categoryButton != null) {
                categoryButton.setSelected();
            }
        }
    }

    private void clearSearchField() {
        this.searchTC.setText("");
        this.clearAllinQS();
    }

    private void showHint(boolean bl) {
        if (this.origForeground == null) {
            this.origForeground = this.searchTC.getForeground();
        }
        if (bl) {
            this.searchTC.setForeground(this.searchTC.getDisabledTextColor());
            this.searchTC.setText(this.hintText);
        } else {
            this.searchTC.setForeground(this.origForeground);
            this.searchTC.setText(this.text2search);
        }
    }

    private void computeOptionsWords() {
        Set<Map.Entry<String, CategoryModel.Category>> set = this.categoryModel.getCategories();
        this.categoryid2tabs = new HashMap();
        for (Map.Entry<String, CategoryModel.Category> fileObjectArray : set) {
            JComponent jComponent = fileObjectArray.getValue().getComponent();
            String string = fileObjectArray.getValue().getID();
            if (jComponent instanceof JTabbedPane) {
                this.categoryid2tabbedpane.put(string, (JTabbedPane)jComponent);
                continue;
            }
            if (jComponent instanceof AdvancedPanel) {
                this.categoryid2tabbedpane.put(string, (JTabbedPane)jComponent.getComponent(0));
                continue;
            }
            if (!(jComponent instanceof Container)) continue;
            this.handleAllComponents(jComponent, string, null, -1);
        }
        FileObject fileObject = FileUtil.getConfigRoot().getFileObject(CategoryModel.OD_LAYER_KEYWORDS_FOLDER_NAME);
        for (FileObject fileObject2 : fileObject.getChildren()) {
            this.handlePanel(fileObject2);
        }
    }

    private void handlePanel(FileObject fileObject) {
        Object object;
        Object object2;
        ArrayList<String> arrayList;
        String string = fileObject.getAttribute("location").toString();
        String string2 = fileObject.getAttribute("tabTitle").toString();
        JTabbedPane jTabbedPane = this.categoryid2tabbedpane.get(string);
        int n = jTabbedPane == null ? -1 : jTabbedPane.indexOfTab(string2);
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add(string.toUpperCase());
        Enumeration enumeration = fileObject.getAttributes();
        while (enumeration.hasMoreElements()) {
            arrayList = (String)enumeration.nextElement();
            if (!((String)((Object)arrayList)).startsWith("keywords")) continue;
            object2 = fileObject.getAttribute((String)((Object)arrayList)).toString();
            hashSet.add(((String)object2).toUpperCase());
        }
        arrayList = this.categoryid2words.get(string);
        if (arrayList == null) {
            arrayList = new ArrayList();
        }
        object2 = new HashSet();
        Object object3 = hashSet.iterator();
        while (object3.hasNext()) {
            object = (String)object3.next();
            if (arrayList.contains(object)) continue;
            object2.add(object);
        }
        arrayList.addAll((Collection<String>)object2);
        this.categoryid2words.put(string, arrayList);
        if (!this.categoryid2tabs.containsKey(string)) {
            this.categoryid2tabs.put(string, new HashMap());
        }
        object = !((HashMap)(object3 = this.categoryid2tabs.get(string))).containsKey(n) ? new TabInfo() : (TabInfo)((HashMap)object3).get(n);
        ((TabInfo)object).addWords(hashSet);
        ((HashMap)object3).put(n, object);
        this.categoryid2tabs.put(string, (HashMap<Integer, TabInfo>)object3);
    }

    private void handleAllComponents(Container container, String string, JTabbedPane jTabbedPane, int n) {
        Component[] componentArray = container.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            Component component = componentArray[i];
            if (component instanceof JTabbedPane) {
                if (this.categoryid2tabbedpane.get(string) != null) continue;
                this.categoryid2tabbedpane.put(string, (JTabbedPane)component);
                continue;
            }
            this.handleAllComponents((Container)component, string, jTabbedPane, n);
        }
    }

    private void clearAllinQS() {
        this.clearSearch = true;
        for (String string : this.categoryModel.getCategoryIDs()) {
            JTabbedPane jTabbedPane = this.categoryid2tabbedpane.get(string);
            if (this.categoryid2tabs.get(string) != null && jTabbedPane != null) {
                for (int i = 0; i < jTabbedPane.getTabCount(); ++i) {
                    jTabbedPane.setEnabledAt(i, true);
                }
            }
            this.buttons.get(string).setEnabled(true);
        }
        this.setCurrentCategory(this.categoryModel.getCurrent(), null);
        this.disabledCategories.clear();
        this.categoryModel.getCurrent().handleSuccessfulSearchInController(null, null);
    }

    private void initActions() {
        if (this.getActionMap().get("PREVIOUS") == null) {
            InputMap inputMap = this.getInputMap(2);
            inputMap.put(KeyStroke.getKeyStroke(37, 0), "PREVIOUS");
            this.getActionMap().put("PREVIOUS", new PreviousAction());
            inputMap.put(KeyStroke.getKeyStroke(39, 0), "NEXT");
            this.getActionMap().put("NEXT", new NextAction());
        }
    }

    private void addCategoryButtons() {
        Iterator<CategoryButton> iterator = this.buttons.values().iterator();
        while (iterator.hasNext()) {
            this.removeButton(iterator.next());
        }
        this.pCategories2.removeAll();
        this.buttons = new LinkedHashMap<String, CategoryButton>();
        String[] stringArray = this.categoryModel.getCategoryIDs();
        for (int i = 0; i < stringArray.length; ++i) {
            CategoryModel.Category category = this.categoryModel.getCategory(stringArray[i]);
            this.addButton(category);
        }
        this.addFakeButton();
    }

    private CategoryButton addButton(CategoryModel.Category category) {
        Serializable serializable;
        CategoryButton categoryButton;
        int n = this.buttons.size();
        CategoryButton categoryButton2 = categoryButton = isNimbus || this.isGTK ? new NimbusCategoryButton(category) : new CategoryButton(category);
        if (!this.isMac) {
            serializable = KeyStroke.getKeyStroke(categoryButton.getDisplayedMnemonic(), 8);
            this.getInputMap(2).put((KeyStroke)serializable, categoryButton);
            this.getActionMap().put(categoryButton, new SelectAction(category));
        }
        serializable = new GridBagConstraints();
        serializable.anchor = 18;
        serializable.fill = 1;
        serializable.weightx = 0.0;
        serializable.weighty = 0.0;
        serializable.gridx = n;
        serializable.gridy = 0;
        this.pCategories2.add((Component)categoryButton, serializable);
        this.buttons.put(category.getID(), categoryButton);
        return categoryButton;
    }

    private void removeButton(CategoryButton categoryButton) {
        KeyStroke keyStroke = KeyStroke.getKeyStroke(categoryButton.getDisplayedMnemonic(), 8);
        this.getInputMap(2).remove(keyStroke);
        this.getActionMap().remove(categoryButton);
    }

    private void addFakeButton() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridy = 0;
        this.pCategories2.add((Component)new JLabel(""), gridBagConstraints);
    }

    private Dimension getInitSize() {
        return new Dimension(750, 500);
    }

    Dimension getUserSize() {
        int n = NbPreferences.forModule(OptionsPanel.class).getInt("OptionsWidth", this.getInitSize().width);
        int n2 = NbPreferences.forModule(OptionsPanel.class).getInt("OptionsHeight", this.getInitSize().height);
        return new Dimension(n, n2);
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        Rectangle rectangle = Utilities.getUsableScreenBounds();
        return new Dimension(Math.min(dimension.width, rectangle.width - 101), Math.min(dimension.height, rectangle.height - 101));
    }

    void storeUserSize() {
        Dimension dimension = this.pOptions.getSize();
        NbPreferences.forModule(OptionsPanel.class).putInt("OptionsWidth", dimension.width);
        NbPreferences.forModule(OptionsPanel.class).putInt("OptionsHeight", dimension.height);
        this.pOptions.setPreferredSize(dimension);
    }

    private boolean checkSize(Dimension dimension) {
        boolean bl = false;
        Dimension dimension2 = this.pOptions.getPreferredSize();
        Dimension dimension3 = this.getUserSize();
        dimension = new Dimension(Math.max(dimension.width, dimension3.width), Math.max(dimension.height, dimension3.height));
        if (dimension2.width < dimension.width || dimension2.height < dimension.height) {
            Dimension dimension4 = new Dimension(Math.max(dimension2.width, dimension.width), Math.max(dimension2.height, dimension.height));
            this.pOptions.setPreferredSize(dimension4);
            Window window = (Window)SwingUtilities.getAncestorOfClass(Window.class, this);
            this.invalidate();
            if (window != null) {
                window.pack();
            }
            bl = true;
        }
        return bl;
    }

    private static Color getTabPanelBackground() {
        if (isMetal || isNimbus) {
            Color color = UIManager.getColor("Tree.background");
            if (null == color) {
                color = Color.white;
            }
            return new Color(color.getRGB());
        }
        return Color.white;
    }

    private static Color getTabPanelForeground() {
        if (isMetal || isNimbus) {
            Color color = UIManager.getColor("Tree.foreground");
            if (null == color) {
                color = Color.black;
            }
            return new Color(color.getRGB());
        }
        return Color.black;
    }

    private static Color getSelectionBackground() {
        if ((isMetal || isNimbus) && !Color.white.equals(OptionsPanel.getTabPanelBackground())) {
            Color color = UIManager.getColor("Tree.selectionBackground");
            if (null == color) {
                color = Color.blue;
            }
            return new Color(color.getRGB());
        }
        return new Color(193, 210, 238);
    }

    private static Color getHighlightBackground() {
        if ((isMetal || isNimbus) && !Color.white.equals(OptionsPanel.getTabPanelBackground())) {
            Color color = UIManager.getColor("Tree.selectionBackground");
            if (null == color) {
                color = Color.blue;
            }
            return new Color(color.getRGB());
        }
        return new Color(224, 232, 246);
    }

    private boolean doPreviousNextAction(String[] stringArray, int n, int n2, boolean bl) {
        if (bl) {
            for (int i = n; i < n2; ++i) {
                String string = stringArray[i];
                if (!this.buttons.get(string).isEnabled()) continue;
                this.setCurrentCategory(this.categoryModel.getCategory(string), null);
                return false;
            }
        } else {
            for (int i = n; i > n2; --i) {
                String string = stringArray[i];
                if (!this.buttons.get(string).isEnabled()) continue;
                this.setCurrentCategory(this.categoryModel.getCategory(string), null);
                return false;
            }
        }
        return true;
    }

    private static class NimbusBorder
    implements Border {
        private static final Color COLOR_BORDER = new Color(72, 93, 112, 255);
        private static final Color COLOR_SHADOW1 = new Color(72, 93, 112, 100);
        private static final Color COLOR_SHADOW2 = new Color(72, 93, 112, 60);

        private NimbusBorder() {
        }

        @Override
        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            Area area = new Area(new RoundRectangle2D.Float(n, n2, n3 - 3, n4 - 2, 4.0f, 4.0f));
            graphics2D.setColor(COLOR_BORDER);
            graphics2D.draw(area);
            Area area2 = new Area(area);
            AffineTransform affineTransform = new AffineTransform();
            affineTransform.translate(1.0, 1.0);
            area2.transform(affineTransform);
            area2.subtract(area);
            graphics2D.setColor(COLOR_SHADOW1);
            graphics2D.draw(area2);
            area2 = new Area(area);
            affineTransform = new AffineTransform();
            affineTransform.translate(2.0, 2.0);
            area2.transform(affineTransform);
            area2.subtract(area);
            graphics2D.setColor(COLOR_SHADOW2);
            graphics2D.draw(area2);
        }

        @Override
        public Insets getBorderInsets(Component component) {
            return new Insets(1, 1, 3, 3);
        }

        @Override
        public boolean isBorderOpaque() {
            return false;
        }
    }

    private class NimbusCategoryButton
    extends CategoryButton {
        private short status;

        public NimbusCategoryButton(CategoryModel.Category category) {
            super(category);
            this.status = 0;
            this.setOpaque(false);
            this.setBorder(normalBorder);
        }

        @Override
        protected void paintChildren(Graphics graphics) {
            super.paintChildren(graphics);
        }

        @Override
        protected void paintComponent(Graphics graphics) {
            if (isDefaultTabBackground && (this.status == 1 || this.status == 2)) {
                Insets insets = this.getInsets();
                insets.top -= 4;
                insets.left -= 4;
                insets.bottom -= 4;
                insets.right -= 4;
                Graphics2D graphics2D = (Graphics2D)graphics.create();
                int n = this.getWidth() - insets.left - insets.right + 1;
                int n2 = this.getHeight() - insets.top - insets.bottom + 1;
                int n3 = (int)(0.7 * (double)n2);
                int n4 = n2 - n3;
                Color color = this.status == 2 ? COL_OVER_GRADIENT1 : COL_GRADIENT1;
                Color color2 = this.status == 2 ? COL_OVER_GRADIENT2 : COL_GRADIENT2;
                Color color3 = this.status == 2 ? COL_OVER_GRADIENT3 : COL_GRADIENT3;
                graphics2D.setPaint(new GradientPaint(insets.left, insets.top, color, insets.left, insets.top + n3, color2));
                graphics2D.fillRect(insets.left, insets.top, n, n3);
                graphics2D.setPaint(new GradientPaint(insets.left, insets.top + n3, color2, insets.left, insets.top + n3 + n4, color3));
                graphics2D.fillRect(insets.left, insets.top + n3, n, n4);
                graphics2D.dispose();
            }
            super.paintComponent(graphics);
        }

        @Override
        void setHighlighted() {
            super.setHighlighted();
            this.status = (short)2;
            this.setBorder(selBorder);
            this.repaint();
        }

        @Override
        void setNormal() {
            this.setBorder(normalBorder);
            this.status = 0;
            this.repaint();
        }

        @Override
        void setSelected() {
            this.setBorder(selBorder);
            this.status = 1;
            this.repaint();
        }
    }

    class CategoryButton
    extends JLabel
    implements MouseListener {
        private final CategoryModel.Category category;

        CategoryButton(CategoryModel.Category category) {
            super(category.getIcon());
            this.category = category;
            Mnemonics.setLocalizedText((JLabel)this, (String)category.getCategoryName());
            this.getAccessibleContext().setAccessibleName(category.getCategoryName());
            this.getAccessibleContext().setAccessibleDescription(Bundle.CategoryButton_AccessibleDescription(category.getCategoryName()));
            this.setDisplayedMnemonic(0);
            this.setOpaque(true);
            this.setVerticalTextPosition(3);
            this.setHorizontalTextPosition(0);
            this.setHorizontalAlignment(0);
            this.addMouseListener(this);
            this.setFocusable(false);
            this.setFocusTraversalKeysEnabled(false);
            this.setForeground(OptionsPanel.getTabPanelForeground());
            if (OptionsPanel.this.isMac) {
                this.setFont(OptionsPanel.this.labelFontMac);
                this.setIconTextGap(2);
            }
            this.setNormal();
        }

        void setNormal() {
            if (OptionsPanel.this.isMac) {
                this.setBorder(new EmptyBorder(5, 6, 3, 6));
            } else {
                this.setBorder(new EmptyBorder(2, 4, 2, 4));
            }
            this.setBackground(OptionsPanel.getTabPanelBackground());
        }

        void setSelected() {
            if (OptionsPanel.this.isMac) {
                this.setBorder(new CompoundBorder(new VariableBorder(null, OptionsPanel.this.selectedB, null, OptionsPanel.this.selectedB), BorderFactory.createEmptyBorder(5, 5, 3, 5)));
            } else {
                this.setBorder(new CompoundBorder(new CompoundBorder(new LineBorder(OptionsPanel.getTabPanelBackground()), new LineBorder(OptionsPanel.this.selectedB)), new EmptyBorder(0, 2, 0, 2)));
            }
            this.setBackground(OptionsPanel.this.selected);
        }

        void setHighlighted() {
            if (!OptionsPanel.this.isMac) {
                this.setBorder(new CompoundBorder(new CompoundBorder(new LineBorder(OptionsPanel.getTabPanelBackground()), new LineBorder(OptionsPanel.this.highlightedB)), new EmptyBorder(0, 2, 0, 2)));
                this.setBackground(OptionsPanel.this.highlighted);
            }
            if (!this.category.isHighlited()) {
                CategoryButton categoryButton;
                if (OptionsPanel.this.categoryModel.getHighlitedCategoryID() != null && (categoryButton = (CategoryButton)OptionsPanel.this.buttons.get(OptionsPanel.this.categoryModel.getHighlitedCategoryID())) != null && !categoryButton.category.isCurrent()) {
                    categoryButton.setNormal();
                }
                OptionsPanel.this.categoryModel.setHighlited(this.category, true);
            }
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (((CategoryButton)OptionsPanel.this.buttons.get(this.category.getID())).isEnabled() && !OptionsPanel.this.isMac && OptionsPanel.this.categoryModel.getCurrent() != null) {
                this.setSelected();
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (((CategoryButton)OptionsPanel.this.buttons.get(this.category.getID())).isEnabled() && !this.category.isCurrent() && this.category.isHighlited() && OptionsPanel.this.categoryModel.getCurrent() != null) {
                OptionsPanel.this.setCurrentCategory(this.category, null);
            }
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            CategoryButton categoryButton = (CategoryButton)OptionsPanel.this.buttons.get(this.category.getID());
            if (categoryButton != null && categoryButton.isEnabled() && !this.category.isCurrent() && OptionsPanel.this.categoryModel != null && OptionsPanel.this.categoryModel.getCurrent() != null) {
                this.setHighlighted();
            } else if (OptionsPanel.this.categoryModel != null) {
                OptionsPanel.this.categoryModel.setHighlited(OptionsPanel.this.categoryModel.getCategory(OptionsPanel.this.categoryModel.getHighlitedCategoryID()), false);
            }
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            if (!this.category.isCurrent() && !OptionsPanel.this.isMac && OptionsPanel.this.categoryModel.getCurrent() != null) {
                this.setNormal();
            }
        }
    }

    class ControllerListener
    implements PropertyChangeListener {
        ControllerListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            OptionsPanel.this.firePropertyChange("buran" + propertyChangeEvent.getPropertyName(), null, null);
        }
    }

    private class NextAction
    extends AbstractAction {
        private NextAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            CategoryModel.Category category = OptionsPanel.this.categoryModel.getNextCategory();
            if (((CategoryButton)OptionsPanel.this.buttons.get(category.getID())).isEnabled()) {
                OptionsPanel.this.setCurrentCategory(category, null);
            } else {
                String string = OptionsPanel.this.categoryModel.getCurrentCategoryID();
                String[] stringArray = OptionsPanel.this.categoryModel.getCategoryIDs();
                int n = Arrays.asList(stringArray).indexOf(string);
                if (n + 1 < stringArray.length) {
                    if (OptionsPanel.this.doPreviousNextAction(stringArray, n + 1, stringArray.length, true)) {
                        OptionsPanel.this.doPreviousNextAction(stringArray, 0, n, true);
                    }
                } else {
                    OptionsPanel.this.doPreviousNextAction(stringArray, 0, n, true);
                }
            }
        }
    }

    private class PreviousAction
    extends AbstractAction {
        private PreviousAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            CategoryModel.Category category = OptionsPanel.this.categoryModel.getPreviousCategory();
            if (((CategoryButton)OptionsPanel.this.buttons.get(category.getID())).isEnabled()) {
                OptionsPanel.this.setCurrentCategory(category, null);
            } else {
                String string = OptionsPanel.this.categoryModel.getCurrentCategoryID();
                String[] stringArray = OptionsPanel.this.categoryModel.getCategoryIDs();
                int n = Arrays.asList(stringArray).indexOf(string);
                if (n - 1 > -1) {
                    if (OptionsPanel.this.doPreviousNextAction(stringArray, n - 1, -1, false)) {
                        OptionsPanel.this.doPreviousNextAction(stringArray, stringArray.length - 1, n, false);
                    }
                } else {
                    OptionsPanel.this.doPreviousNextAction(stringArray, stringArray.length - 1, n, false);
                }
            }
        }
    }

    private class SearchAction
    extends AbstractAction {
        private SearchAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            OptionsPanel.this.showHint(false);
            OptionsPanel.this.searchTC.requestFocusInWindow();
        }
    }

    private class SelectCurrentAction
    extends AbstractAction {
        private SelectCurrentAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            CategoryModel.Category category = OptionsPanel.this.categoryModel.getCategory(OptionsPanel.this.categoryModel.getHighlitedCategoryID());
            if (category != null) {
                OptionsPanel.this.setCurrentCategory(category, null);
            }
        }
    }

    private class SelectAction
    extends AbstractAction {
        private CategoryModel.Category category;

        SelectAction(CategoryModel.Category category) {
            this.category = category;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            OptionsPanel.this.setCurrentCategory(this.category, null);
        }
    }

    final class OptionsQSCallback
    implements QuickSearch.Callback {
        private boolean initialized = false;

        OptionsQSCallback() {
        }

        public void quickSearchUpdate(String string) {
            if (!string.equalsIgnoreCase(OptionsPanel.this.hintText)) {
                OptionsPanel.this.text2search = string.trim();
            }
        }

        private void showWaitCursor() {
            Mutex.EVENT.readAccess(new Runnable(){

                @Override
                public void run() {
                    JFrame jFrame = (JFrame)WindowManager.getDefault().getMainWindow();
                    jFrame.getGlassPane().setCursor(Cursor.getPredefinedCursor(3));
                    jFrame.getGlassPane().setVisible(true);
                    StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(OptionsDisplayerImpl.class, (String)"CTL_Searching_Options"));
                }
            });
        }

        private void hideWaitCursor() {
            Mutex.EVENT.readAccess(new Runnable(){

                @Override
                public void run() {
                    StatusDisplayer.getDefault().setStatusText("");
                    JFrame jFrame = (JFrame)WindowManager.getDefault().getMainWindow();
                    jFrame.getGlassPane().setVisible(false);
                    jFrame.getGlassPane().setCursor(null);
                }
            });
        }

        private int getNextEnabledTabIndex(JTabbedPane jTabbedPane, int n) {
            int n2;
            for (n2 = n + 1; n2 < jTabbedPane.getTabCount(); ++n2) {
                if (!jTabbedPane.isEnabledAt(n2)) continue;
                return n2;
            }
            for (n2 = 0; n2 < n; ++n2) {
                if (!jTabbedPane.isEnabledAt(n2)) continue;
                return n2;
            }
            return -1;
        }

        private boolean containsAllSearchWords(ArrayList<String> arrayList, Collection<String> collection) {
            Iterator<String> iterator = collection.iterator();
            while (iterator.hasNext()) {
                if (this.containsSearchWord(arrayList, iterator.next())) continue;
                return false;
            }
            return true;
        }

        private boolean containsSearchWord(ArrayList<String> arrayList, String string) {
            Iterator<String> iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                if (!iterator.next().contains(string)) continue;
                return true;
            }
            return false;
        }

        private ArrayList<String> getAllMatchedKeywords(ArrayList<String> arrayList, Collection<String> collection) {
            ArrayList<String> arrayList2 = new ArrayList<String>();
            Iterator<String> iterator = collection.iterator();
            while (iterator.hasNext()) {
                arrayList2.addAll(this.getMatchedKeywords(arrayList, iterator.next(), arrayList2));
            }
            return arrayList2;
        }

        private ArrayList<String> getMatchedKeywords(ArrayList<String> arrayList, String string, ArrayList<String> arrayList2) {
            ArrayList<String> arrayList3 = new ArrayList<String>();
            for (String string2 : arrayList) {
                for (String string3 : string2.split(",")) {
                    if (!(string3 = string3.trim()).contains(string) || arrayList2.contains(string3) || arrayList3.contains(string3)) continue;
                    arrayList3.add(string3);
                }
            }
            return arrayList3;
        }

        private void handleSearch(String string) {
            List<String> list = Arrays.asList(string.toUpperCase().split(" "));
            String string2 = null;
            String string3 = null;
            int n = -1;
            for (String string4 : OptionsPanel.this.categoryModel.getCategoryIDs()) {
                n = -1;
                ArrayList arrayList = (ArrayList)OptionsPanel.this.categoryid2words.get(string4);
                if (arrayList != null) {
                    boolean bl = this.containsAllSearchWords(arrayList, list);
                    for (String string5 : list) {
                        if (!string4.toUpperCase().contains(string5)) continue;
                        string2 = string4;
                    }
                    if (bl) {
                        ArrayList<String> arrayList2;
                        OptionsPanel.this.disabledCategories.remove(string4);
                        ((CategoryButton)OptionsPanel.this.buttons.get(string4)).setEnabled(true);
                        JTabbedPane jTabbedPane = (JTabbedPane)OptionsPanel.this.categoryid2tabbedpane.get(string4);
                        if (OptionsPanel.this.categoryid2tabs.get(string4) != null) {
                            HashMap hashMap = (HashMap)OptionsPanel.this.categoryid2tabs.get(string4);
                            boolean bl2 = true;
                            for (Integer n2 : hashMap.keySet()) {
                                if (n2 != -1) {
                                    ArrayList<String> arrayList3 = ((TabInfo)hashMap.get(n2)).getWords();
                                    boolean bl3 = false;
                                    if (this.containsAllSearchWords(arrayList3, list)) {
                                        bl3 = true;
                                        bl2 = false;
                                        n = n2;
                                        if (string2 == null && string3 == null || string2 != null && string2.equals(string4)) {
                                            OptionsPanel.this.setCurrentCategory(OptionsPanel.this.categoryModel.getCategory(string4), null);
                                        }
                                    }
                                    if (bl3) {
                                        for (String string6 : list) {
                                            if (!jTabbedPane.getTitleAt(n2).toUpperCase().contains(string6)) continue;
                                            string3 = jTabbedPane.getTitleAt(n2);
                                        }
                                        jTabbedPane.setEnabledAt(n2, true);
                                        if (n == n2 && (string3 == null || string3 != null && jTabbedPane.getTitleAt(n2).equals(string3))) {
                                            jTabbedPane.setSelectedIndex(n2);
                                        }
                                        arrayList2 = this.getAllMatchedKeywords(arrayList3, list);
                                        OptionsPanel.this.categoryModel.getCurrent().handleSuccessfulSearchInController(string, arrayList2);
                                        continue;
                                    }
                                    jTabbedPane.setEnabledAt(n2, false);
                                    if (n != -1) continue;
                                    jTabbedPane.setSelectedIndex(this.getNextEnabledTabIndex(jTabbedPane, n2));
                                    continue;
                                }
                                if (string2 == null && string3 == null || string2 != null && string2.equals(string4)) {
                                    OptionsPanel.this.setCurrentCategory(OptionsPanel.this.categoryModel.getCategory(string4), null);
                                }
                                if (hashMap.size() != 1) continue;
                                bl2 = false;
                                arrayList2 = this.getAllMatchedKeywords(arrayList, list);
                                OptionsPanel.this.categoryModel.getCurrent().handleSuccessfulSearchInController(string, arrayList2);
                            }
                            if (!bl2) continue;
                            this.handleNotFound(string4, string2, string3);
                            continue;
                        }
                        if (string2 == null && string3 == null || string2 != null && string2.equals(string4)) {
                            OptionsPanel.this.setCurrentCategory(OptionsPanel.this.categoryModel.getCategory(string4), null);
                        }
                        arrayList2 = this.getAllMatchedKeywords(arrayList, list);
                        OptionsPanel.this.categoryModel.getCurrent().handleSuccessfulSearchInController(string, arrayList2);
                        continue;
                    }
                    this.handleNotFound(string4, string2, string3);
                    continue;
                }
                this.handleNotFound(string4, string2, string3);
            }
        }

        private void handleNotFound(String string, String string2, String string3) {
            if (!OptionsPanel.this.disabledCategories.contains(string)) {
                OptionsPanel.this.disabledCategories.add(string);
            }
            JTabbedPane jTabbedPane = (JTabbedPane)OptionsPanel.this.categoryid2tabbedpane.get(string);
            if (OptionsPanel.this.categoryid2tabs.get(string) != null && jTabbedPane != null) {
                for (int i = 0; i < jTabbedPane.getTabCount(); ++i) {
                    jTabbedPane.setEnabledAt(i, false);
                }
            }
            ((CategoryButton)OptionsPanel.this.buttons.get(string)).setEnabled(false);
            if (OptionsPanel.this.disabledCategories.size() == OptionsPanel.this.buttons.size()) {
                OptionsPanel.this.setCurrentCategory(null, null);
            } else {
                for (String string4 : OptionsPanel.this.categoryModel.getCategoryIDs()) {
                    if (!((CategoryButton)OptionsPanel.this.buttons.get(string4)).isEnabled() || (string2 == null || !string2.equals(string4)) && (string2 != null || string3 != null)) continue;
                    OptionsPanel.this.setCurrentCategory(OptionsPanel.this.categoryModel.getCategory(string4), null);
                    break;
                }
            }
        }

        public void showNextSelection(boolean bl) {
        }

        public String findMaxPrefix(String string) {
            return string;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void quickSearchConfirmed() {
            if (OptionsPanel.this.text2search.length() == 0) {
                OptionsPanel.this.clearAllinQS();
                OptionsPanel.this.showHint(true);
                return;
            }
            this.showWaitCursor();
            try {
                if (!this.initialized) {
                    final String string = OptionsPanel.this.text2search;
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            OptionsPanel.this.computeOptionsWords();
                            OptionsQSCallback.this.initialized = true;
                            OptionsQSCallback.this.handleSearch(string);
                            OptionsPanel.this.showHint(false);
                        }
                    });
                } else {
                    this.handleSearch(OptionsPanel.this.text2search);
                    OptionsPanel.this.showHint(false);
                }
            }
            finally {
                this.hideWaitCursor();
            }
        }

        public void quickSearchCanceled() {
            OptionsPanel.this.clearAllinQS();
            OptionsPanel.this.showHint(true);
        }
    }

    private class TabInfo {
        private ArrayList<String> words = new ArrayList();

        public ArrayList<String> getWords() {
            return this.words;
        }

        public void addWord(String string) {
            this.words.add(string.toUpperCase());
        }

        public void addWords(Set<String> set) {
            for (String string : set) {
                this.addWord(string);
            }
        }
    }
}

