/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.initialization.loadercache;

import com.google.common.collect.Iterators;
import com.google.common.collect.Sets;
import com.google.common.hash.HashCode;
import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import java.io.File;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.gradle.api.internal.hash.FileHasher;
import org.gradle.internal.classloader.ClassPathSnapshot;
import org.gradle.internal.classloader.ClassPathSnapshotter;
import org.gradle.internal.classpath.ClassPath;
import org.gradle.internal.nativeintegration.filesystem.FileMetadataSnapshot;
import org.gradle.internal.nativeintegration.filesystem.FileSystem;
import org.gradle.internal.nativeintegration.filesystem.FileType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HashClassPathSnapshotter
implements ClassPathSnapshotter {
    private final FileHasher hasher;
    private final FileSystem fileSystem;

    public HashClassPathSnapshotter(FileHasher hasher, FileSystem fileSystem) {
        this.hasher = hasher;
        this.fileSystem = fileSystem;
    }

    public ClassPathSnapshot snapshot(ClassPath classPath) {
        HashSet visitedDirs = Sets.newHashSet();
        List cpFiles = classPath.getAsFiles();
        Hasher checksum = Hashing.md5().newHasher();
        this.hash(checksum, visitedDirs, cpFiles.iterator());
        return new HashClassPathSnapshot(checksum.hash());
    }

    private void hash(Hasher combinedHash, Set<File> visitedDirs, Iterator<File> toHash) {
        while (toHash.hasNext()) {
            File file = toHash.next();
            FileMetadataSnapshot fileDetails = this.fileSystem.stat(file);
            if (fileDetails.getType() == FileType.Directory) {
                if (!visitedDirs.add(file)) continue;
                Object[] sortedFiles = file.listFiles();
                Arrays.sort(sortedFiles);
                this.hash(combinedHash, visitedDirs, (Iterator<File>)Iterators.forArray((Object[])sortedFiles));
                continue;
            }
            if (fileDetails.getType() != FileType.RegularFile) continue;
            combinedHash.putBytes(this.hasher.hash(file, fileDetails).asBytes());
        }
    }

    private static class HashClassPathSnapshot
    implements ClassPathSnapshot {
        private final HashCode hash;

        HashClassPathSnapshot(HashCode hash) {
            this.hash = hash;
        }

        public HashCode getStrongHash() {
            return this.hash;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            HashClassPathSnapshot that = (HashClassPathSnapshot)o;
            return this.hash.equals((Object)that.hash);
        }

        public int hashCode() {
            return this.hash.hashCode();
        }
    }
}

