/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugin.use.resolve.internal;

import org.gradle.api.internal.DocumentationRegistry;
import org.gradle.api.internal.plugins.PluginImplementation;
import org.gradle.api.internal.plugins.PluginRegistry;
import org.gradle.plugin.internal.PluginId;
import org.gradle.plugin.use.internal.InvalidPluginRequestException;
import org.gradle.plugin.use.internal.PluginRequest;
import org.gradle.plugin.use.resolve.internal.PluginResolutionResult;
import org.gradle.plugin.use.resolve.internal.PluginResolver;
import org.gradle.plugin.use.resolve.internal.SimplePluginResolution;

public class CorePluginResolver
implements PluginResolver {
    private final DocumentationRegistry documentationRegistry;
    private final PluginRegistry pluginRegistry;

    public CorePluginResolver(DocumentationRegistry documentationRegistry, PluginRegistry pluginRegistry) {
        this.documentationRegistry = documentationRegistry;
        this.pluginRegistry = pluginRegistry;
    }

    @Override
    public void resolve(PluginRequest pluginRequest, PluginResolutionResult result) {
        PluginId id = pluginRequest.getId();
        if (!id.isQualified() || id.inNamespace("org.gradle")) {
            PluginImplementation plugin = this.pluginRegistry.lookup(id);
            if (plugin == null) {
                result.notFound(CorePluginResolver.getDescription(), String.format("not a core plugin, please see %s for available core plugins", this.documentationRegistry.getDocumentationFor("standard_plugins")));
            } else {
                if (pluginRequest.getVersion() != null) {
                    throw new InvalidPluginRequestException(pluginRequest, "Plugin '" + id + "' is a core Gradle plugin, which cannot be specified with a version number. " + "Such plugins are versioned as part of Gradle. Please remove the version number from the declaration.");
                }
                if (!pluginRequest.isApply()) {
                    throw new InvalidPluginRequestException(pluginRequest, "Plugin '" + id + "' is a core Gradle plugin, which is already on the classpath. " + "Requesting it with the 'apply false' option is a no-op.");
                }
                result.found(CorePluginResolver.getDescription(), new SimplePluginResolution(plugin));
            }
        } else {
            result.notFound(CorePluginResolver.getDescription(), String.format("plugin is not in '%s' namespace", "org.gradle"));
        }
    }

    public static String getDescription() {
        return "Gradle Core Plugins";
    }
}

