/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.string;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.CreateCast;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.DirectCallNode;
import com.oracle.truffle.api.nodes.IndirectCallNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.api.profiles.ConditionProfile;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import org.jcodings.Encoding;
import org.jcodings.exception.EncodingException;
import org.jcodings.specific.ASCIIEncoding;
import org.jcodings.specific.USASCIIEncoding;
import org.jcodings.specific.UTF8Encoding;
import org.jruby.truffle.Layouts;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.builtins.CoreClass;
import org.jruby.truffle.builtins.CoreMethod;
import org.jruby.truffle.builtins.CoreMethodArrayArgumentsNode;
import org.jruby.truffle.builtins.CoreMethodNode;
import org.jruby.truffle.builtins.Primitive;
import org.jruby.truffle.builtins.PrimitiveArrayArgumentsNode;
import org.jruby.truffle.builtins.PrimitiveNode;
import org.jruby.truffle.builtins.YieldingCoreMethodNode;
import org.jruby.truffle.core.array.ArrayCoreMethodNode;
import org.jruby.truffle.core.array.ArrayUtils;
import org.jruby.truffle.core.cast.ArrayAttributeCastNodeGen;
import org.jruby.truffle.core.cast.CmpIntNode;
import org.jruby.truffle.core.cast.CmpIntNodeGen;
import org.jruby.truffle.core.cast.TaintResultNode;
import org.jruby.truffle.core.cast.ToIntNode;
import org.jruby.truffle.core.cast.ToIntNodeGen;
import org.jruby.truffle.core.cast.ToStrNode;
import org.jruby.truffle.core.cast.ToStrNodeGen;
import org.jruby.truffle.core.encoding.EncodingNodes;
import org.jruby.truffle.core.encoding.EncodingNodesFactory;
import org.jruby.truffle.core.encoding.EncodingOperations;
import org.jruby.truffle.core.format.FormatExceptionTranslator;
import org.jruby.truffle.core.format.exceptions.FormatException;
import org.jruby.truffle.core.format.unpack.ArrayResult;
import org.jruby.truffle.core.format.unpack.UnpackCompiler;
import org.jruby.truffle.core.kernel.KernelNodes;
import org.jruby.truffle.core.kernel.KernelNodesFactory;
import org.jruby.truffle.core.numeric.FixnumLowerNodeGen;
import org.jruby.truffle.core.numeric.FixnumOrBignumNode;
import org.jruby.truffle.core.regexp.RegexpNodes;
import org.jruby.truffle.core.rope.CodeRange;
import org.jruby.truffle.core.rope.ConcatRope;
import org.jruby.truffle.core.rope.LeafRope;
import org.jruby.truffle.core.rope.RepeatingRope;
import org.jruby.truffle.core.rope.Rope;
import org.jruby.truffle.core.rope.RopeBuffer;
import org.jruby.truffle.core.rope.RopeConstants;
import org.jruby.truffle.core.rope.RopeNodes;
import org.jruby.truffle.core.rope.RopeNodesFactory;
import org.jruby.truffle.core.rope.RopeOperations;
import org.jruby.truffle.core.rope.SubstringRope;
import org.jruby.truffle.core.string.ByteList;
import org.jruby.truffle.core.string.ConvertBytes;
import org.jruby.truffle.core.string.DoubleConverter;
import org.jruby.truffle.core.string.StringCachingGuards;
import org.jruby.truffle.core.string.StringGuards;
import org.jruby.truffle.core.string.StringNodesFactory;
import org.jruby.truffle.core.string.StringOperations;
import org.jruby.truffle.core.string.StringSupport;
import org.jruby.truffle.core.string.StringUtils;
import org.jruby.truffle.language.CheckLayoutNode;
import org.jruby.truffle.language.NotProvided;
import org.jruby.truffle.language.RubyGuards;
import org.jruby.truffle.language.RubyNode;
import org.jruby.truffle.language.SnippetNode;
import org.jruby.truffle.language.control.RaiseException;
import org.jruby.truffle.language.dispatch.CallDispatchHeadNode;
import org.jruby.truffle.language.dispatch.DispatchHeadNodeFactory;
import org.jruby.truffle.language.objects.AllocateObjectNode;
import org.jruby.truffle.language.objects.IsTaintedNode;
import org.jruby.truffle.language.objects.TaintNode;
import org.jruby.truffle.platform.posix.TrufflePosix;

@CoreClass(value="String")
public abstract class StringNodes {

    @NodeChildren(value={@NodeChild(value="string"), @NodeChild(value="other")})
    public static abstract class StringAppendNode
    extends RubyNode {
        @Node.Child
        private EncodingNodes.CheckEncodingNode checkEncodingNode = EncodingNodesFactory.CheckEncodingNodeGen.create(null, null);
        @Node.Child
        private RopeNodes.MakeConcatNode makeConcatNode = RopeNodesFactory.MakeConcatNodeGen.create(null, null, null);

        public static StringAppendNode create() {
            return StringNodesFactory.StringAppendNodeGen.create(null, null);
        }

        public abstract Rope executeStringAppend(DynamicObject var1, DynamicObject var2);

        @Specialization
        public Rope stringAppend(DynamicObject string, DynamicObject other) {
            assert (RubyGuards.isRubyString(string));
            assert (RubyGuards.isRubyString(other));
            Rope left = StringOperations.rope(string);
            Rope right = StringOperations.rope(other);
            Encoding compatibleEncoding = this.checkEncodingNode.executeCheckEncoding(string, other);
            return this.makeConcatNode.executeMake(left, right, compatibleEncoding);
        }
    }

    @Primitive(name="string_from_bytearray", needsSelf=false, lowerFixnum={2, 3})
    public static abstract class StringFromByteArrayPrimitiveNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization(guards={"isRubiniusByteArray(bytes)"})
        public DynamicObject stringFromByteArray(DynamicObject bytes, int start, int count) {
            ByteList byteList = Layouts.BYTE_ARRAY.getBytes(bytes);
            return this.createString(new ByteList(byteList, start, count));
        }
    }

    @Primitive(name="string_substring", lowerFixnum={1, 2})
    @ImportStatic(value={StringGuards.class})
    public static abstract class StringSubstringPrimitiveNode
    extends PrimitiveArrayArgumentsNode {
        @Node.Child
        private AllocateObjectNode allocateNode;
        @Node.Child
        private NormalizeIndexNode normalizeIndexNode = StringNodesFactory.NormalizeIndexNodeGen.create(null, null);
        @Node.Child
        private RopeNodes.MakeSubstringNode makeSubstringNode;
        @Node.Child
        private TaintResultNode taintResultNode;

        public abstract Object execute(VirtualFrame var1, DynamicObject var2, int var3, int var4);

        @Specialization(guards={"!indexTriviallyOutOfBounds(string, beg, len)"})
        public Object stringSubstring(DynamicObject string, int beg, int len, @Cached(value="createBinaryProfile()") ConditionProfile negativeIndexProfile, @Cached(value="createBinaryProfile()") ConditionProfile tooLargeTotalProfile, @Cached(value="createBinaryProfile()") ConditionProfile singleByteOptimizableProfile, @Cached(value="createBinaryProfile()") ConditionProfile mutableRopeProfile, @Cached(value="createBinaryProfile()") ConditionProfile foundSingleByteOptimizableDescendentProfile) {
            Rope rope = StringOperations.rope(string);
            int index = this.normalizeIndexNode.executeNormalize(beg, rope.characterLength());
            int length = len;
            if (negativeIndexProfile.profile(index < 0)) {
                return this.nil();
            }
            if (tooLargeTotalProfile.profile(index + length > rope.characterLength())) {
                length = rope.characterLength() - index;
            }
            if (singleByteOptimizableProfile.profile(length == 0 || rope.isSingleByteOptimizable())) {
                if (mutableRopeProfile.profile(rope instanceof RopeBuffer)) {
                    return this.makeBuffer(string, index, length);
                }
                return this.makeRope(string, rope, index, length);
            }
            SearchResult searchResult = this.searchForSingleByteOptimizableDescendant(rope, index, length);
            if (foundSingleByteOptimizableDescendentProfile.profile(searchResult.rope.isSingleByteOptimizable())) {
                return this.makeRope(string, searchResult.rope, searchResult.index, length);
            }
            return this.stringSubstringMultitByte(string, index, length);
        }

        @CompilerDirectives.TruffleBoundary
        private SearchResult searchForSingleByteOptimizableDescendant(Rope base, int index, int length) {
            if (base.isSingleByteOptimizable()) {
                return new SearchResult(index, base);
            }
            if (base instanceof LeafRope) {
                return new SearchResult(index, base);
            }
            if (base instanceof SubstringRope) {
                SubstringRope substringRope = (SubstringRope)base;
                return this.searchForSingleByteOptimizableDescendant(substringRope.getChild(), index + substringRope.getOffset(), length);
            }
            if (base instanceof ConcatRope) {
                ConcatRope concatRope = (ConcatRope)base;
                Rope left = concatRope.getLeft();
                Rope right = concatRope.getRight();
                if (index < left.characterLength()) {
                    return this.searchForSingleByteOptimizableDescendant(left, index, length);
                }
                if (index >= left.characterLength()) {
                    return this.searchForSingleByteOptimizableDescendant(right, index - left.characterLength(), length);
                }
                return new SearchResult(index, concatRope);
            }
            if (base instanceof RepeatingRope) {
                RepeatingRope repeatingRope = (RepeatingRope)base;
                if (index + length < repeatingRope.getChild().characterLength()) {
                    return this.searchForSingleByteOptimizableDescendant(repeatingRope.getChild(), index, length);
                }
                return new SearchResult(index, repeatingRope);
            }
            throw new UnsupportedOperationException("Don't know how to traverse rope type: " + base.getClass().getName());
        }

        @CompilerDirectives.TruffleBoundary
        private Object stringSubstringMultitByte(DynamicObject string, int beg, int len) {
            int p;
            Rope rope = StringOperations.rope(string);
            int length = rope.byteLength();
            boolean isMutableRope = rope instanceof RopeBuffer;
            Encoding enc = rope.getEncoding();
            int s = 0;
            int end = s + length;
            byte[] bytes = rope.getBytes();
            if (beg < 0) {
                if (len > -beg) {
                    len = -beg;
                }
                if (-beg * enc.maxLength() < length >>> 3) {
                    beg = -beg;
                    int e = end;
                    while (beg-- > len && (e = enc.prevCharHead(bytes, s, e, e)) != -1) {
                    }
                    int p2 = e;
                    if (p2 == -1) {
                        return this.nil();
                    }
                    while (len-- > 0 && (p2 = enc.prevCharHead(bytes, s, p2, e)) != -1) {
                    }
                    if (p2 == -1) {
                        return this.nil();
                    }
                    if (isMutableRope) {
                        return this.makeBuffer(string, p2 - s, e - p2);
                    }
                    return this.makeRope(string, rope, p2 - s, e - p2);
                }
                if ((beg += rope.characterLength()) < 0) {
                    return this.nil();
                }
            } else if (beg > 0 && beg > rope.characterLength()) {
                return this.nil();
            }
            if (len == 0) {
                p = 0;
            } else if (StringGuards.isValidCodeRange(string) && enc instanceof UTF8Encoding) {
                p = StringSupport.utf8Nth(bytes, s, end, beg);
                len = StringSupport.utf8Offset(bytes, p, end, len);
            } else if (enc.isFixedWidth()) {
                int w = enc.maxLength();
                p = s + beg * w;
                if (p > end) {
                    p = end;
                    len = 0;
                } else {
                    len = len * w > end - p ? end - p : (len *= w);
                }
            } else {
                p = StringSupport.nth(enc, bytes, s, end, beg);
                len = p == end ? 0 : StringSupport.offset(enc, bytes, p, end, len);
            }
            if (isMutableRope) {
                return this.makeBuffer(string, p - s, len);
            }
            return this.makeRope(string, rope, p - s, len);
        }

        @Specialization(guards={"indexTriviallyOutOfBounds(string, beg, len)"})
        public Object stringSubstringNegativeLength(DynamicObject string, int beg, int len) {
            return this.nil();
        }

        protected static boolean indexTriviallyOutOfBounds(DynamicObject string, int index, int length) {
            assert (RubyGuards.isRubyString(string));
            return length < 0 || index > StringOperations.rope(string).characterLength();
        }

        private DynamicObject makeRope(DynamicObject string, Rope rope, int beg, int len) {
            assert (RubyGuards.isRubyString(string));
            if (this.allocateNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.allocateNode = this.insert(AllocateObjectNode.create());
            }
            if (this.makeSubstringNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.makeSubstringNode = this.insert(RopeNodesFactory.MakeSubstringNodeGen.create(null, null, null));
            }
            if (this.taintResultNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.taintResultNode = this.insert(new TaintResultNode());
            }
            DynamicObject ret = this.allocateNode.allocate(Layouts.BASIC_OBJECT.getLogicalClass(string), this.makeSubstringNode.executeMake(rope, beg, len));
            this.taintResultNode.maybeTaint(string, ret);
            return ret;
        }

        private DynamicObject makeBuffer(DynamicObject string, int beg, int len) {
            assert (RubyGuards.isRubyString(string));
            RopeBuffer buffer = (RopeBuffer)StringOperations.rope(string);
            if (this.allocateNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.allocateNode = this.insert(AllocateObjectNode.create());
            }
            if (this.taintResultNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.taintResultNode = this.insert(new TaintResultNode());
            }
            DynamicObject ret = this.allocateNode.allocate(Layouts.BASIC_OBJECT.getLogicalClass(string), new RopeBuffer(new ByteList(buffer.getByteList(), beg, len), buffer.getCodeRange(), buffer.isSingleByteOptimizable(), len));
            this.taintResultNode.maybeTaint(string, ret);
            return ret;
        }

        private static final class SearchResult {
            public final int index;
            public final Rope rope;

            public SearchResult(int index, Rope rope) {
                this.index = index;
                this.rope = rope;
            }
        }
    }

    @Primitive(name="string_byte_append")
    public static abstract class StringByteAppendPrimitiveNode
    extends PrimitiveArrayArgumentsNode {
        @Node.Child
        private RopeNodes.MakeConcatNode makeConcatNode = RopeNodesFactory.MakeConcatNodeGen.create(null, null, null);
        @Node.Child
        private RopeNodes.MakeLeafRopeNode makeLeafRopeNode = RopeNodesFactory.MakeLeafRopeNodeGen.create(null, null, null, null);

        @Specialization(guards={"isRubyString(other)"})
        public DynamicObject stringByteAppend(DynamicObject string, DynamicObject other) {
            Rope left = StringOperations.rope(string);
            Rope right = StringOperations.rope(other);
            LeafRope rightConverted = this.makeLeafRopeNode.executeMake(right.getBytes(), left.getEncoding(), left.getCodeRange(), NotProvided.INSTANCE);
            StringOperations.setRope(string, this.makeConcatNode.executeMake(left, rightConverted, left.getEncoding()));
            return string;
        }
    }

    @Primitive(name="string_to_inum")
    public static abstract class StringToInumPrimitiveNode
    extends PrimitiveArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        public Object stringToInum(DynamicObject string, int fixBase, boolean strict, @Cached(value="create(getSourceIndexLength())") FixnumOrBignumNode fixnumOrBignumNode) {
            return ConvertBytes.byteListToInum19(this.getContext(), this, fixnumOrBignumNode, string, fixBase, strict);
        }
    }

    @Primitive(name="string_splice", needsSelf=false, lowerFixnum={3, 4})
    @ImportStatic(value={StringGuards.class})
    public static abstract class StringSplicePrimitiveNode
    extends PrimitiveArrayArgumentsNode {
        @Node.Child
        private RopeNodes.MakeConcatNode appendMakeConcatNode;
        @Node.Child
        private RopeNodes.MakeConcatNode prependMakeConcatNode;
        @Node.Child
        private RopeNodes.MakeConcatNode leftMakeConcatNode;
        @Node.Child
        private RopeNodes.MakeConcatNode rightMakeConcatNode;
        @Node.Child
        private RopeNodes.MakeSubstringNode prependMakeSubstringNode;
        @Node.Child
        private RopeNodes.MakeSubstringNode leftMakeSubstringNode;
        @Node.Child
        private RopeNodes.MakeSubstringNode rightMakeSubstringNode;

        @Specialization(guards={"indexAtStartBound(spliceByteIndex)", "isRubyString(other)", "isRubyEncoding(rubyEncoding)"})
        public Object splicePrepend(DynamicObject string, DynamicObject other, int spliceByteIndex, int byteCountToReplace, DynamicObject rubyEncoding) {
            if (this.prependMakeSubstringNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.prependMakeSubstringNode = this.insert(RopeNodesFactory.MakeSubstringNodeGen.create(null, null, null));
            }
            if (this.prependMakeConcatNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.prependMakeConcatNode = this.insert(RopeNodesFactory.MakeConcatNodeGen.create(null, null, null));
            }
            Encoding encoding = EncodingOperations.getEncoding(rubyEncoding);
            Rope original = StringOperations.rope(string);
            Rope left = StringOperations.rope(other);
            Rope right = this.prependMakeSubstringNode.executeMake(original, byteCountToReplace, original.byteLength() - byteCountToReplace);
            StringOperations.setRope(string, this.prependMakeConcatNode.executeMake(left, right, encoding));
            return string;
        }

        @Specialization(guards={"indexAtEndBound(string, spliceByteIndex)", "isRubyString(other)", "isRubyEncoding(rubyEncoding)"})
        public Object spliceAppend(DynamicObject string, DynamicObject other, int spliceByteIndex, int byteCountToReplace, DynamicObject rubyEncoding) {
            Encoding encoding = EncodingOperations.getEncoding(rubyEncoding);
            Rope left = StringOperations.rope(string);
            Rope right = StringOperations.rope(other);
            if (this.appendMakeConcatNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.appendMakeConcatNode = this.insert(RopeNodesFactory.MakeConcatNodeGen.create(null, null, null));
            }
            StringOperations.setRope(string, this.appendMakeConcatNode.executeMake(left, right, encoding));
            return string;
        }

        @Specialization(guards={"!indexAtEitherBounds(string, spliceByteIndex)", "isRubyString(other)", "isRubyEncoding(rubyEncoding)", "!isRopeBuffer(string)"})
        public DynamicObject splice(DynamicObject string, DynamicObject other, int spliceByteIndex, int byteCountToReplace, DynamicObject rubyEncoding, @Cached(value="createBinaryProfile()") ConditionProfile insertStringIsEmptyProfile, @Cached(value="createBinaryProfile()") ConditionProfile splitRightIsEmptyProfile) {
            if (this.leftMakeSubstringNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.leftMakeSubstringNode = this.insert(RopeNodesFactory.MakeSubstringNodeGen.create(null, null, null));
            }
            if (this.rightMakeSubstringNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.rightMakeSubstringNode = this.insert(RopeNodesFactory.MakeSubstringNodeGen.create(null, null, null));
            }
            if (this.leftMakeConcatNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.leftMakeConcatNode = this.insert(RopeNodesFactory.MakeConcatNodeGen.create(null, null, null));
            }
            if (this.rightMakeConcatNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.rightMakeConcatNode = this.insert(RopeNodesFactory.MakeConcatNodeGen.create(null, null, null));
            }
            Encoding encoding = EncodingOperations.getEncoding(rubyEncoding);
            Rope source = StringOperations.rope(string);
            Rope insert = StringOperations.rope(other);
            int rightSideStartingIndex = spliceByteIndex + byteCountToReplace;
            Rope splitLeft = this.leftMakeSubstringNode.executeMake(source, 0, spliceByteIndex);
            Rope splitRight = this.rightMakeSubstringNode.executeMake(source, rightSideStartingIndex, source.byteLength() - rightSideStartingIndex);
            Rope joinedLeft = insertStringIsEmptyProfile.profile(insert.isEmpty()) ? splitLeft : this.leftMakeConcatNode.executeMake(splitLeft, insert, encoding);
            Rope joinedRight = splitRightIsEmptyProfile.profile(splitRight.isEmpty()) ? joinedLeft : this.rightMakeConcatNode.executeMake(joinedLeft, splitRight, encoding);
            StringOperations.setRope(string, joinedRight);
            return string;
        }

        @Specialization(guards={"!indexAtEitherBounds(string, spliceByteIndex)", "isRubyString(other)", "isRubyEncoding(rubyEncoding)", "isRopeBuffer(string)", "isSingleByteOptimizable(string)"})
        public DynamicObject spliceBuffer(DynamicObject string, DynamicObject other, int spliceByteIndex, int byteCountToReplace, DynamicObject rubyEncoding, @Cached(value="createBinaryProfile()") ConditionProfile sameCodeRangeProfile, @Cached(value="createBinaryProfile()") ConditionProfile brokenCodeRangeProfile) {
            Encoding encoding = EncodingOperations.getEncoding(rubyEncoding);
            RopeBuffer source = (RopeBuffer)StringOperations.rope(string);
            Rope insert = StringOperations.rope(other);
            int rightSideStartingIndex = spliceByteIndex + byteCountToReplace;
            ByteList byteList = new ByteList(source.byteLength() + insert.byteLength() - byteCountToReplace);
            byteList.append(source.getByteList(), 0, spliceByteIndex);
            byteList.append(insert.getBytes());
            byteList.append(source.getByteList(), rightSideStartingIndex, source.byteLength() - rightSideStartingIndex);
            byteList.setEncoding(encoding);
            RopeBuffer buffer = new RopeBuffer(byteList, RopeNodes.MakeConcatNode.commonCodeRange(source.getCodeRange(), insert.getCodeRange(), sameCodeRangeProfile, brokenCodeRangeProfile), source.isSingleByteOptimizable() && insert.isSingleByteOptimizable(), source.characterLength() + insert.characterLength() - byteCountToReplace);
            StringOperations.setRope(string, buffer);
            return string;
        }

        protected boolean indexAtStartBound(int index) {
            return index == 0;
        }

        protected boolean indexAtEndBound(DynamicObject string, int index) {
            assert (RubyGuards.isRubyString(string));
            return index == StringOperations.rope(string).byteLength();
        }

        protected boolean indexAtEitherBounds(DynamicObject string, int index) {
            assert (RubyGuards.isRubyString(string));
            return this.indexAtStartBound(index) || this.indexAtEndBound(string, index);
        }

        protected boolean isRopeBuffer(DynamicObject string) {
            assert (RubyGuards.isRubyString(string));
            return StringOperations.rope(string) instanceof RopeBuffer;
        }
    }

    @Primitive(name="string_pattern", lowerFixnum={1, 2})
    public static abstract class StringPatternPrimitiveNode
    extends PrimitiveArrayArgumentsNode {
        @Node.Child
        private AllocateObjectNode allocateObjectNode = AllocateObjectNode.create();
        @Node.Child
        private RopeNodes.MakeLeafRopeNode makeLeafRopeNode = RopeNodes.MakeLeafRopeNode.create();
        @Node.Child
        private RopeNodes.MakeRepeatingNode makeRepeatingNode = RopeNodes.MakeRepeatingNode.create();

        @Specialization(guards={"value >= 0"})
        public DynamicObject stringPatternZero(DynamicObject stringClass, int size, int value) {
            Rope repeatingRope = this.makeRepeatingNode.executeMake(RopeConstants.ASCII_8BIT_SINGLE_BYTE_ROPES[value], size);
            return this.allocateObjectNode.allocate(stringClass, repeatingRope);
        }

        @Specialization(guards={"isRubyString(string)", "patternFitsEvenly(string, size)"})
        public DynamicObject stringPatternFitsEvenly(DynamicObject stringClass, int size, DynamicObject string) {
            Rope rope = StringOperations.rope(string);
            Rope repeatingRope = this.makeRepeatingNode.executeMake(rope, size / rope.byteLength());
            return this.allocateObjectNode.allocate(stringClass, repeatingRope);
        }

        @Specialization(guards={"isRubyString(string)", "!patternFitsEvenly(string, size)"})
        @CompilerDirectives.TruffleBoundary
        public DynamicObject stringPattern(DynamicObject stringClass, int size, DynamicObject string) {
            Rope rope = StringOperations.rope(string);
            byte[] bytes = new byte[size];
            if (!rope.isEmpty()) {
                for (int n = 0; n < size; n += rope.byteLength()) {
                    System.arraycopy(rope.getBytes(), 0, bytes, n, Math.min(rope.byteLength(), size - n));
                }
            }
            CodeRange codeRange = rope.getCodeRange() == CodeRange.CR_7BIT ? CodeRange.CR_7BIT : CodeRange.CR_UNKNOWN;
            Object characterLength = codeRange == CodeRange.CR_7BIT ? Integer.valueOf(size) : NotProvided.INSTANCE;
            return this.allocateObjectNode.allocate(stringClass, this.makeLeafRopeNode.executeMake(bytes, StringOperations.encoding(string), codeRange, characterLength));
        }

        protected boolean patternFitsEvenly(DynamicObject string, int size) {
            assert (RubyGuards.isRubyString(string));
            int byteLength = StringOperations.rope(string).byteLength();
            return byteLength > 0 && size % byteLength == 0;
        }
    }

    @Primitive(name="string_rindex", lowerFixnum={2})
    public static abstract class StringRindexPrimitiveNode
    extends PrimitiveArrayArgumentsNode {
        @Node.Child
        private RopeNodes.GetByteNode patternGetByteNode = RopeNodes.GetByteNode.create();
        @Node.Child
        private RopeNodes.GetByteNode stringGetByteNode = RopeNodes.GetByteNode.create();

        @Specialization(guards={"isRubyString(pattern)"})
        public Object stringRindex(DynamicObject string, DynamicObject pattern, int start, @Cached(value="create()") BranchProfile errorProfile) {
            int pos = start;
            if (pos < 0) {
                errorProfile.enter();
                throw new RaiseException(this.coreExceptions().argumentError("negative start given", (Node)this));
            }
            Rope stringRope = StringOperations.rope(string);
            Rope patternRope = StringOperations.rope(pattern);
            int total = stringRope.byteLength();
            int matchSize = patternRope.byteLength();
            if (pos >= total) {
                pos = total - 1;
            }
            switch (matchSize) {
                case 0: {
                    return start;
                }
                case 1: {
                    int matcher = this.patternGetByteNode.executeGetByte(patternRope, 0);
                    while (pos >= 0) {
                        if (this.stringGetByteNode.executeGetByte(stringRope, pos) == matcher) {
                            return pos;
                        }
                        --pos;
                    }
                    return this.nil();
                }
            }
            if (total - pos < matchSize) {
                pos = total - matchSize;
            }
            for (int cur = pos; cur >= 0; --cur) {
                if (ArrayUtils.memcmp(stringRope.getBytes(), cur, patternRope.getBytes(), 0, matchSize) != 0) continue;
                return cur;
            }
            return this.nil();
        }
    }

    @Primitive(name="string_previous_byte_index")
    @ImportStatic(value={StringGuards.class})
    public static abstract class StringPreviousByteIndexNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization(guards={"index < 0"})
        public Object negativeIndex(DynamicObject string, int index) {
            throw new RaiseException(this.coreExceptions().argumentError("negative index given", (Node)this));
        }

        @Specialization(guards={"index == 0"})
        public Object zeroIndex(DynamicObject string, int index) {
            return this.nil();
        }

        @Specialization(guards={"index > 0", "isSingleByteOptimizable(string)"})
        public int singleByteOptimizable(DynamicObject string, int index) {
            return index - 1;
        }

        @Specialization(guards={"index > 0", "!isSingleByteOptimizable(string)", "isFixedWidthEncoding(string)"})
        public int fixedWidthEncoding(DynamicObject string, int index, @Cached(value="createBinaryProfile()") ConditionProfile firstCharacterProfile) {
            Encoding encoding = StringOperations.encoding(string);
            if (firstCharacterProfile.profile(index < encoding.maxLength())) {
                return 0;
            }
            return (index / encoding.maxLength() - 1) * encoding.maxLength();
        }

        @Specialization(guards={"index > 0", "!isSingleByteOptimizable(string)", "!isFixedWidthEncoding(string)"})
        @CompilerDirectives.TruffleBoundary
        public Object other(DynamicObject string, int index) {
            Rope rope = StringOperations.rope(string);
            boolean p = false;
            int end = 0 + rope.byteLength();
            int b = rope.getEncoding().prevCharHead(rope.getBytes(), 0, 0 + index, end);
            if (b == -1) {
                return this.nil();
            }
            return b - 0;
        }
    }

    @Primitive(name="string_byte_index", needsSelf=false, lowerFixnum={1})
    @ImportStatic(value={StringGuards.class})
    public static abstract class StringByteIndexNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        protected Object findByteIndexFromCharIndex(DynamicObject string, int characterIndex, int offset, @Cached(value="create()") StringByteIndexFromCharIndexNode stringByteIndexFromCharIndexNode) {
            return stringByteIndexFromCharIndexNode.executeFindByteIndex(string, characterIndex);
        }

        @Specialization(guards={"isRubyString(pattern)"})
        public Object pattern(DynamicObject string, DynamicObject pattern, int offset, @Cached(value="createBinaryProfile()") ConditionProfile emptyPatternProfile, @Cached(value="createBinaryProfile()") ConditionProfile brokenCodeRangeProfile, @Cached(value="create()") BranchProfile errorProfile, @Cached(value="create()") EncodingNodes.CheckEncodingNode checkEncodingNode) {
            if (offset < 0) {
                errorProfile.enter();
                throw new RaiseException(this.coreExceptions().argumentError("negative start given", (Node)this));
            }
            Rope stringRope = StringOperations.rope(string);
            Rope patternRope = StringOperations.rope(pattern);
            if (emptyPatternProfile.profile(patternRope.isEmpty())) {
                return offset;
            }
            if (brokenCodeRangeProfile.profile(stringRope.getCodeRange() == CodeRange.CR_BROKEN)) {
                return this.nil();
            }
            Encoding encoding = checkEncodingNode.executeCheckEncoding(string, pattern);
            int p = 0;
            int e = p + stringRope.byteLength();
            int pp = 0;
            int pe = pp + patternRope.byteLength();
            byte[] stringBytes = stringRope.getBytes();
            byte[] patternBytes = patternRope.getBytes();
            int s = p;
            int ss = pp;
            while (p < e) {
                if (stringBytes[p] == patternBytes[pp]) {
                    while (p < e && pp < pe && stringBytes[p] == patternBytes[pp]) {
                        ++p;
                        ++pp;
                    }
                    if (pp < pe) {
                        p = s;
                        pp = ss;
                    } else {
                        int c = StringSupport.preciseLength(encoding, stringBytes, s, e);
                        if (StringSupport.MBCLEN_CHARFOUND_P(c)) {
                            return s;
                        }
                        return this.nil();
                    }
                }
                s = ++p;
            }
            return this.nil();
        }
    }

    @ImportStatic(value={StringGuards.class})
    @NodeChildren(value={@NodeChild(value="string"), @NodeChild(value="characterIndex")})
    public static abstract class StringByteIndexFromCharIndexNode
    extends RubyNode {
        public static StringByteIndexFromCharIndexNode create() {
            return StringNodesFactory.StringByteIndexFromCharIndexNodeGen.create(null, null);
        }

        @CreateCast(value={"characterIndex"})
        public RubyNode coerceCharacterIndexToInt(RubyNode characterIndex) {
            return FixnumLowerNodeGen.create(characterIndex);
        }

        public abstract Object executeFindByteIndex(DynamicObject var1, int var2);

        @Specialization(guards={"characterIndex < 0"})
        protected Object byteIndexNegativeIndex(DynamicObject string, int characterIndex) {
            throw new RaiseException(this.getContext().getCoreExceptions().argumentError(this.coreStrings().CHARACTER_INDEX_NEGATIVE.getRope(), (Node)this));
        }

        @Specialization(guards={"characterIndexTooLarge(string, characterIndex)"})
        protected Object byteIndexTooLarge(DynamicObject string, int characterIndex) {
            return this.nil();
        }

        @Specialization(guards={"characterIndexInBounds(string, characterIndex)", "isSingleByteOptimizable(string)"})
        protected Object singleByte(DynamicObject string, int characterIndex) {
            return characterIndex;
        }

        @Specialization(guards={"characterIndexInBounds(string, characterIndex)", "!isSingleByteOptimizable(string)"})
        protected Object multiBytes(DynamicObject string, int characterIndex, @Cached(value="createBinaryProfile()") ConditionProfile indexTooLargeProfile, @Cached(value="createBinaryProfile()") ConditionProfile invalidByteProfile, @Cached(value="create()") BranchProfile errorProfile) {
            int i;
            Rope rope = StringOperations.rope(string);
            Encoding enc = rope.getEncoding();
            int p = 0;
            int e = p + rope.byteLength();
            int k = characterIndex;
            for (i = 0; i < k && p < e; ++i) {
                int c = StringSupport.preciseLength(enc, rope.getBytes(), p, e);
                if (invalidByteProfile.profile(!StringSupport.MBCLEN_CHARFOUND_P(c))) {
                    ++p;
                    continue;
                }
                p += StringSupport.MBCLEN_CHARFOUND_LEN(c);
            }
            if (indexTooLargeProfile.profile(i < k)) {
                return this.nil();
            }
            return p;
        }

        protected boolean characterIndexTooLarge(DynamicObject string, int characterIndex) {
            return characterIndex > StringOperations.rope(string).characterLength();
        }

        protected boolean characterIndexInBounds(DynamicObject string, int characterIndex) {
            return characterIndex >= 0 && !this.characterIndexTooLarge(string, characterIndex);
        }
    }

    @Primitive(name="string_character_index", needsSelf=false, lowerFixnum={3})
    public static abstract class StringCharacterIndexPrimitiveNode
    extends PrimitiveArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isRubyString(pattern)"})
        public Object stringCharacterIndex(DynamicObject string, DynamicObject pattern, int offset) {
            int index;
            int c;
            if (offset < 0) {
                return this.nil();
            }
            Rope stringRope = StringOperations.rope(string);
            Rope patternRope = StringOperations.rope(pattern);
            int total = stringRope.byteLength();
            int p = 0;
            int e = p + total;
            int pp = 0;
            int pe = pp + patternRope.byteLength();
            byte[] stringBytes = stringRope.getBytes();
            byte[] patternBytes = patternRope.getBytes();
            if (stringRope.isSingleByteOptimizable()) {
                int s = p += offset;
                int ss = pp;
                while (p < e) {
                    if (stringBytes[p] == patternBytes[pp]) {
                        while (p < e && pp < pe && stringBytes[p] == patternBytes[pp]) {
                            ++p;
                            ++pp;
                        }
                        if (pp < pe) {
                            p = s;
                            pp = ss;
                        } else {
                            return s;
                        }
                    }
                    s = ++p;
                }
                return this.nil();
            }
            Encoding enc = stringRope.getEncoding();
            for (index = 0; p < e && index < offset; p += c, ++index) {
                c = StringSupport.preciseLength(enc, stringBytes, p, e);
                if (StringSupport.MBCLEN_CHARFOUND_P(c)) {
                    continue;
                }
                return this.nil();
            }
            int s = p;
            int ss = pp;
            while (p < e) {
                c = StringSupport.preciseLength(enc, stringBytes, p, e);
                if (!StringSupport.MBCLEN_CHARFOUND_P(c)) {
                    return this.nil();
                }
                if (stringBytes[p] == patternBytes[pp]) {
                    while (p < e && pp < pe) {
                        boolean breakOut = false;
                        int pc = p + c;
                        while (p < e && p < pc && pp < pe) {
                            if (stringBytes[p] == patternBytes[pp]) {
                                ++p;
                                ++pp;
                                continue;
                            }
                            breakOut = true;
                            break;
                        }
                        if (!breakOut && StringSupport.MBCLEN_CHARFOUND_P(c = StringSupport.preciseLength(enc, stringBytes, p, e))) continue;
                        break;
                    }
                    if (pp < pe) {
                        p = s;
                        pp = ss;
                    } else {
                        return index;
                    }
                }
                s = p += c;
                ++index;
            }
            return this.nil();
        }
    }

    @Primitive(name="string_byte_character_index", needsSelf=false)
    @ImportStatic(value={StringGuards.class})
    public static abstract class StringByteCharacterIndexNode
    extends PrimitiveArrayArgumentsNode {
        public abstract int executeStringByteCharacterIndex(VirtualFrame var1, DynamicObject var2, int var3, int var4);

        @Specialization(guards={"isSingleByteOptimizable(string)"})
        public int stringByteCharacterIndexSingleByte(DynamicObject string, int index, int start) {
            return index;
        }

        @Specialization(guards={"!isSingleByteOptimizable(string)", "isFixedWidthEncoding(string)"})
        public int stringByteCharacterIndexFixedWidth(DynamicObject string, int index, int start) {
            return index / StringOperations.encoding(string).minLength();
        }

        @Specialization(guards={"!isSingleByteOptimizable(string)", "!isFixedWidthEncoding(string)", "isValidUtf8(string)"})
        public int stringByteCharacterIndexValidUtf8(DynamicObject string, int index, int start) {
            return this.stringByteCharacterIndex(string, index, start);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"!isSingleByteOptimizable(string)", "!isFixedWidthEncoding(string)", "!isValidUtf8(string)"})
        public int stringByteCharacterIndex(DynamicObject string, int index, int start) {
            Rope rope = StringOperations.rope(string);
            byte[] bytes = rope.getBytes();
            Encoding encoding = rope.getEncoding();
            int p = start;
            int end = bytes.length;
            int charIndex = 0;
            while (p < end && index > 0) {
                int charLen = StringSupport.length(encoding, bytes, p, end);
                p += charLen;
                index -= charLen;
                ++charIndex;
            }
            return charIndex;
        }
    }

    @Primitive(name="string_character_byte_index", needsSelf=false, lowerFixnum={1, 2})
    @ImportStatic(value={StringGuards.class})
    public static abstract class CharacterByteIndexNode
    extends PrimitiveArrayArgumentsNode {
        public abstract int executeInt(VirtualFrame var1, DynamicObject var2, int var3, int var4);

        @Specialization(guards={"isSingleByteOptimizable(string)"})
        public int stringCharacterByteIndex(DynamicObject string, int index, int start) {
            return start + index;
        }

        @Specialization(guards={"!isSingleByteOptimizable(string)", "isFixedWidthEncoding(string)"})
        public int stringCharacterByteIndexFixedWidthEncoding(DynamicObject string, int index, int start) {
            Encoding encoding = StringOperations.encoding(string);
            return start + index * encoding.minLength();
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"!isSingleByteOptimizable(string)", "!isFixedWidthEncoding(string)"})
        public int stringCharacterByteIndexMultiByteEncoding(DynamicObject string, int index, int start) {
            Rope rope = StringOperations.rope(string);
            return StringSupport.nth(rope.getEncoding(), rope.getBytes(), start, rope.byteLength(), index);
        }
    }

    @Primitive(name="string_index", lowerFixnum={2})
    @ImportStatic(value={StringGuards.class})
    public static abstract class StringIndexPrimitiveNode
    extends PrimitiveArrayArgumentsNode {
        @Node.Child
        private StringByteCharacterIndexNode byteIndexToCharIndexNode = StringNodesFactory.StringByteCharacterIndexNodeFactory.create(null);
        @Node.Child
        private NormalizeIndexNode normalizeIndexNode = StringNodesFactory.NormalizeIndexNodeGen.create(null, null);

        @Specialization(guards={"isRubyString(pattern)", "isBrokenCodeRange(pattern)"})
        public DynamicObject stringIndexBrokenCodeRange(DynamicObject string, DynamicObject pattern, int start) {
            return this.nil();
        }

        @Specialization(guards={"isRubyString(pattern)", "!isBrokenCodeRange(pattern)"})
        public Object stringIndex(VirtualFrame frame, DynamicObject string, DynamicObject pattern, int start) {
            int charIndex = this.byteIndexToCharIndexNode.executeStringByteCharacterIndex(frame, string, start, 0);
            int index = this.index(StringOperations.rope(string), StringOperations.rope(pattern), charIndex, StringOperations.encoding(string));
            if (index == -1) {
                return this.nil();
            }
            return index;
        }

        @CompilerDirectives.TruffleBoundary
        private int index(Rope source, Rope other, int offset, Encoding enc) {
            int sourceLen = source.characterLength();
            int otherLen = other.characterLength();
            if ((offset = this.normalizeIndexNode.executeNormalize(offset, sourceLen)) < 0) {
                return -1;
            }
            if (sourceLen - offset < otherLen) {
                return -1;
            }
            byte[] bytes = source.getBytes();
            int p = 0;
            int end = p + source.byteLength();
            if (offset != 0) {
                offset = source.isSingleByteOptimizable() ? offset : StringSupport.offset(enc, bytes, p, end, offset);
                p += offset;
            }
            if (otherLen == 0) {
                return offset;
            }
            int pos;
            while ((pos = this.indexOf(source, other, p)) >= 0) {
                int t = enc.rightAdjustCharHead(bytes, p, p + (pos -= p), end);
                if (t == p + pos) {
                    return pos + offset;
                }
                if ((sourceLen -= t - p) <= 0) {
                    return -1;
                }
                offset += t - p;
                p = t;
            }
            return pos;
        }

        @CompilerDirectives.TruffleBoundary
        private int indexOf(Rope sourceRope, Rope otherRope, int fromIndex) {
            byte[] source = sourceRope.getBytes();
            boolean sourceOffset = false;
            int sourceCount = sourceRope.byteLength();
            byte[] target = otherRope.getBytes();
            boolean targetOffset = false;
            int targetCount = otherRope.byteLength();
            if (fromIndex >= sourceCount) {
                return targetCount == 0 ? sourceCount : -1;
            }
            if (fromIndex < 0) {
                fromIndex = 0;
            }
            if (targetCount == 0) {
                return fromIndex;
            }
            byte first = target[0];
            int max = 0 + (sourceCount - targetCount);
            for (int i = 0 + fromIndex; i <= max; ++i) {
                if (source[i] != first) {
                    while (++i <= max && source[i] != first) {
                    }
                }
                if (i > max) continue;
                int j = i + 1;
                int end = j + targetCount - 1;
                int k = 1;
                while (j < end && source[j] == target[k]) {
                    ++j;
                    ++k;
                }
                if (j != end) continue;
                return i - 0;
            }
            return -1;
        }
    }

    @Primitive(name="string_to_f", needsSelf=false)
    public static abstract class StringToFPrimitiveNode
    extends PrimitiveArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary(throwsControlFlowException=true)
        @Specialization
        public Object stringToF(DynamicObject string, boolean strict, @Cached(value="create(getSourceIndexLength())") FixnumOrBignumNode fixnumOrBignumNode) {
            Rope rope = StringOperations.rope(string);
            if (rope.isEmpty()) {
                throw new RaiseException(this.coreExceptions().argumentError(this.coreStrings().INVALID_VALUE_FOR_FLOAT.getRope(), (Node)this));
            }
            if (string.toString().startsWith("0x")) {
                try {
                    return Double.parseDouble(string.toString());
                }
                catch (NumberFormatException e) {
                    Object result = ConvertBytes.byteListToInum19(this.getContext(), this, fixnumOrBignumNode, string, 16, true);
                    if (result instanceof Integer) {
                        return ((Integer)result).doubleValue();
                    }
                    if (result instanceof Long) {
                        return ((Long)result).doubleValue();
                    }
                    if (result instanceof Double) {
                        return result;
                    }
                    return null;
                }
            }
            try {
                return new DoubleConverter().parse(rope, strict, true);
            }
            catch (NumberFormatException e) {
                if (strict) {
                    throw new RaiseException(this.coreExceptions().argumentError(this.coreStrings().INVALID_VALUE_FOR_FLOAT.getRope(), (Node)this));
                }
                return 0.0;
            }
        }
    }

    @Primitive(name="string_from_codepoint", needsSelf=false, lowerFixnum={1})
    public static abstract class StringFromCodepointPrimitiveNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization(guards={"isRubyEncoding(rubyEncoding)", "isSimple(longCode, rubyEncoding)", "isCodepoint(longCode)"})
        public DynamicObject stringFromCodepointSimple(long longCode, DynamicObject rubyEncoding, @Cached(value="createBinaryProfile()") ConditionProfile isUTF8Profile, @Cached(value="createBinaryProfile()") ConditionProfile isUSAsciiProfile, @Cached(value="createBinaryProfile()") ConditionProfile isAscii8BitProfile) {
            int code = (int)longCode;
            Encoding encoding = EncodingOperations.getEncoding(rubyEncoding);
            LeafRope rope = isUTF8Profile.profile(encoding == UTF8Encoding.INSTANCE) ? RopeConstants.UTF8_SINGLE_BYTE_ROPES[code] : (isUSAsciiProfile.profile(encoding == USASCIIEncoding.INSTANCE) ? RopeConstants.US_ASCII_SINGLE_BYTE_ROPES[code] : (isAscii8BitProfile.profile(encoding == ASCIIEncoding.INSTANCE) ? RopeConstants.ASCII_8BIT_SINGLE_BYTE_ROPES[code] : RopeOperations.create(new byte[]{(byte)code}, encoding, CodeRange.CR_UNKNOWN)));
            return this.createString(rope);
        }

        @CompilerDirectives.TruffleBoundary(throwsControlFlowException=true)
        @Specialization(guards={"isRubyEncoding(rubyEncoding)", "!isSimple(code, rubyEncoding)", "isCodepoint(code)"})
        public DynamicObject stringFromCodepoint(long code, DynamicObject rubyEncoding) {
            int length;
            Encoding encoding = EncodingOperations.getEncoding(rubyEncoding);
            try {
                length = encoding.codeToMbcLength((int)code);
            }
            catch (EncodingException e) {
                throw new RaiseException(this.coreExceptions().rangeError(code, rubyEncoding, (Node)this));
            }
            if (length <= 0) {
                throw new RaiseException(this.coreExceptions().rangeError(code, rubyEncoding, (Node)this));
            }
            byte[] bytes = new byte[length];
            try {
                encoding.codeToMbc((int)code, bytes, 0);
            }
            catch (EncodingException e) {
                throw new RaiseException(this.coreExceptions().rangeError(code, rubyEncoding, (Node)this));
            }
            if (StringSupport.preciseLength(encoding, bytes, 0, length) != length) {
                throw new RaiseException(this.coreExceptions().rangeError(code, rubyEncoding, (Node)this));
            }
            return this.createString(RopeOperations.create(bytes, encoding, CodeRange.CR_VALID));
        }

        protected boolean isCodepoint(long code) {
            return code >= 0L && code < 0x100000000L;
        }

        protected boolean isSimple(long code, DynamicObject encoding) {
            Encoding enc = EncodingOperations.getEncoding(encoding);
            return enc.isAsciiCompatible() && code >= 0L && code < 128L || enc == ASCIIEncoding.INSTANCE && code >= 0L && code <= 255L;
        }
    }

    @Primitive(name="string_find_character", lowerFixnum={1})
    @ImportStatic(value={StringGuards.class})
    public static abstract class StringFindCharacterNode
    extends PrimitiveArrayArgumentsNode {
        @Node.Child
        private AllocateObjectNode allocateObjectNode = AllocateObjectNode.create();
        @Node.Child
        private RopeNodes.MakeSubstringNode makeSubstringNode = RopeNodesFactory.MakeSubstringNodeGen.create(null, null, null);
        @Node.Child
        private TaintResultNode taintResultNode;

        @Specialization(guards={"offset < 0"})
        public Object stringFindCharacterNegativeOffset(DynamicObject string, int offset) {
            return this.nil();
        }

        @Specialization(guards={"offsetTooLarge(string, offset)"})
        public Object stringFindCharacterOffsetTooLarge(DynamicObject string, int offset) {
            return this.nil();
        }

        @Specialization(guards={"offset >= 0", "!offsetTooLarge(string, offset)", "isSingleByteOptimizable(string)"})
        public Object stringFindCharacterSingleByte(DynamicObject string, int offset) {
            Rope rope = StringOperations.rope(string);
            DynamicObject ret = this.allocateObjectNode.allocate(Layouts.BASIC_OBJECT.getLogicalClass(string), this.makeSubstringNode.executeMake(rope, offset, 1));
            return this.propagate(string, ret);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"offset >= 0", "!offsetTooLarge(string, offset)", "!isSingleByteOptimizable(string)"})
        public Object stringFindCharacter(DynamicObject string, int offset) {
            Rope rope = StringOperations.rope(string);
            Encoding enc = rope.getEncoding();
            int clen = StringSupport.preciseLength(enc, rope.getBytes(), offset, offset + enc.maxLength());
            DynamicObject ret = StringSupport.MBCLEN_CHARFOUND_P(clen) ? this.allocateObjectNode.allocate(Layouts.BASIC_OBJECT.getLogicalClass(string), this.makeSubstringNode.executeMake(rope, offset, clen)) : this.allocateObjectNode.allocate(Layouts.BASIC_OBJECT.getLogicalClass(string), this.makeSubstringNode.executeMake(rope, offset, 1));
            return this.propagate(string, ret);
        }

        private Object propagate(DynamicObject string, DynamicObject ret) {
            return this.maybeTaint(string, ret);
        }

        private Object maybeTaint(DynamicObject source, DynamicObject value) {
            if (this.taintResultNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.taintResultNode = this.insert(new TaintResultNode());
            }
            return this.taintResultNode.maybeTaint(source, value);
        }

        protected static boolean offsetTooLarge(DynamicObject string, int offset) {
            assert (RubyGuards.isRubyString(string));
            return offset >= StringOperations.rope(string).byteLength();
        }
    }

    @Primitive(name="string_escape", needsSelf=false)
    public static abstract class StringEscapePrimitiveNode
    extends PrimitiveArrayArgumentsNode {
        @Node.Child
        private IsTaintedNode isTaintedNode = IsTaintedNode.create();
        @Node.Child
        private TaintNode taintNode = TaintNode.create();
        private final ConditionProfile taintedProfile = ConditionProfile.createBinaryProfile();

        @Specialization
        public DynamicObject string_escape(DynamicObject string) {
            DynamicObject result = StringOperations.createString(this.getContext(), StringEscapePrimitiveNode.rbStrEscape(StringOperations.rope(string)));
            if (this.taintedProfile.profile(this.isTaintedNode.isTainted(string))) {
                this.taintNode.executeTaint(result);
            }
            return result;
        }

        @CompilerDirectives.TruffleBoundary
        private static Rope rbStrEscape(Rope str) {
            Encoding enc = str.getEncoding();
            byte[] pBytes = str.getBytes();
            int p = 0;
            int pend = str.byteLength();
            int prev = p;
            ByteList result = new ByteList();
            boolean unicode_p = enc.isUnicode();
            boolean asciicompat = enc.isAsciiCompatible();
            while (p < pend) {
                int cc;
                int n = enc.length(pBytes, p, pend);
                if (!StringEscapePrimitiveNode.MBCLEN_CHARFOUND_P(n)) {
                    if (p > prev) {
                        result.append(pBytes, prev, p - prev);
                    }
                    if (pend < p + (n = enc.minLength())) {
                        n = pend - p;
                    }
                    while (n-- > 0) {
                        result.append(String.format("\\x%02X", pBytes[p] & 0xFF).getBytes(StandardCharsets.US_ASCII));
                        prev = ++p;
                    }
                    continue;
                }
                n = StringEscapePrimitiveNode.MBCLEN_CHARFOUND_LEN(n);
                int c = enc.mbcToCode(pBytes, p, pend);
                p += n;
                switch (c) {
                    case 10: {
                        cc = 110;
                        break;
                    }
                    case 13: {
                        cc = 114;
                        break;
                    }
                    case 9: {
                        cc = 116;
                        break;
                    }
                    case 12: {
                        cc = 102;
                        break;
                    }
                    case 11: {
                        cc = 118;
                        break;
                    }
                    case 8: {
                        cc = 98;
                        break;
                    }
                    case 7: {
                        cc = 97;
                        break;
                    }
                    case 27: {
                        cc = 101;
                        break;
                    }
                    default: {
                        cc = 0;
                    }
                }
                if (cc != 0) {
                    if (p - n > prev) {
                        result.append(pBytes, prev, p - n - prev);
                    }
                    result.append(92);
                    result.append((byte)cc);
                    prev = p;
                    continue;
                }
                if (asciicompat && Encoding.isAscii(c) && c < 127 && c > 31) continue;
                if (p - n > prev) {
                    result.append(pBytes, prev, p - n - prev);
                }
                if (unicode_p && ((long)c & 0xFFFFFFFFL) < 127L && Encoding.isAscii(c) && ASCIIEncoding.INSTANCE.isPrint(c)) {
                    result.append(String.format("%c", Character.valueOf((char)((long)c & 0xFFFFFFFFL))).getBytes(StandardCharsets.US_ASCII));
                } else {
                    result.append(String.format(StringEscapePrimitiveNode.escapedCharFormat(c, unicode_p), (long)c & 0xFFFFFFFFL).getBytes(StandardCharsets.US_ASCII));
                }
                prev = p;
            }
            if (p > prev) {
                result.append(pBytes, prev, p - prev);
            }
            result.setEncoding(USASCIIEncoding.INSTANCE);
            return RopeOperations.ropeFromByteList(result, CodeRange.CR_7BIT);
        }

        private static int MBCLEN_CHARFOUND_LEN(int r) {
            return r;
        }

        private static boolean MBCLEN_CHARFOUND_P(int r) {
            return 0 < r;
        }

        private static String escapedCharFormat(int c, boolean isUnicode) {
            String format;
            if (isUnicode) {
                if (((long)c & 0xFFFFFFFFL) < 127L && Encoding.isAscii(c) && ASCIIEncoding.INSTANCE.isPrint(c)) {
                    throw new UnsupportedOperationException();
                }
                format = c < 65536 ? "\\u%04X" : "\\u{%X}";
            } else {
                format = ((long)c & 0xFFFFFFFFL) < 256L ? "\\x%02X" : "\\x{%X}";
            }
            return format;
        }
    }

    @ImportStatic(value={StringGuards.class})
    @NodeChildren(value={@NodeChild(value="first"), @NodeChild(value="second")})
    public static abstract class StringEqualNode
    extends RubyNode {
        @Node.Child
        private StringAreComparableNode areComparableNode;

        public abstract boolean executeStringEqual(DynamicObject var1, DynamicObject var2);

        @Specialization(guards={"ropeReferenceEqual(string, other)"})
        public boolean stringEqualsRopeEquals(DynamicObject string, DynamicObject other) {
            return true;
        }

        @Specialization(guards={"!areComparable(string, other)"})
        public boolean stringEqualNotComparable(DynamicObject string, DynamicObject other) {
            return false;
        }

        @Specialization(guards={"areComparable(string, other)", "byteLength(string) != byteLength(other)"})
        public boolean stringEqualDifferentLength(DynamicObject string, DynamicObject other) {
            return false;
        }

        @Specialization(guards={"areComparable(string, other)", "!ropeReferenceEqual(string, other)", "bytesReferenceEqual(string, other)"})
        public boolean stringEqualsBytesEquals(DynamicObject string, DynamicObject other) {
            return true;
        }

        @Specialization(guards={"areComparable(string, other)", "!ropeReferenceEqual(string, other)", "byteLength(string) == 1", "byteLength(other) == 1", "hasRawBytes(string)", "hasRawBytes(other)"})
        public boolean equalCharacters(DynamicObject string, DynamicObject other) {
            Rope a = StringOperations.rope(string);
            Rope b = StringOperations.rope(other);
            return a.getRawBytes()[0] == b.getRawBytes()[0];
        }

        @Specialization(guards={"areComparable(string, other)", "!ropeReferenceEqual(string, other)", "!bytesReferenceEqual(string, other)", "byteLength(string) == byteLength(other)"}, contains={"equalCharacters"})
        public boolean fullEqual(DynamicObject string, DynamicObject other, @Cached(value="createBinaryProfile()") ConditionProfile hashCodesCalculatedProfile, @Cached(value="createBinaryProfile()") ConditionProfile differentHashCodesProfile, @Cached(value="createBinaryProfile()") ConditionProfile aHasRawBytesProfile, @Cached(value="createBinaryProfile()") ConditionProfile bHasRawBytesProfile) {
            Rope a = StringOperations.rope(string);
            Rope b = StringOperations.rope(other);
            if (hashCodesCalculatedProfile.profile(a.isHashCodeCalculated() && b.isHashCodeCalculated()) && differentHashCodesProfile.profile(a.hashCode() != b.hashCode())) {
                return false;
            }
            byte[] aBytes = aHasRawBytesProfile.profile(a.getRawBytes() != null) ? a.getRawBytes() : a.getBytes();
            byte[] bBytes = bHasRawBytesProfile.profile(b.getRawBytes() != null) ? b.getRawBytes() : b.getBytes();
            return this.arraysEquals(aBytes, bBytes);
        }

        private boolean arraysEquals(byte[] a, byte[] b) {
            assert (a.length == b.length);
            for (int i = 0; i < a.length; ++i) {
                if (a[i] == b[i]) continue;
                return false;
            }
            return true;
        }

        protected boolean areComparable(DynamicObject first, DynamicObject second) {
            if (this.areComparableNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.areComparableNode = this.insert(StringNodesFactory.StringAreComparableNodeGen.create(null, null));
            }
            return this.areComparableNode.executeAreComparable(first, second);
        }

        protected static boolean ropeReferenceEqual(DynamicObject first, DynamicObject second) {
            return StringOperations.rope(first) == StringOperations.rope(second);
        }

        protected static boolean bytesReferenceEqual(DynamicObject first, DynamicObject second) {
            Rope firstRope = StringOperations.rope(first);
            Rope secondRope = StringOperations.rope(second);
            return firstRope.getRawBytes() != null && firstRope.getRawBytes() == secondRope.getRawBytes();
        }

        protected static int byteLength(DynamicObject string) {
            return StringOperations.rope(string).byteLength();
        }

        protected static boolean hasRawBytes(DynamicObject string) {
            return StringOperations.rope(string).getRawBytes() != null;
        }
    }

    @ImportStatic(value={StringGuards.class})
    @NodeChildren(value={@NodeChild(value="first"), @NodeChild(value="second")})
    public static abstract class StringAreComparableNode
    extends RubyNode {
        public abstract boolean executeAreComparable(DynamicObject var1, DynamicObject var2);

        @Specialization(guards={"getEncoding(a) == getEncoding(b)"})
        protected boolean sameEncoding(DynamicObject a, DynamicObject b) {
            return true;
        }

        @Specialization(guards={"isEmpty(a)"})
        protected boolean firstEmpty(DynamicObject a, DynamicObject b) {
            return true;
        }

        @Specialization(guards={"isEmpty(b)"})
        protected boolean secondEmpty(DynamicObject a, DynamicObject b) {
            return true;
        }

        @Specialization(guards={"is7Bit(a)", "is7Bit(b)"})
        protected boolean bothCR7bit(DynamicObject a, DynamicObject b) {
            return true;
        }

        @Specialization(guards={"is7Bit(a)", "isAsciiCompatible(b)"})
        protected boolean CR7bitASCII(DynamicObject a, DynamicObject b) {
            return true;
        }

        @Specialization(guards={"isAsciiCompatible(a)", "is7Bit(b)"})
        protected boolean ASCIICR7bit(DynamicObject a, DynamicObject b) {
            return true;
        }

        @Fallback
        protected boolean notCompatible(Object a, Object b) {
            return false;
        }

        protected static Encoding getEncoding(DynamicObject string) {
            return StringOperations.rope(string).getEncoding();
        }
    }

    @Primitive(name="string_compare_substring")
    public static abstract class StringCompareSubstringPrimitiveNode
    extends PrimitiveArrayArgumentsNode {
        @Node.Child
        private NormalizeIndexNode normalizeIndexNode = StringNodesFactory.NormalizeIndexNodeGen.create(null, null);

        @Specialization(guards={"isRubyString(other)"})
        public int stringCompareSubstring(VirtualFrame frame, DynamicObject string, DynamicObject other, int start, int size, @Cached(value="create()") BranchProfile errorProfile) {
            int stringLength = StringOperations.rope(string).characterLength();
            int otherLength = StringOperations.rope(other).characterLength();
            if ((start = this.normalizeIndexNode.executeNormalize(start, otherLength)) > otherLength) {
                errorProfile.enter();
                throw new RaiseException(this.coreExceptions().indexError(this.formatError(start), this));
            }
            if (start < 0) {
                errorProfile.enter();
                throw new RaiseException(this.coreExceptions().indexError(this.formatError(start), this));
            }
            if (start + size > otherLength) {
                size = otherLength - start;
            }
            if (size > stringLength) {
                size = stringLength;
            }
            Rope rope = StringOperations.rope(string);
            Rope otherRope = StringOperations.rope(other);
            return ArrayUtils.memcmp(rope.getBytes(), 0, otherRope.getBytes(), start, size);
        }

        @CompilerDirectives.TruffleBoundary
        private String formatError(int start) {
            return StringUtils.format("index %d out of string", start);
        }
    }

    @Primitive(name="string_chr_at", lowerFixnum={1})
    @ImportStatic(value={StringGuards.class})
    public static abstract class StringChrAtPrimitiveNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization(guards={"indexOutOfBounds(string, byteIndex)"})
        public Object stringChrAtOutOfBounds(DynamicObject string, int byteIndex) {
            return this.nil();
        }

        @Specialization(guards={"!indexOutOfBounds(string, byteIndex)", "isSingleByteOptimizable(string)"})
        public Object stringChrAtSingleByte(DynamicObject string, int byteIndex, @Cached(value="create()") StringByteSubstringPrimitiveNode stringByteSubstringNode) {
            return stringByteSubstringNode.executeStringByteSubstring(string, byteIndex, 1);
        }

        @Specialization(guards={"!indexOutOfBounds(string, byteIndex)", "!isSingleByteOptimizable(string)"})
        public Object stringChrAt(DynamicObject string, int byteIndex, @Cached(value="create()") StringByteSubstringPrimitiveNode stringByteSubstringNode) {
            Rope rope = StringOperations.rope(string);
            int end = rope.byteLength();
            int c = StringSupport.preciseLength(rope.getEncoding(), rope.getBytes(), byteIndex, end);
            if (!StringSupport.MBCLEN_CHARFOUND_P(c)) {
                return this.nil();
            }
            int n = StringSupport.MBCLEN_CHARFOUND_LEN(c);
            if (n + byteIndex > end) {
                return this.nil();
            }
            return stringByteSubstringNode.executeStringByteSubstring(string, byteIndex, n);
        }

        protected static boolean indexOutOfBounds(DynamicObject string, int byteIndex) {
            return byteIndex < 0 || byteIndex >= StringOperations.rope(string).byteLength();
        }
    }

    @Primitive(name="string_byte_substring")
    @NodeChildren(value={@NodeChild(type=RubyNode.class, value="string"), @NodeChild(type=RubyNode.class, value="index"), @NodeChild(type=RubyNode.class, value="length")})
    public static abstract class StringByteSubstringPrimitiveNode
    extends PrimitiveNode {
        @Node.Child
        private AllocateObjectNode allocateObjectNode = AllocateObjectNode.create();
        @Node.Child
        private NormalizeIndexNode normalizeIndexNode = StringNodesFactory.NormalizeIndexNodeGen.create(null, null);
        @Node.Child
        private RopeNodes.MakeSubstringNode makeSubstringNode = RopeNodesFactory.MakeSubstringNodeGen.create(null, null, null);
        @Node.Child
        private TaintResultNode taintResultNode = new TaintResultNode();

        public static StringByteSubstringPrimitiveNode create() {
            return StringNodesFactory.StringByteSubstringPrimitiveNodeFactory.create(null, null, null);
        }

        @CreateCast(value={"index"})
        public RubyNode coerceIndexToInt(RubyNode index) {
            return ArrayAttributeCastNodeGen.create("index", index);
        }

        @CreateCast(value={"length"})
        public RubyNode coerceLengthToInt(RubyNode length) {
            return ArrayAttributeCastNodeGen.create("length", length);
        }

        public Object executeStringByteSubstring(DynamicObject string, Object index, Object length) {
            return this.nil();
        }

        @Specialization
        public Object stringByteSubstring(DynamicObject string, int index, NotProvided length, @Cached(value="createBinaryProfile()") ConditionProfile negativeLengthProfile, @Cached(value="createBinaryProfile()") ConditionProfile indexOutOfBoundsProfile, @Cached(value="createBinaryProfile()") ConditionProfile lengthTooLongProfile, @Cached(value="createBinaryProfile()") ConditionProfile nilSubstringProfile, @Cached(value="createBinaryProfile()") ConditionProfile emptySubstringProfile) {
            DynamicObject subString = (DynamicObject)this.stringByteSubstring(string, index, 1, negativeLengthProfile, indexOutOfBoundsProfile, lengthTooLongProfile);
            if (nilSubstringProfile.profile(subString == this.nil())) {
                return subString;
            }
            if (emptySubstringProfile.profile(StringOperations.rope(subString).isEmpty())) {
                return this.nil();
            }
            return subString;
        }

        @Specialization
        public Object stringByteSubstring(DynamicObject string, int index, int length, @Cached(value="createBinaryProfile()") ConditionProfile negativeLengthProfile, @Cached(value="createBinaryProfile()") ConditionProfile indexOutOfBoundsProfile, @Cached(value="createBinaryProfile()") ConditionProfile lengthTooLongProfile) {
            if (negativeLengthProfile.profile(length < 0)) {
                return this.nil();
            }
            Rope rope = StringOperations.rope(string);
            int stringByteLength = rope.byteLength();
            int normalizedIndex = this.normalizeIndexNode.executeNormalize(index, stringByteLength);
            if (indexOutOfBoundsProfile.profile(normalizedIndex < 0 || normalizedIndex > stringByteLength)) {
                return this.nil();
            }
            if (lengthTooLongProfile.profile(normalizedIndex + length > stringByteLength)) {
                length = rope.byteLength() - normalizedIndex;
            }
            Rope substringRope = this.makeSubstringNode.executeMake(rope, normalizedIndex, length);
            DynamicObject result = this.allocateObjectNode.allocate(Layouts.BASIC_OBJECT.getLogicalClass(string), substringRope);
            return this.taintResultNode.maybeTaint(string, result);
        }

        @Specialization(guards={"isRubyRange(range)"})
        public Object stringByteSubstring(DynamicObject string, DynamicObject range, NotProvided length) {
            return null;
        }
    }

    @Primitive(name="string_awk_split")
    public static abstract class StringAwkSplitPrimitiveNode
    extends PrimitiveArrayArgumentsNode {
        @Node.Child
        private RopeNodes.GetCodePointNode getCodePointNode = RopeNodes.GetCodePointNode.create();
        @Node.Child
        private RopeNodes.MakeSubstringNode makeSubstringNode = RopeNodesFactory.MakeSubstringNodeGen.create(null, null, null);
        @Node.Child
        private TaintResultNode taintResultNode = new TaintResultNode();

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public DynamicObject stringAwkSplit(DynamicObject string, int lim) {
            int p;
            ArrayList<DynamicObject> ret = new ArrayList<DynamicObject>();
            Rope rope = StringOperations.rope(string);
            boolean limit = lim > 0;
            int i = lim > 0 ? 1 : 0;
            byte[] bytes = rope.getBytes();
            int ptr = p = 0;
            int len = rope.byteLength();
            int end = p + len;
            Encoding enc = rope.getEncoding();
            boolean skip = true;
            int e = 0;
            int b = 0;
            boolean singlebyte = rope.isSingleByteOptimizable();
            while (p < end) {
                int c;
                if (singlebyte) {
                    c = bytes[p++] & 0xFF;
                } else {
                    c = this.getCodePointNode.executeGetCodePoint(rope, p);
                    p += StringSupport.length(enc, bytes, p, end);
                }
                if (skip) {
                    if (enc.isSpace(c)) {
                        b = p - ptr;
                        continue;
                    }
                    e = p - ptr;
                    skip = false;
                    if (!limit || lim > i) continue;
                    break;
                }
                if (enc.isSpace(c)) {
                    ret.add(this.makeString(string, b, e - b));
                    skip = true;
                    b = p - ptr;
                    if (!limit) continue;
                    ++i;
                    continue;
                }
                e = p - ptr;
            }
            if (len > 0 && (limit || len > b || lim < 0)) {
                ret.add(this.makeString(string, b, len - b));
            }
            Object[] objects = ret.toArray();
            return this.createArray(objects, objects.length);
        }

        @CompilerDirectives.TruffleBoundary
        private DynamicObject makeString(DynamicObject source, int index, int length) {
            assert (RubyGuards.isRubyString(source));
            Rope rope = this.makeSubstringNode.executeMake(StringOperations.rope(source), index, length);
            DynamicObject ret = Layouts.STRING.createString(Layouts.CLASS.getInstanceFactory(Layouts.BASIC_OBJECT.getLogicalClass(source)), rope);
            this.taintResultNode.maybeTaint(source, ret);
            return ret;
        }
    }

    @Primitive(name="string_append")
    public static abstract class StringAppendPrimitiveNode
    extends PrimitiveArrayArgumentsNode {
        @Node.Child
        private StringAppendNode stringAppendNode = StringNodesFactory.StringAppendNodeGen.create(null, null);

        public static StringAppendPrimitiveNode create() {
            return StringNodesFactory.StringAppendPrimitiveNodeFactory.create(null);
        }

        public abstract DynamicObject executeStringAppend(DynamicObject var1, DynamicObject var2);

        @Specialization(guards={"isRubyString(other)"})
        public DynamicObject stringAppend(DynamicObject string, DynamicObject other) {
            StringOperations.setRope(string, this.stringAppendNode.executeStringAppend(string, other));
            return string;
        }
    }

    @Primitive(name="character_printable_p")
    public static abstract class CharacterPrintablePrimitiveNode
    extends PrimitiveArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        public boolean isCharacterPrintable(DynamicObject character) {
            Rope rope = StringOperations.rope(character);
            Encoding encoding = rope.getEncoding();
            int codepoint = encoding.mbcToCode(rope.getBytes(), 0, rope.byteLength());
            return encoding.isPrint(codepoint);
        }
    }

    public static class StringNodesHelper {
        @CompilerDirectives.TruffleBoundary
        private static Object trTransHelper(RubyContext context, EncodingNodes.CheckEncodingNode checkEncodingNode, DynamicObject self, DynamicObject fromStr, DynamicObject toStr, boolean sFlag) {
            Encoding e2;
            assert (RubyGuards.isRubyString(self));
            assert (RubyGuards.isRubyString(fromStr));
            assert (RubyGuards.isRubyString(toStr));
            Encoding e1 = checkEncodingNode.executeCheckEncoding(self, fromStr);
            Encoding enc = e1 == (e2 = checkEncodingNode.executeCheckEncoding(self, toStr)) ? e1 : checkEncodingNode.executeCheckEncoding(fromStr, toStr);
            Rope ret = StringSupport.trTransHelper(StringOperations.rope(self), StringOperations.rope(fromStr), StringOperations.rope(toStr), e1, enc, sFlag);
            if (ret == null) {
                return context.getCoreLibrary().getNilObject();
            }
            StringOperations.setRope(self, ret);
            return self;
        }
    }

    @CoreMethod(names={"clear"}, raiseIfFrozenSelf=true)
    public static abstract class ClearNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private RopeNodes.MakeSubstringNode makeSubstringNode = RopeNodes.MakeSubstringNode.createX();

        @Specialization
        public DynamicObject clear(DynamicObject string) {
            StringOperations.setRope(string, this.makeSubstringNode.executeMake(StringOperations.rope(string), 0, 0));
            return string;
        }
    }

    @CoreMethod(names={"capitalize!"}, raiseIfFrozenSelf=true)
    public static abstract class CapitalizeBangNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private RopeNodes.GetCodePointNode getCodePointNode = RopeNodes.GetCodePointNode.create();
        @Node.Child
        private RopeNodes.MakeLeafRopeNode makeLeafRopeNode = RopeNodesFactory.MakeLeafRopeNodeGen.create(null, null, null, null);

        @Specialization
        @CompilerDirectives.TruffleBoundary(throwsControlFlowException=true)
        public DynamicObject capitalizeBang(DynamicObject string) {
            Rope rope = StringOperations.rope(string);
            Encoding enc = rope.getEncoding();
            if (enc.isDummy()) {
                throw new RaiseException(this.coreExceptions().encodingCompatibilityErrorIncompatibleWithOperation(enc, this));
            }
            if (rope.isEmpty()) {
                return this.nil();
            }
            int s = 0;
            int end = s + rope.byteLength();
            byte[] bytes = rope.getBytesCopy();
            boolean modify = false;
            int c = this.getCodePointNode.executeGetCodePoint(rope, s);
            if (enc.isLower(c)) {
                enc.codeToMbc(StringSupport.toUpper(enc, c), bytes, s);
                modify = true;
            }
            s += StringSupport.codeLength(enc, c);
            while (s < end) {
                c = this.getCodePointNode.executeGetCodePoint(rope, s);
                if (enc.isUpper(c)) {
                    enc.codeToMbc(StringSupport.toLower(enc, c), bytes, s);
                    modify = true;
                }
                s += StringSupport.codeLength(enc, c);
            }
            if (modify) {
                StringOperations.setRope(string, this.makeLeafRopeNode.executeMake(bytes, rope.getEncoding(), rope.getCodeRange(), rope.characterLength()));
                return string;
            }
            return this.nil();
        }
    }

    @CoreMethod(names={"valid_encoding?"})
    @ImportStatic(value={StringGuards.class})
    public static abstract class ValidEncodingQueryNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization(guards={"isBrokenCodeRange(string)"})
        public boolean validEncodingQueryBroken(DynamicObject string) {
            return false;
        }

        @Specialization(guards={"!isBrokenCodeRange(string)"})
        public boolean validEncodingQuery(DynamicObject string) {
            return true;
        }
    }

    @CoreMethod(names={"upcase!"}, raiseIfFrozenSelf=true)
    @ImportStatic(value={StringGuards.class})
    public static abstract class UpcaseBangNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private RopeNodes.MakeLeafRopeNode makeLeafRopeNode = RopeNodesFactory.MakeLeafRopeNodeGen.create(null, null, null, null);

        @Specialization(guards={"isSingleByteOptimizable(string)"})
        public DynamicObject upcaseSingleByte(DynamicObject string, @Cached(value="createBinaryProfile()") ConditionProfile isEmptyProfile, @Cached(value="createBinaryProfile()") ConditionProfile modifiedProfile) {
            Rope rope = StringOperations.rope(string);
            if (isEmptyProfile.profile(rope.isEmpty())) {
                return this.nil();
            }
            byte[] bytes = rope.getBytesCopy();
            boolean modified = this.singleByteUpcase(bytes, 0, bytes.length);
            if (modifiedProfile.profile(modified)) {
                LeafRope newRope = this.makeLeafRopeNode.executeMake(bytes, rope.getEncoding(), rope.getCodeRange(), rope.characterLength());
                StringOperations.setRope(string, newRope);
                return string;
            }
            return this.nil();
        }

        @Specialization(guards={"!isSingleByteOptimizable(string)"})
        public DynamicObject upcase(DynamicObject string) {
            Rope rope = StringOperations.rope(string);
            Encoding encoding = rope.getEncoding();
            if (encoding.isDummy()) {
                throw new RaiseException(this.coreExceptions().encodingCompatibilityErrorIncompatibleWithOperation(encoding, this));
            }
            if (rope.isEmpty()) {
                return this.nil();
            }
            ByteList bytes = RopeOperations.toByteListCopy(rope);
            boolean modified = this.multiByteUpcase(encoding, bytes.unsafeBytes(), bytes.begin(), bytes.realSize());
            if (modified) {
                StringOperations.setRope(string, RopeOperations.ropeFromByteList(bytes, rope.getCodeRange()));
                return string;
            }
            return this.nil();
        }

        @CompilerDirectives.TruffleBoundary
        private boolean singleByteUpcase(byte[] bytes, int s, int end) {
            return StringSupport.singleByteUpcase(bytes, s, end);
        }

        @CompilerDirectives.TruffleBoundary
        private boolean multiByteUpcase(Encoding encoding, byte[] bytes, int s, int end) {
            return StringSupport.multiByteUpcase(encoding, bytes, s, end);
        }
    }

    @CoreMethod(names={"unpack"}, required=1, taintFrom=1)
    @ImportStatic(value={StringCachingGuards.class})
    public static abstract class UnpackNode
    extends ArrayCoreMethodNode {
        @Node.Child
        private TaintNode taintNode;
        private final BranchProfile exceptionProfile = BranchProfile.create();

        @Specialization(guards={"isRubyString(format)", "ropesEqual(format, cachedFormat)"}, limit="getCacheLimit()")
        public DynamicObject unpackCached(VirtualFrame frame, DynamicObject string, DynamicObject format, @Cached(value="privatizeRope(format)") Rope cachedFormat, @Cached(value="create(compileFormat(format))") DirectCallNode callUnpackNode) {
            ArrayResult result;
            Rope rope = StringOperations.rope(string);
            try {
                result = (ArrayResult)callUnpackNode.call(frame, new Object[]{rope.getBytes(), rope.byteLength()});
            }
            catch (FormatException e) {
                this.exceptionProfile.enter();
                throw FormatExceptionTranslator.translate(this, e);
            }
            return this.finishUnpack(result);
        }

        @Specialization(contains={"unpackCached"}, guards={"isRubyString(format)"})
        public DynamicObject unpackUncached(VirtualFrame frame, DynamicObject string, DynamicObject format, @Cached(value="create()") IndirectCallNode callUnpackNode) {
            ArrayResult result;
            Rope rope = StringOperations.rope(string);
            try {
                result = (ArrayResult)callUnpackNode.call(frame, this.compileFormat(format), new Object[]{rope.getBytes(), rope.byteLength()});
            }
            catch (FormatException e) {
                this.exceptionProfile.enter();
                throw FormatExceptionTranslator.translate(this, e);
            }
            return this.finishUnpack(result);
        }

        private DynamicObject finishUnpack(ArrayResult result) {
            DynamicObject array = this.createArray(result.getOutput(), result.getOutputLength());
            if (result.isTainted()) {
                if (this.taintNode == null) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.taintNode = this.insert(TaintNode.create());
                }
                this.taintNode.executeTaint(array);
            }
            return array;
        }

        @Specialization(guards={"!isRubyString(format)", "!isBoolean(format)", "!isInteger(format)", "!isLong(format)", "!isNil(format)"})
        public Object unpack(VirtualFrame frame, DynamicObject array, Object format, @Cached(value="new()") SnippetNode snippetNode) {
            return snippetNode.execute(frame, "unpack(format.to_str)", "format", format);
        }

        @CompilerDirectives.TruffleBoundary
        protected CallTarget compileFormat(DynamicObject format) {
            return new UnpackCompiler(this.getContext(), this).compile(format.toString());
        }

        protected int getCacheLimit() {
            return this.getContext().getOptions().UNPACK_CACHE;
        }
    }

    @CoreMethod(names={"tr_s!"}, required=2, raiseIfFrozenSelf=true)
    @ImportStatic(value={StringGuards.class})
    @NodeChildren(value={@NodeChild(type=RubyNode.class, value="self"), @NodeChild(type=RubyNode.class, value="fromStr"), @NodeChild(type=RubyNode.class, value="toStrNode")})
    public static abstract class TrSBangNode
    extends CoreMethodNode {
        @Node.Child
        private EncodingNodes.CheckEncodingNode checkEncodingNode;
        @Node.Child
        private DeleteBangNode deleteBangNode;

        @CreateCast(value={"fromStr"})
        public RubyNode coerceFromStrToString(RubyNode fromStr) {
            return ToStrNodeGen.create(fromStr);
        }

        @CreateCast(value={"toStrNode"})
        public RubyNode coerceToStrToString(RubyNode toStr) {
            return ToStrNodeGen.create(toStr);
        }

        @Specialization(guards={"isEmpty(self)"})
        public DynamicObject trSBangEmpty(DynamicObject self, DynamicObject fromStr, DynamicObject toStr) {
            return this.nil();
        }

        @Specialization(guards={"!isEmpty(self)", "isRubyString(fromStr)", "isRubyString(toStr)"})
        public Object trSBang(VirtualFrame frame, DynamicObject self, DynamicObject fromStr, DynamicObject toStr) {
            if (StringOperations.rope(toStr).isEmpty()) {
                if (this.deleteBangNode == null) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.deleteBangNode = this.insert(StringNodesFactory.DeleteBangNodeFactory.create(new RubyNode[0]));
                }
                return this.deleteBangNode.executeDeleteBang(frame, self, new DynamicObject[]{fromStr});
            }
            if (this.checkEncodingNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.checkEncodingNode = this.insert(EncodingNodesFactory.CheckEncodingNodeGen.create(null, null));
            }
            return StringNodesHelper.trTransHelper(this.getContext(), this.checkEncodingNode, self, fromStr, toStr, true);
        }
    }

    @CoreMethod(names={"tr!"}, required=2, raiseIfFrozenSelf=true)
    @ImportStatic(value={StringGuards.class})
    @NodeChildren(value={@NodeChild(type=RubyNode.class, value="self"), @NodeChild(type=RubyNode.class, value="fromStr"), @NodeChild(type=RubyNode.class, value="toStrNode")})
    public static abstract class TrBangNode
    extends CoreMethodNode {
        @Node.Child
        private EncodingNodes.CheckEncodingNode checkEncodingNode;
        @Node.Child
        private DeleteBangNode deleteBangNode;

        @CreateCast(value={"fromStr"})
        public RubyNode coerceFromStrToString(RubyNode fromStr) {
            return ToStrNodeGen.create(fromStr);
        }

        @CreateCast(value={"toStrNode"})
        public RubyNode coerceToStrToString(RubyNode toStr) {
            return ToStrNodeGen.create(toStr);
        }

        @Specialization(guards={"isEmpty(self)"})
        public Object trBangEmpty(DynamicObject self, DynamicObject fromStr, DynamicObject toStr) {
            return this.nil();
        }

        @Specialization(guards={"!isEmpty(self)", "isRubyString(fromStr)", "isRubyString(toStr)"})
        public Object trBang(VirtualFrame frame, DynamicObject self, DynamicObject fromStr, DynamicObject toStr) {
            if (StringOperations.rope(toStr).isEmpty()) {
                if (this.deleteBangNode == null) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.deleteBangNode = this.insert(StringNodesFactory.DeleteBangNodeFactory.create(new RubyNode[0]));
                }
                return this.deleteBangNode.executeDeleteBang(frame, self, new DynamicObject[]{fromStr});
            }
            if (this.checkEncodingNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.checkEncodingNode = this.insert(EncodingNodesFactory.CheckEncodingNodeGen.create(null, null));
            }
            return StringNodesHelper.trTransHelper(this.getContext(), this.checkEncodingNode, self, fromStr, toStr, false);
        }
    }

    @CoreMethod(names={"reverse!"}, raiseIfFrozenSelf=true)
    @ImportStatic(value={StringGuards.class})
    public static abstract class ReverseBangNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private RopeNodes.MakeLeafRopeNode makeLeafRopeNode = RopeNodesFactory.MakeLeafRopeNodeGen.create(null, null, null, null);

        @Specialization(guards={"reverseIsEqualToSelf(string)"})
        public DynamicObject reverseNoOp(DynamicObject string) {
            return string;
        }

        @Specialization(guards={"!reverseIsEqualToSelf(string)", "isSingleByteOptimizable(string)"})
        public DynamicObject reverseSingleByteOptimizable(DynamicObject string) {
            Rope rope = StringOperations.rope(string);
            byte[] originalBytes = rope.getBytes();
            int len = originalBytes.length;
            byte[] reversedBytes = new byte[len];
            for (int i = 0; i < len; ++i) {
                reversedBytes[len - i - 1] = originalBytes[i];
            }
            StringOperations.setRope(string, this.makeLeafRopeNode.executeMake(reversedBytes, rope.getEncoding(), rope.getCodeRange(), rope.characterLength()));
            return string;
        }

        @Specialization(guards={"!reverseIsEqualToSelf(string)", "!isSingleByteOptimizable(string)"})
        public DynamicObject reverse(DynamicObject string) {
            Rope rope = StringOperations.rope(string);
            byte[] originalBytes = rope.getBytes();
            int p = 0;
            int len = originalBytes.length;
            Encoding enc = rope.getEncoding();
            int end = p + len;
            int op = len;
            byte[] reversedBytes = new byte[len];
            while (p < end) {
                int cl = StringSupport.length(enc, originalBytes, p, end);
                if (cl > 1 || (originalBytes[p] & 0x80) != 0) {
                    System.arraycopy(originalBytes, p, reversedBytes, op -= cl, cl);
                    p += cl;
                    continue;
                }
                reversedBytes[--op] = originalBytes[p++];
            }
            StringOperations.setRope(string, this.makeLeafRopeNode.executeMake(reversedBytes, rope.getEncoding(), rope.getCodeRange(), rope.characterLength()));
            return string;
        }

        public static boolean reverseIsEqualToSelf(DynamicObject string) {
            assert (RubyGuards.isRubyString(string));
            return StringOperations.rope(string).characterLength() <= 1;
        }
    }

    @CoreMethod(names={"to_sym", "intern"})
    public static abstract class ToSymNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        public DynamicObject toSym(DynamicObject string) {
            return this.getSymbol(StringOperations.rope(string));
        }
    }

    @CoreMethod(names={"to_s", "to_str"})
    public static abstract class ToSNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization(guards={"!isStringSubclass(string)"})
        public DynamicObject toS(DynamicObject string) {
            return string;
        }

        @Specialization(guards={"isStringSubclass(string)"})
        public Object toSOnSubclass(VirtualFrame frame, DynamicObject string, @Cached(value="new()") SnippetNode snippetNode) {
            return snippetNode.execute(frame, "''.replace(self)", "self", string);
        }

        public boolean isStringSubclass(DynamicObject string) {
            return Layouts.BASIC_OBJECT.getLogicalClass(string) != this.coreLibrary().getStringClass();
        }
    }

    @CoreMethod(names={"to_f"})
    public static abstract class ToFNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        @CompilerDirectives.TruffleBoundary
        public double toF(DynamicObject string) {
            try {
                return this.convertToDouble(string);
            }
            catch (NumberFormatException e) {
                return 0.0;
            }
        }

        @CompilerDirectives.TruffleBoundary
        private double convertToDouble(DynamicObject string) {
            return new DoubleConverter().parse(StringOperations.rope(string), false, true);
        }
    }

    @CoreMethod(names={"sum"}, optional=1)
    public static abstract class SumNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private CallDispatchHeadNode addNode = DispatchHeadNodeFactory.createMethodCall();
        @Node.Child
        private CallDispatchHeadNode subNode = DispatchHeadNodeFactory.createMethodCall();
        @Node.Child
        private CallDispatchHeadNode shiftNode = DispatchHeadNodeFactory.createMethodCall();
        @Node.Child
        private CallDispatchHeadNode andNode = DispatchHeadNodeFactory.createMethodCall();

        @Specialization
        public Object sum(VirtualFrame frame, DynamicObject string, int bits) {
            return this.sum(frame, string, (long)bits);
        }

        @Specialization
        public Object sum(VirtualFrame frame, DynamicObject string, long bits) {
            Rope rope = StringOperations.rope(string);
            byte[] bytes = rope.getBytes();
            int p = 0;
            int len = rope.byteLength();
            int end = p + len;
            if (bits >= 64L) {
                Object sum = 0;
                while (p < end) {
                    sum = this.addNode.call(frame, sum, "+", bytes[p++] & 0xFF);
                }
                if (bits != 0L) {
                    Object mod = this.shiftNode.call(frame, 1, "<<", bits);
                    sum = this.andNode.call(frame, sum, "&", this.subNode.call(frame, mod, "-", 1));
                }
                return sum;
            }
            long sum = 0L;
            while (p < end) {
                sum += (long)(bytes[p++] & 0xFF);
            }
            return bits == 0L ? sum : sum & (1L << (int)bits) - 1L;
        }

        @Specialization
        public Object sum(VirtualFrame frame, DynamicObject string, NotProvided bits) {
            return this.sum(frame, string, 16);
        }

        @Specialization(guards={"!isInteger(bits)", "!isLong(bits)", "wasProvided(bits)"})
        public Object sum(VirtualFrame frame, DynamicObject string, Object bits, @Cached(value="new()") SnippetNode snippetNode) {
            return snippetNode.execute(frame, "sum Rubinius::Type.coerce_to(bits, Fixnum, :to_int)", "bits", bits);
        }
    }

    @CoreMethod(names={"succ!"}, raiseIfFrozenSelf=true)
    public static abstract class SuccBangNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        public DynamicObject succBang(DynamicObject string) {
            Rope rope = StringOperations.rope(string);
            if (!rope.isEmpty()) {
                ByteList succByteList = StringSupport.succCommon(rope);
                StringOperations.setRope(string, RopeOperations.ropeFromByteList(succByteList, rope.getCodeRange()));
            }
            return string;
        }
    }

    @CoreMethod(names={"squeeze!"}, rest=true, raiseIfFrozenSelf=true)
    @ImportStatic(value={StringGuards.class})
    public static abstract class SqueezeBangNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private EncodingNodes.CheckEncodingNode checkEncodingNode;
        @Node.Child
        private ToStrNode toStrNode;

        @Specialization(guards={"isEmpty(string)"})
        public DynamicObject squeezeBangEmptyString(DynamicObject string, Object[] args) {
            return this.nil();
        }

        @Specialization(guards={"!isEmpty(string)", "zeroArgs(args)"})
        @CompilerDirectives.TruffleBoundary
        public Object squeezeBangZeroArgs(DynamicObject string, Object[] args, @Cached(value="createBinaryProfile()") ConditionProfile singleByteOptimizableProfile) {
            Rope rope = StringOperations.rope(string);
            ByteList buffer = RopeOperations.toByteListCopy(rope);
            boolean[] squeeze = new boolean[256];
            for (int i = 0; i < 256; ++i) {
                squeeze[i] = true;
            }
            if (singleByteOptimizableProfile.profile(rope.isSingleByteOptimizable())) {
                if (!StringSupport.singleByteSqueeze(buffer, squeeze)) {
                    return this.nil();
                }
                StringOperations.setRope(string, RopeOperations.ropeFromByteList(buffer));
            } else {
                if (!this.squeezeCommonMultiByte(buffer, squeeze, null, StringOperations.encoding(string), false)) {
                    return this.nil();
                }
                StringOperations.setRope(string, RopeOperations.ropeFromByteList(buffer));
            }
            return string;
        }

        @Specialization(guards={"!isEmpty(string)", "!zeroArgs(args)"})
        public Object squeezeBang(VirtualFrame frame, DynamicObject string, Object[] args, @Cached(value="createBinaryProfile()") ConditionProfile singleByteOptimizableProfile) {
            if (this.toStrNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.toStrNode = this.insert(ToStrNodeGen.create(null));
            }
            DynamicObject[] otherStrings = new DynamicObject[args.length];
            for (int i = 0; i < args.length; ++i) {
                otherStrings[i] = this.toStrNode.executeToStr(frame, args[i]);
            }
            return this.performSqueezeBang(string, otherStrings, singleByteOptimizableProfile);
        }

        @CompilerDirectives.TruffleBoundary
        private Object performSqueezeBang(DynamicObject string, DynamicObject[] otherStrings, @Cached(value="createBinaryProfile()") ConditionProfile singleByteOptimizableProfile) {
            if (this.checkEncodingNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.checkEncodingNode = this.insert(EncodingNodesFactory.CheckEncodingNodeGen.create(null, null));
            }
            Rope rope = StringOperations.rope(string);
            ByteList buffer = RopeOperations.toByteListCopy(rope);
            DynamicObject otherStr = otherStrings[0];
            Rope otherRope = StringOperations.rope(otherStr);
            Encoding enc = this.checkEncodingNode.executeCheckEncoding(string, otherStr);
            boolean[] squeeze = new boolean[257];
            StringSupport.TrTables tables = StringSupport.trSetupTable(otherRope, squeeze, null, true, enc);
            boolean singlebyte = rope.isSingleByteOptimizable() && otherRope.isSingleByteOptimizable();
            for (int i = 1; i < otherStrings.length; ++i) {
                otherStr = otherStrings[i];
                otherRope = StringOperations.rope(otherStr);
                enc = this.checkEncodingNode.executeCheckEncoding(string, otherStr);
                singlebyte = singlebyte && otherRope.isSingleByteOptimizable();
                tables = StringSupport.trSetupTable(otherRope, squeeze, tables, false, enc);
            }
            if (singleByteOptimizableProfile.profile(singlebyte)) {
                if (!StringSupport.singleByteSqueeze(buffer, squeeze)) {
                    return this.nil();
                }
                StringOperations.setRope(string, RopeOperations.ropeFromByteList(buffer));
            } else {
                if (!StringSupport.multiByteSqueeze(buffer, squeeze, tables, enc, true)) {
                    return this.nil();
                }
                StringOperations.setRope(string, RopeOperations.ropeFromByteList(buffer));
            }
            return string;
        }

        @CompilerDirectives.TruffleBoundary
        private boolean squeezeCommonMultiByte(ByteList value, boolean[] squeeze, StringSupport.TrTables tables, Encoding enc, boolean isArg) {
            return StringSupport.multiByteSqueeze(value, squeeze, tables, enc, isArg);
        }

        public static boolean zeroArgs(Object[] args) {
            return args.length == 0;
        }
    }

    @CoreMethod(names={"size", "length"})
    @ImportStatic(value={StringGuards.class})
    public static abstract class SizeNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        public int size(DynamicObject string, @Cached(value="createBinaryProfile()") ConditionProfile ropeBufferProfile, @Cached(value="createBinaryProfile()") ConditionProfile isSingleByteOptimizableRopeBufferProfile) {
            Rope rope = StringOperations.rope(string);
            if (ropeBufferProfile.profile(rope instanceof RopeBuffer)) {
                if (isSingleByteOptimizableRopeBufferProfile.profile(rope.isSingleByteOptimizable())) {
                    return ((RopeBuffer)rope).getByteList().realSize();
                }
                ByteList byteList = ((RopeBuffer)rope).getByteList();
                return RopeOperations.strLength(rope.getEncoding(), byteList.unsafeBytes(), byteList.begin(), byteList.realSize());
            }
            return rope.characterLength();
        }
    }

    @NodeChildren(value={@NodeChild(value="index"), @NodeChild(value="length")})
    public static abstract class NormalizeIndexNode
    extends RubyNode {
        public abstract int executeNormalize(int var1, int var2);

        @Specialization
        protected int normalizeIndex(int index, int length, @Cached(value="createBinaryProfile()") ConditionProfile negativeIndexProfile) {
            if (negativeIndexProfile.profile(index < 0)) {
                return index + length;
            }
            return index;
        }
    }

    @NodeChildren(value={@NodeChild(value="index"), @NodeChild(value="length")})
    public static abstract class CheckIndexNode
    extends RubyNode {
        public abstract int executeCheck(int var1, int var2);

        @Specialization
        protected int checkIndex(int index, int length, @Cached(value="createBinaryProfile()") ConditionProfile negativeIndexProfile, @Cached(value="create()") BranchProfile errorProfile) {
            if (index >= length) {
                errorProfile.enter();
                throw new RaiseException(this.getContext().getCoreExceptions().indexErrorOutOfString(index, this));
            }
            if (negativeIndexProfile.profile(index < 0)) {
                if (-index > length) {
                    errorProfile.enter();
                    throw new RaiseException(this.getContext().getCoreExceptions().indexErrorOutOfString(index, this));
                }
                index += length;
            }
            return index;
        }
    }

    @CoreMethod(names={"setbyte"}, required=2, raiseIfFrozenSelf=true, lowerFixnum={1, 2})
    @ImportStatic(value={StringGuards.class})
    @NodeChildren(value={@NodeChild(type=RubyNode.class, value="string"), @NodeChild(type=RubyNode.class, value="index"), @NodeChild(type=RubyNode.class, value="value")})
    public static abstract class SetByteNode
    extends CoreMethodNode {
        @Node.Child
        private CheckIndexNode checkIndexNode = StringNodesFactory.CheckIndexNodeGen.create(null, null);
        @Node.Child
        private RopeNodes.MakeConcatNode composedMakeConcatNode = RopeNodesFactory.MakeConcatNodeGen.create(null, null, null);
        @Node.Child
        private RopeNodes.MakeConcatNode middleMakeConcatNode = RopeNodesFactory.MakeConcatNodeGen.create(null, null, null);
        @Node.Child
        private RopeNodes.MakeLeafRopeNode makeLeafRopeNode = RopeNodesFactory.MakeLeafRopeNodeGen.create(null, null, null, null);
        @Node.Child
        private RopeNodes.MakeSubstringNode leftMakeSubstringNode = RopeNodesFactory.MakeSubstringNodeGen.create(null, null, null);
        @Node.Child
        private RopeNodes.MakeSubstringNode rightMakeSubstringNode = RopeNodesFactory.MakeSubstringNodeGen.create(null, null, null);

        @CreateCast(value={"index"})
        public RubyNode coerceIndexToInt(RubyNode index) {
            return FixnumLowerNodeGen.create(ToIntNodeGen.create(index));
        }

        @CreateCast(value={"value"})
        public RubyNode coerceValueToInt(RubyNode value) {
            return FixnumLowerNodeGen.create(ToIntNodeGen.create(value));
        }

        public abstract int executeSetByte(DynamicObject var1, int var2, Object var3);

        @Specialization(guards={"!isRopeBuffer(string)"})
        public int setByte(DynamicObject string, int index, int value) {
            Rope rope = StringOperations.rope(string);
            int normalizedIndex = this.checkIndexNode.executeCheck(index, rope.byteLength());
            Rope left = this.leftMakeSubstringNode.executeMake(rope, 0, normalizedIndex);
            Rope right = this.rightMakeSubstringNode.executeMake(rope, normalizedIndex + 1, rope.byteLength() - normalizedIndex - 1);
            LeafRope middle = this.makeLeafRopeNode.executeMake(new byte[]{(byte)value}, rope.getEncoding(), CodeRange.CR_UNKNOWN, NotProvided.INSTANCE);
            Rope composed = this.composedMakeConcatNode.executeMake(this.middleMakeConcatNode.executeMake(left, middle, rope.getEncoding()), right, rope.getEncoding());
            StringOperations.setRope(string, composed);
            return value;
        }

        @Specialization(guards={"isRopeBuffer(string)"})
        public int setByteRopeBuffer(DynamicObject string, int index, int value) {
            RopeBuffer rope = (RopeBuffer)StringOperations.rope(string);
            int normalizedIndex = this.checkIndexNode.executeCheck(index, rope.byteLength());
            rope.getByteList().set(normalizedIndex, value);
            return value;
        }
    }

    @CoreMethod(names={"dump"}, taintFrom=0)
    @ImportStatic(value={StringGuards.class})
    public static abstract class DumpNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private AllocateObjectNode allocateObjectNode = AllocateObjectNode.create();

        @Specialization(guards={"isAsciiCompatible(string)"})
        public DynamicObject dumpAsciiCompatible(DynamicObject string) {
            ByteList outputBytes = this.dumpCommon(string);
            outputBytes.setEncoding(StringOperations.encoding(string));
            DynamicObject result = this.allocateObjectNode.allocate(Layouts.BASIC_OBJECT.getLogicalClass(string), RopeOperations.ropeFromByteList(outputBytes, CodeRange.CR_7BIT));
            return result;
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"!isAsciiCompatible(string)"})
        public DynamicObject dump(DynamicObject string) {
            ByteList outputBytes = this.dumpCommon(string);
            try {
                outputBytes.append(".force_encoding(\"".getBytes("UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                throw new UnsupportedOperationException(e);
            }
            outputBytes.append(StringOperations.encoding(string).getName());
            outputBytes.append((byte)34);
            outputBytes.append((byte)41);
            outputBytes.setEncoding(ASCIIEncoding.INSTANCE);
            DynamicObject result = this.allocateObjectNode.allocate(Layouts.BASIC_OBJECT.getLogicalClass(string), RopeOperations.ropeFromByteList(outputBytes, CodeRange.CR_7BIT));
            return result;
        }

        @CompilerDirectives.TruffleBoundary
        private ByteList dumpCommon(DynamicObject string) {
            assert (RubyGuards.isRubyString(string));
            return this.dumpCommon(StringOperations.rope(string));
        }

        private ByteList dumpCommon(Rope rope) {
            ByteList buf = null;
            Encoding enc = rope.getEncoding();
            int p = 0;
            int end = rope.byteLength();
            byte[] bytes = rope.getBytes();
            int len = 2;
            block4: while (p < end) {
                int n;
                int c = bytes[p++] & 0xFF;
                switch (c) {
                    case 7: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 11: 
                    case 12: 
                    case 13: 
                    case 27: 
                    case 34: 
                    case 92: {
                        len += 2;
                        continue block4;
                    }
                    case 35: {
                        len += DumpNode.isEVStr(bytes, p, end) ? 2 : 1;
                        continue block4;
                    }
                }
                if (ASCIIEncoding.INSTANCE.isPrint(c)) {
                    ++len;
                    continue;
                }
                if (enc.isUTF8() && (n = DumpNode.preciseLength(enc, bytes, p - 1, end) - 1) > 0) {
                    if (buf == null) {
                        buf = new ByteList();
                    }
                    int cc = this.codePointX(enc, bytes, p - 1, end);
                    buf.append(String.format("%x", cc).getBytes(StandardCharsets.US_ASCII));
                    len += buf.getRealSize() + 4;
                    buf.setRealSize(0);
                    p += n;
                    continue;
                }
                len += 4;
            }
            if (!enc.isAsciiCompatible()) {
                len += ".force_encoding(\"".length() + enc.getName().length + "\")".length();
            }
            ByteList outBytes = new ByteList(len);
            byte[] out = outBytes.getUnsafeBytes();
            int q = 0;
            p = 0;
            end = rope.byteLength();
            out[q++] = 34;
            while (p < end) {
                int n;
                int c;
                if ((c = bytes[p++] & 0xFF) == 34 || c == 92) {
                    out[q++] = 92;
                    out[q++] = (byte)c;
                    continue;
                }
                if (c == 35) {
                    if (DumpNode.isEVStr(bytes, p, end)) {
                        out[q++] = 92;
                    }
                    out[q++] = 35;
                    continue;
                }
                if (c == 10) {
                    out[q++] = 92;
                    out[q++] = 110;
                    continue;
                }
                if (c == 13) {
                    out[q++] = 92;
                    out[q++] = 114;
                    continue;
                }
                if (c == 9) {
                    out[q++] = 92;
                    out[q++] = 116;
                    continue;
                }
                if (c == 12) {
                    out[q++] = 92;
                    out[q++] = 102;
                    continue;
                }
                if (c == 11) {
                    out[q++] = 92;
                    out[q++] = 118;
                    continue;
                }
                if (c == 8) {
                    out[q++] = 92;
                    out[q++] = 98;
                    continue;
                }
                if (c == 7) {
                    out[q++] = 92;
                    out[q++] = 97;
                    continue;
                }
                if (c == 27) {
                    out[q++] = 92;
                    out[q++] = 101;
                    continue;
                }
                if (ASCIIEncoding.INSTANCE.isPrint(c)) {
                    out[q++] = (byte)c;
                    continue;
                }
                out[q++] = 92;
                if (enc.isUTF8() && (n = DumpNode.preciseLength(enc, bytes, p - 1, end) - 1) > 0) {
                    int cc = this.codePointX(enc, bytes, p - 1, end);
                    p += n;
                    outBytes.setRealSize(q);
                    outBytes.append(String.format("u{%x}", cc).getBytes(StandardCharsets.US_ASCII));
                    q = outBytes.getRealSize();
                    continue;
                }
                outBytes.setRealSize(q);
                outBytes.append(String.format("x%02X", c).getBytes(StandardCharsets.US_ASCII));
                q = outBytes.getRealSize();
            }
            out[q++] = 34;
            outBytes.setRealSize(q);
            assert (out == outBytes.getUnsafeBytes());
            return outBytes;
        }

        private static boolean isEVStr(byte[] bytes, int p, int end) {
            return p < end ? DumpNode.isEVStr(bytes[p] & 0xFF) : false;
        }

        private static boolean isEVStr(int c) {
            return c == 36 || c == 64 || c == 123;
        }

        private static int preciseLength(Encoding enc, byte[] bytes, int p, int end) {
            if (p >= end) {
                return -2;
            }
            int n = enc.length(bytes, p, end);
            if (n > end - p) {
                return DumpNode.MBCLEN_NEEDMORE(n - (end - p));
            }
            return n;
        }

        private static int MBCLEN_NEEDMORE(int n) {
            return -1 - n;
        }

        private static int codePoint(Encoding enc, byte[] bytes, int p, int end) {
            if (p >= end) {
                throw new IllegalArgumentException("empty string");
            }
            int cl = DumpNode.preciseLength(enc, bytes, p, end);
            if (cl <= 0) {
                throw new IllegalArgumentException("invalid byte sequence in " + enc);
            }
            return enc.mbcToCode(bytes, p, end);
        }

        private int codePointX(Encoding enc, byte[] bytes, int p, int end) {
            try {
                return DumpNode.codePoint(enc, bytes, p, end);
            }
            catch (IllegalArgumentException e) {
                throw new RaiseException(this.getContext().getCoreExceptions().argumentError(e.getMessage(), (Node)this));
            }
        }
    }

    @CoreMethod(names={"swapcase!"}, raiseIfFrozenSelf=true)
    @ImportStatic(value={StringGuards.class})
    public static abstract class SwapcaseBangNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private RopeNodes.MakeLeafRopeNode makeLeafRopeNode = RopeNodesFactory.MakeLeafRopeNodeGen.create(null, null, null, null);

        @CompilerDirectives.TruffleBoundary(throwsControlFlowException=true)
        @Specialization
        public DynamicObject swapcaseSingleByte(DynamicObject string, @Cached(value="createBinaryProfile()") ConditionProfile emptyStringProfile, @Cached(value="createBinaryProfile()") ConditionProfile singleByteOptimizableProfile) {
            Rope rope = StringOperations.rope(string);
            Encoding enc = rope.getEncoding();
            if (enc.isDummy()) {
                throw new RaiseException(this.coreExceptions().encodingCompatibilityErrorIncompatibleWithOperation(enc, this));
            }
            if (emptyStringProfile.profile(rope.isEmpty())) {
                return this.nil();
            }
            boolean s = false;
            int end = 0 + rope.byteLength();
            byte[] bytes = rope.getBytesCopy();
            if (singleByteOptimizableProfile.profile(rope.isSingleByteOptimizable())) {
                if (StringSupport.singleByteSwapcase(bytes, 0, end)) {
                    StringOperations.setRope(string, this.makeLeafRopeNode.executeMake(bytes, rope.getEncoding(), rope.getCodeRange(), rope.characterLength()));
                    return string;
                }
            } else if (StringSupport.multiByteSwapcase(enc, bytes, 0, end)) {
                StringOperations.setRope(string, this.makeLeafRopeNode.executeMake(bytes, rope.getEncoding(), rope.getCodeRange(), rope.characterLength()));
                return string;
            }
            return this.nil();
        }
    }

    @CoreMethod(names={"rstrip!"}, raiseIfFrozenSelf=true)
    @ImportStatic(value={StringGuards.class})
    public static abstract class RstripBangNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private RopeNodes.MakeSubstringNode makeSubstringNode = RopeNodesFactory.MakeSubstringNodeGen.create(null, null, null);

        @Specialization(guards={"isEmpty(string)"})
        public DynamicObject rstripBangEmptyString(DynamicObject string) {
            return this.nil();
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"!isEmpty(string)", "isSingleByteOptimizable(string)"})
        public Object rstripBangSingleByte(DynamicObject string) {
            int endp;
            Rope rope = StringOperations.rope(string);
            byte[] bytes = rope.getBytes();
            boolean start = false;
            int end = rope.byteLength();
            for (endp = end - 1; endp >= 0 && (bytes[endp] == 0 || ASCIIEncoding.INSTANCE.isSpace(bytes[endp] & 0xFF)); --endp) {
            }
            if (endp < end - 1) {
                StringOperations.setRope(string, this.makeSubstringNode.executeMake(rope, 0, endp - 0 + 1));
                return string;
            }
            return this.nil();
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"!isEmpty(string)", "!isSingleByteOptimizable(string)"})
        public Object rstripBang(DynamicObject string, @Cached(value="create()") RopeNodes.GetCodePointNode getCodePointNode) {
            int point;
            int prev;
            int end;
            Rope rope = StringOperations.rope(string);
            Encoding enc = RopeOperations.STR_ENC_GET(rope);
            byte[] bytes = rope.getBytes();
            boolean start = false;
            int endp = end = rope.byteLength();
            while ((prev = this.prevCharHead(enc, bytes, 0, endp, end)) != -1 && ((point = getCodePointNode.executeGetCodePoint(rope, prev)) == 0 || ASCIIEncoding.INSTANCE.isSpace(point))) {
                endp = prev;
            }
            if (endp < end) {
                StringOperations.setRope(string, this.makeSubstringNode.executeMake(rope, 0, endp - 0));
                return string;
            }
            return this.nil();
        }

        @CompilerDirectives.TruffleBoundary
        private int prevCharHead(Encoding enc, byte[] bytes, int p, int s, int end) {
            return enc.prevCharHead(bytes, p, s, end);
        }
    }

    @CoreMethod(names={"replace"}, required=1, raiseIfFrozenSelf=true, taintFrom=1)
    @NodeChildren(value={@NodeChild(type=RubyNode.class, value="string"), @NodeChild(type=RubyNode.class, value="other")})
    public static abstract class ReplaceNode
    extends CoreMethodNode {
        @CreateCast(value={"other"})
        public RubyNode coerceOtherToString(RubyNode other) {
            return ToStrNodeGen.create(other);
        }

        @Specialization(guards={"string == other"})
        public DynamicObject replaceStringIsSameAsOther(DynamicObject string, DynamicObject other) {
            return string;
        }

        @Specialization(guards={"string != other", "isRubyString(other)"})
        public DynamicObject replace(DynamicObject string, DynamicObject other, @Cached(value="createBinaryProfile()") ConditionProfile ropeBufferProfile) {
            Rope rope = StringOperations.rope(other);
            if (ropeBufferProfile.profile(rope instanceof RopeBuffer)) {
                StringOperations.setRope(string, ((RopeBuffer)rope).dup());
            } else {
                StringOperations.setRope(string, rope);
            }
            return string;
        }
    }

    @CoreMethod(names={"ord"})
    @ImportStatic(value={StringGuards.class})
    public static abstract class OrdNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization(guards={"isEmpty(string)"})
        public int ordEmpty(DynamicObject string) {
            throw new RaiseException(this.coreExceptions().argumentError("empty string", (Node)this));
        }

        @Specialization(guards={"!isEmpty(string)"})
        public int ord(DynamicObject string, @Cached(value="create()") RopeNodes.GetCodePointNode getCodePointNode) {
            return getCodePointNode.executeGetCodePoint(StringOperations.rope(string), 0);
        }
    }

    @CoreMethod(names={"lstrip!"}, raiseIfFrozenSelf=true)
    @ImportStatic(value={StringGuards.class})
    public static abstract class LstripBangNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private RopeNodes.MakeSubstringNode makeSubstringNode = RopeNodesFactory.MakeSubstringNodeGen.create(null, null, null);

        @Specialization(guards={"isEmpty(string)"})
        public DynamicObject lstripBangEmptyString(DynamicObject string) {
            return this.nil();
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"!isEmpty(string)", "isSingleByteOptimizable(string)"})
        public Object lstripBangSingleByte(DynamicObject string) {
            int p;
            Rope rope = StringOperations.rope(string);
            boolean s = false;
            int end = 0 + rope.byteLength();
            byte[] bytes = rope.getBytes();
            for (p = 0; p < end && ASCIIEncoding.INSTANCE.isSpace(bytes[p] & 0xFF); ++p) {
            }
            if (p > 0) {
                StringOperations.setRope(string, this.makeSubstringNode.executeMake(rope, p - 0, end - p));
                return string;
            }
            return this.nil();
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"!isEmpty(string)", "!isSingleByteOptimizable(string)"})
        public Object lstripBang(DynamicObject string, @Cached(value="create()") RopeNodes.GetCodePointNode getCodePointNode) {
            int p;
            int c;
            Rope rope = StringOperations.rope(string);
            Encoding enc = RopeOperations.STR_ENC_GET(rope);
            boolean s = false;
            int end = 0 + rope.byteLength();
            for (p = 0; p < end && ASCIIEncoding.INSTANCE.isSpace(c = getCodePointNode.executeGetCodePoint(rope, p)); p += StringSupport.codeLength(enc, c)) {
            }
            if (p > 0) {
                StringOperations.setRope(string, this.makeSubstringNode.executeMake(rope, p - 0, end - p));
                return string;
            }
            return this.nil();
        }
    }

    @CoreMethod(names={"initialize_copy"}, required=1)
    public static abstract class InitializeCopyNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization(guards={"self == from"})
        public Object initializeCopySelfIsSameAsFrom(DynamicObject self, DynamicObject from) {
            return self;
        }

        @Specialization(guards={"self != from", "isRubyString(from)"})
        public Object initializeCopy(DynamicObject self, DynamicObject from, @Cached(value="createBinaryProfile()") ConditionProfile ropeBufferProfile) {
            Rope rope = StringOperations.rope(from);
            if (ropeBufferProfile.profile(rope instanceof RopeBuffer)) {
                StringOperations.setRope(self, ((RopeBuffer)rope).dup());
            } else {
                StringOperations.setRope(self, rope);
            }
            return self;
        }
    }

    @Primitive(name="string_initialize")
    public static abstract class InitializeNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private ToStrNode toStrNode;

        @Specialization
        public DynamicObject initializeJavaString(DynamicObject self, String from) {
            StringOperations.setRope(self, StringOperations.encodeRope(from, ASCIIEncoding.INSTANCE));
            return self;
        }

        @Specialization(guards={"isRubyString(from)"})
        public DynamicObject initialize(DynamicObject self, DynamicObject from) {
            StringOperations.setRope(self, StringOperations.rope(from));
            return self;
        }

        @Specialization(guards={"!isRubyString(from)", "!isString(from)"})
        public DynamicObject initialize(VirtualFrame frame, DynamicObject self, Object from) {
            if (this.toStrNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.toStrNode = this.insert(ToStrNodeGen.create(null));
            }
            return this.initialize(self, this.toStrNode.executeToStr(frame, from));
        }
    }

    @CoreMethod(names={"hash"})
    public static abstract class HashNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        public int hash(DynamicObject string) {
            return StringOperations.rope(string).hashCode();
        }
    }

    @CoreMethod(names={"getbyte"}, required=1, lowerFixnum={1})
    public static abstract class GetByteNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private NormalizeIndexNode normalizeIndexNode = StringNodesFactory.NormalizeIndexNodeGen.create(null, null);
        @Node.Child
        private RopeNodes.GetByteNode ropeGetByteNode = RopeNodesFactory.GetByteNodeGen.create(null, null);

        @Specialization
        public Object getByte(DynamicObject string, int index, @Cached(value="createBinaryProfile()") ConditionProfile negativeIndexProfile, @Cached(value="createBinaryProfile()") ConditionProfile indexOutOfBoundsProfile) {
            Rope rope = StringOperations.rope(string);
            int normalizedIndex = this.normalizeIndexNode.executeNormalize(index, rope.byteLength());
            if (indexOutOfBoundsProfile.profile(normalizedIndex < 0 || normalizedIndex >= rope.byteLength())) {
                return this.nil();
            }
            return this.ropeGetByteNode.executeGetByte(rope, normalizedIndex);
        }
    }

    @CoreMethod(names={"force_encoding"}, required=1, raiseIfFrozenSelf=true)
    public static abstract class ForceEncodingNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private RopeNodes.WithEncodingNode withEncodingNode = RopeNodesFactory.WithEncodingNodeGen.create(null, null, null);
        @Node.Child
        private ToStrNode toStrNode;

        @Specialization(guards={"isRubyString(encodingName)"})
        public DynamicObject forceEncodingString(DynamicObject string, DynamicObject encodingName, @Cached(value="createBinaryProfile()") ConditionProfile differentEncodingProfile, @Cached(value="createBinaryProfile()") ConditionProfile mutableRopeProfile) {
            DynamicObject encoding = this.getContext().getEncodingManager().getRubyEncoding(StringOperations.decodeUTF8(encodingName));
            return this.forceEncodingEncoding(string, encoding, differentEncodingProfile, mutableRopeProfile);
        }

        @Specialization(guards={"isRubyEncoding(rubyEncoding)"})
        public DynamicObject forceEncodingEncoding(DynamicObject string, DynamicObject rubyEncoding, @Cached(value="createBinaryProfile()") ConditionProfile differentEncodingProfile, @Cached(value="createBinaryProfile()") ConditionProfile mutableRopeProfile) {
            Encoding encoding = EncodingOperations.getEncoding(rubyEncoding);
            Rope rope = StringOperations.rope(string);
            if (differentEncodingProfile.profile(rope.getEncoding() != encoding)) {
                if (mutableRopeProfile.profile(rope instanceof RopeBuffer)) {
                    ((RopeBuffer)rope).getByteList().setEncoding(encoding);
                } else {
                    Rope newRope = this.withEncodingNode.executeWithEncoding(rope, encoding, CodeRange.CR_UNKNOWN);
                    StringOperations.setRope(string, newRope);
                }
            }
            return string;
        }

        @Specialization(guards={"!isRubyString(encoding)", "!isRubyEncoding(encoding)"})
        public DynamicObject forceEncoding(VirtualFrame frame, DynamicObject string, Object encoding, @Cached(value="createBinaryProfile()") ConditionProfile differentEncodingProfile, @Cached(value="createBinaryProfile()") ConditionProfile mutableRopeProfile) {
            if (this.toStrNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.toStrNode = this.insert(ToStrNodeGen.create(null));
            }
            return this.forceEncodingString(string, this.toStrNode.executeToStr(frame, encoding), differentEncodingProfile, mutableRopeProfile);
        }
    }

    @CoreMethod(names={"each_char"}, needsBlock=true, enumeratorSize="size")
    @ImportStatic(value={StringGuards.class})
    public static abstract class EachCharNode
    extends YieldingCoreMethodNode {
        @Node.Child
        private AllocateObjectNode allocateObjectNode = AllocateObjectNode.create();
        @Node.Child
        private RopeNodes.MakeSubstringNode makeSubstringNode = RopeNodesFactory.MakeSubstringNodeGen.create(null, null, null);
        @Node.Child
        private TaintResultNode taintResultNode;

        @Specialization(guards={"!isBrokenCodeRange(string)"})
        public DynamicObject eachChar(VirtualFrame frame, DynamicObject string, DynamicObject block) {
            int n;
            Rope rope = StringOperations.rope(string);
            byte[] ptrBytes = rope.getBytes();
            int len = ptrBytes.length;
            Encoding enc = rope.getEncoding();
            for (int i = 0; i < len; i += n) {
                n = StringSupport.encFastMBCLen(ptrBytes, i, len, enc);
                this.yield(frame, block, this.substr(rope, string, i, n));
            }
            return string;
        }

        @Specialization(guards={"isBrokenCodeRange(string)"})
        public DynamicObject eachCharMultiByteEncoding(VirtualFrame frame, DynamicObject string, DynamicObject block) {
            int n;
            Rope rope = StringOperations.rope(string);
            byte[] ptrBytes = rope.getBytes();
            int len = ptrBytes.length;
            Encoding enc = rope.getEncoding();
            for (int i = 0; i < len; i += n) {
                n = this.multiByteStringLength(enc, ptrBytes, i, len);
                this.yield(frame, block, this.substr(rope, string, i, n));
            }
            return string;
        }

        @CompilerDirectives.TruffleBoundary
        private int multiByteStringLength(Encoding enc, byte[] bytes, int p, int end) {
            return StringSupport.length(enc, bytes, p, end);
        }

        private Object substr(Rope rope, DynamicObject string, int beg, int len) {
            int length = rope.byteLength();
            if (len < 0 || beg > length) {
                return this.nil();
            }
            if (beg < 0 && (beg += length) < 0) {
                return this.nil();
            }
            int end = Math.min(length, beg + len);
            Rope substringRope = this.makeSubstringNode.executeMake(rope, beg, end - beg);
            if (this.taintResultNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.taintResultNode = this.insert(new TaintResultNode());
            }
            DynamicObject ret = this.allocateObjectNode.allocate(Layouts.BASIC_OBJECT.getLogicalClass(string), substringRope);
            return this.taintResultNode.maybeTaint(string, ret);
        }
    }

    @CoreMethod(names={"each_byte"}, needsBlock=true, enumeratorSize="bytesize")
    public static abstract class EachByteNode
    extends YieldingCoreMethodNode {
        @Specialization
        public DynamicObject eachByte(VirtualFrame frame, DynamicObject string, DynamicObject block, @Cached(value="createBinaryProfile()") ConditionProfile ropeChangedProfile) {
            Rope rope = StringOperations.rope(string);
            byte[] bytes = rope.getBytes();
            for (int i = 0; i < bytes.length; ++i) {
                this.yield(frame, block, bytes[i] & 0xFF);
                Rope updatedRope = StringOperations.rope(string);
                if (!ropeChangedProfile.profile(rope != updatedRope)) continue;
                rope = updatedRope;
                bytes = updatedRope.getBytes();
            }
            return string;
        }
    }

    @CoreMethod(names={"downcase!"}, raiseIfFrozenSelf=true)
    @ImportStatic(value={StringGuards.class})
    public static abstract class DowncaseBangNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private RopeNodes.MakeLeafRopeNode makeLeafRopeNode = RopeNodesFactory.MakeLeafRopeNodeGen.create(null, null, null, null);

        @Specialization(guards={"isEmpty(string)", "isSingleByteOptimizable(string)"})
        public DynamicObject downcaseSingleByteEmpty(DynamicObject string) {
            return this.nil();
        }

        @Specialization(guards={"!isEmpty(string)", "isSingleByteOptimizable(string)"})
        public DynamicObject downcaseSingleByte(DynamicObject string, @Cached(value="createBinaryProfile()") ConditionProfile modifiedProfile) {
            Rope rope = StringOperations.rope(string);
            byte[] outputBytes = rope.getBytesCopy();
            boolean modified = this.singleByteDowncase(outputBytes, 0, outputBytes.length);
            if (modifiedProfile.profile(modified)) {
                StringOperations.setRope(string, this.makeLeafRopeNode.executeMake(outputBytes, rope.getEncoding(), rope.getCodeRange(), rope.characterLength()));
                return string;
            }
            return this.nil();
        }

        @Specialization(guards={"!isSingleByteOptimizable(string)"})
        public DynamicObject downcase(DynamicObject string, @Cached(value="createBinaryProfile()") ConditionProfile emptyStringProfile, @Cached(value="createBinaryProfile()") ConditionProfile modifiedProfile) {
            Rope rope = StringOperations.rope(string);
            Encoding encoding = rope.getEncoding();
            if (encoding.isDummy()) {
                throw new RaiseException(this.coreExceptions().encodingCompatibilityErrorIncompatibleWithOperation(encoding, this));
            }
            if (emptyStringProfile.profile(rope.isEmpty())) {
                return this.nil();
            }
            byte[] outputBytes = rope.getBytesCopy();
            boolean modified = this.multiByteDowncase(encoding, outputBytes, 0, outputBytes.length);
            if (modifiedProfile.profile(modified)) {
                StringOperations.setRope(string, this.makeLeafRopeNode.executeMake(outputBytes, rope.getEncoding(), rope.getCodeRange(), rope.characterLength()));
                return string;
            }
            return this.nil();
        }

        @CompilerDirectives.TruffleBoundary
        private boolean singleByteDowncase(byte[] bytes, int s, int end) {
            return StringSupport.singleByteDowncase(bytes, s, end);
        }

        @CompilerDirectives.TruffleBoundary
        private boolean multiByteDowncase(Encoding encoding, byte[] bytes, int s, int end) {
            return StringSupport.multiByteDowncase(encoding, bytes, s, end);
        }
    }

    @CoreMethod(names={"delete!"}, rest=true, raiseIfFrozenSelf=true)
    @ImportStatic(value={StringGuards.class})
    public static abstract class DeleteBangNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private EncodingNodes.CheckEncodingNode checkEncodingNode = EncodingNodesFactory.CheckEncodingNodeGen.create(null, null);
        @Node.Child
        private ToStrNode toStr = ToStrNodeGen.create(null);

        public abstract DynamicObject executeDeleteBang(VirtualFrame var1, DynamicObject var2, Object[] var3);

        @Specialization(guards={"isEmpty(string)"})
        public DynamicObject deleteBangEmpty(DynamicObject string, Object[] args) {
            return this.nil();
        }

        @Specialization(guards={"!isEmpty(string)"})
        public Object deleteBang(VirtualFrame frame, DynamicObject string, Object[] args, @Cached(value="create()") BranchProfile errorProfile) {
            if (args.length == 0) {
                errorProfile.enter();
                throw new RaiseException(this.coreExceptions().argumentErrorEmptyVarargs(this));
            }
            DynamicObject[] otherStrings = new DynamicObject[args.length];
            for (int i = 0; i < args.length; ++i) {
                otherStrings[i] = this.toStr.executeToStr(frame, args[i]);
            }
            return this.deleteBangSlow(string, otherStrings);
        }

        @CompilerDirectives.TruffleBoundary
        private Object deleteBangSlow(DynamicObject string, DynamicObject[] otherStrings) {
            assert (RubyGuards.isRubyString(string));
            DynamicObject otherString = otherStrings[0];
            Encoding enc = this.checkEncodingNode.executeCheckEncoding(string, otherString);
            boolean[] squeeze = new boolean[257];
            StringSupport.TrTables tables = StringSupport.trSetupTable(StringOperations.rope(otherString), squeeze, null, true, enc);
            for (int i = 1; i < otherStrings.length; ++i) {
                assert (RubyGuards.isRubyString(otherStrings[i]));
                enc = this.checkEncodingNode.executeCheckEncoding(string, otherStrings[i]);
                tables = StringSupport.trSetupTable(StringOperations.rope(otherStrings[i]), squeeze, tables, false, enc);
            }
            Rope processedRope = StringSupport.delete_bangCommon19(StringOperations.rope(string), squeeze, tables, enc);
            if (processedRope == null) {
                return this.nil();
            }
            StringOperations.setRope(string, processedRope);
            return string;
        }
    }

    @CoreMethod(names={"crypt"}, required=1)
    @NodeChildren(value={@NodeChild(type=RubyNode.class, value="string"), @NodeChild(type=RubyNode.class, value="salt")})
    public static abstract class CryptNode
    extends CoreMethodNode {
        @Node.Child
        private TaintResultNode taintResultNode;

        @CreateCast(value={"salt"})
        public RubyNode coerceSaltToString(RubyNode other) {
            return ToStrNodeGen.create(other);
        }

        @CompilerDirectives.TruffleBoundary(throwsControlFlowException=true)
        @Specialization(guards={"isRubyString(salt)"})
        public Object crypt(DynamicObject string, DynamicObject salt) {
            Rope value = StringOperations.rope(string);
            Rope other = StringOperations.rope(salt);
            if (other.byteLength() < 2) {
                throw new RaiseException(this.coreExceptions().argumentError("salt too short (need >= 2 bytes)", (Node)this));
            }
            TrufflePosix posix = this.posix();
            byte[] keyBytes = Arrays.copyOfRange(value.getBytes(), 0, value.byteLength());
            byte[] saltBytes = Arrays.copyOfRange(other.getBytes(), 0, other.byteLength());
            if (saltBytes[0] == 0 || saltBytes[1] == 0) {
                throw new RaiseException(this.coreExceptions().argumentError("salt too short (need >= 2 bytes)", (Node)this));
            }
            byte[] cryptedString = posix.crypt(keyBytes, saltBytes);
            if (cryptedString == null) {
                throw new RaiseException(this.coreExceptions().errnoError(posix.errno(), this));
            }
            if (this.taintResultNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.taintResultNode = this.insert(new TaintResultNode());
            }
            DynamicObject ret = this.createString(RopeOperations.ropeFromByteList(new ByteList(cryptedString, 0, cryptedString.length - 1, ASCIIEncoding.INSTANCE, false)));
            this.taintResultNode.maybeTaint(string, ret);
            this.taintResultNode.maybeTaint(salt, ret);
            return ret;
        }
    }

    @CoreMethod(names={"count"}, rest=true)
    @ImportStatic(value={StringGuards.class})
    public static abstract class CountNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private EncodingNodes.CheckEncodingNode checkEncodingNode = EncodingNodesFactory.CheckEncodingNodeGen.create(null, null);
        @Node.Child
        private ToStrNode toStr = ToStrNodeGen.create(null);

        @Specialization(guards={"isEmpty(string)"})
        public int count(DynamicObject string, Object[] args) {
            return 0;
        }

        @Specialization(guards={"!isEmpty(string)"})
        public int count(VirtualFrame frame, DynamicObject string, Object[] args, @Cached(value="create()") BranchProfile errorProfile) {
            if (args.length == 0) {
                errorProfile.enter();
                throw new RaiseException(this.coreExceptions().argumentErrorEmptyVarargs(this));
            }
            DynamicObject[] otherStrings = new DynamicObject[args.length];
            for (int i = 0; i < args.length; ++i) {
                otherStrings[i] = this.toStr.executeToStr(frame, args[i]);
            }
            return this.countSlow(string, otherStrings);
        }

        @CompilerDirectives.TruffleBoundary
        private int countSlow(DynamicObject string, DynamicObject ... otherStrings) {
            assert (RubyGuards.isRubyString(string));
            DynamicObject otherStr = otherStrings[0];
            Encoding enc = this.checkEncodingNode.executeCheckEncoding(string, otherStr);
            boolean[] table = new boolean[257];
            StringSupport.TrTables tables = StringSupport.trSetupTable(StringOperations.rope(otherStr), table, null, true, enc);
            for (int i = 1; i < otherStrings.length; ++i) {
                otherStr = otherStrings[i];
                assert (RubyGuards.isRubyString(otherStr));
                enc = this.checkEncodingNode.executeCheckEncoding(string, otherStr);
                tables = StringSupport.trSetupTable(StringOperations.rope(otherStr), table, tables, false, enc);
            }
            return StringSupport.strCount(StringOperations.rope(string), table, tables, enc);
        }
    }

    @CoreMethod(names={"casecmp"}, required=1)
    @NodeChildren(value={@NodeChild(type=RubyNode.class, value="string"), @NodeChild(type=RubyNode.class, value="other")})
    public static abstract class CaseCmpNode
    extends CoreMethodNode {
        @Node.Child
        private EncodingNodes.NegotiateCompatibleEncodingNode negotiateCompatibleEncodingNode = EncodingNodesFactory.NegotiateCompatibleEncodingNodeGen.create(null, null);

        @CreateCast(value={"other"})
        public RubyNode coerceOtherToString(RubyNode other) {
            return ToStrNodeGen.create(other);
        }

        @Specialization(guards={"isRubyString(other)", "bothSingleByteOptimizable(string, other)"})
        @CompilerDirectives.TruffleBoundary
        public Object caseCmpSingleByte(DynamicObject string, DynamicObject other) {
            if (this.negotiateCompatibleEncodingNode.executeNegotiate(string, other) == null) {
                return this.nil();
            }
            return RopeOperations.caseInsensitiveCmp(StringOperations.rope(string), StringOperations.rope(other));
        }

        @Specialization(guards={"isRubyString(other)", "!bothSingleByteOptimizable(string, other)"})
        @CompilerDirectives.TruffleBoundary
        public Object caseCmp(DynamicObject string, DynamicObject other) {
            Encoding encoding = this.negotiateCompatibleEncodingNode.executeNegotiate(string, other);
            if (encoding == null) {
                return this.nil();
            }
            return StringSupport.multiByteCasecmp(encoding, StringOperations.rope(string), StringOperations.rope(other));
        }

        public static boolean bothSingleByteOptimizable(DynamicObject string, DynamicObject other) {
            assert (RubyGuards.isRubyString(string));
            assert (RubyGuards.isRubyString(other));
            return StringOperations.rope(string).isSingleByteOptimizable() && StringOperations.rope(other).isSingleByteOptimizable();
        }
    }

    @CoreMethod(names={"bytesize"})
    public static abstract class ByteSizeNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        public int byteSize(DynamicObject string, @Cached(value="createBinaryProfile()") ConditionProfile ropeBufferProfile) {
            Rope rope = StringOperations.rope(string);
            if (ropeBufferProfile.profile(rope instanceof RopeBuffer)) {
                return ((RopeBuffer)rope).getByteList().realSize();
            }
            return StringOperations.rope(string).byteLength();
        }
    }

    @CoreMethod(names={"bytes"}, needsBlock=true)
    public static abstract class BytesNode
    extends YieldingCoreMethodNode {
        @Specialization
        public DynamicObject bytes(VirtualFrame frame, DynamicObject string, NotProvided block) {
            Rope rope = StringOperations.rope(string);
            byte[] bytes = rope.getBytes();
            int[] store = new int[bytes.length];
            for (int n = 0; n < store.length; ++n) {
                store[n] = bytes[n] & 0xFF;
            }
            return this.createArray(store, store.length);
        }

        @Specialization
        public DynamicObject bytes(VirtualFrame frame, DynamicObject string, DynamicObject block) {
            Rope rope = StringOperations.rope(string);
            byte[] bytes = rope.getBytes();
            for (int i = 0; i < bytes.length; ++i) {
                this.yield(frame, block, bytes[i] & 0xFF);
            }
            return string;
        }
    }

    @CoreMethod(names={"b"}, taintFrom=0)
    public static abstract class BNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private RopeNodes.WithEncodingNode withEncodingNode = RopeNodesFactory.WithEncodingNodeGen.create(null, null, null);

        @Specialization
        public DynamicObject b(DynamicObject string) {
            Rope rope = StringOperations.rope(string);
            CodeRange newCodeRange = rope.getCodeRange() == CodeRange.CR_7BIT ? CodeRange.CR_7BIT : CodeRange.CR_VALID;
            Rope newRope = this.withEncodingNode.executeWithEncoding(rope, ASCIIEncoding.INSTANCE, newCodeRange);
            return this.createString(newRope);
        }
    }

    @CoreMethod(names={"ascii_only?"})
    @ImportStatic(value={StringGuards.class})
    public static abstract class ASCIIOnlyNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization(guards={"is7Bit(string)"})
        public boolean asciiOnlyAsciiCompatible7BitCR(DynamicObject string) {
            return true;
        }

        @Specialization(guards={"!is7Bit(string)"})
        public boolean asciiOnlyAsciiCompatible(DynamicObject string) {
            return false;
        }
    }

    @CoreMethod(names={"[]", "slice"}, required=1, optional=1, lowerFixnum={1, 2}, taintFrom=0)
    public static abstract class GetIndexNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private AllocateObjectNode allocateObjectNode = AllocateObjectNode.create();
        @Node.Child
        private CallDispatchHeadNode includeNode;
        @Node.Child
        private CallDispatchHeadNode dupNode;
        @Node.Child
        private NormalizeIndexNode normalizeIndexNode;
        @Node.Child
        private StringSubstringPrimitiveNode substringNode;
        private final BranchProfile outOfBounds = BranchProfile.create();

        @Specialization
        public Object getIndex(VirtualFrame frame, DynamicObject string, int index, NotProvided length) {
            if (index == StringOperations.rope(string).characterLength()) {
                this.outOfBounds.enter();
                return this.nil();
            }
            return this.getSubstringNode().execute(frame, string, index, 1);
        }

        @Specialization(guards={"!isRubyRange(index)", "!isRubyRegexp(index)", "!isRubyString(index)"})
        public Object getIndex(VirtualFrame frame, DynamicObject string, Object index, NotProvided length, @Cached(value="new()") SnippetNode snippetNode) {
            return this.getIndex(frame, string, (Integer)snippetNode.execute(frame, "Rubinius::Type.rb_num2int(v)", "v", index), length);
        }

        @Specialization(guards={"isIntRange(range)"})
        public Object sliceIntegerRange(VirtualFrame frame, DynamicObject string, DynamicObject range, NotProvided length) {
            return this.sliceRange(frame, string, Layouts.INT_RANGE.getBegin(range), Layouts.INT_RANGE.getEnd(range), Layouts.INT_RANGE.getExcludedEnd(range));
        }

        @Specialization(guards={"isLongRange(range)"})
        public Object sliceLongRange(VirtualFrame frame, DynamicObject string, DynamicObject range, NotProvided length) {
            return this.sliceRange(frame, string, (int)Layouts.LONG_RANGE.getBegin(range), (int)Layouts.LONG_RANGE.getEnd(range), Layouts.LONG_RANGE.getExcludedEnd(range));
        }

        @Specialization(guards={"isObjectRange(range)"})
        public Object sliceObjectRange(VirtualFrame frame, DynamicObject string, DynamicObject range, NotProvided length, @Cached(value="new()") SnippetNode snippetNode1, @Cached(value="new()") SnippetNode snippetNode2) {
            int coercedBegin = (Integer)snippetNode1.execute(frame, "Rubinius::Type.rb_num2int(v)", "v", Layouts.OBJECT_RANGE.getBegin(range));
            int coercedEnd = (Integer)snippetNode2.execute(frame, "Rubinius::Type.rb_num2int(v)", "v", Layouts.OBJECT_RANGE.getEnd(range));
            return this.sliceRange(frame, string, coercedBegin, coercedEnd, Layouts.OBJECT_RANGE.getExcludedEnd(range));
        }

        private Object sliceRange(VirtualFrame frame, DynamicObject string, int begin, int end, boolean doesExcludeEnd) {
            int stringLength;
            assert (RubyGuards.isRubyString(string));
            if (this.normalizeIndexNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.normalizeIndexNode = this.insert(StringNodesFactory.NormalizeIndexNodeGen.create(null, null));
            }
            if ((begin = this.normalizeIndexNode.executeNormalize(begin, stringLength = StringOperations.rope(string).characterLength())) < 0 || begin > stringLength) {
                this.outOfBounds.enter();
                return this.nil();
            }
            if (begin == stringLength) {
                ByteList byteList = new ByteList();
                byteList.setEncoding(StringOperations.encoding(string));
                return this.allocateObjectNode.allocate(Layouts.BASIC_OBJECT.getLogicalClass(string), RopeOperations.withEncodingVerySlow(RopeConstants.EMPTY_ASCII_8BIT_ROPE, StringOperations.encoding(string)));
            }
            end = this.normalizeIndexNode.executeNormalize(end, stringLength);
            int length = StringOperations.clampExclusiveIndex(string, doesExcludeEnd ? end : end + 1);
            if (length > stringLength) {
                length = stringLength;
            }
            if ((length -= begin) < 0) {
                length = 0;
            }
            return this.getSubstringNode().execute(frame, string, begin, length);
        }

        @Specialization
        public Object slice(VirtualFrame frame, DynamicObject string, int start, int length) {
            return this.getSubstringNode().execute(frame, string, start, length);
        }

        @Specialization(guards={"wasProvided(length)"})
        public Object slice(VirtualFrame frame, DynamicObject string, int start, Object length, @Cached(value="new()") SnippetNode snippetNode) {
            return this.slice(frame, string, start, (Integer)snippetNode.execute(frame, "Rubinius::Type.rb_num2int(v)", "v", length));
        }

        @Specialization(guards={"!isRubyRange(start)", "!isRubyRegexp(start)", "!isRubyString(start)", "wasProvided(length)"})
        public Object slice(VirtualFrame frame, DynamicObject string, Object start, Object length, @Cached(value="new()") SnippetNode snippetNode1, @Cached(value="new()") SnippetNode snippetNode2) {
            return this.slice(frame, string, (Integer)snippetNode1.execute(frame, "Rubinius::Type.rb_num2int(v)", "v", start), (Integer)snippetNode2.execute(frame, "Rubinius::Type.rb_num2int(v)", "v", length));
        }

        @Specialization(guards={"isRubyRegexp(regexp)"})
        public Object slice1(VirtualFrame frame, DynamicObject string, DynamicObject regexp, NotProvided capture, @Cached(value="createMethodCallIgnoreVisibility()") CallDispatchHeadNode callNode, @Cached(value="create()") RegexpNodes.RegexpSetLastMatchPrimitiveNode setLastMatchNode) {
            return this.sliceCapture(frame, string, regexp, 0, callNode, setLastMatchNode);
        }

        @Specialization(guards={"isRubyRegexp(regexp)", "wasProvided(capture)"})
        public Object sliceCapture(VirtualFrame frame, DynamicObject string, DynamicObject regexp, Object capture, @Cached(value="createMethodCallIgnoreVisibility()") CallDispatchHeadNode callNode, @Cached(value="create()") RegexpNodes.RegexpSetLastMatchPrimitiveNode setLastMatchNode) {
            Object matchStrPair = callNode.call(frame, string, "subpattern", regexp, capture);
            if (matchStrPair == this.nil()) {
                setLastMatchNode.executeSetLastMatch(this.nil());
                return this.nil();
            }
            Object[] array = (Object[])Layouts.ARRAY.getStore((DynamicObject)matchStrPair);
            setLastMatchNode.executeSetLastMatch(array[0]);
            return array[1];
        }

        @Specialization(guards={"isRubyString(matchStr)"})
        public Object slice2(VirtualFrame frame, DynamicObject string, DynamicObject matchStr, NotProvided length) {
            boolean result;
            if (this.includeNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.includeNode = this.insert(DispatchHeadNodeFactory.createMethodCall());
            }
            if (result = this.includeNode.callBoolean(frame, string, "include?", null, matchStr)) {
                if (this.dupNode == null) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.dupNode = this.insert(DispatchHeadNodeFactory.createMethodCall());
                }
                throw new TaintResultNode.DoNotTaint(this.dupNode.call(frame, matchStr, "dup", new Object[0]));
            }
            return this.nil();
        }

        private StringSubstringPrimitiveNode getSubstringNode() {
            if (this.substringNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.substringNode = this.insert(StringNodesFactory.StringSubstringPrimitiveNodeFactory.create(null));
            }
            return this.substringNode;
        }
    }

    @CoreMethod(names={"<<", "concat"}, required=1, taintFrom=1, raiseIfFrozenSelf=true)
    @ImportStatic(value={StringGuards.class})
    @NodeChildren(value={@NodeChild(type=RubyNode.class, value="string"), @NodeChild(type=RubyNode.class, value="other")})
    public static abstract class ConcatNode
    extends CoreMethodNode {
        @Specialization(guards={"isRubyString(other)"})
        public DynamicObject concat(DynamicObject string, DynamicObject other, @Cached(value="create()") StringAppendPrimitiveNode stringAppendNode) {
            return stringAppendNode.executeStringAppend(string, other);
        }

        @Specialization(guards={"!isRubyString(other)"})
        public Object concatGeneric(VirtualFrame frame, DynamicObject string, Object other, @Cached(value="createMethodCall()") CallDispatchHeadNode callNode) {
            return callNode.call(frame, string, "concat_internal", other);
        }
    }

    @CoreMethod(names={"<=>"}, required=1)
    public static abstract class CompareNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private CallDispatchHeadNode cmpNode;
        @Node.Child
        private CmpIntNode cmpIntNode;
        @Node.Child
        private KernelNodes.RespondToNode respondToCmpNode;
        @Node.Child
        private KernelNodes.RespondToNode respondToToStrNode;
        @Node.Child
        private ToStrNode toStrNode;

        @Specialization(guards={"isRubyString(b)"})
        public int compare(DynamicObject a, DynamicObject b) {
            Rope secondRope;
            Rope firstRope = StringOperations.rope(a);
            int ret = RopeOperations.cmp(firstRope, secondRope = StringOperations.rope(b));
            if (ret == 0 && !RopeOperations.areComparable(firstRope, secondRope)) {
                return firstRope.getEncoding().getIndex() > secondRope.getEncoding().getIndex() ? 1 : -1;
            }
            return ret;
        }

        @Specialization(guards={"!isRubyString(b)"})
        public Object compare(VirtualFrame frame, DynamicObject a, Object b) {
            if (this.respondToToStrNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.respondToToStrNode = this.insert(KernelNodesFactory.RespondToNodeFactory.create(null, null, null));
            }
            if (this.respondToToStrNode.doesRespondToString(frame, b, this.create7BitString("to_str", UTF8Encoding.INSTANCE), false)) {
                if (this.toStrNode == null) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.toStrNode = this.insert(ToStrNodeGen.create(null));
                }
                try {
                    DynamicObject coerced = this.toStrNode.executeToStr(frame, b);
                    return this.compare(a, coerced);
                }
                catch (RaiseException e) {
                    if (Layouts.BASIC_OBJECT.getLogicalClass(e.getException()) == this.coreLibrary().getTypeErrorClass()) {
                        return this.nil();
                    }
                    throw e;
                }
            }
            if (this.respondToCmpNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.respondToCmpNode = this.insert(KernelNodesFactory.RespondToNodeFactory.create(null, null, null));
            }
            if (this.respondToCmpNode.doesRespondToString(frame, b, this.create7BitString("<=>", UTF8Encoding.INSTANCE), false)) {
                Object cmpResult;
                if (this.cmpNode == null) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.cmpNode = this.insert(DispatchHeadNodeFactory.createMethodCall());
                }
                if ((cmpResult = this.cmpNode.call(frame, b, "<=>", a)) == this.nil()) {
                    return this.nil();
                }
                if (this.cmpIntNode == null) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.cmpIntNode = this.insert(CmpIntNodeGen.create(null, null, null));
                }
                return -this.cmpIntNode.executeCmpInt(frame, cmpResult, a, b);
            }
            return this.nil();
        }
    }

    @CoreMethod(names={"==", "===", "eql?"}, required=1)
    public static abstract class EqualNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private StringEqualNode stringEqualNode = StringNodesFactory.StringEqualNodeGen.create(null, null);
        @Node.Child
        private KernelNodes.RespondToNode respondToNode;
        @Node.Child
        private CallDispatchHeadNode objectEqualNode;
        @Node.Child
        private CheckLayoutNode checkLayoutNode;

        @Specialization(guards={"isRubyString(b)"})
        public boolean equal(DynamicObject a, DynamicObject b) {
            return this.stringEqualNode.executeStringEqual(a, b);
        }

        @Specialization(guards={"!isRubyString(b)"})
        public boolean equal(VirtualFrame frame, DynamicObject a, Object b) {
            if (this.respondToNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.respondToNode = this.insert(KernelNodesFactory.RespondToNodeFactory.create(null, null, null));
            }
            if (this.respondToNode.doesRespondToString(frame, b, this.create7BitString("to_str", UTF8Encoding.INSTANCE), false)) {
                if (this.objectEqualNode == null) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.objectEqualNode = this.insert(DispatchHeadNodeFactory.createMethodCall());
                }
                return this.objectEqualNode.callBoolean(frame, b, "==", null, a);
            }
            return false;
        }

        protected boolean isRubyString(DynamicObject object) {
            if (this.checkLayoutNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.checkLayoutNode = this.insert(new CheckLayoutNode());
            }
            return this.checkLayoutNode.isString(object);
        }
    }

    @CoreMethod(names={"*"}, required=1, lowerFixnum={1}, taintFrom=0)
    public static abstract class MulNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private AllocateObjectNode allocateObjectNode = AllocateObjectNode.create();
        @Node.Child
        private ToIntNode toIntNode;

        public abstract DynamicObject executeInt(VirtualFrame var1, DynamicObject var2, int var3);

        @Specialization(guards={"times < 0"})
        public DynamicObject multiplyTimesNegative(DynamicObject string, int times) {
            throw new RaiseException(this.coreExceptions().argumentError("negative argument", (Node)this));
        }

        @Specialization(guards={"times >= 0"})
        public DynamicObject multiply(DynamicObject string, int times, @Cached(value="create()") RopeNodes.MakeRepeatingNode makeRepeatingNode) {
            Rope repeated = makeRepeatingNode.executeMake(StringOperations.rope(string), times);
            return this.allocateObjectNode.allocate(Layouts.BASIC_OBJECT.getLogicalClass(string), repeated);
        }

        @Specialization(guards={"isRubyBignum(times)"})
        public DynamicObject multiply(DynamicObject string, DynamicObject times) {
            throw new RaiseException(this.coreExceptions().rangeError("bignum too big to convert into `long'", (Node)this));
        }

        @Specialization(guards={"!isRubyBignum(times)", "!isInteger(times)"})
        public DynamicObject multiply(VirtualFrame frame, DynamicObject string, Object times) {
            if (this.toIntNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.toIntNode = this.insert(ToIntNode.create());
            }
            return this.executeInt(frame, string, this.toIntNode.doInt(frame, times));
        }
    }

    @CoreMethod(names={"+"}, required=1)
    @ImportStatic(value={StringGuards.class})
    @NodeChildren(value={@NodeChild(type=RubyNode.class, value="string"), @NodeChild(type=RubyNode.class, value="other")})
    public static abstract class AddNode
    extends CoreMethodNode {
        @Node.Child
        private AllocateObjectNode allocateObjectNode = AllocateObjectNode.create();
        @Node.Child
        private TaintResultNode taintResultNode = new TaintResultNode();

        @CreateCast(value={"other"})
        public RubyNode coerceOtherToString(RubyNode other) {
            return ToStrNodeGen.create(other);
        }

        @Specialization(guards={"!isRopeBuffer(string)", "isRubyString(other)"})
        public DynamicObject add(DynamicObject string, DynamicObject other, @Cached(value="create()") StringAppendNode stringAppendNode) {
            Rope concatRope = stringAppendNode.executeStringAppend(string, other);
            DynamicObject ret = this.allocateObjectNode.allocate(this.coreLibrary().getStringClass(), concatRope);
            this.taintResultNode.maybeTaint(string, ret);
            this.taintResultNode.maybeTaint(other, ret);
            return ret;
        }

        @Specialization(guards={"isRopeBuffer(string)", "is7Bit(string)", "is7Bit(other)"})
        public DynamicObject addRopeBuffer(DynamicObject string, DynamicObject other, @Cached(value="createBinaryProfile()") ConditionProfile ropeBufferProfile, @Cached(value="create()") EncodingNodes.CheckEncodingNode checkEncodingNode) {
            ByteList concatByteList;
            Encoding enc = checkEncodingNode.executeCheckEncoding(string, other);
            RopeBuffer left = (RopeBuffer)StringOperations.rope(string);
            ByteList leftByteList = left.getByteList();
            Rope right = StringOperations.rope(other);
            if (ropeBufferProfile.profile(right instanceof RopeBuffer)) {
                concatByteList = StringSupport.addByteLists(leftByteList, ((RopeBuffer)right).getByteList());
            } else {
                int newLength = leftByteList.realSize() + right.byteLength();
                concatByteList = new ByteList(newLength);
                concatByteList.realSize(newLength);
                System.arraycopy(leftByteList.unsafeBytes(), leftByteList.begin(), concatByteList.unsafeBytes(), 0, leftByteList.realSize());
                System.arraycopy(right.getBytes(), 0, concatByteList.unsafeBytes(), leftByteList.realSize(), right.byteLength());
            }
            concatByteList.setEncoding(enc);
            RopeBuffer concatRope = new RopeBuffer(concatByteList, left.getCodeRange(), left.isSingleByteOptimizable(), concatByteList.realSize());
            DynamicObject ret = Layouts.STRING.createString(this.coreLibrary().getStringFactory(), concatRope);
            this.taintResultNode.maybeTaint(string, ret);
            this.taintResultNode.maybeTaint(other, ret);
            return ret;
        }
    }

    @CoreMethod(names={"allocate"}, constructor=true)
    public static abstract class AllocateNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private AllocateObjectNode allocateObjectNode = AllocateObjectNode.create();

        @Specialization
        public DynamicObject allocate(DynamicObject rubyClass) {
            return this.allocateObjectNode.allocate(rubyClass, RopeConstants.EMPTY_ASCII_8BIT_ROPE);
        }
    }
}

