/*
 * Decompiled with CFR 0.152.
 */
package org.libreoffice.report.pentaho.parser.rpt;

import org.jfree.report.expressions.Expression;
import org.jfree.report.expressions.FormulaExpression;
import org.jfree.report.expressions.FormulaFunction;
import org.pentaho.reporting.libraries.xmlns.parser.AbstractXmlReadHandler;
import org.pentaho.reporting.libraries.xmlns.parser.ParseException;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class FunctionReadHandler
extends AbstractXmlReadHandler {
    private Expression expression;

    protected void startParsing(Attributes attrs) throws SAXException {
        String formula = attrs.getValue("http://openoffice.org/2005/report", "formula");
        if (formula == null) {
            throw new ParseException("Required attribute 'formula' is missing", this.getLocator());
        }
        String name = attrs.getValue("http://openoffice.org/2005/report", "name");
        if (name == null) {
            throw new ParseException("Required attribute 'name' is missing", this.getLocator());
        }
        String initialFormula = attrs.getValue("http://openoffice.org/2005/report", "initial-formula");
        String deepTraversing = attrs.getValue("http://openoffice.org/2005/report", "deep-traversing");
        if (initialFormula != null) {
            FormulaFunction function = new FormulaFunction();
            function.setInitial(initialFormula);
            function.setFormula(formula);
            this.expression = function;
        } else {
            FormulaExpression expression = new FormulaExpression();
            expression.setFormula(formula);
            this.expression = expression;
        }
        this.expression.setName(name);
        this.expression.setDeepTraversing("true".equals(deepTraversing));
        String preEvaluated = attrs.getValue("http://openoffice.org/2005/report", "pre-evaluated");
        this.expression.setPrecompute("true".equals(preEvaluated));
    }

    public Object getObject() throws SAXException {
        return this.getExpression();
    }

    public Expression getExpression() {
        return this.expression;
    }
}

