/*
 * Decompiled with CFR 0.152.
 */
package jspecview.common;

import jspecview.common.Coordinate;
import jspecview.common.ScriptToken;

class PlotWidget
extends Coordinate {
    int xPixel0;
    int yPixel0;
    int xPixel1;
    int yPixel1;
    boolean isPin;
    boolean isPinOrCursor;
    boolean isXtype;
    boolean is2D;
    boolean is2Donly;
    boolean isEnabled = true;
    boolean isVisible = false;
    private String name;
    ScriptToken color = ScriptToken.PLOTCOLOR;

    @Override
    public String toString() {
        return this.name + (!this.isPinOrCursor ? "" + this.xPixel0 + " " + this.yPixel0 + " / " + this.xPixel1 + " " + this.yPixel1 : " x=" + this.getXVal() + "/" + this.xPixel0 + " y=" + this.getYVal() + "/" + this.yPixel0);
    }

    PlotWidget(String string) {
        this.name = string;
        this.isPin = string.charAt(0) == 'p';
        this.isPinOrCursor = string.charAt(0) != 'z';
        this.isXtype = string.indexOf("x") >= 0;
        this.is2D = string.indexOf("2D") >= 0;
        this.is2Donly = this.is2D && string.charAt(0) == 'p';
    }

    boolean selected(int n, int n2) {
        return this.isVisible && Math.abs(n - this.xPixel0) < 5 && Math.abs(n2 - this.yPixel0) < 5;
    }

    void setX(double d, int n) {
        this.setXVal(d);
        this.xPixel0 = this.xPixel1 = n;
    }

    void setY(double d, int n) {
        this.setYVal(d);
        this.yPixel0 = this.yPixel1 = n;
    }

    double getValue() {
        return this.isXtype ? this.getXVal() : this.getYVal();
    }

    void setEnabled(boolean bl) {
        this.isEnabled = bl;
    }
}

