/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.modelset;

import org.jmol.java.BS;
import org.jmol.modelset.Atom;
import org.jmol.util.C;
import org.jmol.util.Edge;
import org.jmol.util.Node;
import org.jmol.viewer.JC;

public class Bond
extends Edge {
    public static final int myVisibilityFlag = JC.getShapeVisibilityFlag(1);
    public Atom atom1;
    public Atom atom2;
    public short mad;
    public short colix;
    public int shapeVisibilityFlags;

    public Bond(Atom atom1, Atom atom2, int order, short mad, short colix) {
        this.atom1 = atom1;
        this.atom2 = atom2;
        this.colix = colix;
        this.setOrder(order);
        this.setMad(mad);
    }

    public void setMad(short mad) {
        this.mad = mad;
        this.setShapeVisibility(mad != 0);
    }

    void setShapeVisibility(boolean isVisible) {
        boolean wasVisible;
        boolean bl = wasVisible = (this.shapeVisibilityFlags & myVisibilityFlag) != 0;
        if (wasVisible == isVisible) {
            return;
        }
        this.atom1.addDisplayedBond(myVisibilityFlag, isVisible);
        this.atom2.addDisplayedBond(myVisibilityFlag, isVisible);
        this.shapeVisibilityFlags = isVisible ? (this.shapeVisibilityFlags |= myVisibilityFlag) : (this.shapeVisibilityFlags &= ~myVisibilityFlag);
    }

    public String getIdentity() {
        return this.index + 1 + " " + Edge.getBondOrderNumberFromOrder(this.order) + " " + this.atom1.getInfo() + " -- " + this.atom2.getInfo() + " " + this.atom1.distance(this.atom2);
    }

    @Override
    public boolean isCovalent() {
        return (this.order & 0x3FF) != 0;
    }

    @Override
    public boolean isHydrogen() {
        return Bond.isOrderH(this.order);
    }

    boolean isStereo() {
        return (this.order & 0x400) != 0;
    }

    boolean isPartial() {
        return (this.order & 0xE0) != 0;
    }

    boolean isAromatic() {
        return (this.order & 0x200) != 0;
    }

    public float getEnergy() {
        return 0.0f;
    }

    public int getValence() {
        return !this.isCovalent() ? 0 : (this.isPartial() || this.is(515) ? 1 : this.order & 7);
    }

    void deleteAtomReferences() {
        if (this.atom1 != null) {
            this.atom1.deleteBond(this);
        }
        if (this.atom2 != null) {
            this.atom2.deleteBond(this);
        }
        this.atom2 = null;
        this.atom1 = null;
    }

    public void setTranslucent(boolean isTranslucent, float translucentLevel) {
        this.colix = C.getColixTranslucent3(this.colix, isTranslucent, translucentLevel);
    }

    public void setOrder(int order) {
        if (this.atom1.getElementNumber() == 16 && this.atom2.getElementNumber() == 16) {
            order |= 0x100;
        }
        if (order == 512) {
            order = 515;
        }
        this.order = order | this.order & 0x20000;
    }

    @Override
    public int getAtomIndex1() {
        return this.atom1.i;
    }

    @Override
    public int getAtomIndex2() {
        return this.atom2.i;
    }

    @Override
    public int getCovalentOrder() {
        return Edge.getCovalentBondOrder(this.order);
    }

    public Atom getOtherAtom(Atom thisAtom) {
        return this.atom1 == thisAtom ? this.atom2 : (this.atom2 == thisAtom ? this.atom1 : null);
    }

    public boolean is(int bondType) {
        return (this.order & 0xFFFDFFFF) == bondType;
    }

    @Override
    public Node getOtherAtomNode(Node thisAtom) {
        return this.atom1 == thisAtom ? this.atom2 : (this.atom2 == thisAtom ? this.atom1 : null);
    }

    public void setAtropisomerOptions(BS bsA, BS bsB) {
        Atom a;
        int i1;
        boolean isBA = bsB.get(this.atom1.i);
        BS bs1 = isBA ? bsB : bsA;
        BS bs2 = isBA ? bsA : bsB;
        int i2 = Integer.MAX_VALUE;
        Bond[] bonds = this.atom1.bonds;
        for (i1 = 0; i1 < bonds.length; ++i1) {
            a = bonds[i1].getOtherAtom(this.atom1);
            if (bs1.get(a.i) && a != this.atom2) break;
        }
        if (i1 < bonds.length) {
            bonds = this.atom2.bonds;
            for (i2 = 0; i2 < bonds.length; ++i2) {
                a = bonds[i2].getOtherAtom(this.atom2);
                if (bs2.get(a.i) && a != this.atom1) break;
            }
        }
        this.order = i1 > 2 || i2 >= bonds.length || i2 > 2 ? 1 : Bond.getAtropismOrder(i1 + 1, i2 + 1);
    }

    @Override
    public String getCIPChirality(boolean doCalculate) {
        int flags = (this.order & 0xC0000) >> 18;
        if (flags == 0 && this.getCovalentOrder() == 2 && doCalculate) {
            flags = this.atom1.group.chain.model.ms.getBondCIPChirality(this);
            this.order |= (flags == 0 ? 3 : flags) << 18;
        }
        switch (flags) {
            case 524288: {
                return "E";
            }
            case 262144: {
                return "Z";
            }
        }
        return "";
    }

    @Override
    public void setCIPChirality(int c) {
        this.order = (byte)(this.order & 0xFFF3FFFF | c << 18);
    }

    public String toString() {
        return this.atom1 + " - " + this.atom2;
    }
}

