/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.quantum;

import javajs.util.P3;
import javajs.util.T3;
import org.jmol.modelset.Atom;
import org.jmol.quantum.QuantumCalculation;
import org.jmol.util.Logger;

class QMAtom
extends P3 {
    private float[] myX;
    private float[] myY;
    private float[] myZ;
    private float[] myX2;
    private float[] myY2;
    private float[] myZ2;
    Atom atom;
    int index;
    int znuc;
    int iMolecule;

    QMAtom(int i, T3 xyzAng, Atom atom, float[] X, float[] Y, float[] Z, float[] X2, float[] Y2, float[] Z2, float unitFactor) {
        this.index = i;
        this.myX = X;
        this.myY = Y;
        this.myZ = Z;
        this.myX2 = X2;
        this.myY2 = Y2;
        this.myZ2 = Z2;
        this.atom = atom;
        this.setT(xyzAng);
        this.scale(unitFactor);
        this.znuc = atom.getElementNumber();
    }

    protected void setXYZ(QuantumCalculation qc, boolean setMinMax) {
        try {
            int i;
            if (setMinMax) {
                if (qc.points != null) {
                    qc.zMin = 0;
                    qc.yMin = 0;
                    qc.xMin = 0;
                    qc.yMax = qc.zMax = qc.points.length;
                    qc.xMax = qc.zMax;
                } else {
                    i = (int)Math.floor((this.x - qc.xBohr[0] - qc.rangeBohrOrAngstroms) / qc.stepBohr[0]);
                    qc.xMin = i < 0 ? 0 : i;
                    i = (int)Math.floor(1.0f + (this.x - qc.xBohr[0] + qc.rangeBohrOrAngstroms) / qc.stepBohr[0]);
                    qc.xMax = i >= qc.nX ? qc.nX : i + 1;
                    i = (int)Math.floor((this.y - qc.yBohr[0] - qc.rangeBohrOrAngstroms) / qc.stepBohr[1]);
                    qc.yMin = i < 0 ? 0 : i;
                    i = (int)Math.floor(1.0f + (this.y - qc.yBohr[0] + qc.rangeBohrOrAngstroms) / qc.stepBohr[1]);
                    qc.yMax = i >= qc.nY ? qc.nY : i + 1;
                    i = (int)Math.floor((this.z - qc.zBohr[0] - qc.rangeBohrOrAngstroms) / qc.stepBohr[2]);
                    qc.zMin = i < 0 ? 0 : i;
                    i = (int)Math.floor(1.0f + (this.z - qc.zBohr[0] + qc.rangeBohrOrAngstroms) / qc.stepBohr[2]);
                    qc.zMax = i >= qc.nZ ? qc.nZ : i + 1;
                }
            }
            i = qc.xMax;
            while (--i >= qc.xMin) {
                this.myX2[i] = this.myX[i] = qc.xBohr[i] - this.x;
                int n = i;
                this.myX2[n] = this.myX2[n] * this.myX[i];
            }
            i = qc.yMax;
            while (--i >= qc.yMin) {
                this.myY2[i] = this.myY[i] = qc.yBohr[i] - this.y;
                int n = i;
                this.myY2[n] = this.myY2[n] * this.myY[i];
            }
            i = qc.zMax;
            while (--i >= qc.zMin) {
                this.myZ2[i] = this.myZ[i] = qc.zBohr[i] - this.z;
                int n = i;
                this.myZ2[n] = this.myZ2[n] * this.myZ[i];
            }
            if (qc.points != null) {
                qc.zMax = 1;
                qc.yMax = 1;
            }
        }
        catch (Exception e) {
            Logger.error((String)"Error in QuantumCalculation setting bounds");
        }
    }
}

