/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.validation.tests;

import java.awt.geom.Area;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.command.ChangeCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.osm.AbstractPrimitive;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.WaySegment;
import org.openstreetmap.josm.data.osm.visitor.paint.relations.Multipolygon;
import org.openstreetmap.josm.data.validation.OsmValidator;
import org.openstreetmap.josm.data.validation.Severity;
import org.openstreetmap.josm.data.validation.Test;
import org.openstreetmap.josm.data.validation.TestError;
import org.openstreetmap.josm.data.validation.tests.CrossingWays;
import org.openstreetmap.josm.data.validation.tests.RelationChecker;
import org.openstreetmap.josm.data.validation.tests.UnclosedWays;
import org.openstreetmap.josm.gui.DefaultNameFormatter;
import org.openstreetmap.josm.gui.mappaint.ElemStyles;
import org.openstreetmap.josm.gui.mappaint.MapPaintStyles;
import org.openstreetmap.josm.gui.mappaint.styleelement.AreaElement;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.tools.Geometry;
import org.openstreetmap.josm.tools.I18n;

public class MultipolygonTest
extends Test {
    public static final int WRONG_MEMBER_TYPE = 1601;
    public static final int WRONG_MEMBER_ROLE = 1602;
    public static final int NON_CLOSED_WAY = 1603;
    public static final int MISSING_OUTER_WAY = 1604;
    public static final int INNER_WAY_OUTSIDE = 1605;
    public static final int CROSSING_WAYS = 1606;
    public static final int OUTER_STYLE_MISMATCH = 1607;
    public static final int INNER_STYLE_MISMATCH = 1608;
    public static final int NOT_CLOSED = 1609;
    public static final int NO_STYLE = 1610;
    public static final int NO_STYLE_POLYGON = 1611;
    public static final int OUTER_STYLE = 1613;
    public static final int REPEATED_MEMBER_SAME_ROLE = 1614;
    public static final int REPEATED_MEMBER_DIFF_ROLE = 1615;
    public static final int EQUAL_RINGS = 1616;
    public static final int RINGS_SHARE_NODES = 1617;
    private static final int FOUND_INSIDE = 1;
    private static final int FOUND_OUTSIDE = 2;
    private final Set<String> keysCheckedByAnotherTest = new HashSet<String>();

    public MultipolygonTest() {
        super(I18n.tr("Multipolygon", new Object[0]), I18n.tr("This test checks if multipolygons are valid.", new Object[0]));
    }

    @Override
    public void startTest(ProgressMonitor progressMonitor) {
        super.startTest(progressMonitor);
        this.keysCheckedByAnotherTest.clear();
        for (Test test : OsmValidator.getEnabledTests(false)) {
            if (!(test instanceof UnclosedWays)) continue;
            this.keysCheckedByAnotherTest.addAll(((UnclosedWays)test).getCheckedKeys());
            break;
        }
    }

    @Override
    public void endTest() {
        this.keysCheckedByAnotherTest.clear();
        super.endTest();
    }

    @Override
    public void visit(Way way) {
        if (!way.isArea() && ElemStyles.hasOnlyAreaOrTextStyleElements(way)) {
            List<Node> list = way.getNodes();
            if (list.isEmpty()) {
                return;
            }
            for (String string : this.keysCheckedByAnotherTest) {
                if (!way.hasKey(string)) continue;
                return;
            }
            this.errors.add(TestError.builder(this, Severity.WARNING, 1609).message(I18n.tr("Area style way is not closed", new Object[0])).primitives(way).highlight(Arrays.asList(list.get(0), list.get(list.size() - 1))).build());
        }
    }

    @Override
    public void visit(Relation relation) {
        if (relation.isMultipolygon() && relation.getMembersCount() > 0) {
            this.checkMembersAndRoles(relation);
            this.checkOuterWay(relation);
            boolean bl = this.checkRepeatedWayMembers(relation);
            if (!bl && !relation.hasIncompleteMembers()) {
                Multipolygon multipolygon = new Multipolygon(relation);
                this.checkStyleConsistency(relation, multipolygon);
                this.checkGeometryAndRoles(relation, multipolygon);
            }
        }
    }

    private void checkOuterWay(Relation relation) {
        for (RelationMember relationMember : relation.getMembers()) {
            if (!relationMember.isWay() || !"outer".equals(relationMember.getRole())) continue;
            return;
        }
        this.errors.add(TestError.builder(this, Severity.WARNING, 1604).message(relation.isBoundary() ? I18n.tr("No outer way for boundary", new Object[0]) : I18n.tr("No outer way for multipolygon", new Object[0])).primitives(relation).build());
    }

    private void checkStyleConsistency(Relation relation, Multipolygon multipolygon) {
        ElemStyles elemStyles = MapPaintStyles.getStyles();
        if (elemStyles != null && !relation.isBoundary()) {
            boolean bl;
            AreaElement areaElement = ElemStyles.getAreaElemStyle(relation, false);
            boolean bl2 = bl = areaElement != null;
            if (areaElement == null) {
                Way way;
                Iterator<Way> iterator = multipolygon.getOuterWays().iterator();
                while (iterator.hasNext() && (areaElement = ElemStyles.getAreaElemStyle(way = iterator.next(), true)) == null) {
                }
                if (areaElement == null) {
                    this.errors.add(TestError.builder(this, Severity.OTHER, 1610).message(I18n.tr("No area style for multipolygon", new Object[0])).primitives(relation).build());
                } else {
                    this.errors.add(TestError.builder(this, Severity.ERROR, 1611).message(I18n.trn("Multipolygon relation should be tagged with area tags and not the outer way", "Multipolygon relation should be tagged with area tags and not the outer ways", multipolygon.getOuterWays().size(), new Object[0])).primitives(relation).build());
                }
            }
            if (areaElement != null) {
                for (Way way : multipolygon.getInnerWays()) {
                    if (!areaElement.equals(ElemStyles.getAreaElemStyle(way, false))) continue;
                    this.errors.add(TestError.builder(this, Severity.OTHER, 1608).message(I18n.tr("With the currently used mappaint style the style for inner way equals the multipolygon style", new Object[0])).primitives(Arrays.asList(relation, way)).highlight(way).build());
                }
                for (Way way : multipolygon.getOuterWays()) {
                    AreaElement areaElement2 = ElemStyles.getAreaElemStyle(way, false);
                    if (areaElement2 == null) continue;
                    if (!areaElement.equals(areaElement2)) {
                        String string = !bl ? I18n.tr("Style for outer way mismatches", new Object[0]) : I18n.tr("With the currently used mappaint style(s) the style for outer way mismatches the area style", new Object[0]);
                        this.errors.add(TestError.builder(this, Severity.OTHER, 1607).message(string).primitives(Arrays.asList(relation, way)).highlight(way).build());
                        continue;
                    }
                    if (!bl) continue;
                    this.errors.add(TestError.builder(this, Severity.ERROR, 1613).message(I18n.tr("Area style on outer way", new Object[0])).primitives(Arrays.asList(relation, way)).highlight(way).build());
                }
            }
        }
    }

    private void checkGeometryAndRoles(Relation relation, Multipolygon multipolygon) {
        int n;
        Object object;
        int n2 = this.errors.size();
        List<Node> list = multipolygon.getOpenEnds();
        if (!list.isEmpty()) {
            this.errors.add(TestError.builder(this, Severity.ERROR, 1603).message(I18n.tr("Multipolygon is not closed", new Object[0])).primitives(MultipolygonTest.combineRelAndPrimitives(relation, list)).highlight(list).build());
        }
        HashMap<Long, RelationMember> hashMap = new HashMap<Long, RelationMember>();
        for (int i = 0; i < relation.getMembersCount(); ++i) {
            object = relation.getMember(i);
            if (!((RelationMember)object).isWay()) continue;
            hashMap.put(((RelationMember)object).getWay().getUniqueId(), (RelationMember)object);
        }
        if (hashMap.isEmpty()) {
            return;
        }
        Set<Node> set = MultipolygonTest.findIntersectionNodes(relation);
        object = multipolygon.getInnerPolygons();
        List<Multipolygon.PolyData> list2 = multipolygon.getOuterPolygons();
        ArrayList<Multipolygon.PolyData> arrayList = new ArrayList<Multipolygon.PolyData>();
        arrayList.addAll(list2);
        arrayList.addAll((Collection<Multipolygon.PolyData>)object);
        Map<Multipolygon.PolyData, List<Multipolygon.PolyData>> map = this.findIntersectingWays(relation, (List<Multipolygon.PolyData>)object, list2);
        if (!set.isEmpty()) {
            for (n = 0; n < arrayList.size(); ++n) {
                Multipolygon.PolyData polyData = (Multipolygon.PolyData)arrayList.get(n);
                for (int i = n + 1; i < arrayList.size(); ++i) {
                    Multipolygon.PolyData polyData2 = (Multipolygon.PolyData)arrayList.get(i);
                    if (MultipolygonTest.checkProblemMap(map, polyData, polyData2)) continue;
                    this.checkPolygonsForSharedNodes(relation, polyData, polyData2, set);
                }
            }
        }
        n = 1;
        for (int i = n2; i < this.errors.size(); ++i) {
            if (((TestError)this.errors.get(i)).getSeverity() == Severity.OTHER) continue;
            n = 0;
            break;
        }
        if (n != 0) {
            this.checkRoles(relation, arrayList, hashMap, set);
        }
    }

    private static Set<Node> findIntersectionNodes(Relation relation) {
        HashSet<Node> hashSet = new HashSet<Node>();
        HashMap<Node, ArrayList<Way>> hashMap = new HashMap<Node, ArrayList<Way>>();
        for (RelationMember relationMember : relation.getMembers()) {
            if (!relationMember.isWay()) continue;
            int n = relationMember.getWay().getNodesCount();
            for (int i = 0; i < n; ++i) {
                Node node = relationMember.getWay().getNode(i);
                if (node.getReferrers().size() <= 1) continue;
                ArrayList<Way> arrayList = (ArrayList<Way>)hashMap.get(node);
                if (arrayList == null) {
                    arrayList = new ArrayList<Way>();
                    hashMap.put(node, arrayList);
                }
                arrayList.add(relationMember.getWay());
                if (arrayList.size() <= 2 && (arrayList.size() != 2 || i == 0 || i + 1 == n)) continue;
                hashSet.add(node);
            }
        }
        return hashSet;
    }

    private void checkPolygonsForSharedNodes(Relation relation, Multipolygon.PolyData polyData, Multipolygon.PolyData polyData2, Set<Node> set) {
        HashSet<Node> hashSet = new HashSet<Node>(set);
        hashSet.retainAll(polyData.getNodes());
        hashSet.retainAll(polyData2.getNodes());
        if (hashSet.isEmpty()) {
            return;
        }
        int n = 1617;
        ExtPolygonIntersection extPolygonIntersection = MultipolygonTest.checkOverlapAtSharedNodes(hashSet, polyData, polyData2);
        if (extPolygonIntersection == ExtPolygonIntersection.CROSSING) {
            n = 1606;
        } else if (extPolygonIntersection == ExtPolygonIntersection.EQUAL) {
            n = 1616;
        }
        if (n != 0) {
            HashSet<OsmPrimitive> hashSet2 = new HashSet<OsmPrimitive>();
            hashSet2.add(relation);
            for (Node node : hashSet) {
                for (OsmPrimitive osmPrimitive : node.getReferrers()) {
                    if (!(osmPrimitive instanceof Way) || !polyData.getWayIds().contains(osmPrimitive.getUniqueId()) && !polyData2.getWayIds().contains(osmPrimitive.getUniqueId())) continue;
                    hashSet2.add(osmPrimitive);
                }
            }
            if (n == 1617) {
                this.errors.add(TestError.builder(this, Severity.OTHER, n).message(I18n.tr("Multipolygon rings share node(s)", new Object[0])).primitives(hashSet2).highlight(hashSet).build());
            } else {
                this.errors.add(TestError.builder(this, Severity.WARNING, n).message(n == 1606 ? I18n.tr("Intersection between multipolygon ways", new Object[0]) : I18n.tr("Multipolygon rings are equal", new Object[0])).primitives(hashSet2).highlight(hashSet).build());
            }
        }
    }

    private static ExtPolygonIntersection checkOverlapAtSharedNodes(Set<Node> set, Multipolygon.PolyData polyData, Multipolygon.PolyData polyData2) {
        Object object;
        int[] nArray = new int[2];
        for (int i = 0; i < nArray.length; ++i) {
            object = i == 0 ? polyData.getNodes() : polyData2.getNodes();
            int n = object.size() - 1;
            int n2 = 0;
            for (int j = 0; j < n; ++j) {
                Node node = object.get(j);
                if (set.contains(node)) {
                    ++n2;
                    continue;
                }
                if (j != 0 && n2 <= 0) continue;
                n2 = 0;
                boolean bl = MultipolygonTest.checkIfNodeIsInsidePolygon(node, i == 0 ? polyData2 : polyData);
                int n3 = i;
                nArray[n3] = nArray[n3] | (bl ? 1 : 2);
                if (nArray[i] != 3) continue;
                return ExtPolygonIntersection.CROSSING;
            }
        }
        if ((nArray[0] & 1) != 0) {
            return ExtPolygonIntersection.FIRST_INSIDE_SECOND;
        }
        if ((nArray[1] & 1) != 0) {
            return ExtPolygonIntersection.SECOND_INSIDE_FIRST;
        }
        if ((nArray[0] & 2) != (nArray[1] & 2)) {
            return (nArray[0] & 2) != 0 ? ExtPolygonIntersection.SECOND_INSIDE_FIRST : ExtPolygonIntersection.FIRST_INSIDE_SECOND;
        }
        if ((nArray[0] & 2) != 0 && (nArray[1] & 2) != 0) {
            Area area = new Area(polyData.get());
            Geometry.PolygonIntersection polygonIntersection = Geometry.polygonIntersection(area, (Area)(object = new Area(polyData2.get())), 1.0E-6);
            if (polygonIntersection == Geometry.PolygonIntersection.OUTSIDE) {
                return ExtPolygonIntersection.OUTSIDE;
            }
            return ExtPolygonIntersection.CROSSING;
        }
        return ExtPolygonIntersection.EQUAL;
    }

    private void checkRoles(Relation relation, List<Multipolygon.PolyData> list, Map<Long, RelationMember> map, Set<Node> set) {
        PolygonLevelFinder polygonLevelFinder = new PolygonLevelFinder(set);
        List<PolygonLevel> list2 = polygonLevelFinder.findOuterWays(list);
        if (list2 == null || list2.isEmpty()) {
            return;
        }
        for (PolygonLevel polygonLevel : list2) {
            String string = polygonLevel.level % 2 == 0 ? "outer" : "inner";
            for (long l : polygonLevel.outerWay.getWayIds()) {
                RelationMember relationMember = map.get(l);
                if (relationMember.getRole().equals(string)) continue;
                this.errors.add(TestError.builder(this, Severity.ERROR, 1602).message(RelationChecker.ROLE_VERIF_PROBLEM_MSG, I18n.marktr("Role for ''{0}'' should be ''{1}''"), relationMember.getMember().getDisplayName(DefaultNameFormatter.getInstance()), string).primitives(Arrays.asList(relation, relationMember.getMember())).highlight(relationMember.getMember()).build());
                if (polygonLevel.level != 0 || !"inner".equals(relationMember.getRole())) continue;
                this.errors.add(TestError.builder(this, Severity.ERROR, 1605).message(I18n.tr("Multipolygon inner way is outside", new Object[0])).primitives(Arrays.asList(relation, relationMember.getMember())).highlight(relationMember.getMember()).build());
            }
        }
    }

    private static boolean checkIfNodeIsInsidePolygon(Node node, Multipolygon.PolyData polyData) {
        EastNorth eastNorth = node.getEastNorth();
        return eastNorth != null && polyData.get().contains(eastNorth.getX(), eastNorth.getY());
    }

    private Map<Multipolygon.PolyData, List<Multipolygon.PolyData>> findIntersectingWays(Relation relation, List<Multipolygon.PolyData> list, List<Multipolygon.PolyData> list2) {
        HashMap<Multipolygon.PolyData, List<Multipolygon.PolyData>> hashMap = new HashMap<Multipolygon.PolyData, List<Multipolygon.PolyData>>();
        HashMap hashMap2 = new HashMap();
        for (int i = 0; i < 2; ++i) {
            HashMap<Point2D, List<WaySegment>> hashMap3 = new HashMap<Point2D, List<WaySegment>>(1000);
            HashMap<List<Way>, List<WaySegment>> hashMap4 = new HashMap<List<Way>, List<WaySegment>>(50);
            HashMap<Multipolygon.PolyData, List<Multipolygon.PolyData>> hashMap5 = i == 0 ? hashMap : hashMap2;
            for (Way way : relation.getMemberPrimitives(Way.class)) {
                MultipolygonTest.findIntersectingWay(way, hashMap3, hashMap4, i == 1);
            }
            if (hashMap4.isEmpty()) continue;
            ArrayList arrayList = new ArrayList(list.size() + list2.size());
            arrayList.addAll(list);
            arrayList.addAll(list2);
            for (Map.Entry entry : hashMap4.entrySet()) {
                List<Multipolygon.PolyData> list3;
                int n;
                List list4 = (List)entry.getKey();
                if (list4.size() != 2) continue;
                Multipolygon.PolyData[] polyDataArray = new Multipolygon.PolyData[2];
                boolean bl = true;
                block3: for (n = 0; n < 2; ++n) {
                    list3 = (Way)list4.get(n);
                    for (int j = 0; j < arrayList.size(); ++j) {
                        Multipolygon.PolyData polyData = (Multipolygon.PolyData)arrayList.get(j);
                        if (!polyData.getWayIds().contains(((AbstractPrimitive)((Object)list3)).getUniqueId())) continue;
                        polyDataArray[n] = polyData;
                        if (j < list.size()) continue block3;
                        bl = false;
                        continue block3;
                    }
                }
                n = 0;
                if (polyDataArray[0] != null && polyDataArray[1] != null) {
                    list3 = (List)hashMap5.get(polyDataArray[0]);
                    if (list3 == null) {
                        list3 = new ArrayList<Multipolygon.PolyData>();
                        hashMap5.put(polyDataArray[0], list3);
                    }
                    list3.add(polyDataArray[1]);
                    if (polyDataArray[0] == polyDataArray[1]) {
                        n = 1;
                    }
                }
                if (i != 0 && n == 0 && (i != 1 || bl)) continue;
                list3 = i == 0 ? I18n.tr("Intersection between multipolygon ways", new Object[0]) : (n != 0 ? I18n.tr("Multipolygon ring contains segments twice", new Object[0]) : I18n.tr("Multipolygon outer way shares segment(s) with other ring", new Object[0]));
                this.errors.add(TestError.builder(this, Severity.ERROR, 1606).message((String)((Object)list3)).primitives(Arrays.asList(relation, (OsmPrimitive)list4.get(0), (OsmPrimitive)list4.get(1))).highlightWaySegments((Collection)entry.getValue()).build());
            }
        }
        return hashMap;
    }

    private static void findIntersectingWay(Way way, Map<Point2D, List<WaySegment>> map, Map<List<Way>, List<WaySegment>> map2, boolean bl) {
        int n = way.getNodesCount();
        for (int i = 0; i < n - 1; ++i) {
            WaySegment waySegment = new WaySegment(way, i);
            EastNorth eastNorth = waySegment.getFirstNode().getEastNorth();
            EastNorth eastNorth2 = waySegment.getSecondNode().getEastNorth();
            if (eastNorth == null || eastNorth2 == null) {
                Main.warn("Crossing ways test (MP) skipped " + waySegment);
                continue;
            }
            for (List<WaySegment> list : CrossingWays.getSegments(map, eastNorth, eastNorth2)) {
                for (WaySegment waySegment2 : list) {
                    if (waySegment2.way == way || bl && !waySegment.isSimilar(waySegment2) || !bl && !waySegment.intersects(waySegment2)) continue;
                    List<Way> list2 = Arrays.asList(waySegment.way, waySegment2.way);
                    List<WaySegment> list3 = map2.get(list2);
                    if (list3 == null) {
                        list3 = new ArrayList<WaySegment>();
                        list3.add(waySegment);
                        list3.add(waySegment2);
                        map2.put(list2, list3);
                        continue;
                    }
                    list3.add(waySegment);
                    list3.add(waySegment2);
                }
                list.add(waySegment);
            }
        }
    }

    private static boolean checkProblemMap(Map<Multipolygon.PolyData, List<Multipolygon.PolyData>> map, Multipolygon.PolyData polyData, Multipolygon.PolyData polyData2) {
        List<Multipolygon.PolyData> list = map.get(polyData);
        if (list != null && list.contains(polyData2)) {
            return true;
        }
        List<Multipolygon.PolyData> list2 = map.get(polyData2);
        return list2 != null && list2.contains(polyData);
    }

    private void checkMembersAndRoles(Relation relation) {
        for (RelationMember relationMember : relation.getMembers()) {
            if (relationMember.isWay()) {
                if (relationMember.hasRole("inner", "outer") || !relationMember.hasRole()) continue;
                this.errors.add(TestError.builder(this, Severity.WARNING, 1602).message(I18n.tr("No useful role for multipolygon member", new Object[0])).primitives(Arrays.asList(relation, relationMember.getMember())).build());
                continue;
            }
            if (relation.isBoundary() && relationMember.hasRole("admin_centre", "label", "subarea", "land_area")) continue;
            this.errors.add(TestError.builder(this, Severity.WARNING, 1601).message(relation.isBoundary() ? I18n.tr("Non-Way in boundary", new Object[0]) : I18n.tr("Non-Way in multipolygon", new Object[0])).primitives(Arrays.asList(relation, relationMember.getMember())).build());
        }
    }

    private static Collection<? extends OsmPrimitive> combineRelAndPrimitives(Relation relation, Collection<? extends OsmPrimitive> collection) {
        if (!collection.contains(relation)) {
            ArrayList<? extends OsmPrimitive> arrayList = new ArrayList<OsmPrimitive>(collection);
            arrayList.add(0, relation);
            return arrayList;
        }
        return collection;
    }

    private boolean checkRepeatedWayMembers(Relation relation) {
        boolean bl = false;
        HashMap<OsmPrimitive, ArrayList<RelationMember>> hashMap = new HashMap<OsmPrimitive, ArrayList<RelationMember>>();
        for (RelationMember object : relation.getMembers()) {
            List<RelationMember> list = (List)hashMap.get(object.getMember());
            if (list == null) {
                list = new ArrayList<RelationMember>(2);
                hashMap.put(object.getMember(), (ArrayList<RelationMember>)list);
            } else {
                bl = true;
            }
            list.add(object);
        }
        if (bl) {
            ArrayList arrayList = new ArrayList();
            ArrayList<OsmPrimitive> arrayList2 = new ArrayList<OsmPrimitive>();
            for (Map.Entry entry : hashMap.entrySet()) {
                List list = (List)entry.getValue();
                if (((List)entry.getValue()).size() == 1) continue;
                boolean bl2 = false;
                RelationMember relationMember = (RelationMember)list.get(0);
                ArrayList<OsmPrimitive> arrayList3 = new ArrayList<OsmPrimitive>();
                for (int i = 1; i < list.size(); ++i) {
                    RelationMember relationMember2 = (RelationMember)list.get(i);
                    arrayList3.add(relationMember.getMember());
                    if (relationMember2.getRole().equals(relationMember.getRole())) continue;
                    bl2 = true;
                }
                if (bl2) {
                    arrayList2.addAll(arrayList3);
                    continue;
                }
                arrayList.addAll(arrayList3);
            }
            this.addRepeatedMemberError(relation, arrayList2, 1615, I18n.tr("Multipolygon member(s) repeated with different role", new Object[0]));
            this.addRepeatedMemberError(relation, arrayList, 1614, I18n.tr("Multipolygon member(s) repeated with same role", new Object[0]));
        }
        return bl;
    }

    private void addRepeatedMemberError(Relation relation, List<OsmPrimitive> list, int n, String string) {
        if (!list.isEmpty()) {
            this.errors.add(TestError.builder(this, Severity.ERROR, n).message(string).primitives(MultipolygonTest.combineRelAndPrimitives(relation, list)).highlight(list).build());
        }
    }

    @Override
    public Command fixError(TestError testError) {
        ArrayList<? extends OsmPrimitive> arrayList;
        if (testError.getCode() == 1614 && (arrayList = new ArrayList<OsmPrimitive>(testError.getPrimitives())).size() >= 2 && arrayList.get(0) instanceof Relation) {
            Relation relation = (Relation)arrayList.get(0);
            Relation relation2 = new Relation(relation);
            List<? extends OsmPrimitive> list = arrayList.subList(1, arrayList.size());
            List<RelationMember> list2 = relation.getMembers();
            ArrayList<RelationMember> arrayList2 = new ArrayList<RelationMember>();
            HashSet<? extends OsmPrimitive> hashSet = new HashSet<OsmPrimitive>(list);
            HashSet<OsmPrimitive> hashSet2 = new HashSet<OsmPrimitive>(list.size());
            for (RelationMember relationMember : list2) {
                if (hashSet.contains(relationMember.getMember())) {
                    if (hashSet2.contains(relationMember.getMember())) continue;
                    hashSet2.add(relationMember.getMember());
                    arrayList2.add(relationMember);
                    continue;
                }
                arrayList2.add(relationMember);
            }
            relation2.setMembers(arrayList2);
            return new ChangeCommand(relation, relation2);
        }
        return null;
    }

    @Override
    public boolean isFixable(TestError testError) {
        return testError.getCode() == 1614;
    }

    private static class PolygonLevelFinder {
        private final Set<Node> sharedNodes;

        PolygonLevelFinder(Set<Node> set) {
            this.sharedNodes = set;
        }

        List<PolygonLevel> findOuterWays(List<Multipolygon.PolyData> list) {
            return this.findOuterWaysRecursive(0, list);
        }

        private List<PolygonLevel> findOuterWaysRecursive(int n, List<Multipolygon.PolyData> list) {
            ArrayList<PolygonLevel> arrayList = new ArrayList<PolygonLevel>();
            for (Multipolygon.PolyData polyData : list) {
                if (this.processOuterWay(n, list, arrayList, polyData) != null) continue;
                return null;
            }
            return arrayList;
        }

        private Object processOuterWay(int n, List<Multipolygon.PolyData> list, List<PolygonLevel> list2, Multipolygon.PolyData polyData) {
            List<Multipolygon.PolyData> list3 = this.findInnerWaysCandidates(polyData, list);
            if (list3 != null) {
                PolygonLevel polygonLevel = new PolygonLevel(polyData, n);
                if (!list3.isEmpty()) {
                    List<PolygonLevel> list4 = this.findOuterWaysRecursive(n + 1, list3);
                    list2.addAll(list4);
                }
                list2.add(polygonLevel);
            }
            return list2;
        }

        private List<Multipolygon.PolyData> findInnerWaysCandidates(Multipolygon.PolyData polyData, List<Multipolygon.PolyData> list) {
            ArrayList<Multipolygon.PolyData> arrayList = new ArrayList<Multipolygon.PolyData>();
            for (Multipolygon.PolyData polyData2 : list) {
                if (polyData2 == polyData || !polyData.getBounds().intersects(polyData2.getBounds())) continue;
                Node node = this.getNonIntersectingNode(polyData, polyData2);
                if (node != null) {
                    if (MultipolygonTest.checkIfNodeIsInsidePolygon(node, polyData)) {
                        arrayList.add(polyData2);
                        continue;
                    }
                    node = this.getNonIntersectingNode(polyData2, polyData);
                    if (node != null) {
                        if (!MultipolygonTest.checkIfNodeIsInsidePolygon(node, polyData2)) continue;
                        return null;
                    }
                    return null;
                }
                node = this.getNonIntersectingNode(polyData2, polyData);
                if (node == null) {
                    return null;
                }
                arrayList.add(polyData2);
            }
            return arrayList;
        }

        private Node getNonIntersectingNode(Multipolygon.PolyData polyData, Multipolygon.PolyData polyData2) {
            for (Node node : polyData2.getNodes()) {
                if (this.sharedNodes.contains(node) && polyData.getNodes().contains(node)) continue;
                return node;
            }
            return null;
        }
    }

    private static class PolygonLevel {
        final int level;
        final Multipolygon.PolyData outerWay;

        PolygonLevel(Multipolygon.PolyData polyData, int n) {
            this.outerWay = polyData;
            this.level = n;
        }
    }

    private static enum ExtPolygonIntersection {
        EQUAL,
        FIRST_INSIDE_SECOND,
        SECOND_INSIDE_FIRST,
        OUTSIDE,
        CROSSING;

    }
}

