/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.array;

import org.jruby.truffle.core.array.ArrayMirror;
import org.jruby.truffle.core.array.ArrayUtils;
import org.jruby.truffle.core.array.BasicArrayMirror;

class ObjectArrayMirror
extends BasicArrayMirror {
    private final Object[] array;

    public ObjectArrayMirror(Object[] array) {
        this.array = array;
    }

    @Override
    public int getLength() {
        return this.array.length;
    }

    @Override
    public Object get(int index) {
        return this.array[index];
    }

    @Override
    public void set(int index, Object value) {
        this.array[index] = value;
    }

    @Override
    public ArrayMirror copyArrayAndMirror() {
        return new ObjectArrayMirror((Object[])this.array.clone());
    }

    @Override
    public ArrayMirror copyArrayAndMirror(int newLength) {
        return new ObjectArrayMirror(ArrayUtils.copyOf(this.array, newLength));
    }

    @Override
    public void copyTo(ArrayMirror destination, int sourceStart, int destinationStart, int count) {
        for (int i = 0; i < count; ++i) {
            destination.set(destinationStart + i, this.array[sourceStart + i]);
        }
    }

    @Override
    public void copyTo(Object[] destination, int sourceStart, int destinationStart, int count) {
        System.arraycopy(this.array, sourceStart, destination, destinationStart, count);
    }

    @Override
    public ArrayMirror extractRange(int start, int end) {
        return new ObjectArrayMirror(ArrayUtils.extractRange(this.array, start, end));
    }

    @Override
    public Object getArray() {
        return this.array;
    }
}

