/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.language.dispatch;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.profiles.ConditionProfile;
import org.jcodings.specific.UTF8Encoding;
import org.jruby.truffle.core.array.ArrayToObjectArrayNode;
import org.jruby.truffle.core.array.ArrayToObjectArrayNodeGen;
import org.jruby.truffle.core.cast.BooleanCastNode;
import org.jruby.truffle.core.cast.BooleanCastNodeGen;
import org.jruby.truffle.core.cast.ProcOrNullNode;
import org.jruby.truffle.core.cast.ProcOrNullNodeGen;
import org.jruby.truffle.core.module.ModuleOperations;
import org.jruby.truffle.language.RubyNode;
import org.jruby.truffle.language.arguments.RubyArguments;
import org.jruby.truffle.language.dispatch.CallDispatchHeadNode;
import org.jruby.truffle.language.dispatch.DispatchHeadNodeFactory;
import org.jruby.truffle.language.dispatch.DispatchNode;
import org.jruby.truffle.language.dispatch.MissingBehavior;
import org.jruby.truffle.language.dispatch.RubyCallNodeParameters;
import org.jruby.truffle.language.methods.BlockDefinitionNode;
import org.jruby.truffle.language.methods.InternalMethod;

public class RubyCallNode
extends RubyNode {
    private final String methodName;
    @Node.Child
    private RubyNode receiver;
    @Node.Child
    private ProcOrNullNode block;
    @Node.Children
    private final RubyNode[] arguments;
    private final boolean isSplatted;
    private final boolean ignoreVisibility;
    private final boolean isVCall;
    private final boolean isSafeNavigation;
    private final boolean isAttrAssign;
    @Node.Child
    private CallDispatchHeadNode dispatchHead;
    @Node.Child
    private ArrayToObjectArrayNode toObjectArrayNode;
    @Node.Child
    private CallDispatchHeadNode respondToMissing;
    @Node.Child
    private BooleanCastNode respondToMissingCast;
    private final ConditionProfile nilProfile;

    public RubyCallNode(RubyCallNodeParameters parameters) {
        this.methodName = parameters.getMethodName();
        this.receiver = parameters.getReceiver();
        this.arguments = parameters.getArguments();
        this.block = parameters.getBlock() == null ? null : ProcOrNullNodeGen.create(parameters.getBlock());
        this.isSplatted = parameters.isSplatted();
        this.ignoreVisibility = parameters.isIgnoreVisibility();
        this.isVCall = parameters.isVCall();
        this.isSafeNavigation = parameters.isSafeNavigation();
        this.isAttrAssign = parameters.isAttrAssign();
        this.nilProfile = parameters.isSafeNavigation() ? ConditionProfile.createCountingProfile() : null;
    }

    @Override
    public Object execute(VirtualFrame frame) {
        Object receiverObject = this.receiver.execute(frame);
        if (this.isSafeNavigation && this.nilProfile.profile(receiverObject == this.nil())) {
            return this.nil();
        }
        Object[] argumentsObjects = this.executeArguments(frame);
        return this.executeWithArgumentsEvaluated(frame, receiverObject, argumentsObjects);
    }

    public Object executeWithArgumentsEvaluated(VirtualFrame frame, Object receiverObject, Object[] argumentsObjects) {
        DynamicObject blockObject = this.executeBlock(frame);
        if (this.dispatchHead == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.dispatchHead = this.insert(DispatchHeadNodeFactory.createMethodCall(this.ignoreVisibility));
        }
        Object returnValue = this.dispatchHead.dispatch(frame, receiverObject, this.methodName, blockObject, argumentsObjects);
        if (this.isAttrAssign) {
            return argumentsObjects[argumentsObjects.length - 1];
        }
        return returnValue;
    }

    private DynamicObject executeBlock(VirtualFrame frame) {
        if (this.block != null) {
            return (DynamicObject)this.block.execute(frame);
        }
        return null;
    }

    @ExplodeLoop
    private Object[] executeArguments(VirtualFrame frame) {
        Object[] argumentsObjects = new Object[this.arguments.length];
        for (int i = 0; i < this.arguments.length; ++i) {
            argumentsObjects[i] = this.arguments[i].execute(frame);
        }
        if (this.isSplatted) {
            assert (argumentsObjects.length == 1);
            return this.splat(argumentsObjects);
        }
        return argumentsObjects;
    }

    private Object[] splat(Object[] arguments) {
        if (this.toObjectArrayNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.toObjectArrayNode = this.insert(ArrayToObjectArrayNodeGen.create(null));
        }
        return this.toObjectArrayNode.unsplat(arguments);
    }

    @Override
    public Object isDefined(VirtualFrame frame) {
        Object receiverObject;
        if (this.receiver.isDefined(frame) == this.nil()) {
            return this.nil();
        }
        for (RubyNode argument : this.arguments) {
            if (argument.isDefined(frame) != this.nil()) continue;
            return this.nil();
        }
        try {
            receiverObject = this.receiver.execute(frame);
        }
        catch (Exception e) {
            return this.nil();
        }
        InternalMethod method = ModuleOperations.lookupMethod(this.coreLibrary().getMetaClass(receiverObject), this.methodName);
        Object self = RubyArguments.getSelf(frame);
        if (method == null) {
            Object r = this.respondToMissing(frame, receiverObject);
            if (r != DispatchNode.MISSING && !this.castRespondToMissingToBoolean(r)) {
                return this.nil();
            }
        } else {
            if (method.isUndefined()) {
                return this.nil();
            }
            if (!this.ignoreVisibility && !method.isVisibleTo(this.coreLibrary().getMetaClass(self))) {
                return this.nil();
            }
        }
        return this.create7BitString("method", UTF8Encoding.INSTANCE);
    }

    private Object respondToMissing(VirtualFrame frame, Object receiverObject) {
        if (this.respondToMissing == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.respondToMissing = this.insert(DispatchHeadNodeFactory.createMethodCall(true, MissingBehavior.RETURN_MISSING));
        }
        DynamicObject method = this.getContext().getSymbolTable().getSymbol(this.methodName);
        return this.respondToMissing.call(frame, receiverObject, "respond_to_missing?", method, false);
    }

    private boolean castRespondToMissingToBoolean(Object r) {
        if (this.respondToMissingCast == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.respondToMissingCast = this.insert(BooleanCastNodeGen.create(null));
        }
        return this.respondToMissingCast.executeToBoolean(r);
    }

    public String getName() {
        return this.methodName;
    }

    public boolean isVCall() {
        return this.isVCall;
    }

    public boolean hasLiteralBlock() {
        assert (this.block != null);
        return this.block.getChild() instanceof BlockDefinitionNode;
    }
}

