/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.parser.ast;

import java.util.List;
import org.jruby.truffle.language.SourceIndexLength;
import org.jruby.truffle.parser.ast.NodeType;
import org.jruby.truffle.parser.ast.ParseNode;
import org.jruby.truffle.parser.ast.visitor.NodeVisitor;
import org.jruby.truffle.parser.scope.DynamicScope;
import org.jruby.truffle.parser.scope.StaticScope;

public class RootParseNode
extends ParseNode {
    private transient DynamicScope scope;
    private StaticScope staticScope;
    private ParseNode bodyNode;
    private String file;
    private int endPosition;
    private boolean needsCodeCoverage;

    public RootParseNode(SourceIndexLength position, DynamicScope scope, ParseNode bodyNode, String file) {
        this(position, scope, bodyNode, file, -1, false);
    }

    public RootParseNode(SourceIndexLength position, DynamicScope scope, ParseNode bodyNode, String file, int endPosition, boolean needsCodeCoverage) {
        super(position, bodyNode.containsVariableAssignment());
        this.scope = scope;
        this.staticScope = scope.getStaticScope();
        this.bodyNode = bodyNode;
        this.file = file;
        this.endPosition = endPosition;
        this.needsCodeCoverage = needsCodeCoverage;
    }

    @Deprecated
    public RootParseNode(SourceIndexLength position, DynamicScope scope, ParseNode bodyNode, String file, int endPosition) {
        this(position, scope, bodyNode, file, endPosition, false);
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.ROOTNODE;
    }

    public DynamicScope getScope() {
        return this.scope;
    }

    public StaticScope getStaticScope() {
        return this.staticScope;
    }

    public String getFile() {
        return this.file;
    }

    public ParseNode getBodyNode() {
        return this.bodyNode;
    }

    @Override
    public <T> T accept(NodeVisitor<T> iVisitor) {
        return iVisitor.visitRootNode(this);
    }

    @Override
    public List<ParseNode> childNodes() {
        return RootParseNode.createList(this.bodyNode);
    }

    public boolean hasEndPosition() {
        return this.endPosition != -1;
    }

    public int getEndPosition() {
        return this.endPosition;
    }

    public boolean needsCoverage() {
        return this.needsCodeCoverage;
    }
}

