/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.declaration;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.js.backend.ast.AbstractNode;
import org.jetbrains.kotlin.js.backend.ast.JsArrayLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsBinaryOperation;
import org.jetbrains.kotlin.js.backend.ast.JsBinaryOperator;
import org.jetbrains.kotlin.js.backend.ast.JsCase;
import org.jetbrains.kotlin.js.backend.ast.JsDefault;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsExpressionStatement;
import org.jetbrains.kotlin.js.backend.ast.JsFunction;
import org.jetbrains.kotlin.js.backend.ast.JsInvocation;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsParameter;
import org.jetbrains.kotlin.js.backend.ast.JsReturn;
import org.jetbrains.kotlin.js.backend.ast.JsSwitch;
import org.jetbrains.kotlin.js.translate.context.Namer;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.general.AbstractTranslator;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0006\u0010\u0011\u001a\u00020\u0012J\b\u0010\u0013\u001a\u00020\u0012H\u0002J\b\u0010\u0014\u001a\u00020\u0012H\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/js/translate/declaration/EnumTranslator;", "Lorg/jetbrains/kotlin/js/translate/general/AbstractTranslator;", "context", "Lorg/jetbrains/kotlin/js/translate/context/TranslationContext;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "entries", "", "(Lorg/jetbrains/kotlin/js/translate/context/TranslationContext;Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;Ljava/util/List;)V", "getDescriptor", "()Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "getEntries", "()Ljava/util/List;", "createFunction", "Lorg/jetbrains/kotlin/js/backend/ast/JsFunction;", "functionDescriptor", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "generateStandardMethods", "", "generateValueOfFunction", "generateValuesFunction", "kotlin-compiler"})
public final class EnumTranslator
extends AbstractTranslator {
    @NotNull
    private final ClassDescriptor descriptor;
    @NotNull
    private final List<ClassDescriptor> entries;

    public final void generateStandardMethods() {
        this.generateValuesFunction();
        this.generateValueOfFunction();
    }

    /*
     * WARNING - void declaration
     */
    private final void generateValuesFunction() {
        void $receiver$iv$iv;
        FunctionDescriptor functionDescriptor = DescriptorUtils.getFunctionByName(this.descriptor.getStaticScope(), DescriptorUtils.ENUM_VALUES);
        Intrinsics.checkExpressionValueIsNotNull(functionDescriptor, "DescriptorUtils.getFunct\u2026criptorUtils.ENUM_VALUES)");
        JsFunction function2 = this.createFunction(functionDescriptor);
        Iterable $receiver$iv = this.entries;
        Object object = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            ClassDescriptor classDescriptor = (ClassDescriptor)item$iv$iv;
            Collection collection = destination$iv$iv;
            JsInvocation jsInvocation = new JsInvocation((JsExpression)JsAstUtils.pureFqn(this.context().getNameForObjectInstance((ClassDescriptor)it), null), new JsExpression[0]);
            collection.add(jsInvocation);
        }
        List values = (List)destination$iv$iv;
        Collection collection = function2.getBody().getStatements();
        object = new JsReturn(new JsArrayLiteral(values));
        collection.add(object);
    }

    /*
     * WARNING - void declaration
     */
    private final void generateValueOfFunction() {
        AbstractNode abstractNode;
        Object object;
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        FunctionDescriptor functionDescriptor = DescriptorUtils.getFunctionByName(this.descriptor.getStaticScope(), DescriptorUtils.ENUM_VALUE_OF);
        Intrinsics.checkExpressionValueIsNotNull(functionDescriptor, "DescriptorUtils.getFunct\u2026iptorUtils.ENUM_VALUE_OF)");
        JsFunction function2 = this.createFunction(functionDescriptor);
        JsName nameParam = function2.getScope().declareTemporaryName("name");
        Collection collection = function2.getParameters();
        JsParameter jsParameter = new JsParameter(nameParam);
        collection.add(jsParameter);
        Iterable iterable = $receiver$iv = (Iterable)this.entries;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void entry;
            object = (ClassDescriptor)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            JsCase $receiver = abstractNode = new JsCase();
            $receiver.setCaseExpression(this.context().program().getStringLiteral(entry.getName().asString()));
            Collection collection3 = $receiver.getStatements();
            JsReturn jsReturn = new JsReturn(new JsInvocation((JsExpression)JsAstUtils.pureFqn(this.context().getNameForObjectInstance((ClassDescriptor)entry), null), new JsExpression[0]));
            collection3.add(jsReturn);
            JsCase jsCase = abstractNode;
            collection2.add(jsCase);
        }
        List clauses = (List)destination$iv$iv;
        JsBinaryOperation message = new JsBinaryOperation(JsBinaryOperator.ADD, this.context().program().getStringLiteral("No enum constant " + DescriptorUtilsKt.getFqNameSafe(this.descriptor) + "."), nameParam.makeRef());
        JsExpressionStatement throwStatement = new JsExpressionStatement(new JsInvocation(Namer.throwIllegalStateExceptionFunRef(), message));
        destination$iv$iv = clauses;
        if (!destination$iv$iv.isEmpty()) {
            Object object2 = new JsDefault();
            JsDefault $receiver = (JsDefault)object2;
            object = $receiver.getStatements();
            abstractNode = throwStatement;
            object.add(abstractNode);
            JsDefault defaultCase = (JsDefault)object2;
            object2 = function2.getBody().getStatements();
            JsSwitch jsSwitch = new JsSwitch(nameParam.makeRef(), CollectionsKt.plus((Collection)clauses, defaultCase));
            object2.add(jsSwitch);
        } else {
            Collection collection4 = function2.getBody().getStatements();
            collection4.add(throwStatement);
        }
    }

    private final JsFunction createFunction(FunctionDescriptor functionDescriptor) {
        JsFunction function2 = this.context().getFunctionObject(functionDescriptor);
        function2.setName(this.context().getInnerNameForDescriptor(functionDescriptor));
        this.context().addDeclarationStatement(function2.makeStmt());
        JsNameRef classRef = this.context().getInnerReference(this.descriptor);
        JsNameRef functionRef = function2.getName().makeRef();
        JsBinaryOperation assignment = JsAstUtils.assignment(new JsNameRef(this.context().getNameForDescriptor(functionDescriptor), (JsExpression)classRef), functionRef);
        this.context().addDeclarationStatement(assignment.makeStmt());
        JsFunction jsFunction = function2;
        Intrinsics.checkExpressionValueIsNotNull(jsFunction, "function");
        return jsFunction;
    }

    @NotNull
    public final ClassDescriptor getDescriptor() {
        return this.descriptor;
    }

    @NotNull
    public final List<ClassDescriptor> getEntries() {
        return this.entries;
    }

    public EnumTranslator(@NotNull TranslationContext context, @NotNull ClassDescriptor descriptor2, @NotNull List<? extends ClassDescriptor> entries) {
        Intrinsics.checkParameterIsNotNull(context, "context");
        Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
        Intrinsics.checkParameterIsNotNull(entries, "entries");
        super(context);
        this.descriptor = descriptor2;
        this.entries = entries;
    }
}

