/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.ext.awt.image.renderable;

import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.RenderContext;
import java.util.Map;
import java.util.Vector;
import org.apache.batik.ext.awt.image.renderable.Filter;

public class DeferRable
implements Filter {
    volatile Filter src;
    Rectangle2D bounds;
    Map props;

    public synchronized Filter getSource() {
        while (this.src == null) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        return this.src;
    }

    public synchronized void setSource(Filter filter) {
        if (this.src != null) {
            return;
        }
        this.src = filter;
        this.bounds = filter.getBounds2D();
        this.notifyAll();
    }

    public synchronized void setBounds(Rectangle2D rectangle2D) {
        if (this.bounds != null) {
            return;
        }
        this.bounds = rectangle2D;
        this.notifyAll();
    }

    public synchronized void setProperties(Map map) {
        this.props = map;
        this.notifyAll();
    }

    @Override
    public long getTimeStamp() {
        return this.getSource().getTimeStamp();
    }

    public Vector getSources() {
        return this.getSource().getSources();
    }

    @Override
    public boolean isDynamic() {
        return this.getSource().isDynamic();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Rectangle2D getBounds2D() {
        DeferRable deferRable = this;
        synchronized (deferRable) {
            while (this.src == null && this.bounds == null) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        if (this.src != null) {
            return this.src.getBounds2D();
        }
        return this.bounds;
    }

    @Override
    public float getMinX() {
        return (float)this.getBounds2D().getX();
    }

    @Override
    public float getMinY() {
        return (float)this.getBounds2D().getY();
    }

    @Override
    public float getWidth() {
        return (float)this.getBounds2D().getWidth();
    }

    @Override
    public float getHeight() {
        return (float)this.getBounds2D().getHeight();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getProperty(String string) {
        DeferRable deferRable = this;
        synchronized (deferRable) {
            while (this.src == null && this.props == null) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        if (this.src != null) {
            return this.src.getProperty(string);
        }
        return this.props.get(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getPropertyNames() {
        String[] stringArray = this;
        synchronized (this) {
            while (this.src == null && this.props == null) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            if (this.src != null) {
                return this.src.getPropertyNames();
            }
            stringArray = new String[this.props.size()];
            this.props.keySet().toArray(stringArray);
            return stringArray;
        }
    }

    @Override
    public RenderedImage createDefaultRendering() {
        return this.getSource().createDefaultRendering();
    }

    @Override
    public RenderedImage createScaledRendering(int n, int n2, RenderingHints renderingHints) {
        return this.getSource().createScaledRendering(n, n2, renderingHints);
    }

    @Override
    public RenderedImage createRendering(RenderContext renderContext) {
        return this.getSource().createRendering(renderContext);
    }

    @Override
    public Shape getDependencyRegion(int n, Rectangle2D rectangle2D) {
        return this.getSource().getDependencyRegion(n, rectangle2D);
    }

    @Override
    public Shape getDirtyRegion(int n, Rectangle2D rectangle2D) {
        return this.getSource().getDirtyRegion(n, rectangle2D);
    }
}

