/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.create;

import java.util.Map;
import org.elasticsearch.action.admin.indices.alias.Alias;
import org.elasticsearch.action.admin.indices.create.CreateIndexAction;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequest;
import org.elasticsearch.action.admin.indices.create.CreateIndexResponse;
import org.elasticsearch.action.support.ActiveShardCount;
import org.elasticsearch.action.support.master.AcknowledgedRequestBuilder;
import org.elasticsearch.client.ElasticsearchClient;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentType;

public class CreateIndexRequestBuilder
extends AcknowledgedRequestBuilder<CreateIndexRequest, CreateIndexResponse, CreateIndexRequestBuilder> {
    public CreateIndexRequestBuilder(ElasticsearchClient client, CreateIndexAction action) {
        super(client, action, new CreateIndexRequest());
    }

    public CreateIndexRequestBuilder(ElasticsearchClient client, CreateIndexAction action, String index) {
        super(client, action, new CreateIndexRequest(index));
    }

    public CreateIndexRequestBuilder setIndex(String index) {
        ((CreateIndexRequest)this.request).index(index);
        return this;
    }

    public CreateIndexRequestBuilder setSettings(Settings settings) {
        ((CreateIndexRequest)this.request).settings(settings);
        return this;
    }

    public CreateIndexRequestBuilder setSettings(Settings.Builder settings) {
        ((CreateIndexRequest)this.request).settings(settings);
        return this;
    }

    public CreateIndexRequestBuilder setSettings(XContentBuilder builder) {
        ((CreateIndexRequest)this.request).settings(builder);
        return this;
    }

    @Deprecated
    public CreateIndexRequestBuilder setSettings(String source) {
        ((CreateIndexRequest)this.request).settings(source);
        return this;
    }

    public CreateIndexRequestBuilder setSettings(String source, XContentType xContentType) {
        ((CreateIndexRequest)this.request).settings(source, xContentType);
        return this;
    }

    public CreateIndexRequestBuilder setSettings(Object ... settings) {
        ((CreateIndexRequest)this.request).settings(settings);
        return this;
    }

    public CreateIndexRequestBuilder setSettings(Map<String, ?> source) {
        ((CreateIndexRequest)this.request).settings(source);
        return this;
    }

    @Deprecated
    public CreateIndexRequestBuilder addMapping(String type, String source) {
        ((CreateIndexRequest)this.request).mapping(type, source);
        return this;
    }

    public CreateIndexRequestBuilder addMapping(String type, String source, XContentType xContentType) {
        ((CreateIndexRequest)this.request).mapping(type, source, xContentType);
        return this;
    }

    public CreateIndexRequestBuilder setCause(String cause) {
        ((CreateIndexRequest)this.request).cause(cause);
        return this;
    }

    public CreateIndexRequestBuilder addMapping(String type, XContentBuilder source) {
        ((CreateIndexRequest)this.request).mapping(type, source);
        return this;
    }

    public CreateIndexRequestBuilder addMapping(String type, Map<String, Object> source) {
        ((CreateIndexRequest)this.request).mapping(type, source);
        return this;
    }

    public CreateIndexRequestBuilder addMapping(String type, Object ... source) {
        ((CreateIndexRequest)this.request).mapping(type, source);
        return this;
    }

    public CreateIndexRequestBuilder setAliases(Map source) {
        ((CreateIndexRequest)this.request).aliases(source);
        return this;
    }

    public CreateIndexRequestBuilder setAliases(String source) {
        ((CreateIndexRequest)this.request).aliases(source);
        return this;
    }

    public CreateIndexRequestBuilder setAliases(XContentBuilder source) {
        ((CreateIndexRequest)this.request).aliases(source);
        return this;
    }

    public CreateIndexRequestBuilder setAliases(BytesReference source) {
        ((CreateIndexRequest)this.request).aliases(source);
        return this;
    }

    public CreateIndexRequestBuilder addAlias(Alias alias) {
        ((CreateIndexRequest)this.request).alias(alias);
        return this;
    }

    @Deprecated
    public CreateIndexRequestBuilder setSource(String source) {
        ((CreateIndexRequest)this.request).source(source);
        return this;
    }

    public CreateIndexRequestBuilder setSource(String source, XContentType xContentType) {
        ((CreateIndexRequest)this.request).source(source, xContentType);
        return this;
    }

    @Deprecated
    public CreateIndexRequestBuilder setSource(BytesReference source) {
        ((CreateIndexRequest)this.request).source(source);
        return this;
    }

    public CreateIndexRequestBuilder setSource(BytesReference source, XContentType xContentType) {
        ((CreateIndexRequest)this.request).source(source, xContentType);
        return this;
    }

    @Deprecated
    public CreateIndexRequestBuilder setSource(byte[] source) {
        ((CreateIndexRequest)this.request).source(source);
        return this;
    }

    public CreateIndexRequestBuilder setSource(byte[] source, XContentType xContentType) {
        ((CreateIndexRequest)this.request).source(source, xContentType);
        return this;
    }

    @Deprecated
    public CreateIndexRequestBuilder setSource(byte[] source, int offset, int length) {
        ((CreateIndexRequest)this.request).source(source, offset, length);
        return this;
    }

    public CreateIndexRequestBuilder setSource(byte[] source, int offset, int length, XContentType xContentType) {
        ((CreateIndexRequest)this.request).source(source, offset, length, xContentType);
        return this;
    }

    public CreateIndexRequestBuilder setSource(Map<String, ?> source) {
        ((CreateIndexRequest)this.request).source(source);
        return this;
    }

    public CreateIndexRequestBuilder addCustom(IndexMetaData.Custom custom) {
        ((CreateIndexRequest)this.request).custom(custom);
        return this;
    }

    public CreateIndexRequestBuilder setSource(XContentBuilder source) {
        ((CreateIndexRequest)this.request).source(source);
        return this;
    }

    public CreateIndexRequestBuilder setUpdateAllTypes(boolean updateAllTypes) {
        ((CreateIndexRequest)this.request).updateAllTypes(updateAllTypes);
        return this;
    }

    public CreateIndexRequestBuilder setWaitForActiveShards(ActiveShardCount waitForActiveShards) {
        ((CreateIndexRequest)this.request).waitForActiveShards(waitForActiveShards);
        return this;
    }

    public CreateIndexRequestBuilder setWaitForActiveShards(int waitForActiveShards) {
        return this.setWaitForActiveShards(ActiveShardCount.from(waitForActiveShards));
    }
}

