/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.metrics.scripted;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.script.CompiledScript;
import org.elasticsearch.script.ExecutableScript;
import org.elasticsearch.script.Script;
import org.elasticsearch.script.ScriptContext;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.metrics.InternalMetricsAggregation;
import org.elasticsearch.search.aggregations.metrics.scripted.ScriptedMetric;
import org.elasticsearch.search.aggregations.pipeline.PipelineAggregator;

public class InternalScriptedMetric
extends InternalMetricsAggregation
implements ScriptedMetric {
    private final Script reduceScript;
    private final Object aggregation;

    public InternalScriptedMetric(String name, Object aggregation, Script reduceScript, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData) {
        super(name, pipelineAggregators, metaData);
        this.aggregation = aggregation;
        this.reduceScript = reduceScript;
    }

    public InternalScriptedMetric(StreamInput in) throws IOException {
        super(in);
        this.reduceScript = in.readOptionalWriteable(Script::new);
        this.aggregation = in.readGenericValue();
    }

    @Override
    protected void doWriteTo(StreamOutput out) throws IOException {
        out.writeOptionalWriteable(this.reduceScript);
        out.writeGenericValue(this.aggregation);
    }

    @Override
    public String getWriteableName() {
        return "scripted_metric";
    }

    @Override
    public Object aggregation() {
        return this.aggregation;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public InternalAggregation doReduce(List<InternalAggregation> aggregations, InternalAggregation.ReduceContext reduceContext) {
        void var5_8;
        ArrayList<Object> aggregationObjects = new ArrayList<Object>();
        for (InternalAggregation internalAggregation : aggregations) {
            InternalScriptedMetric mapReduceAggregation = (InternalScriptedMetric)internalAggregation;
            aggregationObjects.add(mapReduceAggregation.aggregation());
        }
        InternalScriptedMetric firstAggregation = (InternalScriptedMetric)aggregations.get(0);
        if (firstAggregation.reduceScript != null) {
            HashMap<String, Object> vars = new HashMap<String, Object>();
            vars.put("_aggs", aggregationObjects);
            if (firstAggregation.reduceScript.getParams() != null) {
                vars.putAll(firstAggregation.reduceScript.getParams());
            }
            CompiledScript compiledScript = reduceContext.scriptService().compile(firstAggregation.reduceScript, ScriptContext.Standard.AGGS);
            ExecutableScript script = reduceContext.scriptService().executable(compiledScript, vars);
            Object object = script.run();
        } else {
            ArrayList<Object> arrayList = aggregationObjects;
        }
        return new InternalScriptedMetric(firstAggregation.getName(), var5_8, firstAggregation.reduceScript, this.pipelineAggregators(), this.getMetaData());
    }

    @Override
    public Object getProperty(List<String> path) {
        if (path.isEmpty()) {
            return this;
        }
        if (path.size() == 1 && "value".equals(path.get(0))) {
            return this.aggregation;
        }
        throw new IllegalArgumentException("path not supported for [" + this.getName() + "]: " + path);
    }

    @Override
    public XContentBuilder doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return builder.field("value", this.aggregation);
    }
}

