/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.kotlin.com.intellij.pom.java.LanguageLevel;
import org.jetbrains.kotlin.com.intellij.psi.JavaPsiFacade;
import org.jetbrains.kotlin.com.intellij.psi.JavaResolveResult;
import org.jetbrains.kotlin.com.intellij.psi.PsiAnonymousClass;
import org.jetbrains.kotlin.com.intellij.psi.PsiCallExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiClass;
import org.jetbrains.kotlin.com.intellij.psi.PsiClassType;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiExpressionList;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.com.intellij.psi.PsiInferenceHelper;
import org.jetbrains.kotlin.com.intellij.psi.PsiJavaCodeReferenceElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiJavaParserFacade;
import org.jetbrains.kotlin.com.intellij.psi.PsiManager;
import org.jetbrains.kotlin.com.intellij.psi.PsiMember;
import org.jetbrains.kotlin.com.intellij.psi.PsiMethod;
import org.jetbrains.kotlin.com.intellij.psi.PsiModifierList;
import org.jetbrains.kotlin.com.intellij.psi.PsiParameter;
import org.jetbrains.kotlin.com.intellij.psi.PsiResolveHelper;
import org.jetbrains.kotlin.com.intellij.psi.PsiSubstitutor;
import org.jetbrains.kotlin.com.intellij.psi.PsiType;
import org.jetbrains.kotlin.com.intellij.psi.PsiTypeParameter;
import org.jetbrains.kotlin.com.intellij.psi.PsiVariable;
import org.jetbrains.kotlin.com.intellij.psi.ResolveState;
import org.jetbrains.kotlin.com.intellij.psi.impl.JavaPsiImplementationHelper;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve.JavaResolveUtil;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve.ParameterTypeInferencePolicy;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve.PsiOldInferenceHelper;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve.ResolveClassUtil;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve.ResolveVariableUtil;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve.graphInference.PsiGraphInferenceHelper;
import org.jetbrains.kotlin.com.intellij.psi.infos.CandidateInfo;
import org.jetbrains.kotlin.com.intellij.psi.scope.MethodProcessorSetupFailedException;
import org.jetbrains.kotlin.com.intellij.psi.scope.processor.MethodCandidatesProcessor;
import org.jetbrains.kotlin.com.intellij.psi.scope.processor.MethodResolverProcessor;
import org.jetbrains.kotlin.com.intellij.psi.scope.util.PsiScopesUtil;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiUtil;
import org.jetbrains.kotlin.com.intellij.util.IncorrectOperationException;

public class PsiResolveHelperImpl
implements PsiResolveHelper {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.source.resolve.PsiResolveHelperImpl");
    private final PsiManager myManager;

    public PsiResolveHelperImpl(PsiManager manager) {
        this.myManager = manager;
    }

    @Override
    @NotNull
    public JavaResolveResult resolveConstructor(PsiClassType classType, @NotNull PsiExpressionList argumentList2, PsiElement place) {
        if (argumentList2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argumentList", "org/jetbrains/kotlin/com/intellij/psi/impl/source/resolve/PsiResolveHelperImpl", "resolveConstructor"));
        }
        JavaResolveResult[] result2 = this.multiResolveConstructor(classType, argumentList2, place);
        JavaResolveResult javaResolveResult = result2.length == 1 ? result2[0] : JavaResolveResult.EMPTY;
        if (javaResolveResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/source/resolve/PsiResolveHelperImpl", "resolveConstructor"));
        }
        return javaResolveResult;
    }

    @Override
    @NotNull
    public JavaResolveResult[] multiResolveConstructor(@NotNull PsiClassType type2, @NotNull PsiExpressionList argumentList2, @NotNull PsiElement place) {
        MethodResolverProcessor processor;
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/com/intellij/psi/impl/source/resolve/PsiResolveHelperImpl", "multiResolveConstructor"));
        }
        if (argumentList2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argumentList", "org/jetbrains/kotlin/com/intellij/psi/impl/source/resolve/PsiResolveHelperImpl", "multiResolveConstructor"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "org/jetbrains/kotlin/com/intellij/psi/impl/source/resolve/PsiResolveHelperImpl", "multiResolveConstructor"));
        }
        PsiClassType.ClassResolveResult classResolveResult = type2.resolveGenerics();
        PsiClass aClass2 = classResolveResult.getElement();
        if (aClass2 == null) {
            if (JavaResolveResult.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/source/resolve/PsiResolveHelperImpl", "multiResolveConstructor"));
            }
            return JavaResolveResult.EMPTY_ARRAY;
        }
        PsiSubstitutor substitutor2 = classResolveResult.getSubstitutor();
        if (argumentList2.getParent() instanceof PsiAnonymousClass) {
            PsiAnonymousClass anonymous = (PsiAnonymousClass)argumentList2.getParent();
            processor = new MethodResolverProcessor(anonymous, argumentList2, place, place.getContainingFile());
            aClass2 = anonymous.getBaseClassType().resolve();
            if (aClass2 == null) {
                if (JavaResolveResult.EMPTY_ARRAY == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/source/resolve/PsiResolveHelperImpl", "multiResolveConstructor"));
                }
                return JavaResolveResult.EMPTY_ARRAY;
            }
        } else {
            processor = new MethodResolverProcessor(aClass2, argumentList2, place, place.getContainingFile());
        }
        ResolveState state2 = ResolveState.initial().put(PsiSubstitutor.KEY, substitutor2);
        for (PsiMethod constructor : aClass2.getConstructors()) {
            if (!processor.execute(constructor, state2)) break;
        }
        JavaResolveResult[] javaResolveResultArray = processor.getResult();
        if (javaResolveResultArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/source/resolve/PsiResolveHelperImpl", "multiResolveConstructor"));
        }
        return javaResolveResultArray;
    }

    @Override
    public PsiClass resolveReferencedClass(@NotNull String referenceText, PsiElement context) {
        if (referenceText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "referenceText", "org/jetbrains/kotlin/com/intellij/psi/impl/source/resolve/PsiResolveHelperImpl", "resolveReferencedClass"));
        }
        PsiJavaParserFacade parserFacade = JavaPsiFacade.getInstance(this.myManager.getProject()).getParserFacade();
        try {
            PsiJavaCodeReferenceElement ref = parserFacade.createReferenceFromText(referenceText, context);
            PsiFile containingFile = ref.getContainingFile();
            LOG.assertTrue(containingFile.isValid(), referenceText);
            return ResolveClassUtil.resolveClass(ref, containingFile);
        }
        catch (IncorrectOperationException e) {
            return null;
        }
    }

    @Override
    public PsiVariable resolveReferencedVariable(@NotNull String referenceText, PsiElement context) {
        if (referenceText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "referenceText", "org/jetbrains/kotlin/com/intellij/psi/impl/source/resolve/PsiResolveHelperImpl", "resolveReferencedVariable"));
        }
        return this.resolveVar(referenceText, context, null);
    }

    @Override
    public PsiVariable resolveAccessibleReferencedVariable(@NotNull String referenceText, PsiElement context) {
        if (referenceText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "referenceText", "org/jetbrains/kotlin/com/intellij/psi/impl/source/resolve/PsiResolveHelperImpl", "resolveAccessibleReferencedVariable"));
        }
        boolean[] problemWithAccess = new boolean[1];
        PsiVariable variable = this.resolveVar(referenceText, context, problemWithAccess);
        return problemWithAccess[0] ? null : variable;
    }

    @Nullable
    private PsiVariable resolveVar(@NotNull String referenceText, PsiElement context, boolean[] problemWithAccess) {
        if (referenceText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "referenceText", "org/jetbrains/kotlin/com/intellij/psi/impl/source/resolve/PsiResolveHelperImpl", "resolveVar"));
        }
        PsiJavaParserFacade parserFacade = JavaPsiFacade.getInstance(this.myManager.getProject()).getParserFacade();
        try {
            PsiJavaCodeReferenceElement ref = parserFacade.createReferenceFromText(referenceText, context);
            return ResolveVariableUtil.resolveVariable(ref, problemWithAccess, null);
        }
        catch (IncorrectOperationException e) {
            return null;
        }
    }

    @Override
    public boolean isAccessible(@NotNull PsiMember member, @NotNull PsiElement place, @Nullable PsiClass accessObjectClass) {
        if (member == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "member", "org/jetbrains/kotlin/com/intellij/psi/impl/source/resolve/PsiResolveHelperImpl", "isAccessible"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "org/jetbrains/kotlin/com/intellij/psi/impl/source/resolve/PsiResolveHelperImpl", "isAccessible"));
        }
        return this.isAccessible(member, member.getModifierList(), place, accessObjectClass, null);
    }

    @Override
    public boolean isAccessible(@NotNull PsiMember member, @Nullable PsiModifierList modifierList, @NotNull PsiElement place, @Nullable PsiClass accessObjectClass, @Nullable PsiElement currentFileResolveScope) {
        if (member == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "member", "org/jetbrains/kotlin/com/intellij/psi/impl/source/resolve/PsiResolveHelperImpl", "isAccessible"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "org/jetbrains/kotlin/com/intellij/psi/impl/source/resolve/PsiResolveHelperImpl", "isAccessible"));
        }
        PsiClass containingClass = member.getContainingClass();
        return JavaResolveUtil.isAccessible(member, containingClass, modifierList, place, accessObjectClass, currentFileResolveScope);
    }

    @Override
    @NotNull
    public CandidateInfo[] getReferencedMethodCandidates(@NotNull PsiCallExpression expr, boolean dummyImplicitConstructor, final boolean checkVarargs) {
        if (expr == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expr", "org/jetbrains/kotlin/com/intellij/psi/impl/source/resolve/PsiResolveHelperImpl", "getReferencedMethodCandidates"));
        }
        PsiFile containingFile = expr.getContainingFile();
        MethodCandidatesProcessor processor = new MethodCandidatesProcessor(expr, containingFile){

            @Override
            protected boolean acceptVarargs() {
                return checkVarargs;
            }
        };
        try {
            PsiScopesUtil.setupAndRunProcessor(processor, expr, dummyImplicitConstructor);
        }
        catch (MethodProcessorSetupFailedException e) {
            if (CandidateInfo.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/source/resolve/PsiResolveHelperImpl", "getReferencedMethodCandidates"));
            }
            return CandidateInfo.EMPTY_ARRAY;
        }
        CandidateInfo[] candidateInfoArray = processor.getCandidates();
        if (candidateInfoArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/source/resolve/PsiResolveHelperImpl", "getReferencedMethodCandidates"));
        }
        return candidateInfoArray;
    }

    @Override
    @NotNull
    public CandidateInfo[] getReferencedMethodCandidates(@NotNull PsiCallExpression call, boolean dummyImplicitConstructor) {
        if (call == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "org/jetbrains/kotlin/com/intellij/psi/impl/source/resolve/PsiResolveHelperImpl", "getReferencedMethodCandidates"));
        }
        CandidateInfo[] candidateInfoArray = this.getReferencedMethodCandidates(call, dummyImplicitConstructor, false);
        if (candidateInfoArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/source/resolve/PsiResolveHelperImpl", "getReferencedMethodCandidates"));
        }
        return candidateInfoArray;
    }

    @Override
    public PsiType inferTypeForMethodTypeParameter(@NotNull PsiTypeParameter typeParameter, @NotNull PsiParameter[] parameters2, @NotNull PsiExpression[] arguments2, @NotNull PsiSubstitutor partialSubstitutor, @Nullable PsiElement parent2, @NotNull ParameterTypeInferencePolicy policy2) {
        if (typeParameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeParameter", "org/jetbrains/kotlin/com/intellij/psi/impl/source/resolve/PsiResolveHelperImpl", "inferTypeForMethodTypeParameter"));
        }
        if (parameters2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "org/jetbrains/kotlin/com/intellij/psi/impl/source/resolve/PsiResolveHelperImpl", "inferTypeForMethodTypeParameter"));
        }
        if (arguments2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arguments", "org/jetbrains/kotlin/com/intellij/psi/impl/source/resolve/PsiResolveHelperImpl", "inferTypeForMethodTypeParameter"));
        }
        if (partialSubstitutor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "partialSubstitutor", "org/jetbrains/kotlin/com/intellij/psi/impl/source/resolve/PsiResolveHelperImpl", "inferTypeForMethodTypeParameter"));
        }
        if (policy2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "policy", "org/jetbrains/kotlin/com/intellij/psi/impl/source/resolve/PsiResolveHelperImpl", "inferTypeForMethodTypeParameter"));
        }
        return this.getInferenceHelper(PsiUtil.getLanguageLevel(parent2 != null ? parent2 : typeParameter)).inferTypeForMethodTypeParameter(typeParameter, parameters2, arguments2, partialSubstitutor, parent2, policy2);
    }

    @Override
    @NotNull
    public PsiSubstitutor inferTypeArguments(@NotNull PsiTypeParameter[] typeParameters2, @NotNull PsiParameter[] parameters2, @NotNull PsiExpression[] arguments2, @NotNull PsiSubstitutor partialSubstitutor, @NotNull PsiElement parent2, @NotNull ParameterTypeInferencePolicy policy2) {
        if (typeParameters2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeParameters", "org/jetbrains/kotlin/com/intellij/psi/impl/source/resolve/PsiResolveHelperImpl", "inferTypeArguments"));
        }
        if (parameters2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "org/jetbrains/kotlin/com/intellij/psi/impl/source/resolve/PsiResolveHelperImpl", "inferTypeArguments"));
        }
        if (arguments2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arguments", "org/jetbrains/kotlin/com/intellij/psi/impl/source/resolve/PsiResolveHelperImpl", "inferTypeArguments"));
        }
        if (partialSubstitutor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "partialSubstitutor", "org/jetbrains/kotlin/com/intellij/psi/impl/source/resolve/PsiResolveHelperImpl", "inferTypeArguments"));
        }
        if (parent2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "org/jetbrains/kotlin/com/intellij/psi/impl/source/resolve/PsiResolveHelperImpl", "inferTypeArguments"));
        }
        if (policy2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "policy", "org/jetbrains/kotlin/com/intellij/psi/impl/source/resolve/PsiResolveHelperImpl", "inferTypeArguments"));
        }
        PsiSubstitutor psiSubstitutor = this.getInferenceHelper(PsiUtil.getLanguageLevel(parent2)).inferTypeArguments(typeParameters2, parameters2, arguments2, partialSubstitutor, parent2, policy2, PsiUtil.getLanguageLevel(parent2));
        if (psiSubstitutor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/source/resolve/PsiResolveHelperImpl", "inferTypeArguments"));
        }
        return psiSubstitutor;
    }

    @Override
    @NotNull
    public PsiSubstitutor inferTypeArguments(@NotNull PsiTypeParameter[] typeParameters2, @NotNull PsiParameter[] parameters2, @NotNull PsiExpression[] arguments2, @NotNull PsiSubstitutor partialSubstitutor, @NotNull PsiElement parent2, @NotNull ParameterTypeInferencePolicy policy2, @NotNull LanguageLevel languageLevel) {
        if (typeParameters2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeParameters", "org/jetbrains/kotlin/com/intellij/psi/impl/source/resolve/PsiResolveHelperImpl", "inferTypeArguments"));
        }
        if (parameters2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "org/jetbrains/kotlin/com/intellij/psi/impl/source/resolve/PsiResolveHelperImpl", "inferTypeArguments"));
        }
        if (arguments2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arguments", "org/jetbrains/kotlin/com/intellij/psi/impl/source/resolve/PsiResolveHelperImpl", "inferTypeArguments"));
        }
        if (partialSubstitutor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "partialSubstitutor", "org/jetbrains/kotlin/com/intellij/psi/impl/source/resolve/PsiResolveHelperImpl", "inferTypeArguments"));
        }
        if (parent2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "org/jetbrains/kotlin/com/intellij/psi/impl/source/resolve/PsiResolveHelperImpl", "inferTypeArguments"));
        }
        if (policy2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "policy", "org/jetbrains/kotlin/com/intellij/psi/impl/source/resolve/PsiResolveHelperImpl", "inferTypeArguments"));
        }
        if (languageLevel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "languageLevel", "org/jetbrains/kotlin/com/intellij/psi/impl/source/resolve/PsiResolveHelperImpl", "inferTypeArguments"));
        }
        PsiSubstitutor psiSubstitutor = this.getInferenceHelper(languageLevel).inferTypeArguments(typeParameters2, parameters2, arguments2, partialSubstitutor, parent2, policy2, languageLevel);
        if (psiSubstitutor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/source/resolve/PsiResolveHelperImpl", "inferTypeArguments"));
        }
        return psiSubstitutor;
    }

    @Override
    @NotNull
    public PsiSubstitutor inferTypeArguments(@NotNull PsiTypeParameter[] typeParameters2, @NotNull PsiType[] leftTypes, @NotNull PsiType[] rightTypes, @NotNull LanguageLevel languageLevel) {
        if (typeParameters2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeParameters", "org/jetbrains/kotlin/com/intellij/psi/impl/source/resolve/PsiResolveHelperImpl", "inferTypeArguments"));
        }
        if (leftTypes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "leftTypes", "org/jetbrains/kotlin/com/intellij/psi/impl/source/resolve/PsiResolveHelperImpl", "inferTypeArguments"));
        }
        if (rightTypes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rightTypes", "org/jetbrains/kotlin/com/intellij/psi/impl/source/resolve/PsiResolveHelperImpl", "inferTypeArguments"));
        }
        if (languageLevel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "languageLevel", "org/jetbrains/kotlin/com/intellij/psi/impl/source/resolve/PsiResolveHelperImpl", "inferTypeArguments"));
        }
        PsiSubstitutor psiSubstitutor = this.getInferenceHelper(languageLevel).inferTypeArguments(typeParameters2, leftTypes, rightTypes, languageLevel);
        if (psiSubstitutor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/source/resolve/PsiResolveHelperImpl", "inferTypeArguments"));
        }
        return psiSubstitutor;
    }

    @Override
    public PsiType getSubstitutionForTypeParameter(PsiTypeParameter typeParam, PsiType param, PsiType arg, boolean isContraVariantPosition, LanguageLevel languageLevel) {
        return this.getInferenceHelper(languageLevel).getSubstitutionForTypeParameter(typeParam, param, arg, isContraVariantPosition, languageLevel);
    }

    @Override
    @NotNull
    public LanguageLevel getEffectiveLanguageLevel(@Nullable VirtualFile virtualFile) {
        LanguageLevel languageLevel = JavaPsiImplementationHelper.getInstance(this.myManager.getProject()).getEffectiveLanguageLevel(virtualFile);
        if (languageLevel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/source/resolve/PsiResolveHelperImpl", "getEffectiveLanguageLevel"));
        }
        return languageLevel;
    }

    @NotNull
    public PsiInferenceHelper getInferenceHelper(@NotNull LanguageLevel languageLevel) {
        if (languageLevel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "languageLevel", "org/jetbrains/kotlin/com/intellij/psi/impl/source/resolve/PsiResolveHelperImpl", "getInferenceHelper"));
        }
        if (languageLevel.isAtLeast(LanguageLevel.JDK_1_8)) {
            PsiGraphInferenceHelper psiGraphInferenceHelper = new PsiGraphInferenceHelper(this.myManager);
            if (psiGraphInferenceHelper == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/source/resolve/PsiResolveHelperImpl", "getInferenceHelper"));
            }
            return psiGraphInferenceHelper;
        }
        PsiOldInferenceHelper psiOldInferenceHelper = new PsiOldInferenceHelper(this.myManager);
        if (psiOldInferenceHelper == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/source/resolve/PsiResolveHelperImpl", "getInferenceHelper"));
        }
        return psiOldInferenceHelper;
    }
}

