/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.event;

import java.util.ArrayList;
import java.util.Iterator;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.dispatch.Dispatch;
import org.gradle.internal.dispatch.MethodInvocation;
import org.gradle.internal.event.ListenerNotificationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractBroadcastDispatch<T>
implements Dispatch<MethodInvocation> {
    protected final Class<T> type;

    public AbstractBroadcastDispatch(Class<T> type) {
        this.type = type;
    }

    private String getErrorMessage() {
        String typeDescription = this.type.getSimpleName().replaceAll("(\\p{Upper})", " $1").trim().toLowerCase();
        return "Failed to notify " + typeDescription + ".";
    }

    protected void dispatch(MethodInvocation invocation, Iterator<? extends Dispatch<MethodInvocation>> handlers) {
        ArrayList<Throwable> failures = new ArrayList<Throwable>();
        while (handlers.hasNext()) {
            Dispatch<MethodInvocation> handler = handlers.next();
            try {
                handler.dispatch(invocation);
            }
            catch (UncheckedException e) {
                failures.add(e.getCause());
            }
            catch (Throwable t) {
                failures.add(t);
            }
        }
        if (failures.size() == 1 && failures.get(0) instanceof RuntimeException) {
            throw (RuntimeException)failures.get(0);
        }
        if (!failures.isEmpty()) {
            throw new ListenerNotificationException(this.getErrorMessage(), failures);
        }
    }
}

