/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.transform;

import com.google.common.collect.Maps;
import java.io.File;
import java.util.List;
import java.util.Map;
import org.gradle.api.Transformer;
import org.gradle.api.artifacts.ResolvedArtifact;
import org.gradle.api.artifacts.transform.ArtifactTransformRegistrations;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.attributes.AttributesSchema;
import org.gradle.api.internal.artifacts.transform.ArtifactAttributeMatcher;
import org.gradle.api.internal.artifacts.transform.ArtifactTransformRegistration;
import org.gradle.api.internal.artifacts.transform.ArtifactTransformRegistrationsInternal;

public class ArtifactAttributeMatchingCache {
    private final ArtifactAttributeMatcher attributeMatcher;
    private final ArtifactTransformRegistrationsInternal artifactTransformRegistrations;
    private final Map<AttributeContainer, AttributeSpecificCache> attributeSpecificCache = Maps.newConcurrentMap();
    private static final Transformer<List<File>, File> NO_TRANSFORM = new Transformer<List<File>, File>(){

        public List<File> transform(File file) {
            return null;
        }
    };

    public ArtifactAttributeMatchingCache(ArtifactTransformRegistrations artifactTransformRegistrations, AttributesSchema schema) {
        this.attributeMatcher = new ArtifactAttributeMatcher(schema);
        this.artifactTransformRegistrations = (ArtifactTransformRegistrationsInternal)artifactTransformRegistrations;
    }

    boolean areMatchingAttributes(AttributeContainer artifact, AttributeContainer target) {
        return this.matchAttributes(artifact, target, false);
    }

    Transformer<List<File>, File> getTransform(AttributeContainer artifact, AttributeContainer target) {
        AttributeSpecificCache toCache = this.getCache(target.getAttributes());
        Transformer<List<File>, File> transformer = (Transformer<List<File>, File>)toCache.transforms.get(target);
        if (transformer == null) {
            for (ArtifactTransformRegistration transformReg : this.artifactTransformRegistrations.getTransforms()) {
                if (!this.matchAttributes(transformReg.from, artifact, true) || !this.matchAttributes(transformReg.to, target, true)) continue;
                transformer = transformReg.getTransform();
                toCache.transforms.put(artifact.getAttributes(), transformer == null ? NO_TRANSFORM : transformer);
                return transformer;
            }
        }
        return transformer == NO_TRANSFORM ? null : transformer;
    }

    private AttributeSpecificCache getCache(AttributeContainer attributes) {
        AttributeSpecificCache cache = this.attributeSpecificCache.get(attributes);
        if (cache == null) {
            cache = new AttributeSpecificCache();
            this.attributeSpecificCache.put(attributes, cache);
        }
        return cache;
    }

    private boolean matchAttributes(AttributeContainer artifact, AttributeContainer target, boolean incompleteCandidate) {
        Map cache = incompleteCandidate ? this.getCache(target).partialMatches : this.getCache(target).exactMatches;
        Boolean match = (Boolean)cache.get(artifact);
        if (match == null) {
            match = this.attributeMatcher.attributesMatch(artifact, target, incompleteCandidate);
            cache.put(artifact, match);
        }
        return match;
    }

    List<ResolvedArtifact> getTransformedArtifacts(ResolvedArtifact artifact, AttributeContainer target) {
        return (List)this.getCache(target).transformedArtifacts.get(artifact);
    }

    void putTransformedArtifact(ResolvedArtifact artifact, AttributeContainer target, List<ResolvedArtifact> transformResults) {
        this.getCache(target).transformedArtifacts.put(artifact, transformResults);
    }

    List<File> getTransformedFile(File file, AttributeContainer target) {
        return (List)this.getCache(target).transformedFiles.get(file);
    }

    void putTransformedFile(File file, AttributeContainer target, List<File> transformResults) {
        this.getCache(target).transformedFiles.put(file, transformResults);
    }

    private static class AttributeSpecificCache {
        private final Map<AttributeContainer, Boolean> exactMatches = Maps.newConcurrentMap();
        private final Map<AttributeContainer, Boolean> partialMatches = Maps.newConcurrentMap();
        private final Map<AttributeContainer, Transformer<List<File>, File>> transforms = Maps.newConcurrentMap();
        private final Map<File, List<File>> transformedFiles = Maps.newConcurrentMap();
        private final Map<ResolvedArtifact, List<ResolvedArtifact>> transformedArtifacts = Maps.newConcurrentMap();

        private AttributeSpecificCache() {
        }
    }
}

