/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.composite.internal;

import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import org.gradle.api.GradleException;
import org.gradle.api.artifacts.component.BuildIdentifier;
import org.gradle.composite.internal.CompositeProjectComponentArtifactMetadata;
import org.gradle.initialization.IncludedBuildExecuter;
import org.gradle.initialization.ReportedException;
import org.gradle.internal.component.model.ComponentArtifactMetadata;
import org.gradle.internal.exceptions.Contextual;
import org.gradle.internal.exceptions.LocationAwareException;

class IncludedBuildArtifactBuilder {
    private final Multimap<BuildIdentifier, String> tasksForBuild = LinkedHashMultimap.create();
    private final IncludedBuildExecuter includedBuildExecuter;

    IncludedBuildArtifactBuilder(IncludedBuildExecuter includedBuildExecuter) {
        this.includedBuildExecuter = includedBuildExecuter;
    }

    public void willBuild(ComponentArtifactMetadata artifact) {
        if (artifact instanceof CompositeProjectComponentArtifactMetadata) {
            CompositeProjectComponentArtifactMetadata compositeBuildArtifact = (CompositeProjectComponentArtifactMetadata)artifact;
            BuildIdentifier buildId = this.getBuildIdentifier(compositeBuildArtifact);
            this.addTasksForBuild(buildId, compositeBuildArtifact);
        }
    }

    public void build(BuildIdentifier requestingBuild, ComponentArtifactMetadata artifact) {
        if (artifact instanceof CompositeProjectComponentArtifactMetadata) {
            CompositeProjectComponentArtifactMetadata compositeBuildArtifact = (CompositeProjectComponentArtifactMetadata)artifact;
            BuildIdentifier buildId = this.getBuildIdentifier(compositeBuildArtifact);
            Collection<String> tasksToExecute = this.addTasksForBuild(buildId, compositeBuildArtifact);
            this.execute(requestingBuild, buildId, tasksToExecute);
        }
    }

    private void execute(BuildIdentifier requestingBuild, BuildIdentifier targetBuild, Collection<String> tasksToExecute) {
        try {
            this.includedBuildExecuter.execute(requestingBuild, targetBuild, tasksToExecute);
        }
        catch (ReportedException e) {
            throw this.contextualizeFailure(targetBuild, e);
        }
    }

    private synchronized Collection<String> addTasksForBuild(BuildIdentifier buildId, CompositeProjectComponentArtifactMetadata compositeBuildArtifact) {
        this.tasksForBuild.putAll((Object)buildId, compositeBuildArtifact.getTasks());
        return this.tasksForBuild.get((Object)buildId);
    }

    private BuildIdentifier getBuildIdentifier(CompositeProjectComponentArtifactMetadata artifact) {
        return artifact.getComponentId().getBuild();
    }

    private RuntimeException contextualizeFailure(BuildIdentifier buildId, ReportedException e) {
        if (e.getCause() instanceof LocationAwareException) {
            LocationAwareException lae = (LocationAwareException)e.getCause();
            IncludedBuildArtifactException wrappedCause = new IncludedBuildArtifactException("Failed to build artifacts for " + buildId, lae.getCause());
            LocationAwareException newLae = new LocationAwareException((Throwable)((Object)wrappedCause), lae.getSourceDisplayName(), lae.getLineNumber());
            return new ReportedException((Throwable)newLae);
        }
        return e;
    }

    @Contextual
    private static class IncludedBuildArtifactException
    extends GradleException {
        public IncludedBuildArtifactException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

