/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.ListCellRenderer;
import javax.swing.TransferHandler;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionListener;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.util.Log;

public class PingPongList<E>
extends JPanel {
    private MyListModel<E> leftModel;
    private MyListModel<E> rightModel;
    private JList<E> left;
    private JList<E> right;
    private JLabel leftLabel;
    private JLabel rightLabel;
    private JPanel leftPanel;
    private JPanel rightPanel;
    private JButton selectAllButton;
    private JButton selectNoneButton;
    private Box buttonsBox;

    public PingPongList(List<E> list, List<E> list2) {
        this(1, list, list2);
    }

    public PingPongList(int n, List<E> list, List<E> list2) {
        super(new BorderLayout());
        JSplitPane jSplitPane = new JSplitPane(n);
        this.leftModel = new MyListModel(list);
        this.left = new JList<E>(this.leftModel);
        this.rightModel = new MyListModel(list2);
        this.right = new JList<E>(this.rightModel);
        this.leftPanel = new JPanel(new BorderLayout());
        this.rightPanel = new JPanel(new BorderLayout());
        JScrollPane jScrollPane = new JScrollPane(this.left);
        JScrollPane jScrollPane2 = new JScrollPane(this.right);
        this.leftPanel.add(jScrollPane);
        this.rightPanel.add(jScrollPane2);
        jSplitPane.setLeftComponent(this.leftPanel);
        jSplitPane.setRightComponent(this.rightPanel);
        this.left.setDragEnabled(true);
        this.right.setDragEnabled(true);
        MyTransferHandler myTransferHandler = new MyTransferHandler();
        this.left.setTransferHandler(myTransferHandler);
        this.right.setTransferHandler(myTransferHandler);
        jSplitPane.setDividerLocation(0.5);
        this.buttonsBox = Box.createHorizontalBox();
        this.buttonsBox.add(Box.createHorizontalStrut(12));
        ActionHandler actionHandler = new ActionHandler();
        this.selectAllButton = new JButton(jEdit.getProperty("common.selectAll"));
        this.selectAllButton.addActionListener(actionHandler);
        this.selectAllButton.setEnabled(this.getLeftSize() != 0);
        this.buttonsBox.add(this.selectAllButton);
        this.buttonsBox.add(Box.createHorizontalStrut(12));
        this.selectNoneButton = new JButton(jEdit.getProperty("common.selectNone"));
        this.selectNoneButton.addActionListener(actionHandler);
        this.selectNoneButton.setEnabled(this.getRightSize() != 0);
        this.buttonsBox.add(this.selectNoneButton);
        this.buttonsBox.add(Box.createHorizontalStrut(12));
        this.add((Component)jSplitPane, "Center");
        this.add((Component)this.buttonsBox, "South");
        MyListDataListener myListDataListener = new MyListDataListener();
        this.leftModel.addListDataListener(myListDataListener);
        this.rightModel.addListDataListener(myListDataListener);
    }

    public void addButton(JButton jButton) {
        if (jButton != null) {
            this.buttonsBox.add(Box.createHorizontalStrut(12));
            this.buttonsBox.add(jButton);
        }
    }

    public void setLeftData(List<E> list) {
        this.leftModel = new MyListModel(list);
        this.left.setModel(this.leftModel);
    }

    public void setRightData(List<E> list) {
        this.rightModel = new MyListModel(list);
        this.right.setModel(this.rightModel);
    }

    public void setLeftSelected(E e) {
        if (e != null) {
            this.left.setSelectedValue(e, true);
        }
    }

    public List<E> getLeftSelectedValues() {
        return this.left.getSelectedValuesList();
    }

    public void setRightSelected(E e) {
        if (e != null) {
            this.right.setSelectedValue(e, true);
        }
    }

    public List<E> getRightSelectedValues() {
        return this.right.getSelectedValuesList();
    }

    public void setLeftTooltip(String string) {
        this.left.setToolTipText(string);
    }

    public void setRightTooltip(String string) {
        this.right.setToolTipText(string);
    }

    public void setLeftTitle(String string) {
        if (string == null) {
            this.removeLeftTitle();
            return;
        }
        if (this.leftLabel == null) {
            this.leftLabel = new JLabel();
        }
        this.leftLabel.setText(string);
        this.leftPanel.add((Component)this.leftLabel, "North");
    }

    public void setRightTitle(String string) {
        if (string == null) {
            this.removeRightTitle();
            return;
        }
        if (this.rightLabel == null) {
            this.rightLabel = new JLabel();
        }
        this.rightLabel.setText(string);
        this.rightPanel.add((Component)this.rightLabel, "North");
    }

    public void removeLeftTitle() {
        if (this.leftLabel != null) {
            this.leftPanel.remove(this.leftLabel);
            this.leftLabel = null;
        }
    }

    public void removeRightTitle() {
        if (this.rightLabel != null) {
            this.rightPanel.remove(this.rightLabel);
            this.rightLabel = null;
        }
    }

    public int getLeftSize() {
        return this.leftModel.getSize();
    }

    public int getRightSize() {
        return this.rightModel.getSize();
    }

    public Iterator<E> getLeftDataIterator() {
        return this.leftModel.iterator();
    }

    public Iterator<E> getRightDataIterator() {
        return this.rightModel.iterator();
    }

    public void moveAllToLeft() {
        this.leftModel.addAll(((MyListModel)this.rightModel).data);
        this.rightModel.clear();
    }

    public void moveAllToRight() {
        this.rightModel.addAll(((MyListModel)this.leftModel).data);
        this.leftModel.clear();
    }

    public void setLeftCellRenderer(ListCellRenderer<E> listCellRenderer) {
        if (listCellRenderer != null) {
            this.left.setCellRenderer(listCellRenderer);
        }
    }

    public void setRightCellRenderer(ListCellRenderer<E> listCellRenderer) {
        if (listCellRenderer != null) {
            this.right.setCellRenderer(listCellRenderer);
        }
    }

    public void addLeftListSelectionListener(ListSelectionListener listSelectionListener) {
        if (listSelectionListener != null) {
            this.left.addListSelectionListener(listSelectionListener);
        }
    }

    public void addRightListSelectionListener(ListSelectionListener listSelectionListener) {
        if (listSelectionListener != null) {
            this.right.addListSelectionListener(listSelectionListener);
        }
    }

    private class MyListDataListener
    implements ListDataListener {
        private MyListDataListener() {
        }

        @Override
        public void intervalAdded(ListDataEvent listDataEvent) {
            this.dataUpdated();
        }

        @Override
        public void intervalRemoved(ListDataEvent listDataEvent) {
            this.dataUpdated();
        }

        @Override
        public void contentsChanged(ListDataEvent listDataEvent) {
            this.dataUpdated();
        }

        private void dataUpdated() {
            PingPongList.this.selectAllButton.setEnabled(PingPongList.this.getLeftSize() != 0);
            PingPongList.this.selectNoneButton.setEnabled(PingPongList.this.getRightSize() != 0);
        }
    }

    private class ActionHandler
    implements ActionListener {
        private ActionHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == PingPongList.this.selectAllButton) {
                PingPongList.this.moveAllToRight();
                PingPongList.this.selectAllButton.setEnabled(false);
                PingPongList.this.selectNoneButton.setEnabled(true);
            } else if (object == PingPongList.this.selectNoneButton) {
                PingPongList.this.moveAllToLeft();
                PingPongList.this.selectAllButton.setEnabled(true);
                PingPongList.this.selectNoneButton.setEnabled(false);
            }
        }
    }

    private static class MyTransferable<E>
    implements Transferable {
        public static final DataFlavor javaListFlavor = new DataFlavor(Collection.class, "java.util.Collection");
        private final E[] data;

        private MyTransferable(E[] EArray) {
            this.data = Arrays.copyOf(EArray, EArray.length);
        }

        private MyTransferable(List<E> list) {
            this.data = list.toArray();
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return new DataFlavor[]{javaListFlavor};
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
            return dataFlavor.equals(javaListFlavor);
        }

        @Override
        public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
            return this.data;
        }
    }

    private class MyTransferHandler
    extends TransferHandler {
        private JList<E> sourceList;
        private int[] indices;

        private MyTransferHandler() {
        }

        @Override
        public int getSourceActions(JComponent jComponent) {
            return 2;
        }

        @Override
        public boolean importData(JComponent jComponent, Transferable transferable) {
            try {
                Object[] objectArray = (Object[])transferable.getTransferData(MyTransferable.javaListFlavor);
                JList jList = (JList)jComponent;
                MyListModel myListModel = (MyListModel)jList.getModel();
                MyListModel myListModel2 = (MyListModel)this.sourceList.getModel();
                int n = jList.getSelectedIndex();
                if (n == -1) {
                    n = 0;
                }
                myListModel.add(n, objectArray);
                int n2 = n;
                if (jList == this.sourceList) {
                    int n3;
                    for (n3 = this.indices.length - 1; n3 >= 0; --n3) {
                        int n4 = this.indices[n3];
                        if (this.indices[n3] >= n) {
                            n4 += objectArray.length;
                        } else {
                            --n2;
                        }
                        myListModel2.remove(n4);
                    }
                    for (n3 = this.indices.length - 1; n3 >= 0; --n3) {
                        this.indices[n3] = n2 + n3;
                    }
                } else {
                    this.sourceList.clearSelection();
                    for (int i = this.indices.length - 1; i >= 0; --i) {
                        myListModel2.remove(this.indices[i]);
                        this.indices[i] = n + i;
                    }
                }
                jList.setSelectedIndices(this.indices);
                return true;
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
                Log.log(9, this, unsupportedFlavorException);
            }
            catch (IOException iOException) {
                Log.log(9, this, iOException);
            }
            return false;
        }

        @Override
        protected Transferable createTransferable(JComponent jComponent) {
            this.sourceList = (JList)jComponent;
            this.indices = this.sourceList.getSelectedIndices();
            return new MyTransferable(this.sourceList.getSelectedValuesList());
        }

        @Override
        public boolean canImport(JComponent jComponent, DataFlavor[] dataFlavorArray) {
            return jComponent == PingPongList.this.left || jComponent == PingPongList.this.right;
        }
    }

    private static class MyListModel<E>
    extends AbstractListModel<E>
    implements Iterable<E> {
        private List<E> data;

        private MyListModel(List<E> list) {
            this.data = list;
        }

        @Override
        public int getSize() {
            return this.data.size();
        }

        @Override
        public E getElementAt(int n) {
            return this.data.get(n);
        }

        @Override
        public Iterator<E> iterator() {
            return this.data.iterator();
        }

        public void clear() {
            if (this.data.isEmpty()) {
                return;
            }
            int n = this.data.size();
            this.data.clear();
            this.fireIntervalRemoved(this, 0, n - 1);
        }

        public void addAll(Collection<E> collection) {
            int n = this.data.size();
            this.data.addAll(collection);
            this.fireIntervalAdded(this, n, n + collection.size() - 1);
        }

        public void remove(int n) {
            this.data.remove(n);
            this.fireContentsChanged(this, n, n);
        }

        public void add(int n, E[] EArray) {
            for (int i = EArray.length - 1; i >= 0; --i) {
                this.data.add(n, EArray[i]);
            }
            this.fireContentsChanged(this, n, n + EArray.length - 1);
        }
    }
}

