/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.net.URL;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javajs.J2SIgnoreImport;
import javajs.api.GenericCifDataParser;
import javajs.api.GenericMenuInterface;
import javajs.api.GenericMouseInterface;
import javajs.api.GenericPlatform;
import javajs.api.GenericZipTools;
import javajs.api.PlatformViewer;
import javajs.awt.Dimension;
import javajs.awt.Font;
import javajs.util.AU;
import javajs.util.CU;
import javajs.util.DF;
import javajs.util.JSJSONParser;
import javajs.util.Lst;
import javajs.util.M3;
import javajs.util.M4;
import javajs.util.Measure;
import javajs.util.OC;
import javajs.util.P3;
import javajs.util.P3i;
import javajs.util.P4;
import javajs.util.PT;
import javajs.util.Quat;
import javajs.util.Rdr;
import javajs.util.SB;
import javajs.util.T3;
import javajs.util.V3;
import org.jmol.adapter.readers.quantum.NBOParser;
import org.jmol.adapter.smarter.SmarterJmolAdapter;
import org.jmol.api.AtomIndexIterator;
import org.jmol.api.Interface;
import org.jmol.api.JmolAdapter;
import org.jmol.api.JmolAnnotationParser;
import org.jmol.api.JmolAppConsoleInterface;
import org.jmol.api.JmolCallbackListener;
import org.jmol.api.JmolDataManager;
import org.jmol.api.JmolJSpecView;
import org.jmol.api.JmolNMRInterface;
import org.jmol.api.JmolPropertyManager;
import org.jmol.api.JmolRendererInterface;
import org.jmol.api.JmolRepaintManager;
import org.jmol.api.JmolScriptEditorInterface;
import org.jmol.api.JmolScriptEvaluator;
import org.jmol.api.JmolScriptFunction;
import org.jmol.api.JmolScriptManager;
import org.jmol.api.JmolSelectionListener;
import org.jmol.api.JmolStatusListener;
import org.jmol.api.JmolViewer;
import org.jmol.api.SmilesMatcherInterface;
import org.jmol.api.SymmetryInterface;
import org.jmol.atomdata.AtomData;
import org.jmol.atomdata.AtomDataServer;
import org.jmol.atomdata.RadiusData;
import org.jmol.c.FIL;
import org.jmol.c.STER;
import org.jmol.c.STR;
import org.jmol.c.VDW;
import org.jmol.i18n.GT;
import org.jmol.java.BS;
import org.jmol.minimize.Minimizer;
import org.jmol.modelset.Atom;
import org.jmol.modelset.Bond;
import org.jmol.modelset.MeasurementData;
import org.jmol.modelset.MeasurementPending;
import org.jmol.modelset.ModelSet;
import org.jmol.modelset.Orientation;
import org.jmol.modelset.StateScript;
import org.jmol.modelsetbio.BioResolver;
import org.jmol.script.SV;
import org.jmol.script.ScriptContext;
import org.jmol.script.T;
import org.jmol.thread.TimeoutThread;
import org.jmol.util.BSUtil;
import org.jmol.util.BoxInfo;
import org.jmol.util.C;
import org.jmol.util.CommandHistory;
import org.jmol.util.Elements;
import org.jmol.util.Escape;
import org.jmol.util.GData;
import org.jmol.util.JmolMolecule;
import org.jmol.util.Logger;
import org.jmol.util.Node;
import org.jmol.util.Parser;
import org.jmol.util.Rectangle;
import org.jmol.util.TempArray;
import org.jmol.util.Triangulator;
import org.jmol.viewer.ActionManager;
import org.jmol.viewer.AnimationManager;
import org.jmol.viewer.ColorManager;
import org.jmol.viewer.FileManager;
import org.jmol.viewer.GlobalSettings;
import org.jmol.viewer.JC;
import org.jmol.viewer.JmolAsyncException;
import org.jmol.viewer.JmolChimeMessenger;
import org.jmol.viewer.JmolStateCreator;
import org.jmol.viewer.ModelManager;
import org.jmol.viewer.OutputManager;
import org.jmol.viewer.SelectionManager;
import org.jmol.viewer.ShapeManager;
import org.jmol.viewer.StateManager;
import org.jmol.viewer.StatusManager;
import org.jmol.viewer.TransformManager;
import org.jmol.viewer.binding.Binding;

@J2SIgnoreImport(value={Runtime.class})
public class Viewer
extends JmolViewer
implements AtomDataServer,
PlatformViewer {
    public boolean testAsync;
    public boolean autoExit = false;
    public boolean haveDisplay = false;
    public boolean isJS;
    public boolean isWebGL;
    public boolean isSingleThreaded;
    public boolean queueOnHold = false;
    public String fullName = "";
    public static String appletDocumentBase = "";
    public static String appletCodeBase = "";
    public static String appletIdiomaBase;
    public static String jsDocumentBase;
    public Object compiler;
    public Map<String, Object> definedAtomSets;
    public ModelSet ms;
    public FileManager fm;
    public boolean isApplet;
    public boolean isJNLP;
    public boolean isSyntaxAndFileCheck = false;
    public boolean isSyntaxCheck = false;
    public boolean listCommands = false;
    boolean mustRender = false;
    public String htmlName = "";
    public String appletName = "";
    public int tryPt;
    private String insertedCommand = "";
    public GData gdata;
    public Object html5Applet;
    public ActionManager acm;
    public AnimationManager am;
    public ColorManager cm;
    JmolDataManager dm;
    public ShapeManager shm;
    public SelectionManager slm;
    JmolRepaintManager rm;
    public GlobalSettings g;
    public StatusManager sm;
    public TransformManager tm;
    public static String strJavaVendor;
    public static String strOSName;
    public static String strJavaVersion;
    String syncId = "";
    String logFilePath = "";
    private boolean allowScripting;
    public boolean isPrintOnly;
    public boolean isSignedApplet = false;
    private boolean isSignedAppletLocal = false;
    private boolean isSilent;
    private boolean multiTouch;
    public boolean noGraphicsAllowed;
    private boolean useCommandThread = false;
    private String commandOptions;
    public Map<String, Object> vwrOptions;
    public Object display;
    private JmolAdapter modelAdapter;
    private ACCESS access;
    private CommandHistory commandHistory;
    public ModelManager mm;
    public StateManager stm;
    private JmolScriptManager scm;
    public JmolScriptEvaluator eval;
    private TempArray tempArray;
    public boolean allowArrayDotNotation;
    public boolean async;
    public Object executor;
    private static String version_date;
    final Dimension dimScreen;
    final Lst<String> actionStates;
    final Lst<String> actionStatesRedo;
    VDW defaultVdw;
    public RadiusData rd;
    public Map<Object, Object> chainMap;
    private Lst<String> chainList;
    private String errorMessage;
    private String errorMessageUntranslated;
    private double privateKey;
    private boolean dataOnly;
    public boolean isPreviewOnly;
    public boolean headless;
    public BS movableBitSet;
    private GenericMouseInterface mouse;
    Map<String, Object> ligandModels;
    Map<String, Boolean> ligandModelSet;
    private JmolAnnotationParser annotationParser;
    private JmolAnnotationParser dssrParser;
    private Minimizer minimizer;
    private SmilesMatcherInterface smilesMatcher;
    JmolStateCreator jsc;
    private Object[] lastData;
    private int motionEventNumber;
    private boolean inMotion;
    private boolean refreshing = true;
    private boolean axesAreTainted = false;
    private int maximumSize = Integer.MAX_VALUE;
    private Object gRight;
    private boolean isStereoSlave;
    public float imageFontScaling = 1.0f;
    public Map<String, Object> captureParams;
    private Map<String, Object> jsParams;
    public boolean antialiased;
    private int hoverAtomIndex = -1;
    private String hoverText;
    private String hoverLabel = "%U";
    private boolean hoverEnabled = true;
    int currentCursor = 0;
    private P3 ptTemp;
    private int prevFrame = Integer.MIN_VALUE;
    private float prevMorphModel;
    private boolean haveJDX;
    private JmolJSpecView jsv;
    private boolean selectionHalosEnabled = false;
    public boolean frankOn = true;
    public boolean noFrankEcho = true;
    public boolean scriptEditorVisible;
    public JmolAppConsoleInterface appConsole;
    JmolScriptEditorInterface scriptEditor;
    GenericMenuInterface jmolpopup;
    private GenericMenuInterface modelkitPopup;
    private Map<String, Object> headlessImageParams;
    JmolPropertyManager pm;
    boolean isTainted = true;
    private boolean movingSelected;
    private boolean showSelected;
    private int rotateBondIndex = -1;
    private int rotatePrev1 = -1;
    private int rotatePrev2 = -1;
    private BS bsRotateBranch;
    public boolean creatingImage;
    private OutputManager outputManager;
    public static final String SYNC_GRAPHICS_MESSAGE = "GET_GRAPHICS";
    public static final String SYNC_NO_GRAPHICS_MESSAGE = "SET_GRAPHICS_OFF";
    BS bsUserVdws;
    float[] userVdws;
    int[] userVdwMars;
    private int currentShapeID = -1;
    private String currentShapeState;
    static final Map<String, JmolScriptFunction> staticFunctions;
    Map<String, JmolScriptFunction> localFunctions;
    boolean isKiosk;
    public static int nProcessors;
    public boolean displayLoadErrors = true;
    private boolean isParallel;
    public int stateScriptVersionInt;
    private JmolRendererInterface jsExporter3D;
    public Map<String, Object> timeouts;
    private boolean chainCaseSpecified;
    JmolNMRInterface nmrCalculation;
    String logFileName;
    private GenericZipTools jzt;
    BioResolver jbr;
    private JmolChimeMessenger jcm;
    private JSJSONParser jsonParser;
    private Triangulator triangulator;
    private NBOParser nboParser;

    protected void finalize() throws Throwable {
        if (Logger.debugging) {
            Logger.debug("vwr finalize " + this);
        }
        super.finalize();
    }

    public void setInsertedCommand(String strScript) {
        this.insertedCommand = strScript;
    }

    public static String getJmolVersion() {
        return version_date == null ? (version_date = JC.version + "  " + JC.date) : version_date;
    }

    protected static JmolViewer allocateViewer(Object display, JmolAdapter modelAdapter, String fullName, URL documentBase, URL codeBase, String commandOptions, JmolStatusListener statusListener, GenericPlatform implementedPlatform) {
        Hashtable<String, Object> info = new Hashtable<String, Object>();
        info.put("display", display);
        info.put("adapter", modelAdapter);
        info.put("statusListener", statusListener);
        info.put("platform", implementedPlatform);
        info.put("options", commandOptions);
        info.put("fullName", fullName);
        info.put("documentBase", documentBase);
        info.put("codeBase", codeBase);
        return new Viewer(info);
    }

    public Viewer(Map<String, Object> info) {
        this.commandHistory = new CommandHistory();
        this.dimScreen = new Dimension(0, 0);
        this.rd = new RadiusData(null, 0.0f, null, null);
        this.defaultVdw = VDW.JMOL;
        this.localFunctions = new Hashtable<String, JmolScriptFunction>();
        this.privateKey = Math.random();
        this.actionStates = new Lst();
        this.actionStatesRedo = new Lst();
        this.chainMap = new Hashtable<Object, Object>();
        this.chainList = new Lst();
        this.setOptions(info);
    }

    public boolean haveAccess(ACCESS a) {
        return this.access == a;
    }

    @Override
    public JmolAdapter getModelAdapter() {
        return this.modelAdapter == null ? (this.modelAdapter = new SmarterJmolAdapter()) : this.modelAdapter;
    }

    @Override
    public BS getSmartsMatch(String smarts, BS bsSelected) throws Exception {
        if (bsSelected == null) {
            bsSelected = this.bsA();
        }
        return this.getSmilesMatcher().getSubstructureSet(smarts, this.ms.at, this.ms.ac, bsSelected, 2);
    }

    public void setOptions(Map<String, Object> info) {
        Object o;
        this.vwrOptions = info;
        if (Logger.debugging) {
            Logger.debug("Viewer constructor " + this);
        }
        this.modelAdapter = (JmolAdapter)info.get("adapter");
        JmolStatusListener statusListener = (JmolStatusListener)info.get("statusListener");
        this.fullName = (String)info.get("fullName");
        if (this.fullName == null) {
            this.fullName = "";
        }
        if ((o = info.get("codePath")) == null) {
            o = "../java/";
        }
        appletCodeBase = o.toString();
        appletIdiomaBase = appletCodeBase.substring(0, appletCodeBase.lastIndexOf("/", appletCodeBase.length() - 2) + 1) + "idioma";
        o = info.get("documentBase");
        appletDocumentBase = o == null ? "" : o.toString();
        o = info.get("options");
        String string = this.commandOptions = o == null ? "" : o.toString();
        if (info.containsKey("debug") || this.commandOptions.indexOf("-debug") >= 0) {
            Logger.setLogLevel(5);
        }
        if (this.isApplet && info.containsKey("maximumSize")) {
            this.setMaximumSize((Integer)info.get("maximumSize"));
        }
        this.isJNLP = this.checkOption2("isJNLP", "-jnlp");
        if (this.isJNLP) {
            Logger.info("setting JNLP mode TRUE");
        }
        this.isSignedApplet = this.isJNLP || this.checkOption2("signedApplet", "-signed");
        this.isApplet = this.isSignedApplet || this.checkOption2("applet", "-applet");
        this.allowScripting = !this.checkOption2("noscripting", "-noscripting");
        int i = this.fullName.indexOf("__");
        this.htmlName = i < 0 ? this.fullName : this.fullName.substring(0, i);
        this.appletName = PT.split(this.htmlName + "_", "_")[0];
        String string2 = this.syncId = i < 0 ? "" : this.fullName.substring(i + 2, this.fullName.length() - 2);
        this.access = this.checkOption2("access:READSPT", "-r") ? ACCESS.READSPT : (this.checkOption2("access:NONE", "-R") ? ACCESS.NONE : ACCESS.ALL);
        this.isPreviewOnly = info.containsKey("previewOnly");
        if (this.isPreviewOnly) {
            info.remove("previewOnly");
        }
        this.isPrintOnly = this.checkOption2("printOnly", "-p");
        this.dataOnly = this.checkOption2("isDataOnly", "\u0000");
        this.autoExit = this.checkOption2("exit", "-x");
        o = info.get("platform");
        String platform = "unknown";
        if (o == null) {
            Object object = o = this.commandOptions.contains("platform=") ? this.commandOptions.substring(this.commandOptions.indexOf("platform=") + 9) : "org.jmol.awt.Platform";
        }
        if (o instanceof String) {
            platform = (String)o;
            this.isWebGL = platform.indexOf(".awtjs.") >= 0;
            this.isJS = this.isWebGL || platform.indexOf(".awtjs2d.") >= 0;
            this.async = !this.dataOnly && !this.autoExit && (this.testAsync || this.isJS && info.containsKey("async"));
            Object applet = null;
            String javaver = "?";
            javaver = null;
            if (javaver != null) {
                this.html5Applet = applet;
                strJavaVersion = javaver;
                strJavaVendor = "Java2Script " + (this.isWebGL ? "(WebGL)" : "(HTML5)");
            }
            o = Interface.getInterface(platform, this, "setOptions");
        }
        this.apiPlatform = (GenericPlatform)o;
        this.display = info.get("display");
        this.isSingleThreaded = this.apiPlatform.isSingleThreaded();
        this.noGraphicsAllowed = this.checkOption2("noDisplay", "-n");
        this.headless = this.apiPlatform.isHeadless();
        this.haveDisplay = this.isWebGL || this.display != null && !this.noGraphicsAllowed && !this.headless && !this.dataOnly;
        this.noGraphicsAllowed &= this.display == null;
        this.headless |= this.noGraphicsAllowed;
        if (this.haveDisplay) {
            this.mustRender = true;
            this.multiTouch = this.checkOption2("multiTouch", "-multitouch");
        } else {
            this.display = null;
        }
        this.apiPlatform.setViewer(this, this.display);
        o = info.get("graphicsAdapter");
        if (o == null && !this.isWebGL) {
            o = Interface.getOption("g3d.Graphics3D", this, "setOptions");
        }
        this.gdata = o == null && (this.isWebGL || !this.isJS) ? new GData() : (GData)o;
        this.gdata.initialize(this, this.apiPlatform);
        this.stm = new StateManager(this);
        this.cm = new ColorManager(this, this.gdata);
        this.sm = new StatusManager(this);
        boolean is4D = info.containsKey("4DMouse");
        this.tm = TransformManager.getTransformManager(this, Integer.MAX_VALUE, 0, is4D);
        this.slm = new SelectionManager(this);
        if (this.haveDisplay) {
            this.acm = this.multiTouch ? (ActionManager)Interface.getOption("multitouch.ActionManagerMT", null, null) : new ActionManager();
            this.acm.setViewer(this, this.commandOptions + "-multitouch-" + info.get("multiTouch"));
            this.mouse = this.apiPlatform.getMouseManager(this.privateKey, this.display);
            if (this.multiTouch && !this.checkOption2("-simulated", "-simulated")) {
                this.apiPlatform.setTransparentCursor(this.display);
            }
        }
        this.mm = new ModelManager(this);
        this.shm = new ShapeManager(this);
        this.tempArray = new TempArray();
        this.am = new AnimationManager(this);
        o = info.get("repaintManager");
        if (o == null) {
            o = Interface.getOption("render.RepaintManager", this, "setOptions");
        }
        if (this.isJS || o != null && !o.equals("")) {
            this.rm = (JmolRepaintManager)o;
            this.rm.set(this, this.shm);
        }
        this.ms = new ModelSet(this, null);
        this.initialize(true, false);
        this.fm = new FileManager(this);
        this.definedAtomSets = new Hashtable<String, Object>();
        this.setJmolStatusListener(statusListener);
        if (this.isApplet) {
            Logger.info("vwrOptions: \n" + Escape.escapeMap(this.vwrOptions));
            String path = (String)this.vwrOptions.get("documentLocation");
            if (!this.isJS && path != null && path.startsWith("file:/")) {
                path = path.substring(0, path.substring(0, (path + "?").indexOf("?")).lastIndexOf("/"));
                Logger.info("setting current directory to " + path);
                this.cd(path);
            }
            if ((i = (path = appletDocumentBase).indexOf("#")) >= 0) {
                path = path.substring(0, i);
            }
            if ((i = path.lastIndexOf("?")) >= 0) {
                path = path.substring(0, i);
            }
            if ((i = path.lastIndexOf("/")) >= 0) {
                path = path.substring(0, i);
            }
            jsDocumentBase = path;
            this.fm.setAppletContext(appletDocumentBase);
            String appletProxy = (String)info.get("appletProxy");
            if (appletProxy != null) {
                this.setStringProperty("appletProxy", appletProxy);
            }
            if (this.isSignedApplet) {
                this.logFilePath = PT.rep(appletCodeBase, "file://", "");
                this.logFilePath = PT.rep(this.logFilePath, "file:/", "");
                if (this.logFilePath.indexOf("//") >= 0) {
                    this.logFilePath = null;
                } else {
                    this.isSignedAppletLocal = true;
                }
            } else if (!this.isJS) {
                this.logFilePath = null;
            }
            new GT(this, (String)info.get("language"));
            if (this.isJS) {
                this.acm.createActions();
            }
        } else {
            this.gdata.setBackgroundTransparent(this.checkOption2("backgroundTransparent", "-b"));
            this.isSilent = this.checkOption2("silent", "-i");
            if (this.isSilent) {
                Logger.setLogLevel(3);
            }
            if (this.headless && !this.isSilent) {
                Logger.info("Operating headless display=" + this.display + " nographicsallowed=" + this.noGraphicsAllowed);
            }
            this.isSyntaxAndFileCheck = this.checkOption2("checkLoad", "-C");
            this.isSyntaxCheck = this.isSyntaxAndFileCheck || this.checkOption2("check", "-c");
            this.listCommands = this.checkOption2("listCommands", "-l");
            this.cd(".");
            if (this.headless) {
                this.headlessImageParams = (Map)info.get("headlessImage");
                o = info.get("headlistMaxTimeMs");
                if (o == null) {
                    o = 60000;
                }
                this.setTimeout("" + Math.random(), (Integer)o, "exitJmol");
            }
        }
        this.useCommandThread = !this.headless && this.checkOption2("useCommandThread", "-threaded");
        this.setStartupBooleans();
        this.setIntProperty("_nProcessors", nProcessors);
        if (!this.isSilent) {
            Logger.info("(C) 2015 Jmol Development\nJmol Version: " + Viewer.getJmolVersion() + "\njava.vendor: " + strJavaVendor + "\njava.version: " + strJavaVersion + "\nos.name: " + strOSName + "\nAccess: " + (Object)((Object)this.access) + "\nmemory: " + this.getP("_memory") + "\nprocessors available: " + nProcessors + "\nuseCommandThread: " + this.useCommandThread + (!this.isApplet ? "" : "\nappletId:" + this.htmlName + (this.isSignedApplet ? " (signed)" : "")));
        }
        if (this.allowScripting) {
            this.getScriptManager();
        }
        this.zap(false, true, false);
        this.g.setO("language", GT.getLanguage());
        this.g.setO("_hoverLabel", this.hoverLabel);
        this.stm.setJmolDefaults();
        Elements.covalentVersion = 1;
        this.allowArrayDotNotation = true;
    }

    public void setDisplay(Object canvas) {
        this.display = canvas;
        this.apiPlatform.setViewer(this, canvas);
    }

    public MeasurementData newMeasurementData(String id, Lst<Object> points) {
        return ((MeasurementData)Interface.getInterface("org.jmol.modelset.MeasurementData", this, "script")).init(id, this, points);
    }

    private JmolDataManager getDataManager() {
        return this.dm == null ? (this.dm = ((JmolDataManager)Interface.getInterface("org.jmol.viewer.DataManager", this, "script")).set(this)) : this.dm;
    }

    private JmolScriptManager getScriptManager() {
        if (this.allowScripting && this.scm == null) {
            this.scm = (JmolScriptManager)Interface.getInterface("org.jmol.script.ScriptManager", this, "setOptions");
            if (this.isJS && this.scm == null) {
                throw new NullPointerException();
            }
            if (this.scm == null) {
                this.allowScripting = false;
                return null;
            }
            this.eval = this.scm.setViewer(this);
            if (this.useCommandThread) {
                this.scm.startCommandWatcher(true);
            }
        }
        return this.scm;
    }

    private boolean checkOption2(String key1, String key2) {
        return this.vwrOptions.containsKey(key1) || this.commandOptions.indexOf(key2) >= 0;
    }

    private void setStartupBooleans() {
        this.setBooleanProperty("_applet", this.isApplet);
        this.setBooleanProperty("_JSpecView".toLowerCase(), false);
        this.setBooleanProperty("_signedApplet", this.isSignedApplet);
        this.setBooleanProperty("_headless", this.headless);
        this.setStringProperty("_restrict", "\"" + (Object)((Object)this.access) + "\"");
        this.setBooleanProperty("_useCommandThread", this.useCommandThread);
    }

    public String getExportDriverList() {
        return this.haveAccess(ACCESS.ALL) ? (String)this.g.getParameter("exportDrivers", true) : "";
    }

    @Override
    public void dispose() {
        this.gRight = null;
        if (this.mouse != null) {
            this.acm.dispose();
            this.mouse.dispose();
            this.mouse = null;
        }
        this.clearScriptQueue();
        this.clearThreads();
        this.haltScriptExecution();
        if (this.scm != null) {
            this.scm.clear(true);
        }
        this.gdata.destroy();
        if (this.jmolpopup != null) {
            this.jmolpopup.jpiDispose();
        }
        if (this.modelkitPopup != null) {
            this.modelkitPopup.jpiDispose();
        }
        try {
            if (this.appConsole != null) {
                this.appConsole.dispose();
                this.appConsole = null;
            }
            if (this.scriptEditor != null) {
                this.scriptEditor.dispose();
                this.scriptEditor = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void reset(boolean includingSpin) {
        this.ms.calcBoundBoxDimensions(null, 1.0f);
        this.axesAreTainted = true;
        this.tm.homePosition(includingSpin);
        if (this.ms.setCrystallographicDefaults()) {
            this.stm.setCrystallographicDefaults();
        } else {
            this.setAxesMode(603979809);
        }
        this.prevFrame = Integer.MIN_VALUE;
        if (!this.tm.spinOn) {
            this.setSync();
        }
    }

    @Override
    public void homePosition() {
        this.evalString("reset spin");
    }

    public void initialize(boolean clearUserVariables, boolean isPyMOL) {
        this.g = new GlobalSettings(this, this.g, clearUserVariables);
        this.setStartupBooleans();
        this.setWidthHeightVar();
        if (this.haveDisplay) {
            this.g.setB("_is2D", this.isJS && !this.isWebGL);
            this.g.setB("_multiTouchClient", this.acm.isMTClient());
            this.g.setB("_multiTouchServer", this.acm.isMTServer());
        }
        this.cm.setDefaultColors(false);
        this.setObjectColor("background", "black");
        this.setObjectColor("axis1", "red");
        this.setObjectColor("axis2", "green");
        this.setObjectColor("axis3", "blue");
        this.am.setAnimationOn(false);
        this.am.setAnimationFps(this.g.animationFps);
        this.sm.allowStatusReporting = this.g.statusReporting;
        this.setBooleanProperty("antialiasDisplay", isPyMOL ? true : this.g.antialiasDisplay);
        this.stm.resetLighting();
        this.tm.setDefaultPerspective();
    }

    public void setWidthHeightVar() {
        this.g.setI("_width", this.dimScreen.width);
        this.g.setI("_height", this.dimScreen.height);
    }

    void saveModelOrientation() {
        this.ms.saveModelOrientation(this.am.cmi, this.stm.getOrientation());
    }

    void restoreModelOrientation(int modelIndex) {
        Orientation o = this.ms.getModelOrientation(modelIndex);
        if (o != null) {
            o.restore(-1.0f, true);
        }
    }

    void restoreModelRotation(int modelIndex) {
        Orientation o = this.ms.getModelOrientation(modelIndex);
        if (o != null) {
            o.restore(-1.0f, false);
        }
    }

    public Object getGLmolView() {
        TransformManager tm = this.tm;
        P3 center = tm.fixedRotationCenter;
        Quat q = tm.getRotationQ();
        float xtrans = tm.xTranslationFraction;
        float ytrans = tm.yTranslationFraction;
        float scale = tm.scalePixelsPerAngstrom;
        float zoom = tm.zmPctSet;
        float cd = tm.cameraDistance;
        float pc = tm.screenPixelCount;
        boolean pd = tm.perspectiveDepth;
        int width = tm.width;
        int height = tm.height;
        return null;
    }

    public void setRotationRadius(float angstroms, boolean doAll) {
        if (doAll) {
            angstroms = this.tm.setRotationRadius(angstroms, false);
        }
        if (this.ms.setRotationRadius(this.am.cmi, angstroms)) {
            this.g.setF("rotationRadius", angstroms);
        }
    }

    public void setCenterBitSet(BS bsCenter, boolean doScale) {
        if (this.isJmolDataFrame()) {
            return;
        }
        this.tm.setNewRotationCenter(BSUtil.cardinalityOf(bsCenter) > 0 ? this.ms.getAtomSetCenter(bsCenter) : null, doScale);
    }

    public void setNewRotationCenter(P3 center) {
        if (!this.isJmolDataFrame()) {
            this.tm.setNewRotationCenter(center, true);
        }
    }

    void navigate(int keyWhere, int modifiers) {
        if (this.isJmolDataFrame()) {
            return;
        }
        this.tm.navigateKey(keyWhere, modifiers);
        if (!this.tm.vibrationOn && keyWhere != 0) {
            this.refresh(1, "Viewer:navigate()");
        }
    }

    public void move(JmolScriptEvaluator eval, V3 dRot, float dZoom, V3 dTrans, float dSlab, float floatSecondsTotal, int fps) {
        this.tm.move(eval, dRot, dZoom, dTrans, dSlab, floatSecondsTotal, fps);
        this.moveUpdate(floatSecondsTotal);
    }

    public void moveTo(JmolScriptEvaluator eval, float floatSecondsTotal, P3 center, V3 rotAxis, float degrees, M3 rotationMatrix, float zoom, float xTrans, float yTrans, float rotationRadius, P3 navCenter, float xNav, float yNav, float navDepth, float cameraDepth, float cameraX, float cameraY) {
        if (!this.haveDisplay) {
            floatSecondsTotal = 0.0f;
        }
        this.setTainted(true);
        this.tm.moveTo(eval, floatSecondsTotal, center, rotAxis, degrees, rotationMatrix, zoom, xTrans, yTrans, rotationRadius, navCenter, xNav, yNav, navDepth, cameraDepth, cameraX, cameraY);
    }

    public void moveUpdate(float floatSecondsTotal) {
        if (floatSecondsTotal > 0.0f) {
            this.requestRepaintAndWait("moveUpdate");
        } else if (floatSecondsTotal == 0.0f) {
            this.setSync();
        }
    }

    public void navigatePt(P3 center) {
        this.tm.setNavigatePt(center);
        this.setSync();
    }

    public void navigateAxis(V3 rotAxis, float degrees) {
        this.tm.navigateAxis(rotAxis, degrees);
        this.setSync();
    }

    public void navTranslatePercent(float x, float y) {
        if (this.isJmolDataFrame()) {
            return;
        }
        this.tm.navTranslatePercentOrTo(0.0f, x, y);
        this.setSync();
    }

    void zoomBy(int pixels) {
        this.tm.zoomBy(pixels);
        this.refresh(2, this.sm.syncingMouse ? "Mouse: zoomBy " + pixels : "");
    }

    void zoomByFactor(float factor, int x, int y) {
        this.tm.zoomByFactor(factor, x, y);
        this.refresh(2, !this.sm.syncingMouse ? "" : "Mouse: zoomByFactor " + factor + (x == Integer.MAX_VALUE ? "" : " " + x + " " + y));
    }

    void rotateXYBy(float degX, float degY) {
        this.tm.rotateXYBy(degX, degY, null);
        this.refresh(2, this.sm.syncingMouse ? "Mouse: rotateXYBy " + degX + " " + degY : "");
    }

    public void spinXYBy(int xDelta, int yDelta, float speed) {
        this.tm.spinXYBy(xDelta, yDelta, speed);
        if (xDelta == 0 && yDelta == 0) {
            return;
        }
        this.refresh(2, this.sm.syncingMouse ? "Mouse: spinXYBy " + xDelta + " " + yDelta + " " + speed : "");
    }

    public void rotateZBy(int zDelta, int x, int y) {
        this.tm.rotateZBy(zDelta, x, y);
        this.refresh(2, this.sm.syncingMouse ? "Mouse: rotateZBy " + zDelta + (x == Integer.MAX_VALUE ? "" : " " + x + " " + y) : "");
    }

    void rotateSelected(float deltaX, float deltaY, BS bsSelected) {
        if (this.isJmolDataFrame()) {
            return;
        }
        this.tm.rotateXYBy(deltaX, deltaY, this.setMovableBitSet(bsSelected, true));
        this.refreshMeasures(true);
        this.refresh(2, this.sm.syncingMouse ? "Mouse: rotateMolecule " + deltaX + " " + deltaY : "");
    }

    private BS setMovableBitSet(BS bsSelected, boolean checkMolecule) {
        if (bsSelected == null) {
            bsSelected = this.bsA();
        }
        bsSelected = BSUtil.copy(bsSelected);
        BSUtil.andNot(bsSelected, this.getMotionFixedAtoms());
        if (checkMolecule && !this.g.allowMoveAtoms) {
            bsSelected = this.ms.getMoleculeBitSet(bsSelected);
        }
        this.movableBitSet = bsSelected;
        return this.movableBitSet;
    }

    public void translateXYBy(int xDelta, int yDelta) {
        this.tm.translateXYBy(xDelta, yDelta);
        this.refresh(2, this.sm.syncingMouse ? "Mouse: translateXYBy " + xDelta + " " + yDelta : "");
    }

    @Override
    public void rotateFront() {
        this.tm.resetRotation();
        this.refresh(1, "Viewer:rotateFront()");
    }

    public void translate(char xyz, float x, char type, BS bsAtoms) {
        int xy;
        int n = type == '\u0000' ? (int)x : (type == '%' ? this.tm.percentToPixels(xyz, x) : (xy = this.tm.angstromsToPixels(x * (type == 'n' ? 10.0f : 1.0f))));
        if (bsAtoms != null) {
            if (xy == 0) {
                return;
            }
            this.tm.setSelectedTranslation(bsAtoms, xyz, xy);
        } else {
            switch (xyz) {
                case 'X': 
                case 'x': {
                    if (type == '\u0000') {
                        this.tm.translateToPercent('x', x);
                        break;
                    }
                    this.tm.translateXYBy(xy, 0);
                    break;
                }
                case 'Y': 
                case 'y': {
                    if (type == '\u0000') {
                        this.tm.translateToPercent('y', x);
                        break;
                    }
                    this.tm.translateXYBy(0, xy);
                    break;
                }
                case 'Z': 
                case 'z': {
                    if (type == '\u0000') {
                        this.tm.translateToPercent('z', x);
                        break;
                    }
                    this.tm.translateZBy(xy);
                }
            }
        }
        this.refresh(1, "Viewer:translate()");
    }

    void slabByPixels(int pixels) {
        this.tm.slabByPercentagePoints(pixels);
        this.refresh(3, "slabByPixels");
    }

    void depthByPixels(int pixels) {
        this.tm.depthByPercentagePoints(pixels);
        this.refresh(3, "depthByPixels");
    }

    void slabDepthByPixels(int pixels) {
        this.tm.slabDepthByPercentagePoints(pixels);
        this.refresh(3, "slabDepthByPixels");
    }

    public void finalizeTransformParameters() {
        this.tm.finalizeTransformParameters();
        this.gdata.setSlabAndZShade(this.tm.slabValue, this.tm.depthValue, this.tm.zShadeEnabled ? this.tm.zSlabValue : Integer.MAX_VALUE, this.tm.zDepthValue, this.g.zShadePower);
    }

    public float getScalePixelsPerAngstrom(boolean asAntialiased) {
        return this.tm.scalePixelsPerAngstrom * (asAntialiased || !this.antialiased ? 1.0f : 0.5f);
    }

    public void setSpin(String key, int value) {
        if (!PT.isOneOf(key, ";x;y;z;fps;X;Y;Z;FPS;")) {
            return;
        }
        int i = "x;y;z;fps;X;Y;Z;FPS".indexOf(key);
        switch (i) {
            case 0: {
                this.tm.setSpinXYZ(value, Float.NaN, Float.NaN);
                break;
            }
            case 2: {
                this.tm.setSpinXYZ(Float.NaN, value, Float.NaN);
                break;
            }
            case 4: {
                this.tm.setSpinXYZ(Float.NaN, Float.NaN, value);
                break;
            }
            default: {
                this.tm.setSpinFps(value);
                break;
            }
            case 10: {
                this.tm.setNavXYZ(value, Float.NaN, Float.NaN);
                break;
            }
            case 12: {
                this.tm.setNavXYZ(Float.NaN, value, Float.NaN);
                break;
            }
            case 14: {
                this.tm.setNavXYZ(Float.NaN, Float.NaN, value);
                break;
            }
            case 16: {
                this.tm.setNavFps(value);
            }
        }
        this.g.setI((i < 10 ? "spin" : "nav") + key, value);
    }

    public String getSpinState() {
        return this.getStateCreator().getSpinState(false);
    }

    public String getOrientationText(int type, String name) {
        switch (type) {
            case 134221850: 
            case 1073741864: 
            case 1111492629: 
            case 1111492630: 
            case 1111492631: 
            case 1312817669: {
                return this.ms.getBoundBoxOrientation(type, this.bsA());
            }
            case 1073742034: {
                return this.stm.getSavedOrientationText(name);
            }
        }
        return this.tm.getOrientationText(type);
    }

    public float[] getCurrentColorRange() {
        return this.cm.getPropertyColorRange();
    }

    private void setDefaultColors(boolean isRasmol) {
        this.cm.setDefaultColors(isRasmol);
        this.g.setB("colorRasmol", isRasmol);
        this.g.setO("defaultColorScheme", isRasmol ? "rasmol" : "jmol");
    }

    public void setElementArgb(int elementNumber, int argb) {
        this.g.setO("=color " + Elements.elementNameFromNumber(elementNumber), Escape.escapeColor(argb));
        this.cm.setElementArgb(elementNumber, argb);
    }

    @Override
    public void setVectorScale(float scale) {
        this.g.setF("vectorScale", scale);
        this.g.vectorScale = scale;
    }

    @Override
    public void setVibrationScale(float scale) {
        this.tm.setVibrationScale(scale);
        this.g.vibrationScale = scale;
        this.g.setF("vibrationScale", scale);
    }

    @Override
    public void setVibrationPeriod(float period) {
        this.tm.setVibrationPeriod(period);
        this.g.vibrationPeriod = period = Math.abs(period);
        this.g.setF("vibrationPeriod", period);
    }

    void setObjectColor(String name, String colorName) {
        if (colorName == null || colorName.length() == 0) {
            return;
        }
        this.setObjectArgb(name, CU.getArgbFromString(colorName));
    }

    public void setObjectVisibility(String name, boolean b) {
        int objId = StateManager.getObjectIdFromName(name);
        if (objId >= 0) {
            this.setShapeProperty(objId, "display", b ? Boolean.TRUE : Boolean.FALSE);
        }
    }

    public void setObjectArgb(String name, int argb) {
        int objId = StateManager.getObjectIdFromName(name);
        if (objId < 0) {
            if (name.equalsIgnoreCase("axes")) {
                this.setObjectArgb("axis1", argb);
                this.setObjectArgb("axis2", argb);
                this.setObjectArgb("axis3", argb);
            }
            return;
        }
        this.g.objColors[objId] = argb;
        switch (objId) {
            case 0: {
                this.gdata.setBackgroundArgb(argb);
                this.cm.setColixBackgroundContrast(argb);
            }
        }
        this.g.setO(name + "Color", Escape.escapeColor(argb));
    }

    public void setBackgroundImage(String fileName, Object image) {
        this.g.backgroundImageFileName = fileName;
        this.gdata.setBackgroundImage(image);
    }

    public short getObjectColix(int objId) {
        int argb = this.g.objColors[objId];
        return argb == 0 ? this.cm.colixBackgroundContrast : C.getColix(argb);
    }

    @Override
    public void setColorBackground(String colorName) {
        this.setObjectColor("background", colorName);
    }

    @Override
    public int getBackgroundArgb() {
        return this.g.objColors[0];
    }

    public void setObjectMad10(int iShape, String name, int mad10) {
        int objId = StateManager.getObjectIdFromName(name.equalsIgnoreCase("axes") ? "axis" : name);
        if (objId < 0) {
            return;
        }
        if (mad10 == -2 || mad10 == -4) {
            int m = mad10 + 3;
            mad10 = this.getObjectMad10(objId);
            if (mad10 == 0) {
                mad10 = m;
            }
        }
        this.g.setB("show" + name, mad10 != 0);
        boolean bl = this.g.objStateOn[objId] = mad10 != 0;
        if (mad10 == 0) {
            return;
        }
        this.g.objMad10[objId] = mad10;
        this.setShapeSize(iShape, mad10, null);
    }

    public int getObjectMad10(int objId) {
        return this.g.objStateOn[objId] ? this.g.objMad10[objId] : 0;
    }

    public void setPropertyColorScheme(String scheme, boolean isTranslucent, boolean isOverloaded) {
        this.g.propertyColorScheme = scheme;
        if (scheme.startsWith("translucent ")) {
            isTranslucent = true;
            scheme = scheme.substring(12).trim();
        }
        this.cm.setPropertyColorScheme(scheme, isTranslucent, isOverloaded);
    }

    public String getLightingState() {
        return this.getStateCreator().getLightingState(true);
    }

    public P3 getColorPointForPropertyValue(float val) {
        return CU.colorPtFromInt(this.gdata.getColorArgbOrGray(this.cm.ce.getColorIndex(val)), null);
    }

    public void select(BS bs, boolean isGroup, int addRemove, boolean isQuiet) {
        if (isGroup) {
            bs = this.getUndeletedGroupAtomBits(bs);
        }
        this.slm.select(bs, addRemove, isQuiet);
        this.shm.setShapeSizeBs(1, Integer.MAX_VALUE, null, null);
    }

    @Override
    public void setSelectionSet(BS set) {
        this.select(set, false, 0, true);
    }

    public void selectBonds(BS bs) {
        this.shm.setShapeSizeBs(1, Integer.MAX_VALUE, null, bs);
    }

    public void displayAtoms(BS bs, boolean isDisplay, boolean isGroup, int addRemove, boolean isQuiet) {
        if (isGroup) {
            bs = this.getUndeletedGroupAtomBits(bs);
        }
        if (isDisplay) {
            this.slm.display(this.ms, bs, addRemove, isQuiet);
        } else {
            this.slm.hide(this.ms, bs, addRemove, isQuiet);
        }
    }

    private BS getUndeletedGroupAtomBits(BS bs) {
        bs = this.ms.getAtoms(1086324742, bs);
        BSUtil.andNot(bs, this.slm.bsDeleted);
        return bs;
    }

    void reportSelection(String msg) {
        if (this.selectionHalosEnabled) {
            this.setTainted(true);
        }
        if (this.isScriptQueued() || this.g.debugScript) {
            this.scriptStatus(msg);
        }
    }

    private void clearAtomSets() {
        this.slm.setSelectionSubset(null);
        this.definedAtomSets.clear();
        if (this.haveDisplay) {
            this.acm.exitMeasurementMode("clearAtomSets");
        }
    }

    public BS getDefinedAtomSet(String name) {
        Object o = this.definedAtomSets.get(name.toLowerCase());
        return o instanceof BS ? (BS)o : new BS();
    }

    @Override
    public void selectAll() {
        this.slm.selectAll(false);
    }

    @Override
    public void clearSelection() {
        this.slm.clearSelection(true);
        this.g.setB("hideNotSelected", false);
    }

    public BS bsA() {
        return this.slm.getSelectedAtoms();
    }

    @Override
    public void addSelectionListener(JmolSelectionListener listener) {
        this.slm.addListener(listener);
    }

    @Override
    public void removeSelectionListener(JmolSelectionListener listener) {
        this.slm.addListener(listener);
    }

    BS getAtomBitSetEval(JmolScriptEvaluator eval, Object atomExpression) {
        return this.allowScripting ? this.getScriptManager().getAtomBitSetEval(eval, atomExpression) : new BS();
    }

    public void processTwoPointGesture(float[][][] touches) {
        this.mouse.processTwoPointGesture(touches);
    }

    public boolean processMouseEvent(int id, int x, int y, int modifiers, long time) {
        return this.mouse.processEvent(id, x, y, modifiers, time);
    }

    public Rectangle getRubberBandSelection() {
        return this.haveDisplay ? this.acm.getRubberBand() : null;
    }

    public boolean isBound(int mouseAction, int jmolAction) {
        return this.haveDisplay && this.acm.bnd(mouseAction, jmolAction);
    }

    public int getCursorX() {
        return this.haveDisplay ? this.acm.getCurrentX() : 0;
    }

    public int getCursorY() {
        return this.haveDisplay ? this.acm.getCurrentY() : 0;
    }

    public String getDefaultDirectory() {
        return this.g.defaultDirectory;
    }

    public String getLocalUrl(String fileName) {
        return this.apiPlatform.getLocalUrl(fileName);
    }

    @Override
    public BufferedInputStream getBufferedInputStream(String fullPathName) {
        return this.fm.getBufferedInputStream(fullPathName);
    }

    public Map<String, Object> setLoadParameters(Map<String, Object> htParams, boolean isAppend) {
        String filter;
        if (htParams == null) {
            htParams = new Hashtable<String, Object>();
        }
        htParams.put("vwr", this);
        if (this.g.atomTypes.length() > 0) {
            htParams.put("atomTypes", this.g.atomTypes);
        }
        if (!htParams.containsKey("lattice")) {
            htParams.put("lattice", this.g.ptDefaultLattice);
        }
        if (this.g.applySymmetryToBonds) {
            htParams.put("applySymmetryToBonds", Boolean.TRUE);
        }
        if (this.g.pdbGetHeader) {
            htParams.put("getHeader", Boolean.TRUE);
        }
        if (this.g.pdbSequential) {
            htParams.put("isSequential", Boolean.TRUE);
        }
        if (this.g.legacyJavaFloat) {
            htParams.put("legacyJavaFloat", Boolean.TRUE);
        }
        htParams.put("stateScriptVersionInt", this.stateScriptVersionInt);
        if (!htParams.containsKey("filter") && (filter = this.g.defaultLoadFilter).length() > 0) {
            htParams.put("filter", filter);
        }
        boolean merging = isAppend && !this.g.appendNew && this.ms.ac > 0;
        htParams.put("baseAtomIndex", isAppend ? this.ms.ac : 0);
        htParams.put("baseModelIndex", this.ms.ac == 0 ? 0 : this.ms.mc + (merging ? -1 : 0));
        if (merging) {
            htParams.put("merging", Boolean.TRUE);
        }
        return htParams;
    }

    @Override
    public void openFileAsyncSpecial(String fileName, int flags) {
        this.getScriptManager().openFileAsync(fileName, flags);
    }

    @Override
    public String openFile(String fileName) {
        this.zap(true, true, false);
        return this.loadModelFromFileRepaint(null, fileName, null, null);
    }

    @Override
    public String openFiles(String[] fileNames) {
        this.zap(true, true, false);
        return this.loadModelFromFileRepaint(null, null, fileNames, null);
    }

    @Override
    public String openReader(String fullPathName, String fileName, Object reader) {
        this.zap(true, true, false);
        return this.loadModelFromFileRepaint(fullPathName, fileName, null, reader);
    }

    @Override
    public String openDOM(Object DOMNode) {
        this.zap(true, true, false);
        return this.loadModelFromFileRepaint("?", "?", null, DOMNode);
    }

    private String loadModelFromFileRepaint(String fullPathName, String fileName, String[] fileNames, Object reader) {
        String ret = this.loadModelFromFile(fullPathName, fileName, fileNames, reader, false, null, null, null, 0, false);
        this.refresh(1, "loadModelFromFileRepaint");
        return ret;
    }

    public String loadModelFromFile(String fullPathName, String fileName, String[] fileNames, Object reader, boolean isAppend, Map<String, Object> htParams, SB loadScript, SB sOptions, int tokType, boolean isConcat) {
        Object atomSetCollection;
        if (htParams == null) {
            htParams = this.setLoadParameters(null, isAppend);
        }
        if (isConcat) {
            htParams.put("concatenate", Boolean.TRUE);
        }
        String[] saveInfo = this.fm.getFileInfo();
        if (fileNames != null) {
            if (loadScript == null) {
                loadScript = new SB().append("load files");
                for (int i = 0; i < fileNames.length; ++i) {
                    loadScript.append(i == 0 || !isConcat ? " " : "+").append("/*file*/$FILENAME" + (i + 1) + "$");
                }
            }
            if (sOptions.length() > 0) {
                loadScript.append(" /*options*/ ").append(sOptions.toString());
            }
            long timeBegin = System.currentTimeMillis();
            atomSetCollection = this.fm.createAtomSetCollectionFromFiles(fileNames, this.setLoadParameters(htParams, isAppend), isAppend);
            long ms = System.currentTimeMillis() - timeBegin;
            Logger.info("openFiles(" + fileNames.length + ") " + ms + " ms");
            fileNames = (String[])htParams.get("fullPathNames");
            String[] fileTypes = (String[])htParams.get("fileTypes");
            String s = loadScript.toString();
            for (int i = 0; i < fileNames.length; ++i) {
                String fname = fileNames[i];
                if (fileTypes != null && fileTypes[i] != null) {
                    fname = fileTypes[i] + "::" + fname;
                }
                s = PT.rep(s, "$FILENAME" + (i + 1) + "$", PT.esc(FileManager.fixDOSName(fname)));
            }
            loadScript = new SB().append(s);
        } else if (reader == null) {
            if (loadScript == null) {
                loadScript = new SB().append("load /*file*/$FILENAME$");
            }
            atomSetCollection = this.openFileFull(fileName, isAppend, htParams, loadScript);
        } else {
            atomSetCollection = reader instanceof Reader || reader instanceof BufferedInputStream || AU.isAB(reader) ? this.fm.createAtomSetCollectionFromReader(fullPathName, fileName, reader, this.setLoadParameters(htParams, isAppend)) : this.fm.createAtomSetCollectionFromDOM(reader, this.setLoadParameters(htParams, isAppend));
        }
        if (tokType != 0) {
            this.fm.setFileInfo(saveInfo);
            return this.loadAtomDataAndReturnError(atomSetCollection, tokType);
        }
        if (htParams.containsKey("isData")) {
            return (String)atomSetCollection;
        }
        if (loadScript != null && !(atomSetCollection instanceof String)) {
            String fname = (String)htParams.get("fullPathName");
            if (fname == null) {
                fname = "";
            }
            if (htParams.containsKey("loadScript")) {
                loadScript = (SB)htParams.get("loadScript");
            }
            loadScript = new SB().append(PT.rep(loadScript.toString(), "$FILENAME$", PT.esc(FileManager.fixDOSName(fname))));
            htParams.put("loadScript", loadScript);
        }
        return this.createModelSetAndReturnError(atomSetCollection, isAppend, loadScript, htParams);
    }

    public void setLigandModel(String key, String data) {
        if (this.ligandModels == null) {
            this.ligandModels = new Hashtable<String, Object>();
        }
        this.ligandModels.put(key, data);
    }

    public Object getLigandModel(String id, String prefix, String suffix, String terminator) {
        String data;
        boolean isNew;
        int pngPt;
        if (id == null) {
            if (this.ligandModelSet != null) {
                Iterator<Map.Entry<String, Object>> e = this.ligandModels.entrySet().iterator();
                while (e.hasNext()) {
                    Map.Entry<String, Object> entry = e.next();
                    if (!(entry.getValue() instanceof Boolean)) continue;
                    e.remove();
                }
            }
            return null;
        }
        id = id.replace('\\', '/');
        boolean isLigand = prefix.equals("ligand_");
        String string = id.indexOf("/cif") >= 0 ? id : (id = isLigand ? id.toUpperCase() : id.substring(id.lastIndexOf("/") + 1));
        if (this.ligandModelSet == null) {
            this.ligandModelSet = new Hashtable<String, Boolean>();
        }
        this.ligandModelSet.put(id, Boolean.TRUE);
        if (this.ligandModels == null) {
            this.ligandModels = new Hashtable<String, Object>();
        }
        if ((pngPt = id.indexOf("|")) >= 0) {
            id = id.substring(id.indexOf("|") + 1);
        }
        Object model = terminator == null ? this.ligandModels.get(id) : null;
        String fname = null;
        if (model instanceof Boolean) {
            return null;
        }
        if (model == null && (terminator == null || pngPt >= 0)) {
            model = this.ligandModels.get(id + suffix);
        }
        boolean isError = false;
        boolean bl = isNew = model == null;
        if (isNew) {
            String s;
            if (isLigand) {
                fname = (String)this.setLoadFormat("#" + id, '#', false);
                if (fname.length() == 0) {
                    return null;
                }
                this.scriptEcho("fetching " + fname);
                s = this.getFileAsString3(fname, false, null);
            } else {
                int pt;
                this.scriptEcho("fetching " + prefix);
                s = this.getFileAsString3(prefix, false, null);
                int n = pt = terminator == null ? -1 : s.indexOf(terminator);
                if (pt >= 0) {
                    s = s.substring(0, pt);
                }
            }
            isError = s.indexOf("java.") == 0;
            model = s;
            if (!isError) {
                this.ligandModels.put(id + suffix, model);
            }
        }
        if (!isLigand) {
            if (!isNew) {
                this.scriptEcho(prefix + " loaded from cache");
            }
            return model;
        }
        if (!isError && model instanceof String && (data = (String)model).length() != 0) {
            Hashtable<String, Object> htParams = new Hashtable<String, Object>();
            htParams.put("modelOnly", Boolean.TRUE);
            model = this.getModelAdapter().getAtomSetCollectionReader("ligand", null, Rdr.getBR(data), htParams);
            isError = model instanceof String;
            if (!isError) {
                model = this.getModelAdapter().getAtomSetCollection(model);
                isError = model instanceof String;
                if (fname != null && !isError) {
                    this.scriptEcho((String)this.getModelAdapter().getAtomSetCollectionAuxiliaryInfo(model).get("modelLoadNote"));
                }
            }
        }
        if (isError) {
            this.scriptEcho(model.toString());
            this.ligandModels.put(id, Boolean.FALSE);
            return null;
        }
        return model;
    }

    private Object openFileFull(String fileName, boolean isAppend, Map<String, Object> htParams, SB loadScript) {
        Object atomSetCollection;
        if (fileName == null) {
            return null;
        }
        if (fileName.equals("String[]")) {
            return null;
        }
        String msg = "openFile(" + fileName + ")";
        Logger.startTimer(msg);
        htParams = this.setLoadParameters(htParams, isAppend);
        boolean isLoadVariable = fileName.startsWith("@");
        boolean haveFileData = htParams.containsKey("fileData");
        if (fileName.indexOf(36) == 0) {
            htParams.put("smilesString", fileName.substring(1));
        }
        boolean isString = fileName.equals("string") || fileName.equals("Jmol Model Kit");
        String strModel = null;
        if (haveFileData) {
            strModel = (String)htParams.get("fileData");
            if (htParams.containsKey("isData")) {
                String o = this.loadInlineScript(strModel, '\u0000', isAppend, htParams);
                this.lastData = this.g.preserveState ? this.getDataManager().createFileData(strModel) : null;
                return o;
            }
        } else if (isString) {
            strModel = this.ms.getInlineData(-1);
            if (strModel == null) {
                if (this.g.modelKitMode) {
                    strModel = "5\n\nC 0 0 0\nH .63 .63 .63\nH -.63 -.63 .63\nH -.63 .63 -.63\nH .63 -.63 -.63";
                } else {
                    return "cannot find string data";
                }
            }
            if (loadScript != null) {
                loadScript = new SB().append(PT.rep(loadScript.toString(), "/*file*/$FILENAME$", "/*data*/data \"model inline\"\n" + strModel + "end \"model inline\""));
                htParams.put("loadScript", loadScript);
            }
        }
        if (strModel != null) {
            if (!isAppend) {
                this.zap(true, false, false);
            }
            if (!(isLoadVariable || haveFileData && !isString)) {
                this.getStateCreator().getInlineData(loadScript, strModel, isAppend, this.g.defaultLoadFilter);
            }
            atomSetCollection = this.fm.createAtomSetCollectionFromString(strModel, htParams, isAppend);
        } else {
            atomSetCollection = this.fm.createAtomSetCollectionFromFile(fileName, htParams, isAppend);
        }
        Logger.checkTimer(msg, false);
        return atomSetCollection;
    }

    @Override
    public String openStringInline(String strModel) {
        String ret = this.openStringInlineParamsAppend(strModel, null, false);
        this.refresh(1, "openStringInline");
        return ret;
    }

    @Override
    public String loadInline(String strModel) {
        return this.loadInlineScriptRepaint(strModel, this.g.inlineNewlineChar, false);
    }

    @Override
    public String loadInline(String strModel, char newLine) {
        return this.loadInlineScriptRepaint(strModel, newLine, false);
    }

    @Override
    public String loadInlineAppend(String strModel, boolean isAppend) {
        return this.loadInlineScriptRepaint(strModel, '\u0000', isAppend);
    }

    private String loadInlineScriptRepaint(String strModel, char newLine, boolean isAppend) {
        String ret = this.loadInlineScript(strModel, newLine, isAppend, null);
        this.refresh(1, "loadInlineScript");
        return ret;
    }

    @Override
    public String loadInline(String[] arrayModels) {
        return this.loadInline(arrayModels, false);
    }

    @Override
    public String loadInline(String[] arrayModels, boolean isAppend) {
        if (arrayModels == null || arrayModels.length == 0) {
            return null;
        }
        String ret = this.openStringsInlineParamsAppend(arrayModels, new Hashtable<String, Object>(), isAppend);
        this.refresh(1, "loadInline String[]");
        return ret;
    }

    @Override
    public String loadInline(List<Object> arrayData, boolean isAppend) {
        if (arrayData == null || arrayData.size() == 0) {
            return null;
        }
        if (!isAppend) {
            this.zap(true, false, false);
        }
        Lst<Object> list = new Lst<Object>();
        for (int i = 0; i < arrayData.size(); ++i) {
            list.addLast(arrayData.get(i));
        }
        Object atomSetCollection = this.fm.createAtomSeCollectionFromArrayData(list, this.setLoadParameters(null, isAppend), isAppend);
        String ret = this.createModelSetAndReturnError(atomSetCollection, isAppend, null, new Hashtable<String, Object>());
        this.refresh(1, "loadInline");
        return ret;
    }

    private String loadInlineScript(String strModel, char newLine, boolean isAppend, Map<String, Object> htParams) {
        int i;
        String datasep;
        if (strModel == null || strModel.length() == 0) {
            return null;
        }
        strModel = Viewer.fixInlineString(strModel, newLine);
        if (newLine != '\u0000') {
            Logger.info("loading model inline, " + strModel.length() + " bytes, with newLine character " + newLine + " isAppend=" + isAppend);
        }
        if (Logger.debugging) {
            Logger.debug(strModel);
        }
        if ((datasep = this.getDataSeparator()) != null && datasep != "" && (i = strModel.indexOf(datasep)) >= 0 && strModel.indexOf("# Jmol state") < 0) {
            int n = 2;
            while ((i = strModel.indexOf(datasep, i + 1)) >= 0) {
                ++n;
            }
            String[] strModels = new String[n];
            int pt = 0;
            int pt0 = 0;
            for (i = 0; i < n; ++i) {
                pt = strModel.indexOf(datasep, pt0);
                if (pt < 0) {
                    pt = strModel.length();
                }
                strModels[i] = strModel.substring(pt0, pt);
                pt0 = pt + datasep.length();
            }
            return this.openStringsInlineParamsAppend(strModels, htParams, isAppend);
        }
        return this.openStringInlineParamsAppend(strModel, htParams, isAppend);
    }

    public static String fixInlineString(String strModel, char newLine) {
        if (strModel.indexOf("\\/n") >= 0) {
            strModel = PT.rep(strModel, "\n", "");
            strModel = PT.rep(strModel, "\\/n", "\n");
            newLine = '\u0000';
        }
        if (newLine != '\u0000' && newLine != '\n') {
            int i;
            boolean repEmpty = strModel.indexOf(10) >= 0;
            int len = strModel.length();
            for (i = 0; i < len && strModel.charAt(i) == ' '; ++i) {
            }
            if (i < len && strModel.charAt(i) == newLine) {
                strModel = strModel.substring(i + 1);
            }
            strModel = repEmpty ? PT.rep(strModel, "" + newLine, "") : strModel.replace(newLine, '\n');
        }
        return strModel;
    }

    public String openStringInlineParamsAppend(String strModel, Map<String, Object> htParams, boolean isAppend) {
        String type = this.getModelAdapter().getFileTypeName(Rdr.getBR(strModel));
        if (type == null) {
            return "unknown file type";
        }
        if (type.equals("spt")) {
            return "cannot open script inline";
        }
        htParams = this.setLoadParameters(htParams, isAppend);
        SB loadScript = (SB)htParams.get("loadScript");
        boolean isLoadCommand = htParams.containsKey("isData");
        if (loadScript == null) {
            loadScript = new SB();
        }
        if (!isAppend) {
            this.zap(true, false, false);
        }
        if (!isLoadCommand) {
            this.getStateCreator().getInlineData(loadScript, strModel, isAppend, this.g.defaultLoadFilter);
        }
        Object atomSetCollection = this.fm.createAtomSetCollectionFromString(strModel, htParams, isAppend);
        return this.createModelSetAndReturnError(atomSetCollection, isAppend, loadScript, htParams);
    }

    private String openStringsInlineParamsAppend(String[] arrayModels, Map<String, Object> htParams, boolean isAppend) {
        SB loadScript = new SB();
        if (!isAppend) {
            this.zap(true, false, false);
        }
        Object atomSetCollection = this.fm.createAtomSeCollectionFromStrings(arrayModels, loadScript, this.setLoadParameters(htParams, isAppend), isAppend);
        return this.createModelSetAndReturnError(atomSetCollection, isAppend, loadScript, htParams);
    }

    public char getInlineChar() {
        return this.g.inlineNewlineChar;
    }

    String getDataSeparator() {
        return (String)this.g.getParameter("dataseparator", true);
    }

    private String createModelSetAndReturnError(Object atomSetCollection, boolean isAppend, SB loadScript, Map<String, Object> htParams) {
        String errMsg;
        Logger.startTimer("creating model");
        String fullPathName = this.fm.getFullPathName(false);
        String fileName = this.fm.getFileName();
        if (loadScript == null) {
            this.setBooleanProperty("preserveState", false);
            loadScript = new SB().append("load \"???\"");
        }
        if (atomSetCollection instanceof String) {
            String errMsg2 = (String)atomSetCollection;
            this.setFileLoadStatus(FIL.NOT_LOADED, fullPathName, null, null, errMsg2, null);
            if (this.displayLoadErrors && !isAppend && !errMsg2.equals("#CANCELED#") && !errMsg2.startsWith(JC.READER_NOT_FOUND)) {
                this.zapMsg(errMsg2);
            }
            return errMsg2;
        }
        if (isAppend) {
            this.clearAtomSets();
        } else if (this.g.modelKitMode && !fileName.equals("Jmol Model Kit")) {
            this.setModelKitMode(false);
        }
        this.setFileLoadStatus(FIL.CREATING_MODELSET, fullPathName, fileName, null, null, null);
        this.pushHoldRepaintWhy("createModelSet");
        this.setErrorMessage(null, null);
        try {
            BS bsNew = new BS();
            this.mm.createModelSet(fullPathName, fileName, loadScript, atomSetCollection, bsNew, isAppend);
            if (bsNew.cardinality() > 0) {
                String jmolScript = (String)this.ms.getInfoM("jmolscript");
                if (this.ms.getMSInfoB("doMinimize")) {
                    try {
                        JmolScriptEvaluator eval = (JmolScriptEvaluator)htParams.get("eval");
                        this.minimize(eval, Integer.MAX_VALUE, 0.0f, bsNew, null, 0.0f, true, true, true, true);
                    }
                    catch (Exception e) {}
                } else {
                    this.addHydrogens(bsNew, false, true);
                }
                if (jmolScript != null) {
                    this.ms.msInfo.put("jmolscript", jmolScript);
                }
            }
            this.initializeModel(isAppend);
        }
        catch (Error er) {
            this.handleError(er, true);
            errMsg = this.getShapeErrorState();
            errMsg = "ERROR creating model: " + er + (errMsg.length() == 0 ? "" : "|" + errMsg);
            this.zapMsg(errMsg);
            this.setErrorMessage(errMsg, null);
        }
        this.popHoldRepaint("createModelSet \u0001## REPAINT_IGNORE ##");
        errMsg = this.getErrorMessage();
        this.setFileLoadStatus(FIL.CREATED, fullPathName, fileName, this.ms.modelSetName, errMsg, (Boolean)htParams.get("async"));
        if (isAppend) {
            this.selectAll();
            this.setTainted(true);
            this.axesAreTainted = true;
        }
        atomSetCollection = null;
        Logger.checkTimer("creating model", false);
        System.gc();
        return errMsg;
    }

    private String loadAtomDataAndReturnError(Object atomSetCollection, int tokType) {
        if (atomSetCollection instanceof String) {
            return (String)atomSetCollection;
        }
        this.setErrorMessage(null, null);
        try {
            String script = this.mm.createAtomDataSet(atomSetCollection, tokType);
            switch (tokType) {
                case 1145047050: {
                    if (script == null) break;
                    this.runScriptCautiously(script);
                    break;
                }
                case 4166: {
                    this.setStatusFrameChanged(true, false);
                    break;
                }
                case 1648363544: {
                    this.shm.deleteVdwDependentShapes(null);
                }
            }
        }
        catch (Error er) {
            this.handleError(er, true);
            String errMsg = this.getShapeErrorState();
            errMsg = "ERROR adding atom data: " + er + (errMsg.length() == 0 ? "" : "|" + errMsg);
            this.zapMsg(errMsg);
            this.setErrorMessage(errMsg, null);
            this.setParallel(false);
        }
        return this.getErrorMessage();
    }

    public String getCurrentFileAsString(String state) {
        String filename = this.fm.getFullPathName(false);
        if (filename.equals("string") || filename.equals("Jmol Model Kit")) {
            return this.ms.getInlineData(this.am.cmi);
        }
        if (filename.equals("String[]")) {
            return filename;
        }
        if (filename == "JSNode") {
            return "<DOM NODE>";
        }
        return this.getFileAsString4(filename, -1, true, false, false, state);
    }

    public String[] getFullPathNameOrError(String filename) {
        String[] data = new String[2];
        this.fm.getFullPathNameOrError(filename, false, data);
        return data;
    }

    public String getFileAsString3(String name, boolean checkProtected, String state) {
        return this.getFileAsString4(name, -1, false, false, checkProtected, state);
    }

    public String getFileAsString4(String name, int nBytesMax, boolean doSpecialLoad, boolean allowBinary, boolean checkProtected, String state) {
        if (name == null) {
            return this.getCurrentFileAsString(state);
        }
        String[] data = new String[]{name, null};
        this.fm.getFileDataAsString(data, nBytesMax, doSpecialLoad, allowBinary, checkProtected);
        return data[1];
    }

    public String getAsciiFileOrNull(String name) {
        String[] data = new String[]{name, null};
        return this.fm.getFileDataAsString(data, -1, false, false, false) ? data[1] : null;
    }

    public void autoCalculate(int tokProperty, String dataType) {
        switch (tokProperty) {
            case 1111490575: {
                this.ms.getSurfaceDistanceMax();
                break;
            }
            case 1111490574: {
                this.ms.calculateStraightnessAll();
                break;
            }
            case 1111490587: {
                this.ms.calculateDssrProperty(dataType);
            }
        }
    }

    public void calculateStraightness() {
        this.ms.haveStraightness = false;
        this.ms.calculateStraightnessAll();
    }

    public P3[] calculateSurface(BS bsSelected, float envelopeRadius) {
        if (bsSelected == null) {
            bsSelected = this.bsA();
        }
        if (envelopeRadius == Float.MAX_VALUE || envelopeRadius == -1.0f) {
            this.ms.addStateScript("calculate surfaceDistance " + (envelopeRadius == Float.MAX_VALUE ? "FROM" : "WITHIN"), null, bsSelected, null, "", false, true);
        }
        return this.ms.calculateSurface(bsSelected, envelopeRadius);
    }

    public Map<STR, float[]> getStructureList() {
        return this.g.getStructureList();
    }

    public void setStructureList(float[] list, STR type) {
        this.g.setStructureList(list, type);
        this.ms.setStructureList(this.getStructureList());
    }

    public String calculateStructures(BS bsAtoms, boolean asDSSP, boolean setStructure, int version) {
        if (bsAtoms == null) {
            bsAtoms = this.bsA();
        }
        return this.ms.calculateStructures(bsAtoms, asDSSP, !this.am.animationOn, this.g.dsspCalcHydrogen, setStructure, version);
    }

    public JmolAnnotationParser getAnnotationParser(boolean isDSSR) {
        JmolAnnotationParser jmolAnnotationParser = isDSSR ? (this.dssrParser == null ? (this.dssrParser = (JmolAnnotationParser)Interface.getOption("dssx.DSSR1", this, "script")) : this.dssrParser) : (this.annotationParser == null ? (this.annotationParser = (JmolAnnotationParser)Interface.getOption("dssx.AnnotationParser", this, "script")) : this.annotationParser);
        return jmolAnnotationParser;
    }

    @Override
    public AtomIndexIterator getSelectedAtomIterator(BS bsSelected, boolean isGreaterOnly, boolean modelZeroBased, boolean isMultiModel) {
        return this.ms.getSelectedAtomIterator(bsSelected, isGreaterOnly, modelZeroBased, false, isMultiModel);
    }

    @Override
    public void setIteratorForAtom(AtomIndexIterator iterator, int atomIndex, float distance) {
        this.ms.setIteratorForAtom(iterator, -1, atomIndex, distance, null);
    }

    @Override
    public void setIteratorForPoint(AtomIndexIterator iterator, int modelIndex, T3 pt, float distance) {
        this.ms.setIteratorForPoint(iterator, modelIndex, pt, distance);
    }

    @Override
    public void fillAtomData(AtomData atomData, int mode) {
        atomData.programInfo = "Jmol Version " + Viewer.getJmolVersion();
        atomData.fileName = this.fm.getFileName();
        this.ms.fillAtomData(atomData, mode);
    }

    public StateScript addStateScript(String script, boolean addFrameNumber, boolean postDefinitions) {
        return this.ms.addStateScript(script, null, null, null, null, addFrameNumber, postDefinitions);
    }

    public Minimizer getMinimizer(boolean createNew) {
        Minimizer minimizer;
        if (this.minimizer == null && createNew) {
            this.minimizer = (Minimizer)Interface.getInterface("org.jmol.minimize.Minimizer", this, "script");
            minimizer = this.minimizer.setProperty("vwr", this);
        } else {
            minimizer = this.minimizer;
        }
        return minimizer;
    }

    public SmilesMatcherInterface getSmilesMatcher() {
        return this.smilesMatcher == null ? (this.smilesMatcher = (SmilesMatcherInterface)Interface.getInterface("org.jmol.smiles.SmilesMatcher", this, "script")) : this.smilesMatcher;
    }

    public void clearModelDependentObjects() {
        this.setFrameOffsets(null, false);
        this.stopMinimization();
        this.minimizer = null;
        this.smilesMatcher = null;
    }

    public void zap(boolean notify, boolean resetUndo, boolean zapModelKit) {
        this.clearThreads();
        if (this.mm.modelSet == null) {
            this.mm.zap();
        } else {
            this.ligandModelSet = null;
            this.clearModelDependentObjects();
            this.fm.clear();
            this.clearRepaintManager(-1);
            this.am.clear();
            this.tm.clear();
            this.slm.clear();
            this.clearAllMeasurements();
            this.clearMinimization();
            this.gdata.clear();
            this.mm.zap();
            if (this.scm != null) {
                this.scm.clear(false);
            }
            if (this.nmrCalculation != null) {
                this.getNMRCalculation().setChemicalShiftReference(null, 0.0f);
            }
            if (this.haveDisplay) {
                this.mouse.clear();
                this.clearTimeouts();
                this.acm.clear();
            }
            this.stm.clear(this.g);
            this.tempArray.clear();
            this.chainMap.clear();
            this.chainList.clear();
            this.chainCaseSpecified = false;
            this.definedAtomSets.clear();
            this.lastData = null;
            if (this.dm != null) {
                this.dm.clear();
            }
            this.setBooleanProperty("legacyjavafloat", false);
            if (resetUndo) {
                if (zapModelKit && this.g.modelKitMode) {
                    this.openStringInlineParamsAppend("5\n\nC 0 0 0\nH .63 .63 .63\nH -.63 -.63 .63\nH -.63 .63 -.63\nH .63 -.63 -.63", null, true);
                    this.setRotationRadius(5.0f, true);
                    this.setStringProperty("picking", "assignAtom_C");
                    this.setStringProperty("picking", "assignBond_p");
                }
                this.undoClear();
            }
            System.gc();
        }
        this.initializeModel(false);
        if (notify) {
            this.setFileLoadStatus(FIL.ZAPPED, null, resetUndo ? "resetUndo" : this.getZapName(), null, null, null);
        }
        if (Logger.debugging) {
            Logger.checkMemory();
        }
    }

    private void zapMsg(String msg) {
        this.zap(true, true, false);
        this.echoMessage(msg);
    }

    void echoMessage(String msg) {
        int iShape = 31;
        this.shm.loadShape(iShape);
        this.setShapeProperty(iShape, "font", this.getFont3D("SansSerif", "Plain", 9.0f));
        this.setShapeProperty(iShape, "target", "error");
        this.setShapeProperty(iShape, "text", msg);
    }

    private void initializeModel(boolean isAppend) {
        this.clearThreads();
        if (isAppend) {
            this.am.initializePointers(1);
            return;
        }
        this.reset(true);
        this.selectAll();
        this.rotateBondIndex = -1;
        this.rotatePrev1 = -1;
        this.movingSelected = false;
        this.slm.noneSelected = Boolean.FALSE;
        this.setHoverEnabled(true);
        this.setSelectionHalosEnabled(false);
        this.tm.setCenter();
        this.am.initializePointers(1);
        this.setBooleanProperty("multipleBondBananas", false);
        if (!this.ms.getMSInfoB("isPyMOL")) {
            this.clearAtomSets();
            this.setCurrentModelIndex(0);
        }
        this.setBackgroundModelIndex(-1);
        this.setFrankOn(this.getShowFrank());
        this.startHoverWatcher(true);
        this.setTainted(true);
        this.finalizeTransformParameters();
    }

    public void startHoverWatcher(boolean tf) {
        if (tf && this.inMotion || !this.haveDisplay || tf && (!this.hoverEnabled && !this.sm.haveHoverCallback() || this.am.animationOn)) {
            return;
        }
        this.acm.startHoverWatcher(tf);
    }

    @Override
    public String getModelSetPathName() {
        return this.mm.modelSetPathName;
    }

    @Override
    public String getModelSetFileName() {
        return this.mm.fileName == null ? this.getZapName() : this.mm.fileName;
    }

    public String getUnitCellInfoText() {
        SymmetryInterface c = this.getCurrentUnitCell();
        return c == null ? "not applicable" : c.getUnitCellInfo();
    }

    public float getUnitCellInfo(int infoType) {
        SymmetryInterface symmetry = this.getCurrentUnitCell();
        return symmetry == null ? Float.NaN : symmetry.getUnitCellInfoType(infoType);
    }

    public T3[] getV0abc(Object def) {
        SymmetryInterface uc = this.getCurrentUnitCell();
        return uc == null ? null : uc.getV0abc(def);
    }

    public void getPolymerPointsAndVectors(BS bs, Lst<P3[]> vList) {
        this.ms.getPolymerPointsAndVectors(bs, vList, this.g.traceAlpha, this.g.sheetSmoothing);
    }

    public String getHybridizationAndAxes(int atomIndex, V3 z, V3 x, String lcaoType) {
        return this.ms.getHybridizationAndAxes(atomIndex, 0, z, x, lcaoType, true, true);
    }

    public BS getAllAtoms() {
        return this.getModelUndeletedAtomsBitSet(-1);
    }

    public BS getModelUndeletedAtomsBitSet(int modelIndex) {
        return this.slm.excludeAtoms(this.ms.getModelAtomBitSetIncludingDeleted(modelIndex, true), false);
    }

    public BS getModelUndeletedAtomsBitSetBs(BS bsModels) {
        return this.slm.excludeAtoms(this.ms.getModelAtomBitSetIncludingDeletedBs(bsModels), false);
    }

    @Override
    public P3 getBoundBoxCenter() {
        return this.ms.getBoundBoxCenter(this.am.cmi);
    }

    public void calcBoundBoxDimensions(BS bs, float scale) {
        this.ms.calcBoundBoxDimensions(bs, scale);
        this.axesAreTainted = true;
    }

    @Override
    public V3 getBoundBoxCornerVector() {
        return this.ms.getBoundBoxCornerVector();
    }

    public int getBoundBoxCenterX() {
        return this.dimScreen.width / 2;
    }

    public int getBoundBoxCenterY() {
        return this.dimScreen.height / 2;
    }

    @Override
    public Properties getModelSetProperties() {
        return this.ms.modelSetProperties;
    }

    @Override
    public Properties getModelProperties(int modelIndex) {
        return this.ms.am[modelIndex].properties;
    }

    @Override
    public Map<String, Object> getModelSetAuxiliaryInfo() {
        return this.ms.getAuxiliaryInfo(null);
    }

    @Override
    public int getModelNumber(int modelIndex) {
        return modelIndex < 0 ? modelIndex : this.ms.getModelNumber(modelIndex);
    }

    public int getModelFileNumber(int modelIndex) {
        return modelIndex < 0 ? 0 : this.ms.modelFileNumbers[modelIndex];
    }

    @Override
    public String getModelNumberDotted(int modelIndex) {
        return modelIndex < 0 ? "0" : this.ms.getModelNumberDotted(modelIndex);
    }

    @Override
    public String getModelName(int modelIndex) {
        return this.ms.getModelName(modelIndex);
    }

    public boolean modelHasVibrationVectors(int modelIndex) {
        return this.ms.getLastVibrationVector(modelIndex, 4166) >= 0;
    }

    public BS getBondsForSelectedAtoms(BS bsAtoms) {
        return this.ms.getBondsForSelectedAtoms(bsAtoms, this.g.bondModeOr || BSUtil.cardinalityOf(bsAtoms) == 1);
    }

    public boolean frankClicked(int x, int y) {
        return !this.g.disablePopupMenu && this.getShowFrank() && this.shm.checkFrankclicked(x, y);
    }

    public boolean frankClickedModelKit(int x, int y) {
        return !this.g.disablePopupMenu && this.g.modelKitMode && x >= 0 && y >= 0 && x < 40 && y < 80;
    }

    @Override
    public int findNearestAtomIndex(int x, int y) {
        return this.findNearestAtomIndexMovable(x, y, false);
    }

    public int findNearestAtomIndexMovable(int x, int y, boolean mustBeMovable) {
        return !this.g.atomPicking ? -1 : this.ms.findNearestAtomIndex(x, y, mustBeMovable ? this.slm.getMotionFixedAtoms() : null, this.g.minPixelSelRadius);
    }

    public void toCartesian(T3 pt, boolean ignoreOffset) {
        SymmetryInterface unitCell = this.getCurrentUnitCell();
        if (unitCell != null) {
            unitCell.toCartesian(pt, ignoreOffset);
            if (!this.g.legacyJavaFloat) {
                PT.fixPtFloats(pt, 10000.0f);
            }
        }
    }

    public void toFractional(T3 pt, boolean ignoreOffset) {
        SymmetryInterface unitCell = this.getCurrentUnitCell();
        if (unitCell != null) {
            unitCell.toFractional(pt, ignoreOffset);
            if (!this.g.legacyJavaFloat) {
                PT.fixPtFloats(pt, 100000.0f);
            }
        }
    }

    public void toUnitCell(P3 pt, P3 offset) {
        SymmetryInterface unitCell = this.getCurrentUnitCell();
        if (unitCell != null) {
            unitCell.toUnitCell(pt, offset);
        }
    }

    public void setCurrentCage(String isosurfaceId) {
        Object[] data = new Object[]{isosurfaceId, null};
        this.shm.getShapePropertyData(24, "unitCell", data);
        this.ms.setModelCage(this.am.cmi, (SymmetryInterface)data[1]);
    }

    public void addUnitCellOffset(P3 pt) {
        SymmetryInterface unitCell = this.getCurrentUnitCell();
        if (unitCell == null) {
            return;
        }
        pt.add(unitCell.getCartesianOffset());
    }

    public void setAtomData(int type, String name, String coordinateData, boolean isDefault) {
        this.ms.setAtomData(type, name, coordinateData, isDefault);
        if (type == 2) {
            this.checkCoordinatesChanged();
        }
        this.refreshMeasures(true);
    }

    @Override
    public void setCenterSelected() {
        this.setCenterBitSet(this.bsA(), true);
    }

    void setApplySymmetryToBonds(boolean TF) {
        this.g.applySymmetryToBonds = TF;
    }

    @Override
    public void setBondTolerance(float bondTolerance) {
        this.g.setF("bondTolerance", bondTolerance);
        this.g.bondTolerance = bondTolerance;
    }

    @Override
    public void setMinBondDistance(float minBondDistance) {
        this.g.setF("minBondDistance", minBondDistance);
        this.g.minBondDistance = minBondDistance;
    }

    public BS getAtomsNearPt(float distance, P3 coord) {
        BS bs = new BS();
        this.ms.getAtomsWithin(distance, coord, bs, -1);
        return bs;
    }

    public BS getBranchBitSet(int atomIndex, int atomIndexNot, boolean allowCyclic) {
        if (atomIndex < 0 || atomIndex >= this.ms.ac) {
            return new BS();
        }
        return JmolMolecule.getBranchBitSet(this.ms.at, atomIndex, this.getModelUndeletedAtomsBitSet(this.ms.at[atomIndex].mi), null, atomIndexNot, allowCyclic, true);
    }

    @Override
    public BS getElementsPresentBitSet(int modelIndex) {
        return this.ms.getElementsPresentBitSet(modelIndex);
    }

    String getFileHeader() {
        return this.ms.getFileHeader(this.am.cmi);
    }

    Object getFileData() {
        return this.ms.getFileData(this.am.cmi);
    }

    public Map<String, Object> getCifData(int modelIndex) {
        return this.readCifData(this.ms.getModelFileName(modelIndex), this.ms.getModelFileType(modelIndex));
    }

    public Map<String, Object> readCifData(String fileName, String type) {
        String data;
        String string = data = fileName == null || fileName.length() == 0 ? this.getCurrentFileAsString("script") : this.getFileAsString3(fileName, false, null);
        if (data == null) {
            return null;
        }
        BufferedReader rdr = Rdr.getBR(data);
        if (type == null) {
            type = this.getModelAdapter().getFileTypeName(rdr);
        }
        return type == null ? null : Rdr.readCifData((GenericCifDataParser)Interface.getInterface("cif2".equals(type.toLowerCase()) ? "org.jmol.adapter.readers.cif.Cif2DataParser" : "javajs.util.CifDataParser", this, "script"), rdr);
    }

    public JmolStateCreator getStateCreator() {
        if (this.jsc == null) {
            this.jsc = (JmolStateCreator)Interface.getInterface("org.jmol.viewer.StateCreator", this, "script");
            this.jsc.setViewer(this);
        }
        return this.jsc;
    }

    public String getWrappedStateScript() {
        return (String)this.getOutputManager().getWrappedState(null, null, null, null);
    }

    @Override
    public String getStateInfo() {
        return this.getStateInfo3(null, 0, 0);
    }

    public String getStateInfo3(String type, int width, int height) {
        return this.g.preserveState ? this.getStateCreator().getStateScript(type, width, height) : "";
    }

    public String getStructureState() {
        return this.getStateCreator().getModelState(null, false, true);
    }

    public String getCoordinateState(BS bsSelected) {
        return this.getStateCreator().getAtomicPropertyState(2, bsSelected);
    }

    public void setCurrentColorRange(String label) {
        BS bs;
        float[] data = (float[])this.getDataObj(label, null, 1);
        BS bS = bs = data == null ? null : (BS)((Object[])this.getDataObj(label, null, -1))[2];
        if (bs != null && this.g.rangeSelected) {
            bs.and(this.bsA());
        }
        this.cm.setPropertyColorRangeData(data, bs);
    }

    public void setData(String key, Object[] data, int dataType, int matchField, int matchFieldColumnCount, int dataField, int dataFieldColumnCount) {
        this.lastData = data;
        this.getDataManager().setData(key, data, dataType, this.ms.ac, matchField, matchFieldColumnCount, dataField, dataFieldColumnCount);
    }

    public Object getDataObj(String key, BS bsSelected, int dataType) {
        return key == null && dataType == -2 ? this.lastData : this.getDataManager().getData(key, bsSelected, dataType);
    }

    public int autoHbond(BS bsFrom, BS bsTo, boolean onlyIfHaveCalculated) {
        if (bsFrom == null) {
            bsFrom = bsTo = this.bsA();
        }
        return this.ms.autoHbond(bsFrom, bsTo, onlyIfHaveCalculated);
    }

    public SymmetryInterface getCurrentUnitCell() {
        if (this.am.cai >= 0) {
            return this.ms.getUnitCellForAtom(this.am.cai);
        }
        int m = this.am.cmi;
        if (m >= 0) {
            return this.ms.getUnitCell(m);
        }
        BS models = this.getVisibleFramesBitSet();
        SymmetryInterface ucLast = null;
        int i = models.nextSetBit(0);
        while (i >= 0) {
            SymmetryInterface uc = this.ms.getUnitCell(i);
            if (uc != null) {
                if (ucLast == null) {
                    ucLast = uc;
                } else if (!ucLast.unitCellEquals(uc)) {
                    return null;
                }
            }
            i = models.nextSetBit(i + 1);
        }
        return ucLast;
    }

    public String getDefaultMeasurementLabel(int nPoints) {
        switch (nPoints) {
            case 2: {
                return this.g.defaultDistanceLabel;
            }
            case 3: {
                return this.g.defaultAngleLabel;
            }
        }
        return this.g.defaultTorsionLabel;
    }

    @Override
    public int getMeasurementCount() {
        int count = this.getShapePropertyAsInt(6, "count");
        return count <= 0 ? 0 : count;
    }

    @Override
    public String getMeasurementStringValue(int i) {
        return "" + this.shm.getShapePropertyIndex(6, "stringValue", i);
    }

    public String getMeasurementInfoAsString() {
        return (String)this.getShapeProperty(6, "infostring");
    }

    @Override
    public int[] getMeasurementCountPlusIndices(int i) {
        return (int[])this.shm.getShapePropertyIndex(6, "countPlusIndices", i);
    }

    void setPendingMeasurement(MeasurementPending mp) {
        this.shm.loadShape(6);
        this.setShapeProperty(6, "pending", mp);
    }

    public MeasurementPending getPendingMeasurement() {
        return (MeasurementPending)this.getShapeProperty(6, "pending");
    }

    public void clearAllMeasurements() {
        this.setShapeProperty(6, "clear", null);
    }

    @Override
    public void clearMeasurements() {
        this.evalString("measures delete");
    }

    public void setAnimation(int tok) {
        switch (tok) {
            case 1073742098: {
                this.am.reverseAnimation();
            }
            case 4143: 
            case 0x40000110: {
                if (!this.am.animationOn) {
                    this.am.resumeAnimation();
                }
                return;
            }
            case 20487: {
                if (this.am.animationOn && !this.am.animationPaused) {
                    this.am.pauseAnimation();
                }
                return;
            }
            case 1073742037: {
                this.am.setAnimationNext();
                return;
            }
            case 1073742108: {
                this.am.setAnimationPrevious();
                return;
            }
            case 1073741942: 
            case 1073742125: {
                this.am.rewindAnimation();
                return;
            }
            case 1073741993: {
                this.am.setAnimationLast();
                return;
            }
        }
    }

    @Override
    public void setAnimationFps(int fps) {
        this.am.setAnimationFps(fps);
    }

    private void setAnimationMode(String mode) {
        if (mode.equalsIgnoreCase("once")) {
            this.am.setAnimationReplayMode(1073742070, 0.0f, 0.0f);
        } else if (mode.equalsIgnoreCase("loop")) {
            this.am.setAnimationReplayMode(528411, 1.0f, 1.0f);
        } else if (mode.startsWith("pal")) {
            this.am.setAnimationReplayMode(1073742082, 1.0f, 1.0f);
        }
    }

    public void setAnimationOn(boolean animationOn) {
        boolean wasAnimating = this.am.animationOn;
        if (animationOn == wasAnimating) {
            return;
        }
        this.am.setAnimationOn(animationOn);
    }

    public void setAnimationRange(int modelIndex1, int modelIndex2) {
        this.am.setAnimationRange(modelIndex1, modelIndex2);
    }

    @Override
    public BS getVisibleFramesBitSet() {
        BS bs = BSUtil.copy(this.am.bsVisibleModels);
        if (this.ms.trajectory != null) {
            this.ms.trajectory.selectDisplayed(bs);
        }
        return bs;
    }

    public BS getFrameAtoms() {
        return this.getModelUndeletedAtomsBitSetBs(this.getVisibleFramesBitSet());
    }

    public void defineAtomSets(Map<String, Object> info) {
        this.definedAtomSets.putAll(info);
    }

    public void setAnimDisplay(BS bs) {
        this.am.setDisplay(bs);
        if (!this.am.animationOn) {
            this.am.morph(this.am.currentMorphModel + 1.0f);
        }
    }

    public void setCurrentModelIndex(int modelIndex) {
        if (modelIndex == Integer.MIN_VALUE) {
            this.prevFrame = Integer.MIN_VALUE;
            this.setCurrentModelIndexClear(this.am.cmi, true);
            return;
        }
        this.am.setModel(modelIndex, true);
    }

    public String getTrajectoryState() {
        return this.ms.trajectory == null ? "" : this.ms.trajectory.getState();
    }

    public void setFrameOffsets(BS bsAtoms, boolean isFull) {
        this.tm.bsFrameOffsets = null;
        if (isFull) {
            this.clearModelDependentObjects();
        } else {
            this.tm.bsFrameOffsets = bsAtoms;
        }
        this.tm.frameOffsets = this.ms.getFrameOffsets(bsAtoms, isFull);
    }

    public void setCurrentModelIndexClear(int modelIndex, boolean clearBackground) {
        this.am.setModel(modelIndex, clearBackground);
    }

    public boolean haveFileSet() {
        return this.ms.mc > 1 && this.getModelNumber(Integer.MAX_VALUE) > 2000000;
    }

    public void setBackgroundModelIndex(int modelIndex) {
        this.am.setBackgroundModelIndex(modelIndex);
        this.g.setO("backgroundModel", this.ms.getModelNumberDotted(modelIndex));
    }

    void setFrameVariables() {
        this.g.setO("animationMode", T.nameOf(this.am.animationReplayMode));
        this.g.setI("animationFps", this.am.animationFps);
        this.g.setO("_firstFrame", this.am.getModelSpecial(-1));
        this.g.setO("_lastFrame", this.am.getModelSpecial(1));
        this.g.setF("_animTimeSec", this.am.getAnimRunTimeSeconds());
        this.g.setB("_animMovie", this.am.isMovie);
    }

    public boolean getInMotion(boolean includeAnim) {
        return this.inMotion || includeAnim && this.am.animationOn;
    }

    @Override
    public int getMotionEventNumber() {
        return this.motionEventNumber;
    }

    @Override
    public void setInMotion(boolean inMotion) {
        if (this.inMotion ^ inMotion) {
            this.inMotion = inMotion;
            this.resizeImage(0, 0, false, false, true);
            if (inMotion) {
                this.startHoverWatcher(false);
                ++this.motionEventNumber;
            } else {
                this.startHoverWatcher(true);
                this.refresh(3, "vwr setInMotion " + inMotion);
            }
        }
    }

    private void setRefreshing(boolean TF) {
        this.refreshing = TF;
    }

    public boolean getRefreshing() {
        return this.refreshing;
    }

    @Override
    public void pushHoldRepaint() {
        this.pushHoldRepaintWhy(null);
    }

    public void pushHoldRepaintWhy(String why) {
        if (this.rm != null) {
            this.rm.pushHoldRepaint(why);
        }
    }

    @Override
    public void popHoldRepaint(String why) {
        if (this.rm != null) {
            this.rm.popHoldRepaint(why.indexOf("\u0001## REPAINT_IGNORE ##") < 0, why);
        }
    }

    @Override
    public void refresh(int mode, String strWhy) {
        if (this.rm == null || !this.refreshing) {
            return;
        }
        if (mode == 6 && this.getInMotion(true)) {
            return;
        }
        if (this.isWebGL) {
            if (mode == 1 || mode == 2 || mode == 7) {
                this.tm.finalizeTransformParameters();
            }
        } else if (mode > 0 && mode != 7) {
            this.rm.repaintIfReady("refresh " + mode + " " + strWhy);
        }
        if (mode != 7 && mode % 3 != 0 && this.sm.doSync()) {
            this.sm.setSync(mode == 2 ? strWhy : null);
        }
    }

    public void requestRepaintAndWait(String why) {
        if (this.rm == null) {
            return;
        }
        if (!this.haveDisplay) {
            this.setModelVisibility();
            this.shm.finalizeAtoms(null, true);
            return;
        }
        this.rm.requestRepaintAndWait(why);
        this.setSync();
    }

    public void clearShapeRenderers() {
        this.clearRepaintManager(-1);
    }

    public boolean isRepaintPending() {
        return this.rm == null ? false : this.rm.isRepaintPending();
    }

    @Override
    public void notifyViewerRepaintDone() {
        if (this.rm != null) {
            this.rm.repaintDone();
        }
        this.am.repaintDone();
    }

    public boolean areAxesTainted() {
        boolean TF = this.axesAreTainted;
        this.axesAreTainted = false;
        return TF;
    }

    private void setMaximumSize(int x) {
        this.maximumSize = Math.max(x, 100);
    }

    @Override
    public void setScreenDimension(int width, int height) {
        height = Math.min(height, this.maximumSize);
        width = Math.min(width, this.maximumSize);
        if (this.tm.stereoDoubleFull) {
            width = (width + 1) / 2;
        }
        if (this.dimScreen.width == width && this.dimScreen.height == height) {
            return;
        }
        this.resizeImage(width, height, false, false, true);
    }

    public void setStereo(boolean isStereoSlave, Object gRight) {
        this.isStereoSlave = isStereoSlave;
        this.gRight = gRight;
    }

    void resizeImage(int width, int height, boolean isImageWrite, boolean isExport, boolean isReset) {
        if (!isImageWrite && this.creatingImage) {
            return;
        }
        boolean wasAntialiased = this.antialiased;
        boolean bl = isReset ? this.g.antialiasDisplay && this.checkMotionRendering(603979786) : (this.antialiased = isImageWrite && !isExport ? this.g.antialiasImages : false);
        if (!(isExport || isImageWrite || width <= 0 && wasAntialiased == this.antialiased)) {
            this.setShapeProperty(5, "clearBoxes", null);
        }
        this.imageFontScaling = (this.antialiased ? 2.0f : 1.0f) * (isReset || this.tm.scale3D || width <= 0 ? 1.0f : (float)(this.g.zoomLarge == height > width ? height : width) * 1.0f / (float)this.getScreenDim());
        if (width > 0) {
            this.dimScreen.width = width;
            this.dimScreen.height = height;
            if (!isImageWrite) {
                this.g.setI("_width", width);
                this.g.setI("_height", height);
            }
        } else {
            width = this.dimScreen.width == 0 ? (this.dimScreen.width = 500) : this.dimScreen.width;
            height = this.dimScreen.height == 0 ? (this.dimScreen.height = 500) : this.dimScreen.height;
        }
        this.tm.setScreenParameters(width, height, isImageWrite || isReset ? this.g.zoomLarge : false, this.antialiased, false, false);
        this.gdata.setWindowParameters(width, height, this.antialiased);
        if (width > 0 && !isImageWrite) {
            this.setStatusResized(width, height);
        }
    }

    @Override
    public int getScreenWidth() {
        return this.dimScreen.width;
    }

    @Override
    public int getScreenHeight() {
        return this.dimScreen.height;
    }

    public int getScreenDim() {
        return this.g.zoomLarge == this.dimScreen.height > this.dimScreen.width ? this.dimScreen.height : this.dimScreen.width;
    }

    @Override
    public String generateOutputForExport(Map<String, Object> params) {
        return this.noGraphicsAllowed || this.rm == null ? null : this.getOutputManager().getOutputFromExport(params);
    }

    private void clearRepaintManager(int iShape) {
        if (this.rm != null) {
            this.rm.clear(iShape);
        }
    }

    public void renderScreenImageStereo(Object gLeft, boolean checkStereoSlave, int width, int height) {
        if (this.updateWindow(width, height)) {
            if (!checkStereoSlave || this.gRight == null) {
                this.getScreenImageBuffer(gLeft, false);
            } else {
                this.drawImage(this.gRight, this.getImage(true, false), 0, 0, this.tm.stereoDoubleDTI);
                this.drawImage(gLeft, this.getImage(false, false), 0, 0, this.tm.stereoDoubleDTI);
            }
        }
        if (this.captureParams != null && Boolean.FALSE != this.captureParams.get("captureEnabled")) {
            long t = (Long)this.captureParams.get("endTime");
            if (t > 0L && System.currentTimeMillis() + 50L > t) {
                this.captureParams.put("captureMode", "end");
            }
            this.processWriteOrCapture(this.captureParams);
        }
        this.notifyViewerRepaintDone();
    }

    public void updateJS() {
        if (this.isWebGL) {
            if (this.jsParams == null) {
                this.jsParams = new Hashtable<String, Object>();
                this.jsParams.put("type", "JS");
            }
            if (this.updateWindow(0, 0)) {
                this.render();
            }
            this.notifyViewerRepaintDone();
        } else {
            if (this.isStereoSlave) {
                return;
            }
            this.renderScreenImageStereo(this.apiPlatform.getGraphics(null), true, 0, 0);
        }
    }

    private void updateJSView(int imodel, int iatom) {
        Object applet = this.html5Applet;
    }

    private boolean updateWindow(int width, int height) {
        if (!this.refreshing || this.creatingImage) {
            return this.refreshing ? false : !this.isJS;
        }
        if (this.isTainted || this.tm.slabEnabled) {
            this.setModelVisibility();
        }
        this.isTainted = false;
        if (this.rm != null && width != 0) {
            this.setScreenDimension(width, height);
        }
        return true;
    }

    @Override
    public void renderScreenImage(Object g, int width, int height) {
        this.renderScreenImageStereo(g, false, width, height);
    }

    private Object getImage(boolean isDouble, boolean isImageWrite) {
        Object image;
        block3: {
            image = null;
            try {
                this.beginRendering(isDouble, isImageWrite);
                this.render();
                this.gdata.endRendering();
                image = this.gdata.getScreenImage(isImageWrite);
            }
            catch (Error er) {
                this.gdata.getScreenImage(isImageWrite);
                this.handleError(er, false);
                this.setErrorMessage("Error during rendering: " + er, null);
            }
            catch (Exception e) {
                System.out.println("render error" + e);
                if (this.isJS) break block3;
                e.printStackTrace();
            }
        }
        return image;
    }

    private void beginRendering(boolean isDouble, boolean isImageWrite) {
        this.gdata.beginRendering(this.tm.getStereoRotationMatrix(isDouble), this.g.translucent, isImageWrite, !this.checkMotionRendering(603979967));
    }

    private void render() {
        if (this.mm.modelSet == null || !this.mustRender || !this.refreshing && !this.creatingImage || this.rm == null) {
            return;
        }
        boolean antialias2 = this.antialiased && this.g.antialiasTranslucent;
        int[] navMinMax = this.shm.finalizeAtoms(this.tm.bsSelectedAtoms, true);
        if (this.isWebGL) {
            this.rm.renderExport(this.gdata, this.ms, this.jsParams);
            this.notifyViewerRepaintDone();
            return;
        }
        this.rm.render(this.gdata, this.ms, true, navMinMax);
        if (this.gdata.setPass2(antialias2)) {
            this.tm.setAntialias(antialias2);
            this.rm.render(this.gdata, this.ms, false, null);
            this.tm.setAntialias(this.antialiased);
        }
    }

    private void drawImage(Object graphic, Object img, int x, int y, boolean isDTI) {
        if (graphic != null && img != null) {
            this.apiPlatform.drawImage(graphic, img, x, y, this.dimScreen.width, this.dimScreen.height, isDTI);
        }
        this.gdata.releaseScreenImage();
    }

    @Override
    public Object getScreenImageBuffer(Object graphic, boolean isImageWrite) {
        Object imageBuffer;
        boolean mergeImages;
        if (this.isWebGL) {
            return isImageWrite ? this.apiPlatform.allocateRgbImage(0, 0, null, 0, false, true) : null;
        }
        boolean isDouble = this.tm.stereoDoubleFull || this.tm.stereoDoubleDTI;
        boolean bl = mergeImages = graphic == null && isDouble;
        if (this.tm.stereoMode.isBiColor()) {
            this.beginRendering(true, isImageWrite);
            this.render();
            this.gdata.endRendering();
            this.gdata.snapshotAnaglyphChannelBytes();
            this.beginRendering(false, isImageWrite);
            this.render();
            this.gdata.endRendering();
            this.gdata.applyAnaglygh(this.tm.stereoMode, this.tm.stereoColors);
            imageBuffer = this.gdata.getScreenImage(isImageWrite);
        } else {
            imageBuffer = this.getImage(isDouble, isImageWrite);
        }
        Object imageBuffer2 = null;
        if (mergeImages) {
            imageBuffer2 = this.apiPlatform.newBufferedImage(imageBuffer, this.tm.stereoDoubleDTI ? this.dimScreen.width : this.dimScreen.width << 1, this.dimScreen.height);
            graphic = this.apiPlatform.getGraphics(imageBuffer2);
        }
        if (graphic != null) {
            if (isDouble) {
                if (this.tm.stereoMode == STER.DTI) {
                    this.drawImage(graphic, imageBuffer, this.dimScreen.width >> 1, 0, true);
                    imageBuffer = this.getImage(false, false);
                    this.drawImage(graphic, imageBuffer, 0, 0, true);
                    graphic = null;
                } else {
                    this.drawImage(graphic, imageBuffer, this.dimScreen.width, 0, false);
                    imageBuffer = this.getImage(false, false);
                }
            }
            if (graphic != null) {
                this.drawImage(graphic, imageBuffer, 0, 0, false);
            }
        }
        return mergeImages ? imageBuffer2 : imageBuffer;
    }

    @Override
    public byte[] getImageAsBytes(String type, int width, int height, int quality, String[] errMsg) {
        return this.getOutputManager().getImageAsBytes(type, width, height, quality, errMsg);
    }

    @Override
    public void releaseScreenImage() {
        this.gdata.releaseScreenImage();
    }

    @Override
    public String evalFile(String strFilename) {
        return this.allowScripting && this.getScriptManager() != null ? this.scm.evalFile(strFilename) : null;
    }

    public String getInsertedCommand() {
        String s = this.insertedCommand;
        this.insertedCommand = "";
        if (Logger.debugging && s != "") {
            Logger.debug("inserting: " + s);
        }
        return s;
    }

    @Override
    public String script(String strScript) {
        return this.evalStringQuietSync(strScript, false, true);
    }

    @Override
    public String evalString(String strScript) {
        return this.evalStringQuietSync(strScript, false, true);
    }

    @Override
    public String evalStringQuiet(String strScript) {
        return this.evalStringQuietSync(strScript, true, true);
    }

    public String evalStringQuietSync(String strScript, boolean isQuiet, boolean allowSyncScript) {
        return this.getScriptManager() == null ? null : this.scm.evalStringQuietSync(strScript, isQuiet, allowSyncScript);
    }

    public void clearScriptQueue() {
        if (this.scm != null) {
            this.scm.clearQueue();
        }
    }

    private void setScriptQueue(boolean TF) {
        this.g.useScriptQueue = TF;
        if (!TF) {
            this.clearScriptQueue();
        }
    }

    @Override
    public boolean checkHalt(String str, boolean isInsert) {
        return this.scm != null && this.scm.checkHalt(str, isInsert);
    }

    @Override
    public String scriptWait(String strScript) {
        return (String)this.evalWait("JSON", strScript, "+scriptStarted,+scriptStatus,+scriptEcho,+scriptTerminated");
    }

    @Override
    public Object scriptWaitStatus(String strScript, String statusList) {
        return this.evalWait("object", strScript, statusList);
    }

    private Object evalWait(String returnType, String strScript, String statusList) {
        if (this.getScriptManager() == null) {
            return null;
        }
        this.scm.waitForQueue();
        boolean doTranslateTemp = GT.setDoTranslate(false);
        Object ret = this.evalStringWaitStatusQueued(returnType, strScript, statusList, false, false);
        GT.setDoTranslate(doTranslateTemp);
        return ret;
    }

    public synchronized Object evalStringWaitStatusQueued(String returnType, String strScript, String statusList, boolean isQuiet, boolean isQueued) {
        return this.getScriptManager() == null ? null : this.scm.evalStringWaitStatusQueued(returnType, strScript, statusList, isQuiet, isQueued);
    }

    public void exitJmol() {
        if (this.isApplet && !this.isJNLP) {
            return;
        }
        if (this.headlessImageParams != null) {
            try {
                if (this.headless) {
                    this.outputToFile(this.headlessImageParams);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (Logger.debugging) {
            Logger.debug("exitJmol -- exiting");
        }
        System.out.flush();
        System.exit(0);
    }

    private Object scriptCheckRet(String strScript, boolean returnContext) {
        return this.getScriptManager() == null ? null : this.scm.scriptCheckRet(strScript, returnContext);
    }

    @Override
    public synchronized Object scriptCheck(String strScript) {
        return this.getScriptManager() == null ? null : this.scriptCheckRet(strScript, false);
    }

    @Override
    public boolean isScriptExecuting() {
        return this.eval != null && this.eval.isExecuting();
    }

    @Override
    public void haltScriptExecution() {
        if (this.eval != null) {
            this.eval.haltExecution();
            this.eval.stopScriptThreads();
        }
        this.setStringPropertyTok("pathForAllFiles", 545259572, "");
        this.clearTimeouts();
    }

    public void pauseScriptExecution() {
        if (this.eval != null) {
            this.eval.pauseExecution(true);
        }
    }

    String resolveDatabaseFormat(String fileName) {
        if (Viewer.hasDatabasePrefix(fileName)) {
            fileName = (String)this.setLoadFormat(fileName, fileName.charAt(0), false);
        }
        return fileName;
    }

    public static boolean hasDatabasePrefix(String fileName) {
        return fileName.length() != 0 && Viewer.isDatabaseCode(fileName.charAt(0));
    }

    public static boolean isDatabaseCode(char ch) {
        return ch == '*' || ch == '$' || ch == '=' || ch == ':';
    }

    public Object setLoadFormat(String name, char type, boolean withPrefix) {
        String format = null;
        String id = name.substring(1);
        switch (type) {
            case '=': {
                if (name.startsWith("==")) {
                    id = id.substring(1);
                    type = (char)35;
                } else {
                    if (id.indexOf("/") > 0) {
                        try {
                            int pt = id.indexOf("/");
                            String database = id.substring(0, pt);
                            id = this.g.resolveDataBase(database, id.substring(pt + 1), null);
                            if (id != null && id.startsWith("'")) {
                                id = this.evaluateExpression(id).toString();
                            }
                            return id == null || id.length() == 0 ? name : id;
                        }
                        catch (Exception e) {
                            return name;
                        }
                    }
                    if (id.endsWith(".mmtf")) {
                        id = id.substring(0, id.indexOf(".mmtf"));
                        return this.g.resolveDataBase("mmtf", id.toUpperCase(), null);
                    }
                    format = this.isJS && this.g.loadFormat.equals(this.g.pdbLoadFormat) ? this.g.pdbLoadFormat0 : this.g.loadFormat;
                }
            }
            case '#': {
                if (format == null) {
                    format = this.g.pdbLoadLigandFormat;
                }
                if (id.indexOf(".") >= 0 && format.equals(this.g.pdbLoadFormat)) {
                    format = this.g.pdbLoadFormat0;
                }
                return this.g.resolveDataBase(null, id, format);
            }
            case '*': {
                int pt = name.lastIndexOf("/");
                if (name.startsWith("*dom/")) {
                    id = name.substring(pt + 1);
                    format = pt > 4 ? name.substring(5) : "mappings";
                    return PT.rep(this.g.resolveDataBase("map", id, null), "%TYPE", format);
                }
                if (name.startsWith("*val/")) {
                    id = name.substring(pt + 1);
                    format = pt > 4 ? name.substring(5) : "validation/outliers/all";
                    return PT.rep(this.g.resolveDataBase("map", id, null), "%TYPE", format);
                }
                if (name.startsWith("*rna3d/")) {
                    id = name.substring(pt + 1);
                    format = pt > 6 ? name.substring(6) : "loops";
                    return PT.rep(this.g.resolveDataBase("rna3d", id, null), "%TYPE", format);
                }
                if (name.startsWith("*dssr--")) {
                    id = name.substring(pt + 1);
                    id = this.g.resolveDataBase("dssr", id, null);
                    return id + "%20" + PT.rep(name.substring(5, pt), " ", "%20");
                }
                if (name.startsWith("*dssr/")) {
                    id = name.substring(pt + 1);
                    return this.g.resolveDataBase("dssr", id, null);
                }
                if (name.startsWith("*dssr1/")) {
                    id = name.substring(pt + 1);
                    return this.g.resolveDataBase("dssr1", id, null);
                }
                String pdbe = "pdbe";
                if (id.length() == 5 && id.charAt(4) == '*') {
                    pdbe = "pdbe2";
                    id = id.substring(0, 4);
                }
                return this.g.resolveDataBase(pdbe, id, null);
            }
            case ':': {
                format = this.g.pubChemFormat;
                if (id.equals("")) {
                    try {
                        id = "smiles:" + this.getOpenSmiles(this.bsA());
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                String fl = id.toLowerCase();
                int fi = Integer.MIN_VALUE;
                try {
                    fi = Integer.parseInt(id);
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (fi != Integer.MIN_VALUE) {
                    id = "cid/" + fi;
                } else if (fl.startsWith("smiles:")) {
                    format = format + "?POST?smiles=" + id.substring(7);
                    id = "smiles";
                } else if (id.startsWith("cid:") || id.startsWith("inchikey:") || id.startsWith("cas:")) {
                    id = id.replace(':', '/');
                } else {
                    if (fl.startsWith("name:")) {
                        id = id.substring(5);
                    }
                    id = "name/" + PT.escapeUrl(id);
                }
                return PT.formatStringS(format, "FILE", id);
            }
            case '$': {
                if (name.startsWith("$$")) {
                    id = id.substring(1);
                    format = PT.rep(this.g.smilesUrlFormat, "&get3d=True", "");
                    return PT.formatStringS(format, "FILE", PT.escapeUrl(id));
                }
                if (name.equals("$")) {
                    try {
                        id = this.getOpenSmiles(this.bsA());
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
            }
            case '/': 
            case '2': 
            case 'I': 
            case 'K': 
            case 'M': 
            case 'N': 
            case 'S': 
            case 'T': {
                id = PT.escapeUrl(id);
                switch (type) {
                    case 'M': 
                    case 'N': {
                        format = this.g.nihResolverFormat + "/names";
                        break;
                    }
                    case '2': {
                        format = this.g.nihResolverFormat + "/image";
                        break;
                    }
                    case 'I': 
                    case 'T': {
                        format = this.g.nihResolverFormat + "/stdinchi";
                        break;
                    }
                    case 'K': {
                        format = this.g.nihResolverFormat + "/inchikey";
                        break;
                    }
                    case 'S': {
                        format = this.g.nihResolverFormat + "/stdinchikey";
                        break;
                    }
                    case '/': {
                        format = this.g.nihResolverFormat + "/";
                        break;
                    }
                    default: {
                        format = this.g.smilesUrlFormat;
                    }
                }
                return (withPrefix ? "MOL3D::" : "") + PT.formatStringS(format, "FILE", id);
            }
            case '_': {
                if (name.startsWith("*")) {
                    boolean isDiff = id.startsWith("*");
                    if (isDiff) {
                        id = id.substring(1);
                    }
                    return this.g.resolveDataBase(isDiff ? "pdbemapdiff" : "pdbemap", id, null);
                }
                return this.g.fixSurfaceFileNameVariables(id);
            }
        }
        return id;
    }

    public String getStandardLabelFormat(int type) {
        switch (type) {
            default: {
                return "%[identify]";
            }
            case 1: {
                return this.g.defaultLabelXYZ;
            }
            case 2: 
        }
        return this.g.defaultLabelPDB;
    }

    public P3[] getAdditionalHydrogens(BS bsAtoms, boolean doAll, boolean justCarbon, Lst<Atom> vConnections) {
        if (bsAtoms == null) {
            bsAtoms = this.bsA();
        }
        int[] nTotal = new int[1];
        P3[][] pts = this.ms.calculateHydrogens(bsAtoms, nTotal, doAll, justCarbon, vConnections);
        P3[] points = new P3[nTotal[0]];
        int pt = 0;
        for (int i = 0; i < pts.length; ++i) {
            if (pts[i] == null) continue;
            for (int j = 0; j < pts[i].length; ++j) {
                points[pt++] = pts[i][j];
            }
        }
        return points;
    }

    @Override
    public void setMarBond(short marBond) {
        this.g.bondRadiusMilliAngstroms = marBond;
        this.g.setI("bondRadiusMilliAngstroms", marBond);
        this.setShapeSize(1, marBond * 2, BSUtil.setAll(this.ms.ac));
    }

    public void setHoverLabel(String strLabel) {
        this.shm.loadShape(35);
        this.setShapeProperty(35, "label", strLabel);
        this.setHoverEnabled(strLabel != null);
        this.hoverLabel = strLabel;
        this.g.setO("_hoverLabel", this.hoverLabel);
        if (!this.hoverEnabled && !this.sm.haveHoverCallback()) {
            this.startHoverWatcher(false);
        }
    }

    private void setHoverEnabled(boolean tf) {
        this.hoverEnabled = tf;
        this.g.setB("_hoverEnabled", tf);
    }

    void hoverOn(int atomIndex, boolean isLabel) {
        this.g.removeParam("_objecthovered");
        this.g.setI("_atomhovered", atomIndex);
        this.g.setO("_hoverLabel", this.hoverLabel);
        this.g.setUserVariable("hovered", SV.getVariable(BSUtil.newAndSetBit(atomIndex)));
        if (this.sm.haveHoverCallback()) {
            this.sm.setStatusAtomHovered(atomIndex, this.getAtomInfoXYZ(atomIndex, false));
        }
        if (!this.hoverEnabled) {
            return;
        }
        if (this.g.modelKitMode) {
            if (this.ms.isAtomAssignable(atomIndex)) {
                this.highlight(BSUtil.newAndSetBit(atomIndex));
            }
            this.refresh(3, "hover on atom");
            return;
        }
        if (this.eval != null && this.isScriptExecuting() || atomIndex == this.hoverAtomIndex || this.g.hoverDelayMs == 0) {
            return;
        }
        if (!this.slm.isInSelectionSubset(atomIndex)) {
            return;
        }
        this.shm.loadShape(35);
        if (isLabel && this.ms.at[atomIndex].isVisible(512)) {
            this.setShapeProperty(35, "specialLabel", GT._("Drag to move label"));
        }
        this.setShapeProperty(35, "text", null);
        this.setShapeProperty(35, "target", atomIndex);
        this.hoverText = null;
        this.hoverAtomIndex = atomIndex;
        this.refresh(3, "hover on atom");
    }

    public void hoverOnPt(int x, int y, String text, String id, T3 pt) {
        if (this.eval != null && this.isScriptExecuting()) {
            return;
        }
        this.g.setO("_hoverLabel", this.hoverLabel);
        if (id != null && pt != null) {
            this.g.setO("_objecthovered", id);
            this.g.setI("_atomhovered", -1);
            this.g.setUserVariable("hovered", SV.getVariable(pt));
            if (this.sm.haveHoverCallback()) {
                this.sm.setStatusObjectHovered(id, text, pt);
            }
        }
        if (!this.hoverEnabled) {
            return;
        }
        this.shm.loadShape(35);
        this.setShapeProperty(35, "xy", P3i.new3(x, y, 0));
        this.setShapeProperty(35, "target", null);
        this.setShapeProperty(35, "specialLabel", null);
        this.setShapeProperty(35, "text", text);
        this.hoverAtomIndex = -1;
        this.hoverText = text;
        this.refresh(3, "hover on point");
    }

    void hoverOff() {
        try {
            boolean isHover;
            if (this.g.modelKitMode) {
                this.highlight(null);
            }
            if (!this.hoverEnabled) {
                return;
            }
            boolean bl = isHover = this.hoverText != null || this.hoverAtomIndex >= 0;
            if (this.hoverAtomIndex >= 0) {
                this.setShapeProperty(35, "target", null);
                this.hoverAtomIndex = -1;
            }
            if (this.hoverText != null) {
                this.setShapeProperty(35, "text", null);
                this.hoverText = null;
            }
            this.setShapeProperty(35, "specialLabel", null);
            if (isHover) {
                this.refresh(3, "hover off");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void setDebugScript(boolean debugScript) {
        this.g.debugScript = debugScript;
        this.g.setB("debugScript", debugScript);
        if (this.eval != null) {
            this.eval.setDebugging();
        }
    }

    void clearClickCount() {
        this.setTainted(true);
    }

    public void setCursor(int cursor) {
        if (this.isKiosk || this.currentCursor == cursor || this.multiTouch || !this.haveDisplay) {
            return;
        }
        this.currentCursor = cursor;
        this.apiPlatform.setCursor(this.currentCursor, this.display);
    }

    void setPickingMode(String strMode, int pickingMode) {
        if (!this.haveDisplay) {
            return;
        }
        this.showSelected = false;
        String option = null;
        if (strMode != null) {
            int pt = strMode.indexOf("_");
            if (pt >= 0) {
                option = strMode.substring(pt + 1);
                strMode = strMode.substring(0, pt);
            }
            pickingMode = ActionManager.getPickingMode(strMode);
        }
        if (pickingMode < 0) {
            pickingMode = 1;
        }
        this.acm.setPickingMode(pickingMode);
        this.g.setO("picking", ActionManager.getPickingModeName(this.acm.getAtomPickingMode()));
        if (option == null || option.length() == 0) {
            return;
        }
        option = Character.toUpperCase(option.charAt(0)) + (option.length() == 1 ? "" : option.substring(1, 2));
        switch (pickingMode) {
            case 32: {
                this.setAtomPickingOption(option);
                break;
            }
            case 33: {
                this.setBondPickingOption(option);
                break;
            }
            default: {
                Logger.error("Bad picking mode: " + strMode + "_" + option);
            }
        }
    }

    public int getPickingMode() {
        return this.haveDisplay ? this.acm.getAtomPickingMode() : 0;
    }

    void setPickingStyle(String style, int pickingStyle) {
        if (!this.haveDisplay) {
            return;
        }
        if (style != null) {
            pickingStyle = ActionManager.getPickingStyleIndex(style);
        }
        if (pickingStyle < 0) {
            pickingStyle = 0;
        }
        this.acm.setPickingStyle(pickingStyle);
        this.g.setO("pickingStyle", ActionManager.getPickingStyleName(this.acm.getPickingStyle()));
    }

    public boolean getDrawHover() {
        return this.haveDisplay && this.g.drawHover;
    }

    public String getAtomInfo(int atomOrPointIndex) {
        if (this.ptTemp == null) {
            this.ptTemp = new P3();
        }
        return atomOrPointIndex >= 0 ? this.ms.getAtomInfo(atomOrPointIndex, null, this.ptTemp) : (String)this.shm.getShapePropertyIndex(6, "pointInfo", -atomOrPointIndex);
    }

    private String getAtomInfoXYZ(int atomIndex, boolean useChimeFormat) {
        Atom atom = this.ms.at[atomIndex];
        if (useChimeFormat) {
            return this.getChimeMessenger().getInfoXYZ(atom);
        }
        if (this.ptTemp == null) {
            this.ptTemp = new P3();
        }
        return atom.getIdentityXYZ(true, this.ptTemp);
    }

    private void setSync() {
        if (this.sm.doSync()) {
            this.sm.setSync(null);
        }
    }

    @Override
    public void setJmolCallbackListener(JmolCallbackListener listener) {
        this.sm.cbl = listener;
    }

    @Override
    public void setJmolStatusListener(JmolStatusListener listener) {
        this.sm.jsl = listener;
        this.sm.cbl = this.sm.jsl;
    }

    public Lst<Lst<Lst<Object>>> getStatusChanged(String statusNameList) {
        return statusNameList == null ? null : this.sm.getStatusChanged(statusNameList);
    }

    public boolean menuEnabled() {
        return !this.g.disablePopupMenu && this.getPopupMenu() != null;
    }

    void popupMenu(int x, int y, char type) {
        if (!this.haveDisplay || !this.refreshing || this.isPreviewOnly || this.g.disablePopupMenu) {
            return;
        }
        switch (type) {
            case 'j': {
                try {
                    this.getPopupMenu();
                    this.jmolpopup.jpiShow(x, y);
                }
                catch (Throwable e) {
                    Logger.info(e.toString());
                    this.g.disablePopupMenu = true;
                }
                break;
            }
            case 'a': 
            case 'b': 
            case 'm': {
                if (this.modelkitPopup == null && (this.modelkitPopup = this.apiPlatform.getMenuPopup(null, type)) == null) {
                    return;
                }
                this.modelkitPopup.jpiShow(x, y);
            }
        }
    }

    public String getMenu(String type) {
        this.getPopupMenu();
        if (type.equals("\u0000")) {
            this.popupMenu(this.dimScreen.width - 120, 0, 'j');
            return "OK";
        }
        return this.jmolpopup == null ? "" : this.jmolpopup.jpiGetMenuAsString("Jmol version " + Viewer.getJmolVersion() + "|_GET_MENU|" + type);
    }

    private Object getPopupMenu() {
        if (this.g.disablePopupMenu) {
            return null;
        }
        if (this.jmolpopup == null) {
            GenericMenuInterface genericMenuInterface = this.jmolpopup = this.allowScripting ? this.apiPlatform.getMenuPopup(this.menuStructure, 'j') : null;
            if (this.jmolpopup == null && !this.async) {
                this.g.disablePopupMenu = true;
                return null;
            }
        }
        return this.jmolpopup.jpiGetMenuAsObject();
    }

    @Override
    public void setMenu(String fileOrText, boolean isFile) {
        if (isFile) {
            Logger.info("Setting menu " + (fileOrText.length() == 0 ? "to Jmol defaults" : "from file " + fileOrText));
        }
        if (fileOrText.length() == 0) {
            fileOrText = null;
        } else if (isFile) {
            fileOrText = this.getFileAsString3(fileOrText, false, null);
        }
        this.getProperty("DATA_API", "setMenu", fileOrText);
        this.sm.setCallbackFunction("menu", fileOrText);
    }

    void setStatusFrameChanged(boolean isVib, boolean doNotify) {
        String strModelNo;
        int lastNo;
        if (isVib) {
            this.prevFrame = Integer.MIN_VALUE;
        }
        this.tm.setVibrationPeriod(Float.NaN);
        int firstIndex = this.am.firstFrameIndex;
        int lastIndex = this.am.lastFrameIndex;
        boolean isMovie = this.am.isMovie;
        int modelIndex = this.am.cmi;
        if (firstIndex == lastIndex && !isMovie) {
            modelIndex = firstIndex;
        }
        int frameID = this.getModelFileNumber(modelIndex);
        int currentFrame = this.am.cmi;
        int fileNo = frameID;
        int modelNo = frameID % 1000000;
        int firstNo = isMovie ? firstIndex : this.getModelFileNumber(firstIndex);
        int n = lastNo = isMovie ? lastIndex : this.getModelFileNumber(lastIndex);
        if (isMovie) {
            strModelNo = "" + (currentFrame + 1);
        } else if (fileNo == 0) {
            strModelNo = this.getModelNumberDotted(firstIndex);
            if (firstIndex != lastIndex) {
                strModelNo = strModelNo + " - " + this.getModelNumberDotted(lastIndex);
            }
            if (firstNo / 1000000 == lastNo / 1000000) {
                fileNo = firstNo;
            }
        } else {
            strModelNo = this.getModelNumberDotted(modelIndex);
        }
        if (fileNo != 0) {
            int n2 = fileNo = fileNo < 1000000 ? 1 : fileNo / 1000000;
        }
        if (!isMovie) {
            this.g.setI("_currentFileNumber", fileNo);
            this.g.setI("_currentModelNumberInFile", modelNo);
        }
        float currentMorphModel = this.am.currentMorphModel;
        this.g.setI("_currentFrame", currentFrame);
        this.g.setI("_morphCount", this.am.morphCount);
        this.g.setF("_currentMorphFrame", currentMorphModel);
        this.g.setI("_frameID", frameID);
        this.g.setI("_modelIndex", modelIndex);
        this.g.setO("_modelNumber", strModelNo);
        this.g.setO("_modelName", modelIndex < 0 ? "" : this.getModelName(modelIndex));
        String title = modelIndex < 0 ? "" : this.ms.getModelTitle(modelIndex);
        this.g.setO("_modelTitle", title == null ? "" : title);
        this.g.setO("_modelFile", modelIndex < 0 ? "" : this.ms.getModelFileName(modelIndex));
        this.g.setO("_modelType", modelIndex < 0 ? "" : this.ms.getModelFileType(modelIndex));
        if (currentFrame == this.prevFrame && currentMorphModel == this.prevMorphModel) {
            return;
        }
        this.prevFrame = currentFrame;
        this.prevMorphModel = currentMorphModel;
        String entryName = this.getModelName(currentFrame);
        if (isMovie) {
            entryName = "" + (entryName == "" ? currentFrame + 1 : this.am.caf + 1) + ": " + entryName;
        } else {
            String script = "" + this.getModelNumberDotted(currentFrame);
            if (!entryName.equals(script)) {
                entryName = script + ": " + entryName;
            }
        }
        this.sm.setStatusFrameChanged(fileNo, modelNo, this.am.animationDirection < 0 ? -firstNo : firstNo, this.am.currentDirection < 0 ? -lastNo : lastNo, currentFrame, currentMorphModel, entryName);
        if (this.doHaveJDX()) {
            this.getJSV().setModel(modelIndex);
        }
        if (this.isJS) {
            this.updateJSView(modelIndex, -1);
        }
    }

    private boolean doHaveJDX() {
        return this.haveJDX || (this.haveJDX = this.getBooleanProperty("_JSpecView".toLowerCase()));
    }

    JmolJSpecView getJSV() {
        if (this.jsv == null) {
            this.jsv = (JmolJSpecView)Interface.getOption("jsv.JSpecView", this, "script");
            this.jsv.setViewer(this);
        }
        return this.jsv;
    }

    public int getJDXBaseModelIndex(int modelIndex) {
        if (!this.doHaveJDX()) {
            return modelIndex;
        }
        return this.getJSV().getBaseModelIndex(modelIndex);
    }

    public Object getJspecViewProperties(Object myParam) {
        Map<String, Object> o = this.sm.getJspecViewProperties("" + myParam);
        if (o != null) {
            this.haveJDX = true;
        }
        return o;
    }

    public void scriptEcho(String strEcho) {
        if (!Logger.isActiveLevel(4)) {
            return;
        }
        this.sm.setScriptEcho(strEcho, this.isScriptQueued());
        if (this.listCommands && strEcho != null && strEcho.indexOf("$[") == 0) {
            Logger.info(strEcho);
        }
    }

    private boolean isScriptQueued() {
        return this.scm != null && this.scm.isScriptQueued();
    }

    public void notifyError(String errType, String errMsg, String errMsgUntranslated) {
        this.g.setO("_errormessage", errMsgUntranslated);
        this.sm.notifyError(errType, errMsg, errMsgUntranslated);
    }

    public String jsEval(String strEval) {
        return "" + this.sm.jsEval(strEval);
    }

    public SV jsEvalSV(String strEval) {
        return SV.getVariable(this.isJS ? this.sm.jsEval(strEval) : this.jsEval(strEval));
    }

    private void setFileLoadStatus(FIL ptLoad, String fullPathName, String fileName, String modelName, String strError, Boolean isAsync) {
        boolean doCallback;
        this.setErrorMessage(strError, null);
        this.g.setI("_loadPoint", ptLoad.getCode());
        boolean bl = doCallback = ptLoad != FIL.CREATING_MODELSET;
        if (doCallback) {
            this.setStatusFrameChanged(false, false);
        }
        this.sm.setFileLoadStatus(fullPathName, fileName, modelName, strError, ptLoad.getCode(), doCallback, isAsync);
        if (doCallback) {
            if (this.doHaveJDX()) {
                this.getJSV().setModel(this.am.cmi);
            }
            if (this.isJS) {
                this.updateJSView(this.am.cmi, -2);
            }
        }
    }

    public String getZapName() {
        return this.g.modelKitMode ? "Jmol Model Kit" : "zapped";
    }

    public void setStatusMeasuring(String status, int intInfo, String strMeasure, float value) {
        this.sm.setStatusMeasuring(status, intInfo, strMeasure, value);
    }

    public void notifyMinimizationStatus() {
        Object step = this.getP("_minimizationStep");
        String ff = (String)this.getP("_minimizationForceField");
        this.sm.notifyMinimizationStatus((String)this.getP("_minimizationStatus"), step instanceof String ? Integer.valueOf(0) : (Integer)step, (Float)this.getP("_minimizationEnergy"), step.toString().equals("0") ? Float.valueOf(0.0f) : (Float)this.getP("_minimizationEnergyDiff"), ff);
    }

    public void setStatusAtomPicked(int atomIndex, String info, Map<String, Object> map) {
        MeasurementPending m;
        if (info == null) {
            info = this.g.pickLabel;
            info = info.length() == 0 ? this.getAtomInfoXYZ(atomIndex, this.g.messageStyleChime) : this.ms.getAtomInfo(atomIndex, info, this.ptTemp);
        }
        this.setPicked(atomIndex);
        if (atomIndex < 0 && (m = this.getPendingMeasurement()) != null) {
            info = info.substring(0, info.length() - 1) + ",\"" + m.getString() + "\"]";
        }
        this.g.setO("_pickinfo", info);
        this.sm.setStatusAtomPicked(atomIndex, info, map);
        if (atomIndex < 0) {
            return;
        }
        int syncMode = this.sm.getSyncMode();
        if (syncMode == 1 && this.doHaveJDX()) {
            this.getJSV().atomPicked(atomIndex);
        }
        if (this.isJS) {
            this.updateJSView(this.ms.at[atomIndex].mi, atomIndex);
        }
    }

    public boolean setStatusDragDropped(int mode, int x, int y, String fileName) {
        boolean handled;
        if (mode == 0) {
            this.g.setO("_fileDropped", fileName);
            this.g.setUserVariable("doDrop", SV.vT);
        }
        return !(handled = this.sm.setStatusDragDropped(mode, x, y, fileName)) || this.getP("doDrop").toString().equals("true");
    }

    public void setStatusResized(int width, int height) {
        this.sm.setStatusResized(width, height);
    }

    public void scriptStatus(String strStatus) {
        this.setScriptStatus(strStatus, "", 0, null);
    }

    public void scriptStatusMsg(String strStatus, String statusMessage) {
        this.setScriptStatus(strStatus, statusMessage, 0, null);
    }

    public void setScriptStatus(String strStatus, String statusMessage, int msWalltime, String strErrorMessageUntranslated) {
        this.sm.setScriptStatus(strStatus, statusMessage, msWalltime, strErrorMessageUntranslated);
    }

    @Override
    public void showUrl(String urlString) {
        if (urlString == null) {
            return;
        }
        if (urlString.indexOf(":") < 0) {
            String base = this.fm.getAppletDocumentBase();
            if (base == "") {
                base = this.fm.getFullPathName(false);
            }
            if (base.indexOf("/") >= 0) {
                base = base.substring(0, base.lastIndexOf("/") + 1);
            } else if (base.indexOf("\\") >= 0) {
                base = base.substring(0, base.lastIndexOf("\\") + 1);
            }
            urlString = base + urlString;
        }
        Logger.info("showUrl:" + urlString);
        this.sm.showUrl(urlString);
    }

    public void setMeshCreator(Object meshCreator) {
        this.shm.loadShape(24);
        this.setShapeProperty(24, "meshCreator", meshCreator);
    }

    public void showConsole(boolean showConsole) {
        if (!this.haveDisplay) {
            return;
        }
        try {
            if (this.appConsole == null && showConsole) {
                this.getConsole();
            }
            this.appConsole.setVisible(true);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public JmolAppConsoleInterface getConsole() {
        this.getProperty("DATA_API", "getAppConsole", Boolean.TRUE);
        return this.appConsole;
    }

    @Override
    public Object getParameter(String key) {
        return this.getP(key);
    }

    public Object getP(String key) {
        return this.g.getParameter(key, true);
    }

    public Object getPOrNull(String key) {
        return this.g.getParameter(key, false);
    }

    public void unsetProperty(String key) {
        if ((key = key.toLowerCase()).equals("all") || key.equals("variables")) {
            this.fm.setPathForAllFiles("");
        }
        this.g.unsetUserVariable(key);
    }

    @Override
    public void notifyStatusReady(boolean isReady) {
        System.out.println("Jmol applet " + this.fullName + (isReady ? " ready" : " destroyed"));
        if (!isReady) {
            this.dispose();
        }
        this.sm.setStatusAppletReady(this.fullName, isReady);
    }

    @Override
    public boolean getBooleanProperty(String key) {
        if (this.g.htBooleanParameterFlags.containsKey(key = key.toLowerCase())) {
            return this.g.htBooleanParameterFlags.get(key);
        }
        if (key.endsWith("p!")) {
            if (this.acm == null) {
                return false;
            }
            String s = this.acm.getPickingState().toLowerCase();
            return s.indexOf(key = key.substring(0, key.length() - 2) + ";") >= 0;
        }
        if (key.equalsIgnoreCase("executionPaused")) {
            return this.eval != null && this.eval.isPaused();
        }
        if (key.equalsIgnoreCase("executionStepping")) {
            return this.eval != null && this.eval.isStepping();
        }
        if (key.equalsIgnoreCase("haveBFactors")) {
            return this.ms.getBFactors() != null;
        }
        if (key.equalsIgnoreCase("colorRasmol")) {
            return this.cm.isDefaultColorRasmol;
        }
        if (key.equalsIgnoreCase("frank")) {
            return this.getShowFrank();
        }
        if (key.equalsIgnoreCase("spinOn")) {
            return this.tm.spinOn;
        }
        if (key.equalsIgnoreCase("isNavigating")) {
            return this.tm.isNavigating();
        }
        if (key.equalsIgnoreCase("showSelections")) {
            return this.selectionHalosEnabled;
        }
        if (this.g.htUserVariables.containsKey(key)) {
            SV t = this.g.getUserVariable(key);
            if (t.tok == 1073742335) {
                return true;
            }
            if (t.tok == 1073742334) {
                return false;
            }
        }
        Logger.error("vwr.getBooleanProperty(" + key + ") - unrecognized");
        return false;
    }

    @Override
    public int getInt(int tok) {
        switch (tok) {
            case 553648132: {
                return this.am.animationFps;
            }
            case 553648143: {
                return this.g.dotDensity;
            }
            case 0x21000010: {
                return this.g.dotScale;
            }
            case 0x21000012: {
                return this.g.helixStep;
            }
            case 553648151: {
                return this.g.meshScale;
            }
            case 553648153: {
                return this.g.minPixelSelRadius;
            }
            case 553648154: {
                return this.g.percentVdwAtom;
            }
            case 553648157: {
                return this.g.pickingSpinRate;
            }
            case 553648166: {
                return this.g.ribbonAspectRatio;
            }
            case 0x2000000A: {
                return this.g.scriptDelay;
            }
            case 553648170: {
                return this.g.smallMoleculeMaxAtoms;
            }
            case 553648184: {
                return this.g.strutSpacing;
            }
            case 553648185: {
                return this.g.vectorTrail;
            }
        }
        Logger.error("viewer.getInt(" + T.nameOf(tok) + ") - not listed");
        return 0;
    }

    public int getDelayMaximumMs() {
        return this.haveDisplay ? this.g.delayMaximumMs : 1;
    }

    public int getHermiteLevel() {
        return this.tm.spinOn && this.g.hermiteLevel > 0 ? 0 : this.g.hermiteLevel;
    }

    public int getHoverDelay() {
        return this.g.modelKitMode ? 20 : this.g.hoverDelayMs;
    }

    @Override
    public boolean getBoolean(int tok) {
        switch (tok) {
            case 603979891: {
                return this.g.nboCharges;
            }
            case 603979856: {
                return this.g.hiddenLinesDashed;
            }
            case 1073742086: {
                return this.ms.getMSInfoB("isPDB");
            }
            case 0x24000004: {
                return this.g.allowGestures;
            }
            case 603979784: {
                return this.g.allowMultiTouch;
            }
            case 603979785: {
                return this.g.allowRotateSelected;
            }
            case 603979792: {
                return this.g.appendNew;
            }
            case 603979794: {
                return this.g.applySymmetryToBonds;
            }
            case 603979796: {
                return this.g.atomPicking;
            }
            case 603979798: {
                return this.g.autoBond;
            }
            case 603979800: {
                return this.g.autoFps;
            }
            case 603979806: {
                return this.g.axesOrientationRasmol;
            }
            case 603979811: {
                return this.g.backboneSteps;
            }
            case 0x24000022: {
                return this.g.backboneBlocks;
            }
            case 0x24000024: {
                return this.g.bondModeOr;
            }
            case 603979816: {
                return this.g.cartoonBaseEdges;
            }
            case 603979817: {
                return this.g.cartoonFancy;
            }
            case 603979818: {
                return this.g.cartoonLadders;
            }
            case 603979819: {
                return this.g.cartoonRibose;
            }
            case 603979820: {
                return this.g.cartoonRockets;
            }
            case 603979823: {
                return this.g.chainCaseSensitive || this.chainCaseSpecified;
            }
            case 603979825: {
                return this.g.debugScript;
            }
            case 603979826: {
                return this.g.defaultStructureDSSP;
            }
            case 603979827: {
                return this.g.disablePopupMenu;
            }
            case 603979828: {
                return this.g.displayCellParameters;
            }
            case 603979830: {
                return this.g.dotSurface;
            }
            case 603979829: {
                return this.g.dotsSelectedOnly;
            }
            case 603979833: {
                return this.g.drawPicking;
            }
            case 0x24000044: {
                return this.g.fontCaching;
            }
            case 603979845: {
                return this.g.fontScaling;
            }
            case 603979846: {
                return this.g.forceAutoBond;
            }
            case 603979848: {
                return false;
            }
            case 603979850: {
                return this.g.greyscaleRendering;
            }
            case 603979852: {
                return this.g.hbondsBackbone;
            }
            case 603979853: {
                return this.g.hbondsRasmol;
            }
            case 603979854: {
                return this.g.hbondsSolid;
            }
            case 0x60200006: {
                return this.g.rasmolHeteroSetting;
            }
            case 603979858: {
                return this.g.hideNameInPopup;
            }
            case 603979864: {
                return this.g.highResolutionFlag;
            }
            case 1612709900: {
                return this.g.rasmolHydrogenSetting;
            }
            case 603979867: {
                return this.g.isosurfaceKey;
            }
            case 603979869: {
                return this.g.jmolInJSpecView;
            }
            case 603979871: {
                return this.g.justifyMeasurements;
            }
            case 603979873: {
                return this.g.legacyAutoBonding;
            }
            case 603979874: {
                return this.g.legacyHAddition;
            }
            case 603979877: {
                return this.g.logGestures;
            }
            case 603979878: {
                return this.g.measureAllModels;
            }
            case 603979879: {
                return this.g.measurementLabels;
            }
            case 603979880: {
                return this.g.messageStyleChime;
            }
            case 603979883: {
                return this.g.modelKitMode;
            }
            case 603979886: {
                return this.g.multipleBondBananas;
            }
            case 603979889: {
                return this.g.navigationMode;
            }
            case 603979890: {
                return this.g.navigationPeriodic;
            }
            case 603979892: {
                return this.g.partialDots;
            }
            case 603979895: {
                return this.g.pdbSequential;
            }
            case 603979897: {
                return this.g.preserveState;
            }
            case 603979900: {
                return this.g.ribbonBorder;
            }
            case 603979901: {
                return this.g.rocketBarrels;
            }
            case 603979906: {
                return this.g.selectAllModels;
            }
            case 603979920: {
                return this.g.showHiddenSelectionHalos;
            }
            case 603979922: {
                return this.g.showHydrogens;
            }
            case 603979926: {
                return this.g.showMeasurements;
            }
            case 603979927: {
                return this.g.showModVecs;
            }
            case 603979928: {
                return this.g.showMultipleBonds;
            }
            case 603979934: {
                return this.g.showTiming;
            }
            case 603979937: {
                return this.g.showUnitCellDetails;
            }
            case 603979939: {
                return this.g.slabByAtom;
            }
            case 603979940: {
                return this.g.slabByMolecule;
            }
            case 603979944: {
                return this.g.smartAromatic;
            }
            case 1612709912: {
                return this.g.solventOn;
            }
            case 603979952: {
                return this.g.ssbondsBackbone;
            }
            case 603979955: {
                return this.g.strutsMultiple;
            }
            case 603979960: {
                return this.g.testFlag1;
            }
            case 603979962: {
                return this.g.testFlag2;
            }
            case 603979964: {
                return this.g.testFlag3;
            }
            case 603979965: {
                return this.g.testFlag4;
            }
            case 603979966: {
                return this.g.traceAlpha;
            }
            case 603979967: {
                return this.g.translucent;
            }
            case 603979968: {
                return this.g.twistedSheets;
            }
            case 603979972: {
                return this.g.vectorsCentered;
            }
            case 603979973: {
                return this.g.vectorSymmetry;
            }
            case 603979975: {
                return this.g.waitForMoveTo;
            }
            case 603979978: {
                return this.g.zeroBasedXyzRasmol;
            }
        }
        Logger.error("viewer.getBoolean(" + T.nameOf(tok) + ") - not listed");
        return false;
    }

    public boolean allowEmbeddedScripts() {
        return this.g.allowEmbeddedScripts && !this.isPreviewOnly;
    }

    boolean getDragSelected() {
        return this.g.dragSelected && !this.g.modelKitMode;
    }

    boolean getBondPicking() {
        return this.g.bondPicking || this.g.modelKitMode;
    }

    public boolean useMinimizationThread() {
        return this.g.useMinimizationThread && !this.autoExit;
    }

    @Override
    public float getFloat(int tok) {
        switch (tok) {
            case 0x44000001: {
                return this.g.particleRadius;
            }
            case 0x22000001: {
                return this.g.axesOffset;
            }
            case 0x22000002: {
                return this.g.axesScale;
            }
            case 0x22000004: {
                return this.g.bondTolerance;
            }
            case 0x2200000A: {
                return this.g.defaultTranslucent;
            }
            case 0x22000008: {
                return this.g.defaultDrawArrowScale;
            }
            case 0x2200000B: {
                return this.g.dipoleScale;
            }
            case 0x2200000C: {
                return this.g.drawFontSize;
            }
            case 0x2200000E: {
                return this.g.exportScale;
            }
            case 0x22000010: {
                return this.g.hbondsAngleMinimum;
            }
            case 0x22000011: {
                return this.g.hbondsDistanceMaximum;
            }
            case 570425363: {
                return this.g.loadAtomDataTolerance;
            }
            case 570425364: {
                return this.g.minBondDistance;
            }
            case 1275072532: {
                return this.g.modulationScale;
            }
            case 570425370: {
                return this.g.multipleBondSpacing;
            }
            case 570425369: {
                return this.g.multipleBondRadiusFactor;
            }
            case 570425374: {
                return this.g.navigationSpeed;
            }
            case 0x22000026: {
                return this.g.pointGroupDistanceTolerance;
            }
            case 0x22000028: {
                return this.g.pointGroupLinearTolerance;
            }
            case 0x2200002C: {
                return this.tm.modelRadius;
            }
            case 0x22000030: {
                return this.g.sheetSmoothing;
            }
            case 0x22000032: {
                return this.g.solventProbeRadius;
            }
            case 570425403: {
                return this.g.starWidth;
            }
            case 570425406: {
                return this.g.strutDefaultRadius;
            }
            case 0x22000040: {
                return this.g.strutLengthMaximum;
            }
            case 1648361473: {
                return this.g.vectorScale;
            }
            case 0x22000044: {
                return this.g.vibrationPeriod;
            }
            case 0x22000003: {
                return this.g.backboneBlockWidth;
            }
        }
        Logger.error("viewer.getFloat(" + T.nameOf(tok) + ") - not listed");
        return 0.0f;
    }

    @Override
    public void setStringProperty(String key, String value) {
        if (value == null || key == null || key.length() == 0) {
            return;
        }
        if (key.charAt(0) == '_') {
            this.g.setO(key, value);
            return;
        }
        int tok = T.getTokFromName(key);
        switch (T.getParamType(tok)) {
            case 0x24000000: {
                this.setBooleanPropertyTok(key, tok, SV.newV(4, value).asBoolean());
                break;
            }
            case 0x21000000: {
                this.setIntPropertyTok(key, tok, SV.newV(4, value).asInt());
                break;
            }
            case 0x22000000: {
                this.setFloatPropertyTok(key, tok, PT.parseFloat(value));
                break;
            }
            default: {
                this.setStringPropertyTok(key, tok, value);
            }
        }
    }

    private void setStringPropertyTok(String key, int tok, String value) {
        switch (tok) {
            case 545259570: {
                this.g.nihResolverFormat = value;
                break;
            }
            case 545259556: {
                this.g.edsUrlCutoff = value;
                break;
            }
            case 545259557: {
                this.g.edsUrlFormat = value;
                break;
            }
            case 545259558: {
                this.g.edsUrlFormatDiff = value;
                break;
            }
            case 545259521: {
                this.setAnimationMode(value);
                return;
            }
            case 545259569: {
                this.g.nmrPredictFormat = value;
                break;
            }
            case 545259548: {
                this.g.defaultDropScript = value;
                break;
            }
            case 545259572: {
                value = this.fm.setPathForAllFiles(value);
                break;
            }
            case 545259559: {
                this.setUnits(value, false);
                return;
            }
            case 545259561: {
                value = "UFF".equalsIgnoreCase(value) ? "UFF" : "MMFF";
                this.g.forceField = value;
                this.minimizer = null;
                break;
            }
            case 545259571: {
                this.g.nmrUrlFormat = value;
                break;
            }
            case 545259568: {
                this.setUnits(value, true);
                return;
            }
            case 545259566: {
                this.g.pdbLoadLigandFormat = value;
                break;
            }
            case 545259543: {
                this.g.defaultLabelPDB = value;
                break;
            }
            case 545259544: {
                this.g.defaultLabelXYZ = value;
                break;
            }
            case 545259549: {
                this.g.defaultLoadFilter = value;
                break;
            }
            case 545259567: {
                value = this.getOutputManager().setLogFile(value);
                if (value != null) break;
                return;
            }
            case 0x20800028: {
                break;
            }
            case 545259524: {
                this.g.atomTypes = value;
                break;
            }
            case 545259538: {
                break;
            }
            case 545259576: {
                this.g.pickLabel = value;
                break;
            }
            case 545259580: {
                this.g.quaternionFrame = value.length() == 2 && value.startsWith("R") ? value.substring(0, 2) : "" + (value.toLowerCase() + "p").charAt(0);
                if (!PT.isOneOf(this.g.quaternionFrame, "RC;RP;a;b;c;n;p;q;x;")) {
                    this.g.quaternionFrame = "p";
                }
                this.ms.haveStraightness = false;
                break;
            }
            case 545259555: {
                this.setVdwStr(value);
                return;
            }
            case 545259564: {
                new GT(this, value);
                String language = GT.getLanguage();
                this.modelkitPopup = null;
                if (this.jmolpopup != null) {
                    this.jmolpopup.jpiDispose();
                    this.jmolpopup = null;
                    this.getPopupMenu();
                }
                this.sm.setCallbackFunction("language", language);
                value = GT.getLanguage();
                break;
            }
            case 545259565: {
                this.g.loadFormat = value;
                break;
            }
            case 545259534: {
                this.setObjectColor("background", value);
                return;
            }
            case 0x20800008: {
                this.setObjectColor("axis1", value);
                return;
            }
            case 545259530: {
                this.setObjectColor("axis2", value);
                return;
            }
            case 545259532: {
                this.setObjectColor("axis3", value);
                return;
            }
            case 545259536: {
                this.setObjectColor("boundbox", value);
                return;
            }
            case 545259586: {
                this.setObjectColor("unitcell", value);
                return;
            }
            case 545259578: {
                this.setPropertyColorScheme(value, false, false);
                break;
            }
            case 545259563: {
                this.shm.loadShape(35);
                this.setShapeProperty(35, "atomLabel", value);
                break;
            }
            case 545259547: {
                this.g.defaultDistanceLabel = value;
                break;
            }
            case 545259542: {
                this.g.defaultAngleLabel = value;
                break;
            }
            case 0x20800022: {
                this.g.defaultTorsionLabel = value;
                break;
            }
            case 545259550: {
                this.g.defaultLoadScript = value;
                break;
            }
            case 0x20800002: {
                this.fm.setAppletProxy(value);
                break;
            }
            case 545259546: {
                if (value == null) {
                    value = "";
                }
                this.g.defaultDirectory = value = value.replace('\\', '/');
                break;
            }
            case 545259562: {
                this.g.helpPath = value;
                break;
            }
            case 0x20800020: {
                if (!value.equalsIgnoreCase("RasMol") && !value.equalsIgnoreCase("PyMOL")) {
                    value = "Jmol";
                }
                this.setDefaultsType(value);
                break;
            }
            case 545259545: {
                this.setDefaultColors(value.equalsIgnoreCase("rasmol"));
                return;
            }
            case 545259573: {
                this.setPickingMode(value, 0);
                return;
            }
            case 545259574: {
                this.setPickingStyle(value, 0);
                return;
            }
            case 545259540: {
                break;
            }
            default: {
                if (key.toLowerCase().endsWith("callback")) {
                    this.sm.setCallbackFunction(key, value.length() == 0 || value.equalsIgnoreCase("none") ? null : value);
                    break;
                }
                if (this.g.htNonbooleanParameterValues.containsKey(key.toLowerCase())) break;
                this.g.setUserVariable(key, SV.newV(4, value));
                return;
            }
        }
        this.g.setO(key, value);
    }

    @Override
    public void setFloatProperty(String key, float value) {
        if (Float.isNaN(value) || key == null || key.length() == 0) {
            return;
        }
        if (key.charAt(0) == '_') {
            this.g.setF(key, value);
            return;
        }
        int tok = T.getTokFromName(key);
        switch (T.getParamType(tok)) {
            case 0x20800000: {
                this.setStringPropertyTok(key, tok, "" + value);
                break;
            }
            case 0x24000000: {
                this.setBooleanPropertyTok(key, tok, value != 0.0f);
                break;
            }
            case 0x21000000: {
                this.setIntPropertyTok(key, tok, (int)value);
                break;
            }
            default: {
                this.setFloatPropertyTok(key, tok, value);
            }
        }
    }

    private void setFloatPropertyTok(String key, int tok, float value) {
        switch (tok) {
            case 0x22000003: {
                this.g.backboneBlockWidth = value;
                break;
            }
            case 570425366: {
                this.ms.setModulation(null, false, null, false);
                this.g.modulationScale = value = Math.max(0.1f, value);
                this.ms.setModulation(null, true, null, false);
                break;
            }
            case 0x22000025: {
                this.g.particleRadius = Math.abs(value);
                break;
            }
            case 0x2200000C: {
                this.g.drawFontSize = value;
                break;
            }
            case 0x2200000E: {
                this.g.exportScale = value;
                break;
            }
            case 570425403: {
                this.g.starWidth = value;
                break;
            }
            case 570425369: {
                this.g.multipleBondRadiusFactor = value;
                break;
            }
            case 570425370: {
                this.g.multipleBondSpacing = value;
                break;
            }
            case 570425393: {
                this.tm.setSlabRange(value);
                break;
            }
            case 570425365: {
                this.g.minimizationCriterion = value;
                break;
            }
            case 0x2200000F: {
                if (!this.haveDisplay) break;
                this.acm.setGestureSwipeFactor(value);
                break;
            }
            case 570425367: {
                if (!this.haveDisplay) break;
                this.acm.setMouseDragFactor(value);
                break;
            }
            case 570425368: {
                if (!this.haveDisplay) break;
                this.acm.setMouseWheelFactor(value);
                break;
            }
            case 0x22000040: {
                this.g.strutLengthMaximum = value;
                break;
            }
            case 570425406: {
                this.g.strutDefaultRadius = value;
                break;
            }
            case 0x22000020: {
                this.setSpin("X", (int)value);
                break;
            }
            case 0x22000022: {
                this.setSpin("Y", (int)value);
                break;
            }
            case 0x22000024: {
                this.setSpin("Z", (int)value);
                break;
            }
            case 570425371: {
                if (Float.isNaN(value)) {
                    return;
                }
                this.setSpin("FPS", (int)value);
                break;
            }
            case 570425363: {
                this.g.loadAtomDataTolerance = value;
                break;
            }
            case 0x22000010: {
                this.g.hbondsAngleMinimum = value;
                break;
            }
            case 0x22000011: {
                this.g.hbondsDistanceMaximum = value;
                break;
            }
            case 0x22000026: {
                this.g.pointGroupDistanceTolerance = value;
                break;
            }
            case 0x22000028: {
                this.g.pointGroupLinearTolerance = value;
                break;
            }
            case 0x2200000D: {
                this.g.ellipsoidAxisDiameter = value;
                break;
            }
            case 570425398: {
                this.setSpin("x", (int)value);
                break;
            }
            case 570425400: {
                this.setSpin("y", (int)value);
                break;
            }
            case 570425402: {
                this.setSpin("z", (int)value);
                break;
            }
            case 570425396: {
                this.setSpin("fps", (int)value);
                break;
            }
            case 0x22000008: {
                this.g.defaultDrawArrowScale = value;
                break;
            }
            case 0x2200000A: {
                this.g.defaultTranslucent = value;
                break;
            }
            case 0x22000001: {
                this.setAxesScale(tok, value);
                break;
            }
            case 0x22000002: {
                this.setAxesScale(tok, value);
                break;
            }
            case 570425416: {
                this.tm.visualRangeAngstroms = value;
                this.refresh(1, "set visualRange");
                break;
            }
            case 570425372: {
                this.setNavigationDepthPercent(value);
                break;
            }
            case 570425374: {
                this.g.navigationSpeed = value;
                break;
            }
            case 570425373: {
                this.tm.setNavigationSlabOffsetPercent(value);
                break;
            }
            case 0x22000006: {
                this.tm.setCameraDepthPercent(value, false);
                this.refresh(1, "set cameraDepth");
                return;
            }
            case 0x2200002C: {
                this.setRotationRadius(value, true);
                return;
            }
            case 0x22000012: {
                this.g.hoverDelayMs = (int)(value * 1000.0f);
                break;
            }
            case 0x22000030: {
                this.g.sheetSmoothing = value;
                break;
            }
            case 0x2200000B: {
                this.g.dipoleScale = value = Viewer.checkFloatRange(value, -10.0f, 10.0f);
                break;
            }
            case 570425404: {
                this.tm.setStereoDegrees(value);
                break;
            }
            case 1648361473: {
                this.setVectorScale(value);
                return;
            }
            case 0x22000044: {
                this.setVibrationPeriod(value);
                return;
            }
            case 570425414: {
                this.setVibrationScale(value);
                return;
            }
            case 0x22000004: {
                this.setBondTolerance(value);
                return;
            }
            case 570425364: {
                this.setMinBondDistance(value);
                return;
            }
            case 0x2200002E: {
                this.tm.setScaleAngstromsPerInch(value);
                break;
            }
            case 0x22000032: {
                this.g.solventProbeRadius = value = Viewer.checkFloatRange(value, 0.0f, 10.0f);
                break;
            }
            default: {
                if (this.g.htNonbooleanParameterValues.containsKey(key.toLowerCase())) break;
                this.g.setUserVariable(key, SV.newF(value));
                return;
            }
        }
        this.g.setF(key, value);
    }

    @Override
    public void setIntProperty(String key, int value) {
        if (value == Integer.MIN_VALUE || key == null || key.length() == 0) {
            return;
        }
        if (key.charAt(0) == '_') {
            this.g.setI(key, value);
            return;
        }
        int tok = T.getTokFromName(key);
        switch (T.getParamType(tok)) {
            case 0x20800000: {
                this.setStringPropertyTok(key, tok, "" + value);
                break;
            }
            case 0x24000000: {
                this.setBooleanPropertyTok(key, tok, value != 0);
                break;
            }
            case 0x22000000: {
                this.setFloatPropertyTok(key, tok, value);
                break;
            }
            default: {
                this.setIntPropertyTok(key, tok, value);
            }
        }
    }

    private void setIntPropertyTok(String key, int tok, int value) {
        switch (tok) {
            case 553648148: 
            case 553648167: 
            case 553648168: {
                value = this.eval.setStatic(tok, value);
                break;
            }
            case 553648185: {
                this.g.vectorTrail = value;
                break;
            }
            case 553648138: {
                this.g.bondingVersion = Elements.bondingVersion = (value = value == 0 ? 0 : 1);
                break;
            }
            case 553648137: {
                this.gdata.setCelPower(value);
                break;
            }
            case 0x21000001: {
                this.gdata.setAmbientOcclusion(value);
                break;
            }
            case 553648158: {
                this.g.platformSpeed = Math.min(Math.max(value, 0), 10);
                break;
            }
            case 553648151: {
                this.g.meshScale = value;
                break;
            }
            case 553648153: {
                this.g.minPixelSelRadius = value;
                break;
            }
            case 553648149: {
                this.g.isosurfacePropertySmoothingPower = value;
                break;
            }
            case 553648165: {
                this.g.repaintWaitMs = value;
                break;
            }
            case 553648170: {
                this.g.smallMoleculeMaxAtoms = value;
                break;
            }
            case 553648152: {
                this.g.minimizationSteps = value;
                break;
            }
            case 553648184: {
                this.g.strutSpacing = value;
                break;
            }
            case 553648156: {
                value = Viewer.checkIntRange(value, 0, 1000);
                this.gdata.setPhongExponent(value);
                break;
            }
            case 0x21000012: {
                this.g.helixStep = value;
                this.ms.haveStraightness = false;
                break;
            }
            case 0x21000010: {
                this.g.dotScale = value;
                break;
            }
            case 553648143: {
                this.g.dotDensity = value;
                break;
            }
            case 553648140: {
                this.g.delayMaximumMs = value;
                break;
            }
            case 553648150: {
                Logger.setLogLevel(value);
                Logger.info("logging level set to " + value);
                this.g.setI("logLevel", value);
                if (this.eval != null) {
                    this.eval.setDebugging();
                }
                return;
            }
            case 553648134: {
                this.setAxesMode(value == 2 ? 0x24000020 : (value == 1 ? 603979804 : 603979809));
                return;
            }
            case 553648178: {
                this.setStrandCount(0, value);
                return;
            }
            case 553648182: {
                this.setStrandCount(12, value);
                return;
            }
            case 553648180: {
                this.setStrandCount(13, value);
                return;
            }
            case 553648155: {
                return;
            }
            case 0x2000000A: {
                this.g.scriptDelay = value;
                break;
            }
            case 553648176: {
                value = value < 0 ? Viewer.checkIntRange(value, -10, -1) : Viewer.checkIntRange(value, 0, 100);
                this.gdata.setSpecularPower(value);
                break;
            }
            case 553648172: {
                value = Viewer.checkIntRange(-value, -10, -1);
                this.gdata.setSpecularPower(value);
                break;
            }
            case 553648136: {
                this.setMarBond((short)value);
                return;
            }
            case 0x2000000C: {
                this.setBooleanPropertyTok(key, tok, value == 1);
                return;
            }
            case 553648174: {
                value = Viewer.checkIntRange(value, 0, 100);
                this.gdata.setSpecularPercent(value);
                break;
            }
            case 553648142: {
                value = Viewer.checkIntRange(value, 0, 100);
                this.gdata.setDiffusePercent(value);
                break;
            }
            case 0x21000002: {
                value = Viewer.checkIntRange(value, 0, 100);
                this.gdata.setAmbientPercent(value);
                break;
            }
            case 553648186: {
                this.tm.zDepthToPercent(value);
                break;
            }
            case 553648188: {
                this.tm.zSlabToPercent(value);
                break;
            }
            case 554176526: {
                this.tm.depthToPercent(value);
                break;
            }
            case 554176565: {
                this.tm.slabToPercent(value);
                break;
            }
            case 553648190: {
                this.g.zShadePower = value = Math.max(value, 0);
                break;
            }
            case 553648166: {
                this.g.ribbonAspectRatio = value;
                break;
            }
            case 553648157: {
                this.g.pickingSpinRate = value < 1 ? 1 : value;
                break;
            }
            case 553648132: {
                this.setAnimationFps(value);
                return;
            }
            case 553648154: {
                this.setPercentVdwAtom(value);
                break;
            }
            case 553648147: {
                this.g.hermiteLevel = value;
                break;
            }
            case 0x21000011: 
            case 553648159: 
            case 0x21000020: 
            case 0x21000022: 
            case 553648164: {
                break;
            }
            default: {
                if (this.g.htNonbooleanParameterValues.containsKey(key)) break;
                this.g.setUserVariable(key, SV.newI(value));
                return;
            }
        }
        this.g.setI(key, value);
    }

    private static int checkIntRange(int value, int min, int max) {
        return value < min ? min : (value > max ? max : value);
    }

    private static float checkFloatRange(float value, float min, float max) {
        return value < min ? min : (value > max ? max : value);
    }

    @Override
    public void setBooleanProperty(String key, boolean value) {
        if (key == null || key.length() == 0) {
            return;
        }
        if (key.charAt(0) == '_') {
            this.g.setB(key, value);
            return;
        }
        int tok = T.getTokFromName(key);
        switch (T.getParamType(tok)) {
            case 0x20800000: {
                this.setStringPropertyTok(key, tok, "");
                break;
            }
            case 0x21000000: {
                this.setIntPropertyTok(key, tok, value ? 1 : 0);
                break;
            }
            case 0x22000000: {
                this.setFloatPropertyTok(key, tok, value ? 1.0f : 0.0f);
                break;
            }
            default: {
                this.setBooleanPropertyTok(key, tok, value);
            }
        }
    }

    private void setBooleanPropertyTok(String key, int tok, boolean value) {
        boolean doRepaint = true;
        switch (tok) {
            case 603979891: {
                this.g.nboCharges = value;
                break;
            }
            case 603979856: {
                this.g.hiddenLinesDashed = value;
                break;
            }
            case 603979886: {
                this.g.multipleBondBananas = value;
                break;
            }
            case 603979884: {
                this.g.modulateOccupancy = value;
                break;
            }
            case 603979875: {
                this.g.legacyJavaFloat = value;
                break;
            }
            case 603979927: {
                this.g.showModVecs = value;
                break;
            }
            case 603979937: {
                this.g.showUnitCellDetails = value;
                break;
            }
            case 603979848: {
                doRepaint = false;
                break;
            }
            case 603979972: {
                this.g.vectorsCentered = value;
                break;
            }
            case 0x24000022: {
                this.g.backboneBlocks = value;
                break;
            }
            case 603979811: {
                this.g.backboneSteps = value;
                break;
            }
            case 603979819: {
                this.g.cartoonRibose = value;
                break;
            }
            case 603979837: {
                this.g.ellipsoidArrows = value;
                break;
            }
            case 603979967: {
                this.g.translucent = value;
                break;
            }
            case 603979818: {
                this.g.cartoonLadders = value;
                break;
            }
            case 603979968: {
                boolean b = this.g.twistedSheets;
                this.g.twistedSheets = value;
                if (b == value) break;
                this.checkCoordinatesChanged();
                break;
            }
            case 603979822: {
                this.gdata.setCel(value);
                break;
            }
            case 603979817: {
                this.g.cartoonFancy = value;
                break;
            }
            case 603979934: {
                this.g.showTiming = value;
                break;
            }
            case 603979973: {
                this.g.vectorSymmetry = value;
                break;
            }
            case 603979867: {
                this.g.isosurfaceKey = value;
                break;
            }
            case 603979892: {
                this.g.partialDots = value;
                break;
            }
            case 603979873: {
                this.g.legacyAutoBonding = value;
                break;
            }
            case 603979826: {
                this.g.defaultStructureDSSP = value;
                break;
            }
            case 603979834: {
                this.g.dsspCalcHydrogen = value;
                break;
            }
            case 603979782: {
                this.g.allowModelkit = value;
                if (value) break;
                this.setModelKitMode(false);
                break;
            }
            case 603979883: {
                this.setModelKitMode(value);
                break;
            }
            case 603979887: {
                this.g.multiProcessor = value && nProcessors > 1;
                break;
            }
            case 603979885: {
                this.g.monitorEnergy = value;
                break;
            }
            case 603979853: {
                this.g.hbondsRasmol = value;
                break;
            }
            case 603979881: {
                this.g.minimizationRefresh = value;
                break;
            }
            case 603979882: {
                this.g.minimizationSilent = value;
                break;
            }
            case 603979866: {
                if (!value) break;
                this.isKiosk = true;
                this.g.disablePopupMenu = true;
                if (this.display == null) break;
                this.apiPlatform.setTransparentCursor(this.display);
                break;
            }
            case 603979975: {
                this.g.waitForMoveTo = value;
                break;
            }
            case 603979876: {
                this.g.logCommands = true;
                break;
            }
            case 603979877: {
                this.g.logGestures = true;
                break;
            }
            case 603979784: {
                this.g.allowMultiTouch = value;
                break;
            }
            case 603979897: {
                this.g.preserveState = value;
                this.ms.setPreserveState(value);
                this.undoClear();
                break;
            }
            case 603979955: {
                this.g.strutsMultiple = value;
                break;
            }
            case 0x24000042: {
                break;
            }
            case 603979939: {
                this.g.slabByAtom = value;
                break;
            }
            case 603979940: {
                this.g.slabByMolecule = value;
                break;
            }
            case 603979902: {
                this.g.saveProteinStructureState = value;
                break;
            }
            case 0x24000004: {
                this.g.allowGestures = value;
                break;
            }
            case 603979865: {
                this.g.imageState = value;
                break;
            }
            case 603979970: {
                this.g.useMinimizationThread = value;
                break;
            }
            case 603979781: {
                if (this.g.disablePopupMenu) {
                    value = false;
                }
                this.g.allowKeyStrokes = value;
                break;
            }
            case 603979831: {
                this.g.dragSelected = value;
                this.showSelected = false;
                break;
            }
            case 603979924: {
                this.g.showKeyStrokes = value;
                break;
            }
            case 0x24000044: {
                this.g.fontCaching = value;
                break;
            }
            case 603979796: {
                this.g.atomPicking = value;
                break;
            }
            case 603979814: {
                this.highlight(null);
                this.g.bondPicking = value;
                break;
            }
            case 603979906: {
                this.g.selectAllModels = value;
                if (value) {
                    this.slm.setSelectionSubset(null);
                    break;
                }
                this.am.setSelectAllSubset(false);
                break;
            }
            case 603979880: {
                this.g.messageStyleChime = value;
                break;
            }
            case 603979895: {
                this.g.pdbSequential = value;
                break;
            }
            case 603979893: {
                this.g.pdbAddHydrogens = value;
                break;
            }
            case 603979894: {
                this.g.pdbGetHeader = value;
                break;
            }
            case 603979838: {
                this.g.ellipsoidAxes = value;
                break;
            }
            case 603979836: {
                this.g.ellipsoidArcs = value;
                break;
            }
            case 603979839: {
                this.g.ellipsoidBall = value;
                break;
            }
            case 0x24000040: {
                this.g.ellipsoidDots = value;
                break;
            }
            case 603979841: {
                this.g.ellipsoidFill = value;
                break;
            }
            case 603979845: {
                this.g.fontScaling = value;
                break;
            }
            case 603979956: {
                this.setSyncTarget(0, value);
                break;
            }
            case 603979958: {
                this.setSyncTarget(1, value);
                break;
            }
            case 603979977: {
                this.g.wireframeRotation = value;
                break;
            }
            case 603979868: {
                this.g.isosurfacePropertySmoothing = value;
                break;
            }
            case 603979833: {
                this.g.drawPicking = value;
                break;
            }
            case 603979786: 
            case 603979788: 
            case 603979790: {
                this.setAntialias(tok, value);
                break;
            }
            case 603979944: {
                this.g.smartAromatic = value;
                break;
            }
            case 603979794: {
                this.setApplySymmetryToBonds(value);
                break;
            }
            case 603979792: {
                this.g.appendNew = value;
                break;
            }
            case 603979800: {
                this.g.autoFps = value;
                break;
            }
            case 603979971: {
                this.g.useNumberLocalization = value;
                DF.setUseNumberLocalization(this.g.useNumberLocalization);
                break;
            }
            case 603979918: 
            case 1611272202: {
                key = "showFrank";
                this.setFrankOn(value);
                break;
            }
            case 1612709912: {
                key = "solventProbe";
                this.g.solventOn = value;
                break;
            }
            case 603979948: {
                this.g.solventOn = value;
                break;
            }
            case 603979785: {
                this.g.allowRotateSelected = value;
                break;
            }
            case 603979783: {
                this.g.allowMoveAtoms = value;
                this.showSelected = false;
                break;
            }
            case 0x2000000A: {
                this.setIntPropertyTok("showScript", tok, value ? 1 : 0);
                return;
            }
            case 0x24000002: {
                this.g.allowEmbeddedScripts = value;
                break;
            }
            case 603979890: {
                this.g.navigationPeriodic = value;
                break;
            }
            case 603979984: {
                this.tm.setZShadeEnabled(value);
                return;
            }
            case 603979832: {
                if (!this.haveDisplay) break;
                this.g.drawHover = value;
                break;
            }
            case 603979889: {
                this.setNavigationMode(value);
                break;
            }
            case 603979888: {
                return;
            }
            case 603979860: {
                this.g.hideNavigationPoint = value;
                break;
            }
            case 603979930: {
                this.g.showNavigationPointAlways = value;
                break;
            }
            case 603979899: {
                this.setRefreshing(value);
                break;
            }
            case 603979869: {
                this.g.jmolInJSpecView = value;
                break;
            }
            case 603979871: {
                this.g.justifyMeasurements = value;
                break;
            }
            case 603979952: {
                this.g.ssbondsBackbone = value;
                break;
            }
            case 603979852: {
                this.g.hbondsBackbone = value;
                break;
            }
            case 603979854: {
                this.g.hbondsSolid = value;
                break;
            }
            case 0x2000000C: {
                this.gdata.setSpecular(value);
                break;
            }
            case 603979942: {
                this.tm.setSlabEnabled(value);
                return;
            }
            case 603979980: {
                this.tm.setZoomEnabled(value);
                return;
            }
            case 603979864: {
                this.g.highResolutionFlag = value;
                break;
            }
            case 603979966: {
                this.g.traceAlpha = value;
                break;
            }
            case 603979983: {
                this.g.zoomLarge = value;
                this.tm.setZoomHeight(this.g.zoomHeight, value);
                break;
            }
            case 603979982: {
                this.g.zoomHeight = value;
                this.tm.setZoomHeight(value, this.g.zoomLarge);
                break;
            }
            case 603979872: {
                GT.setDoTranslate(value);
                break;
            }
            case 603979862: {
                this.slm.setHideNotSelected(value);
                break;
            }
            case 603979904: {
                this.setScriptQueue(value);
                break;
            }
            case 603979830: {
                this.g.dotSurface = value;
                break;
            }
            case 603979829: {
                this.g.dotsSelectedOnly = value;
                break;
            }
            case 1611141171: {
                this.setSelectionHalosEnabled(value);
                break;
            }
            case 603979910: {
                this.g.rasmolHydrogenSetting = value;
                break;
            }
            case 603979908: {
                this.g.rasmolHeteroSetting = value;
                break;
            }
            case 603979928: {
                this.g.showMultipleBonds = value;
                break;
            }
            case 603979920: {
                this.g.showHiddenSelectionHalos = value;
                break;
            }
            case 603979976: {
                this.tm.setWindowCentered(value);
                break;
            }
            case 603979828: {
                this.g.displayCellParameters = value;
                break;
            }
            case 603979960: {
                this.g.testFlag1 = value;
                break;
            }
            case 603979962: {
                this.g.testFlag2 = value;
                break;
            }
            case 603979964: {
                this.g.testFlag3 = value;
                break;
            }
            case 603979965: {
                this.jmolTest();
                this.g.testFlag4 = value;
                break;
            }
            case 603979900: {
                this.g.ribbonBorder = value;
                break;
            }
            case 603979816: {
                this.g.cartoonBaseEdges = value;
                break;
            }
            case 603979820: {
                this.g.cartoonRockets = value;
                break;
            }
            case 603979901: {
                this.g.rocketBarrels = value;
                break;
            }
            case 603979850: {
                this.g.greyscaleRendering = value;
                this.gdata.setGreyscaleMode(this.g.greyscaleRendering);
                break;
            }
            case 603979879: {
                this.g.measurementLabels = value;
                break;
            }
            case 603979804: 
            case 0x24000020: 
            case 603979809: {
                this.setAxesMode(tok);
                return;
            }
            case 603979806: {
                this.setAxesOrientationRasmol(value);
                return;
            }
            case 603979824: {
                this.setStringPropertyTok("defaultcolorscheme", 545259545, value ? "rasmol" : "jmol");
                return;
            }
            case 603979825: {
                this.setDebugScript(value);
                return;
            }
            case 603979896: {
                this.setPerspectiveDepth(value);
                return;
            }
            case 603979798: {
                this.setAutoBond(value);
                return;
            }
            case 603979914: {
                this.setShowAxes(value);
                return;
            }
            case 603979916: {
                this.setShowBbcage(value);
                return;
            }
            case 603979922: {
                this.setShowHydrogens(value);
                return;
            }
            case 603979926: {
                this.setShowMeasurements(value);
                return;
            }
            case 603979936: {
                this.setShowUnitCell(value);
                return;
            }
            case 0x24000024: {
                doRepaint = false;
                this.g.bondModeOr = value;
                break;
            }
            case 603979978: {
                doRepaint = false;
                this.g.zeroBasedXyzRasmol = value;
                this.reset(true);
                break;
            }
            case 603979898: {
                doRepaint = false;
                this.g.rangeSelected = value;
                break;
            }
            case 603979878: {
                doRepaint = false;
                this.g.measureAllModels = value;
                break;
            }
            case 603979954: {
                doRepaint = false;
                this.sm.allowStatusReporting = value;
                break;
            }
            case 603979823: {
                doRepaint = false;
                this.g.chainCaseSensitive = value;
                break;
            }
            case 603979858: {
                doRepaint = false;
                this.g.hideNameInPopup = value;
                break;
            }
            case 603979827: {
                doRepaint = false;
                this.g.disablePopupMenu = value;
                break;
            }
            case 603979846: {
                doRepaint = false;
                this.g.forceAutoBond = value;
                break;
            }
            default: {
                if (this.g.htBooleanParameterFlags.containsKey(key.toLowerCase())) break;
                this.g.setUserVariable(key, SV.getBoolean(value));
                return;
            }
        }
        this.g.setB(key, value);
        if (doRepaint) {
            this.setTainted(true);
        }
    }

    private void setModelKitMode(boolean value) {
        if (this.acm == null || !this.allowScripting) {
            return;
        }
        if (value || this.g.modelKitMode) {
            this.setPickingMode(null, value ? 33 : 1);
            this.setPickingMode(null, value ? 32 : 1);
        }
        boolean isChange = this.g.modelKitMode != value;
        this.g.modelKitMode = value;
        this.highlight(null);
        if (value) {
            this.setNavigationMode(false);
            this.selectAll();
            this.setAtomPickingOption("C");
            this.setBondPickingOption("p");
            if (!this.isApplet) {
                this.popupMenu(0, 0, 'm');
            }
            if (isChange) {
                this.sm.setCallbackFunction("modelkit", "ON");
            }
            this.g.modelKitMode = true;
            if (this.ms.ac == 0) {
                this.zap(false, true, true);
            }
        } else {
            this.acm.setPickingMode(-1);
            this.setStringProperty("pickingStyle", "toggle");
            this.setBooleanProperty("bondPicking", false);
            if (isChange) {
                this.sm.setCallbackFunction("modelkit", "OFF");
            }
        }
    }

    public void setSmilesString(String s) {
        if (s == null) {
            this.g.removeParam("_smilesString");
        } else {
            this.g.setO("_smilesString", s);
        }
    }

    public void removeUserVariable(String key) {
        this.g.removeUserVariable(key);
        if (key.endsWith("callback")) {
            this.sm.setCallbackFunction(key, null);
        }
    }

    private void jmolTest() {
    }

    public void showParameter(String key, boolean ifNotSet, int nMax) {
        String sv = "" + this.g.getParameterEscaped(key, nMax);
        if (ifNotSet || sv.indexOf("<not defined>") < 0) {
            this.showString(key + " = " + sv, false);
        }
    }

    public void showString(String str, boolean isPrint) {
        if (!(this.isJS || !this.isScriptQueued() || this.isSilent && !isPrint || "\u0000".equals(str))) {
            Logger.warn(str);
        }
        this.scriptEcho(str);
    }

    public String getAllSettings(String prefix) {
        return this.getStateCreator().getAllSettings(prefix);
    }

    public String getBindingInfo(String qualifiers) {
        return this.haveDisplay ? this.acm.getBindingInfo(qualifiers) : "";
    }

    public int getIsosurfacePropertySmoothing(boolean asPower) {
        return asPower ? this.g.isosurfacePropertySmoothingPower : (this.g.isosurfacePropertySmoothing ? 1 : 0);
    }

    public void setNavigationDepthPercent(float percent) {
        this.tm.setNavigationDepthPercent(percent);
        this.refresh(1, "set navigationDepth");
    }

    public boolean getShowNavigationPoint() {
        if (!this.g.navigationMode) {
            return false;
        }
        return this.tm.isNavigating() && !this.g.hideNavigationPoint || this.g.showNavigationPointAlways || this.getInMotion(true);
    }

    public float getCurrentSolventProbeRadius() {
        return this.g.solventOn ? this.g.solventProbeRadius : 0.0f;
    }

    @Override
    public void setPerspectiveDepth(boolean perspectiveDepth) {
        this.tm.setPerspectiveDepth(perspectiveDepth);
    }

    @Override
    public void setAxesOrientationRasmol(boolean TF) {
        this.g.setB("axesOrientationRasmol", TF);
        this.g.axesOrientationRasmol = TF;
        this.reset(true);
    }

    private void setAxesScale(int tok, float val) {
        val = Viewer.checkFloatRange(val, -100.0f, 100.0f);
        if (tok == 0x22000001) {
            this.g.axesOffset = val;
        } else {
            this.g.axesScale = val;
        }
        this.axesAreTainted = true;
    }

    void setAxesMode(int mode) {
        this.g.axesMode = mode;
        this.axesAreTainted = true;
        switch (mode) {
            case 0x24000020: {
                this.g.removeParam("axesmolecular");
                this.g.removeParam("axeswindow");
                this.g.setB("axesUnitcell", true);
                mode = 2;
                break;
            }
            case 603979804: {
                this.g.removeParam("axesunitcell");
                this.g.removeParam("axeswindow");
                this.g.setB("axesMolecular", true);
                mode = 1;
                break;
            }
            case 603979809: {
                this.g.removeParam("axesunitcell");
                this.g.removeParam("axesmolecular");
                this.g.setB("axesWindow", true);
                mode = 0;
            }
        }
        this.g.setI("axesMode", mode);
    }

    public boolean getSelectionHalosEnabled() {
        return this.selectionHalosEnabled;
    }

    public void setSelectionHalosEnabled(boolean TF) {
        if (this.selectionHalosEnabled == TF) {
            return;
        }
        this.g.setB("selectionHalos", TF);
        this.shm.loadShape(8);
        this.selectionHalosEnabled = TF;
    }

    public boolean getShowSelectedOnce() {
        boolean flag = this.showSelected;
        this.showSelected = false;
        return flag;
    }

    private void setStrandCount(int type, int value) {
        value = Viewer.checkIntRange(value, 0, 20);
        switch (type) {
            case 12: {
                this.g.strandCountForStrands = value;
                break;
            }
            case 13: {
                this.g.strandCountForMeshRibbon = value;
                break;
            }
            default: {
                this.g.strandCountForStrands = value;
                this.g.strandCountForMeshRibbon = value;
            }
        }
        this.g.setI("strandCount", value);
        this.g.setI("strandCountForStrands", this.g.strandCountForStrands);
        this.g.setI("strandCountForMeshRibbon", this.g.strandCountForMeshRibbon);
    }

    public int getStrandCount(int type) {
        return type == 12 ? this.g.strandCountForStrands : this.g.strandCountForMeshRibbon;
    }

    public void setNavigationMode(boolean TF) {
        this.g.navigationMode = TF;
        this.tm.setNavigationMode(TF);
    }

    @Override
    public void setAutoBond(boolean TF) {
        this.g.setB("autobond", TF);
        this.g.autoBond = TF;
    }

    public int[] makeConnections(float minDistance, float maxDistance, int order, int connectOperation, BS bsA, BS bsB, BS bsBonds, boolean isBonds, boolean addGroup, float energy) {
        this.clearModelDependentObjects();
        this.clearMinimization();
        return this.ms.makeConnections(minDistance, maxDistance, order, connectOperation, bsA, bsB, bsBonds, isBonds, addGroup, energy);
    }

    @Override
    public void rebond() {
        this.rebondState(false);
    }

    public void rebondState(boolean isStateScript) {
        this.clearModelDependentObjects();
        this.ms.deleteAllBonds();
        boolean isLegacy = isStateScript && this.g.legacyAutoBonding;
        this.ms.autoBondBs4(null, null, null, null, this.getMadBond(), isLegacy);
        this.addStateScript(isLegacy ? "set legacyAutoBonding TRUE;connect;set legacyAutoBonding FALSE;" : "connect;", false, true);
    }

    @Override
    public void setPercentVdwAtom(int value) {
        this.g.setI("percentVdwAtom", value);
        this.g.percentVdwAtom = value;
        this.rd.value = (float)value / 100.0f;
        this.rd.factorType = RadiusData.EnumType.FACTOR;
        this.rd.vdwType = VDW.AUTO;
        this.shm.setShapeSizeBs(0, 0, this.rd, null);
    }

    @Override
    public short getMadBond() {
        return (short)(this.g.bondRadiusMilliAngstroms * 2);
    }

    @Override
    public void setShowHydrogens(boolean TF) {
        this.g.setB("showHydrogens", TF);
        this.g.showHydrogens = TF;
    }

    public void setShowBbcage(boolean value) {
        this.setObjectMad10(32, "boundbox", (short)(value ? -4 : 0));
        this.g.setB("showBoundBox", value);
    }

    public boolean getShowBbcage() {
        return this.getObjectMad10(4) != 0;
    }

    public void setShowUnitCell(boolean value) {
        this.setObjectMad10(33, "unitcell", (short)(value ? -2 : 0));
        this.g.setB("showUnitCell", value);
    }

    public boolean getShowUnitCell() {
        return this.getObjectMad10(5) != 0;
    }

    public void setShowAxes(boolean value) {
        this.setObjectMad10(34, "axes", (short)(value ? -2 : 0));
        this.g.setB("showAxes", value);
    }

    public boolean getShowAxes() {
        return this.getObjectMad10(1) != 0;
    }

    @Override
    public void setFrankOn(boolean TF) {
        if (this.isPreviewOnly) {
            TF = false;
        }
        this.frankOn = TF;
        this.setObjectMad10(36, "frank", (short)(TF ? 1 : 0));
    }

    public boolean getShowFrank() {
        if (this.isPreviewOnly || this.isApplet && this.creatingImage) {
            return false;
        }
        return this.isSignedApplet && !this.isSignedAppletLocal && !this.isJS || this.frankOn;
    }

    @Override
    public void setShowMeasurements(boolean TF) {
        this.g.setB("showMeasurements", TF);
        this.g.showMeasurements = TF;
    }

    public void setUnits(String units, boolean isDistance) {
        this.g.setUnits(units);
        if (isDistance) {
            this.g.setUnits(units);
            this.setShapeProperty(6, "reformatDistances", null);
        }
    }

    @Override
    public void setRasmolDefaults() {
        this.setDefaultsType("RasMol");
    }

    @Override
    public void setJmolDefaults() {
        this.setDefaultsType("Jmol");
    }

    private void setDefaultsType(String type) {
        if (type.equalsIgnoreCase("RasMol")) {
            this.stm.setRasMolDefaults();
            return;
        }
        if (type.equalsIgnoreCase("PyMOL")) {
            this.stm.setPyMOLDefaults();
            return;
        }
        this.stm.setJmolDefaults();
        this.setIntProperty("bondingVersion", 0);
        this.shm.setShapeSizeBs(0, 0, this.rd, this.getAllAtoms());
    }

    private void setAntialias(int tok, boolean TF) {
        boolean isChanged = false;
        switch (tok) {
            case 603979786: {
                isChanged = this.g.antialiasDisplay != TF;
                this.g.antialiasDisplay = TF;
                break;
            }
            case 603979790: {
                isChanged = this.g.antialiasTranslucent != TF;
                this.g.antialiasTranslucent = TF;
                break;
            }
            case 603979788: {
                this.g.antialiasImages = TF;
                return;
            }
        }
        if (isChanged) {
            this.refresh(3, "Viewer:setAntialias()");
        }
    }

    public P3[] allocTempPoints(int size) {
        return this.tempArray.allocTempPoints(size);
    }

    public void freeTempPoints(P3[] tempPoints) {
        this.tempArray.freeTempPoints(tempPoints);
    }

    public P3i[] allocTempScreens(int size) {
        return this.tempArray.allocTempScreens(size);
    }

    public void freeTempScreens(P3i[] tempScreens) {
        this.tempArray.freeTempScreens(tempScreens);
    }

    public STR[] allocTempEnum(int size) {
        return this.tempArray.allocTempEnum(size);
    }

    public void freeTempEnum(STR[] temp) {
        this.tempArray.freeTempEnum(temp);
    }

    public Font getFont3D(String fontFace, String fontStyle, float fontSize) {
        return this.gdata.getFont3DFSS(fontFace, fontStyle, fontSize);
    }

    public Quat[] getAtomGroupQuaternions(BS bsAtoms, int nMax) {
        return this.ms.getAtomGroupQuaternions(bsAtoms, nMax, this.getQuaternionFrame());
    }

    public void setStereoMode(int[] twoColors, STER stereoMode, float degrees) {
        this.setFloatProperty("stereoDegrees", degrees);
        this.setBooleanProperty("greyscaleRendering", stereoMode.isBiColor());
        if (twoColors != null) {
            this.tm.setStereoMode2(twoColors);
        } else {
            this.tm.setStereoMode(stereoMode);
        }
    }

    public String getChimeInfo(int tok) {
        return this.getPropertyManager().getChimeInfo(tok, this.bsA());
    }

    public String getModelFileInfo() {
        return this.getPropertyManager().getModelFileInfo(this.getVisibleFramesBitSet());
    }

    public String getModelFileInfoAll() {
        return this.getPropertyManager().getModelFileInfo(null);
    }

    @Override
    public Object getProperty(String returnType, String infoType, Object paramInfo) {
        if (!"DATA_API".equals(returnType)) {
            return this.getPropertyManager().getProperty(returnType, infoType, paramInfo);
        }
        switch ("scriptCheck.........consoleText.........scriptEditor........scriptEditorState...getAppConsole.......getScriptEditor.....setMenu.............spaceGroupInfo......disablePopupMenu....defaultDirectory....getPopupMenu........shapeManager........getPreference.......".indexOf(infoType)) {
            case 0: {
                return this.scriptCheckRet((String)paramInfo, true);
            }
            case 20: {
                return this.appConsole == null ? "" : this.appConsole.getText();
            }
            case 40: {
                this.showEditor((String[])paramInfo);
                return null;
            }
            case 60: {
                this.scriptEditorVisible = (Boolean)paramInfo;
                return null;
            }
            case 80: {
                if (this.isKiosk) {
                    this.appConsole = null;
                } else if (paramInfo instanceof JmolAppConsoleInterface) {
                    this.appConsole = (JmolAppConsoleInterface)paramInfo;
                } else if (paramInfo != null && !((Boolean)paramInfo).booleanValue()) {
                    this.appConsole = null;
                } else if (this.appConsole == null && paramInfo != null && ((Boolean)paramInfo).booleanValue()) {
                    if (this.isJS) {
                        this.appConsole = (JmolAppConsoleInterface)Interface.getOption("consolejs.AppletConsole", this, "script");
                    }
                    for (int i = 0; i < 4 && this.appConsole == null; ++i) {
                        JmolAppConsoleInterface jmolAppConsoleInterface = this.appConsole = this.isApplet ? (JmolAppConsoleInterface)Interface.getOption("console.AppletConsole", null, null) : (JmolAppConsoleInterface)Interface.getInterface("org.openscience.jmol.app.jmolpanel.console.AppConsole", null, null);
                        if (this.appConsole != null) continue;
                        try {
                            System.out.println("Viewer can't start appConsole");
                            Thread.currentThread().wait(100L);
                            continue;
                        }
                        catch (InterruptedException e) {
                            // empty catch block
                        }
                    }
                    if (this.appConsole != null) {
                        this.appConsole.start(this);
                    }
                }
                this.scriptEditor = this.isJS || this.appConsole == null ? null : this.appConsole.getScriptEditor();
                return this.appConsole;
            }
            case 100: {
                if (this.appConsole == null && paramInfo != null && ((Boolean)paramInfo).booleanValue()) {
                    this.getProperty("DATA_API", "getAppConsole", Boolean.TRUE);
                    this.scriptEditor = this.appConsole == null ? null : this.appConsole.getScriptEditor();
                }
                return this.scriptEditor;
            }
            case 120: {
                if (this.jmolpopup != null) {
                    this.jmolpopup.jpiDispose();
                }
                this.jmolpopup = null;
                this.menuStructure = (String)paramInfo;
                return this.menuStructure;
            }
            case 140: {
                return this.getSymTemp().getSpaceGroupInfo(this.ms, null, -1);
            }
            case 160: {
                this.g.disablePopupMenu = true;
                return null;
            }
            case 180: {
                return this.g.defaultDirectory;
            }
            case 200: {
                if (paramInfo instanceof String) {
                    return this.getMenu((String)paramInfo);
                }
                return this.getPopupMenu();
            }
            case 220: {
                return this.shm.getProperty(paramInfo);
            }
            case 240: {
                return this.sm.syncSend("getPreference", paramInfo, 1);
            }
        }
        Logger.error("ERROR in getProperty DATA_API: " + infoType);
        return null;
    }

    public void showEditor(String[] file_text) {
        JmolScriptEditorInterface scriptEditor = (JmolScriptEditorInterface)this.getProperty("DATA_API", "getScriptEditor", Boolean.TRUE);
        if (scriptEditor == null) {
            return;
        }
        scriptEditor.show(file_text);
    }

    private JmolPropertyManager getPropertyManager() {
        if (this.pm == null) {
            this.pm = (JmolPropertyManager)Interface.getInterface("org.jmol.viewer.PropertyManager", this, "prop");
            this.pm.setViewer(this);
        }
        return this.pm;
    }

    public void setTainted(boolean TF) {
        this.axesAreTainted = TF && (this.refreshing || this.creatingImage);
        this.isTainted = this.axesAreTainted;
    }

    public int notifyMouseClicked(int x, int y, int action, int mode) {
        int modifiers = Binding.getButtonMods(action);
        int clickCount = Binding.getClickCount(action);
        this.g.setI("_mouseX", x);
        this.g.setI("_mouseY", this.dimScreen.height - y);
        this.g.setI("_mouseAction", action);
        this.g.setI("_mouseModifiers", modifiers);
        this.g.setI("_clickCount", clickCount);
        return this.sm.setStatusClicked(x, this.dimScreen.height - y, action, clickCount, mode);
    }

    Map<String, Object> checkObjectClicked(int x, int y, int modifiers) {
        return this.shm.checkObjectClicked(x, y, modifiers, this.getVisibleFramesBitSet(), this.g.drawPicking);
    }

    public boolean checkObjectHovered(int x, int y) {
        return x >= 0 && this.shm != null && this.shm.checkObjectHovered(x, y, this.getVisibleFramesBitSet(), this.getBondPicking());
    }

    void checkObjectDragged(int prevX, int prevY, int x, int y, int action) {
        int iShape = 0;
        switch (this.getPickingMode()) {
            case 2: {
                iShape = 5;
                break;
            }
            case 4: {
                iShape = 22;
            }
        }
        if (this.shm.checkObjectDragged(prevX, prevY, x, y, action, this.getVisibleFramesBitSet(), iShape)) {
            this.refresh(1, "checkObjectDragged");
            if (iShape == 22) {
                this.scriptEcho((String)this.getShapeProperty(22, "command"));
            }
        }
    }

    public boolean rotateAxisAngleAtCenter(JmolScriptEvaluator eval, P3 rotCenter, V3 rotAxis, float degreesPerSecond, float endDegrees, boolean isSpin, BS bsSelected) {
        boolean isOK = this.tm.rotateAxisAngleAtCenter(eval, rotCenter, rotAxis, degreesPerSecond, endDegrees, isSpin, bsSelected);
        if (isOK) {
            this.setSync();
        }
        return isOK;
    }

    public boolean rotateAboutPointsInternal(JmolScriptEvaluator eval, P3 point1, P3 point2, float degreesPerSecond, float endDegrees, boolean isSpin, BS bsSelected, V3 translation, Lst<P3> finalPoints, float[] dihedralList, M4 m4) {
        boolean isOK;
        if (this.headless) {
            if (isSpin && endDegrees == Float.MAX_VALUE) {
                return false;
            }
            isSpin = false;
        }
        if (isOK = this.tm.rotateAboutPointsInternal(eval, point1, point2, degreesPerSecond, endDegrees, false, isSpin, bsSelected, false, translation, finalPoints, dihedralList, m4)) {
            this.setSync();
        }
        return isOK;
    }

    public void startSpinningAxis(T3 pt1, T3 pt2, boolean isClockwise) {
        if (this.tm.spinOn || this.tm.navOn) {
            this.tm.setSpinOff();
            this.tm.setNavOn(false);
            return;
        }
        this.tm.rotateAboutPointsInternal(null, pt1, pt2, this.g.pickingSpinRate, Float.MAX_VALUE, isClockwise, true, null, false, null, null, null, null);
    }

    public V3 getModelDipole() {
        return this.ms.getModelDipole(this.am.cmi);
    }

    public V3 calculateMolecularDipole(BS bsAtoms) throws Exception {
        try {
            return this.ms.calculateMolecularDipole(this.am.cmi, bsAtoms);
        }
        catch (JmolAsyncException e) {
            if (this.eval != null) {
                this.eval.loadFileResourceAsync(e.getFileName());
            }
            return null;
        }
    }

    public void setDefaultLattice(P3 p) {
        if (!Float.isNaN(p.x + p.y + p.z)) {
            this.g.ptDefaultLattice.setT(p);
        }
        this.g.setO("defaultLattice", Escape.eP(p));
    }

    public P3 getDefaultLattice() {
        return this.g.ptDefaultLattice;
    }

    public String getModelExtract(Object atomExpression, boolean doTransform, boolean isModelKit, String type) {
        return this.getPropertyManager().getModelExtract(this.getAtomBitSet(atomExpression), doTransform, isModelKit, type, false);
    }

    @Override
    public String getData(String atomExpression, String type) {
        return this.getModelFileData(atomExpression, type, true);
    }

    public String getModelFileData(String atomExpression, String type, boolean allTrajectories) {
        return this.getPropertyManager().getAtomData(atomExpression, type, allTrajectories);
    }

    public String getModelCml(BS bs, int nAtomsMax, boolean addBonds, boolean doTransform) {
        return this.getPropertyManager().getModelCml(bs, nAtomsMax, addBonds, doTransform, false);
    }

    public String getPdbAtomData(BS bs, OC out, boolean asPQR, boolean doTransform) {
        return this.getPropertyManager().getPdbAtomData(bs == null ? this.bsA() : bs, out, asPQR, doTransform, false);
    }

    public boolean isJmolDataFrame() {
        return this.ms.isJmolDataFrameForModel(this.am.cmi);
    }

    public void setFrameTitle(int modelIndex, String title) {
        this.ms.setFrameTitle(BSUtil.newAndSetBit(modelIndex), title);
    }

    public void setFrameTitleObj(Object title) {
        this.shm.loadShape(31);
        this.ms.setFrameTitle(this.getVisibleFramesBitSet(), title);
    }

    public String getFrameTitle() {
        return this.ms.getFrameTitle(this.am.cmi);
    }

    public void setAtomProperty(BS bs, int tok, int iValue, float fValue, String sValue, float[] values, String[] list) {
        if (tok == 1648363544) {
            this.shm.deleteVdwDependentShapes(bs);
        }
        this.clearMinimization();
        this.ms.setAtomProperty(bs, tok, iValue, fValue, sValue, values, list);
        switch (tok) {
            case 1086326789: 
            case 1111490577: 
            case 1111490578: 
            case 1111490579: 
            case 1111492609: 
            case 1111492610: 
            case 1111492611: 
            case 1111492612: 
            case 1111492613: 
            case 1111492614: {
                this.refreshMeasures(true);
            }
        }
    }

    public void checkCoordinatesChanged() {
        this.ms.recalculatePositionDependentQuantities(null, null);
        this.refreshMeasures(true);
    }

    public void setAtomCoords(BS bs, int tokType, Object xyzValues) {
        if (bs.isEmpty()) {
            return;
        }
        this.ms.setAtomCoords(bs, tokType, xyzValues);
        this.checkMinimization();
        this.sm.setStatusAtomMoved(bs);
    }

    public void setAtomCoordsRelative(T3 offset, BS bs) {
        if (bs == null) {
            bs = this.bsA();
        }
        if (bs.isEmpty()) {
            return;
        }
        this.ms.setAtomCoordsRelative(offset, bs);
        this.checkMinimization();
        this.sm.setStatusAtomMoved(bs);
    }

    public void invertAtomCoordPt(P3 pt, BS bs) {
        this.ms.invertSelected(pt, null, -1, null, bs);
        this.checkMinimization();
        this.sm.setStatusAtomMoved(bs);
    }

    public void invertAtomCoordPlane(P4 plane, BS bs) {
        this.ms.invertSelected(null, plane, -1, null, bs);
        this.checkMinimization();
        this.sm.setStatusAtomMoved(bs);
    }

    public void invertRingAt(int atomIndex, boolean isClick) {
        BS bs = this.getAtomBitSet("connected(atomIndex=" + atomIndex + ") and !within(SMARTS,'[r50,R]')");
        int nb = bs.cardinality();
        switch (nb) {
            case 0: 
            case 1: {
                return;
            }
            case 2: {
                break;
            }
            case 3: 
            case 4: {
                int[] lengths = new int[nb];
                int[] points = new int[nb];
                int ni = 0;
                int i = bs.nextSetBit(0);
                while (i >= 0) {
                    lengths[ni] = this.getBranchBitSet(i, atomIndex, true).cardinality();
                    points[ni] = i;
                    i = bs.nextSetBit(i + 1);
                    ++ni;
                }
                for (int j = 0; j < nb - 2; ++j) {
                    int max = Integer.MIN_VALUE;
                    int imax = 0;
                    for (int i2 = 0; i2 < nb; ++i2) {
                        if (lengths[i2] < max || !bs.get(points[i2])) continue;
                        imax = points[i2];
                        max = lengths[i2];
                    }
                    bs.clear(imax);
                }
                break;
            }
        }
        if (isClick) {
            this.undoMoveActionClear(atomIndex, 2, true);
        }
        this.invertSelected(null, null, atomIndex, bs);
        if (isClick) {
            this.setStatusAtomPicked(atomIndex, "inverted: " + Escape.eBS(bs), null);
        }
    }

    public void invertSelected(P3 pt, P4 plane, int iAtom, BS invAtoms) {
        BS bs = this.bsA();
        if (bs.isEmpty()) {
            return;
        }
        this.ms.invertSelected(pt, plane, iAtom, invAtoms, bs);
        this.checkMinimization();
        this.sm.setStatusAtomMoved(bs);
    }

    public void moveAtoms(M4 m4, M3 mNew, M3 rotation, V3 translation, P3 center, boolean isInternal, BS bsAtoms, boolean translationOnly) {
        if (bsAtoms.isEmpty()) {
            return;
        }
        this.ms.moveAtoms(m4, mNew, rotation, translation, bsAtoms, center, isInternal, translationOnly);
        this.checkMinimization();
        this.sm.setStatusAtomMoved(bsAtoms);
    }

    public void moveSelected(int deltaX, int deltaY, int deltaZ, int x, int y, BS bsSelected, boolean isTranslation, boolean asAtoms) {
        if (deltaZ == 0) {
            return;
        }
        if (x == Integer.MIN_VALUE) {
            this.rotateBondIndex = -1;
        }
        if (this.isJmolDataFrame()) {
            return;
        }
        if (deltaX == Integer.MIN_VALUE) {
            this.showSelected = true;
            this.movableBitSet = this.setMovableBitSet(null, !asAtoms);
            this.shm.loadShape(8);
            this.refresh(6, "moveSelected");
            return;
        }
        if (deltaX == Integer.MAX_VALUE) {
            if (!this.showSelected) {
                return;
            }
            this.showSelected = false;
            this.movableBitSet = null;
            this.refresh(6, "moveSelected");
            return;
        }
        if (this.movingSelected) {
            return;
        }
        this.movingSelected = true;
        this.stopMinimization();
        if (this.rotateBondIndex >= 0 && x != Integer.MIN_VALUE) {
            this.actionRotateBond(deltaX, deltaY, x, y);
        } else if (!(bsSelected = this.setMovableBitSet(bsSelected, !asAtoms)).isEmpty()) {
            if (isTranslation) {
                P3 ptCenter = this.ms.getAtomSetCenter(bsSelected);
                this.tm.finalizeTransformParameters();
                float f = this.g.antialiasDisplay ? 2 : 1;
                P3i ptScreen = this.tm.transformPt(ptCenter);
                P3 ptScreenNew = deltaZ != Integer.MIN_VALUE ? P3.new3(ptScreen.x, ptScreen.y, (float)(ptScreen.z + deltaZ) + 0.5f) : P3.new3((float)ptScreen.x + (float)deltaX * f + 0.5f, (float)ptScreen.y + (float)deltaY * f + 0.5f, ptScreen.z);
                P3 ptNew = new P3();
                this.tm.unTransformPoint(ptScreenNew, ptNew);
                ptNew.sub(ptCenter);
                this.setAtomCoordsRelative(ptNew, bsSelected);
            } else {
                this.tm.rotateXYBy(deltaX, deltaY, bsSelected);
            }
        }
        this.refresh(2, "");
        this.movingSelected = false;
    }

    public void highlightBond(int index, boolean isHover) {
        if (isHover && !this.hoverEnabled) {
            return;
        }
        BS bs = null;
        if (index >= 0) {
            Bond b = this.ms.bo[index];
            int i = b.atom2.i;
            if (!this.ms.isAtomAssignable(i)) {
                return;
            }
            bs = BSUtil.newAndSetBit(i);
            bs.set(b.atom1.i);
        }
        this.highlight(bs);
        this.refresh(3, "highlightBond");
    }

    public void highlight(BS bs) {
        if (bs != null) {
            this.shm.loadShape(8);
        }
        this.setShapeProperty(8, "highlight", bs);
    }

    public void setRotateBondIndex(int index) {
        boolean haveBond;
        boolean bl = haveBond = this.rotateBondIndex >= 0;
        if (!haveBond && index < 0) {
            return;
        }
        this.rotatePrev1 = -1;
        this.bsRotateBranch = null;
        if (index == Integer.MIN_VALUE) {
            return;
        }
        this.rotateBondIndex = index;
        this.highlightBond(index, false);
    }

    int getRotateBondIndex() {
        return this.rotateBondIndex;
    }

    void actionRotateBond(int deltaX, int deltaY, int x, int y) {
        Atom atom2;
        Atom atom1;
        if (this.rotateBondIndex < 0) {
            return;
        }
        BS bsBranch = this.bsRotateBranch;
        if (bsBranch == null) {
            Bond b = this.ms.bo[this.rotateBondIndex];
            atom1 = b.atom1;
            atom2 = b.atom2;
            this.undoMoveActionClear(atom1.i, 2, true);
            P3 pt = P3.new3(x, y, (atom1.sZ + atom2.sZ) / 2);
            this.tm.unTransformPoint(pt, pt);
            if (atom2.getCovalentBondCount() == 1 || pt.distance(atom1) < pt.distance(atom2) && atom1.getCovalentBondCount() != 1) {
                Atom a = atom1;
                atom1 = atom2;
                atom2 = a;
            }
            if (Measure.computeAngleABC(pt, atom1, atom2, true) > 90.0f || Measure.computeAngleABC(pt, atom2, atom1, true) > 90.0f) {
                bsBranch = this.getBranchBitSet(atom2.i, atom1.i, true);
            }
            if (bsBranch != null) {
                int n = 0;
                int i = atom1.bonds.length;
                while (--i >= 0) {
                    if (!bsBranch.get(atom1.getBondedAtomIndex(i)) || ++n != 2) continue;
                    bsBranch = null;
                    break;
                }
            }
            if (bsBranch == null) {
                bsBranch = this.ms.getMoleculeBitSetForAtom(atom1.i);
            }
            this.bsRotateBranch = bsBranch;
            this.rotatePrev1 = atom1.i;
            this.rotatePrev2 = atom2.i;
        } else {
            atom1 = this.ms.at[this.rotatePrev1];
            atom2 = this.ms.at[this.rotatePrev2];
        }
        V3 v1 = V3.new3(atom2.sX - atom1.sX, atom2.sY - atom1.sY, 0.0f);
        V3 v2 = V3.new3(deltaX, deltaY, 0.0f);
        v1.cross(v1, v2);
        float degrees = (float)(v1.z > 0.0f ? 1 : -1) * v2.length();
        BS bs = BSUtil.copy(bsBranch);
        bs.andNot(this.slm.getMotionFixedAtoms());
        this.rotateAboutPointsInternal(this.eval, atom1, atom2, 0.0f, degrees, false, bs, null, null, null, null);
    }

    public void refreshMeasures(boolean andStopMinimization) {
        this.setShapeProperty(6, "refresh", null);
        if (andStopMinimization) {
            this.stopMinimization();
        }
    }

    public float[][] functionXY(String functionName, int nX, int nY) {
        float[][] fdata;
        String data = null;
        if (functionName.indexOf("file:") == 0) {
            data = this.getFileAsString3(functionName.substring(5), false, null);
        } else if (functionName.indexOf("data2d_") != 0) {
            return this.sm.functionXY(functionName, nX, nY);
        }
        nX = Math.abs(nX);
        nY = Math.abs(nY);
        if (data == null) {
            fdata = (float[][])this.getDataObj(functionName, null, 2);
            if (fdata != null) {
                return fdata;
            }
            data = "";
        }
        fdata = new float[nX][nY];
        float[] f = new float[nX * nY];
        Parser.parseStringInfestedFloatArray(data, null, f);
        int n = 0;
        for (int i = 0; i < nX; ++i) {
            for (int j = 0; j < nY; ++j) {
                fdata[i][j] = f[n++];
            }
        }
        return fdata;
    }

    public float[][][] functionXYZ(String functionName, int nX, int nY, int nZ) {
        float[][][] xyzdata;
        String data = null;
        if (functionName.indexOf("file:") == 0) {
            data = this.getFileAsString3(functionName.substring(5), false, null);
        } else if (functionName.indexOf("data3d_") != 0) {
            return this.sm.functionXYZ(functionName, nX, nY, nZ);
        }
        nX = Math.abs(nX);
        nY = Math.abs(nY);
        nZ = Math.abs(nZ);
        if (data == null) {
            xyzdata = (float[][][])this.getDataObj(functionName, null, 2);
            if (xyzdata != null) {
                return xyzdata;
            }
            data = "";
        }
        xyzdata = new float[nX][nY][nZ];
        float[] f = new float[nX * nY * nZ];
        Parser.parseStringInfestedFloatArray(data, null, f);
        int n = 0;
        for (int i = 0; i < nX; ++i) {
            for (int j = 0; j < nY; ++j) {
                for (int k = 0; k < nZ; ++k) {
                    xyzdata[i][j][k] = f[n++];
                }
            }
        }
        return xyzdata;
    }

    @Override
    public String extractMolData(String what) {
        if (what == null) {
            int i = this.am.cmi;
            if (i < 0 || this.ms.ac == 0) {
                return null;
            }
            what = this.getModelNumberDotted(i);
        }
        return this.getModelExtract(what, true, false, "V2000");
    }

    public String getNMRPredict(String type) {
        if ((type = type.toUpperCase()).equals("H") || type.equals("1H") || type.equals("")) {
            type = "H1";
        } else if (type.equals("C") || type.equals("13C")) {
            type = "C13";
        }
        if (!type.equals("NONE")) {
            if (!type.equals("C13") && !type.equals("H1")) {
                return "Type must be H1 or C13";
            }
            String molFile = this.getModelExtract("selected", true, false, "V2000");
            int pt = molFile.indexOf("\n");
            if (pt < 0) {
                return null;
            }
            molFile = "Jmol " + version_date + molFile.substring(pt);
            if (this.isApplet) {
                this.showUrl(this.g.nmrUrlFormat + molFile);
                return "opening " + this.g.nmrUrlFormat;
            }
        }
        this.syncScript("true", "*", 0);
        this.syncScript(type + "Simulate:", ".", 0);
        return "sending request to JSpecView";
    }

    public void getHelp(String what) {
        if (this.g.helpPath.indexOf("?") < 0) {
            if (what.length() > 0 && what.indexOf("?") != 0) {
                what = "?search=" + PT.rep(what, " ", "%20");
            }
            what = what + (what.length() == 0 ? "?ver=" : "&ver=") + JC.majorVersion;
        } else {
            what = "&" + what;
        }
        this.showUrl(this.g.helpPath + what);
    }

    public String getChemicalInfo(String smiles, String info, BS bsAtoms) {
        info = info.toLowerCase();
        char type = '/';
        switch (";inchi;inchikey;stdinchi;stdinchikey;name;image;drawing;names;".indexOf(";" + info + ";")) {
            case 0: {
                type = 'I';
                break;
            }
            case 6: {
                type = 'K';
                break;
            }
            case 15: {
                type = 'T';
                break;
            }
            case 24: {
                type = 'S';
                break;
            }
            case 36: {
                type = 'M';
                break;
            }
            case 41: 
            case 47: {
                type = '2';
                break;
            }
            case 55: {
                type = 'N';
            }
        }
        String s = (String)this.setLoadFormat("_" + smiles, type, false);
        if (type == '2') {
            this.fm.loadImage(s, "\u0001" + smiles, false);
            return s;
        }
        if (type == '/') {
            s = PT.isOneOf(info, ";alc;cdxml;cerius;charmm;cif;cml;ctx;gjf;gromacs;hyperchem;jme;maestro;mol;mol2;sybyl2;mrv;pdb;sdf;sdf3000;sln;smiles;xyz;") ? s + "file?format=" + info : s + PT.rep(info, " ", "%20");
        }
        s = this.getFileAsString4(s, -1, false, false, false, "file");
        if (type == 'M' && s.indexOf("\n") > 0) {
            s = s.substring(0, s.indexOf("\n"));
        } else if (info.equals("jme")) {
            s = this.getPropertyManager().fixJMEFormalCharges(bsAtoms, s);
        }
        return s;
    }

    public void addCommand(String command) {
        if (this.autoExit || !this.haveDisplay || !this.getPreserveState()) {
            return;
        }
        this.commandHistory.addCommand(PT.replaceAllCharacters(command, "\r\n\t", " "));
    }

    public String removeCommand() {
        return this.commandHistory.removeCommand();
    }

    @Override
    public String getSetHistory(int howFarBack) {
        return this.commandHistory.getSetHistory(howFarBack);
    }

    public String historyFind(String cmd, int dir) {
        return this.commandHistory.find(cmd, dir);
    }

    public void setHistory(String fileName) {
        this.commandHistory.getSetHistory(Integer.MIN_VALUE);
        this.commandHistory.addCommand(this.getFileAsString4(fileName, -1, false, false, true, null));
    }

    public OC getOutputChannel(String localName, String[] fullPath) {
        return this.getOutputManager().getOutputChannel(localName, fullPath);
    }

    @Override
    public String writeTextFile(String fileName, String data) {
        Hashtable<String, Object> params = new Hashtable<String, Object>();
        params.put("fileName", fileName);
        params.put("type", "txt");
        params.put("text", data);
        return this.outputToFile(params);
    }

    @Override
    public String clipImageOrPasteText(String text) {
        if (!this.haveAccess(ACCESS.ALL)) {
            return "no";
        }
        return this.getOutputManager().clipImageOrPasteText(text);
    }

    @Override
    public String getClipboardText() {
        if (!this.haveAccess(ACCESS.ALL)) {
            return "no";
        }
        try {
            return this.getOutputManager().getClipboardText();
        }
        catch (Error er) {
            return GT._("clipboard is not accessible -- use signed applet");
        }
    }

    public String processWriteOrCapture(Map<String, Object> params) {
        return this.getOutputManager().processWriteOrCapture(params);
    }

    public Object createZip(String fileName, String type, Map<String, Object> params) {
        Object data = params.get("data");
        params.put("fileName", fileName);
        params.put("type", type);
        params.put("text", this.getStateInfo());
        if (data instanceof String[]) {
            params.put("scripts", data);
        } else if (data instanceof Lst) {
            params.put("imageData", data);
        }
        return this.getOutputManager().outputToFile(params);
    }

    @Override
    public String outputToFile(Map<String, Object> params) {
        return this.getOutputManager().outputToFile(params);
    }

    private OutputManager getOutputManager() {
        if (this.outputManager != null) {
            return this.outputManager;
        }
        this.outputManager = (OutputManager)Interface.getInterface("org.jmol.viewer.OutputManager" + (this.isJS ? "JS" : "Awt"), this, "file");
        return this.outputManager.setViewer(this, this.privateKey);
    }

    private void setSyncTarget(int mode, boolean TF) {
        switch (mode) {
            case 0: {
                this.sm.syncingMouse = TF;
                break;
            }
            case 1: {
                this.sm.syncingScripts = TF;
                break;
            }
            case 2: {
                this.sm.syncSend(TF ? SYNC_GRAPHICS_MESSAGE : SYNC_NO_GRAPHICS_MESSAGE, "*", 0);
                if (Float.isNaN(this.tm.stereoDegrees)) {
                    this.setFloatProperty("stereoDegrees", -5.0f);
                }
                if (TF) {
                    this.setBooleanProperty("_syncMouse", false);
                    this.setBooleanProperty("_syncScript", false);
                }
                return;
            }
        }
        if (!this.sm.syncingScripts && !this.sm.syncingMouse) {
            this.setSync();
        }
    }

    @Override
    public void syncScript(String script, String applet, int port) {
        this.getStateCreator().syncScript(script, applet, port);
    }

    @Override
    public int getModelIndexFromId(String id) {
        return this.ms.getModelIndexFromId(id);
    }

    public void setSyncDriver(int mode) {
        this.sm.setSyncDriver(mode);
    }

    public void setProteinType(STR type, BS bs) {
        this.ms.setProteinType(bs == null ? this.bsA() : bs, type);
    }

    public int getVanderwaalsMar(int i) {
        return this.defaultVdw == VDW.USER ? this.userVdwMars[i] : Elements.getVanderwaalsMar(i, this.defaultVdw);
    }

    public int getVanderwaalsMarType(int atomicAndIsotopeNumber, VDW type) {
        if (type == null) {
            type = this.defaultVdw;
        } else {
            switch (type) {
                case AUTO: 
                case AUTO_BABEL: 
                case AUTO_JMOL: 
                case AUTO_RASMOL: {
                    if (this.defaultVdw == VDW.AUTO) break;
                    type = this.defaultVdw;
                    break;
                }
            }
        }
        if (type == VDW.USER && this.bsUserVdws == null) {
            type = VDW.JMOL;
        }
        return type == VDW.USER ? this.userVdwMars[atomicAndIsotopeNumber & 0x7F] : Elements.getVanderwaalsMar(atomicAndIsotopeNumber, type);
    }

    void setVdwStr(String name) {
        VDW type = VDW.getVdwType(name);
        if (type == null) {
            type = VDW.AUTO;
        }
        switch (type) {
            case AUTO: 
            case JMOL: 
            case BABEL: 
            case RASMOL: 
            case USER: {
                break;
            }
            default: {
                type = VDW.JMOL;
            }
        }
        if (type != this.defaultVdw && type == VDW.USER && this.bsUserVdws == null) {
            this.setUserVdw(this.defaultVdw);
        }
        this.defaultVdw = type;
        this.g.setO("defaultVDW", type.getVdwLabel());
    }

    void setUserVdw(VDW mode) {
        this.userVdwMars = new int[Elements.elementNumberMax];
        this.userVdws = new float[Elements.elementNumberMax];
        this.bsUserVdws = new BS();
        if (mode == VDW.USER) {
            mode = VDW.JMOL;
        }
        for (int i = 1; i < Elements.elementNumberMax; ++i) {
            this.userVdwMars[i] = Elements.getVanderwaalsMar(i, mode);
            this.userVdws[i] = (float)this.userVdwMars[i] / 1000.0f;
        }
    }

    public String getDefaultVdwNameOrData(int mode, VDW type, BS bs) {
        switch (mode) {
            case -2147483648: {
                return this.defaultVdw.getVdwLabel();
            }
            case 0x7FFFFFFF: {
                bs = this.bsUserVdws;
                if (bs == null) {
                    return "";
                }
                type = VDW.USER;
            }
        }
        if (type == null || type == VDW.AUTO) {
            type = this.defaultVdw;
        }
        if (type == VDW.USER && this.bsUserVdws == null) {
            this.setUserVdw(this.defaultVdw);
        }
        return this.getDataManager().getDefaultVdwNameOrData(type, bs);
    }

    public int deleteAtoms(BS bsAtoms, boolean fullModels) {
        int atomIndex;
        int n = atomIndex = bsAtoms == null ? -1 : bsAtoms.nextSetBit(0);
        if (atomIndex < 0) {
            return 0;
        }
        this.clearModelDependentObjects();
        if (!fullModels) {
            this.sm.modifySend(atomIndex, this.ms.at[atomIndex].mi, 4, "deleting atom " + this.ms.at[atomIndex].getAtomName());
            this.ms.deleteAtoms(bsAtoms);
            int n2 = this.slm.deleteAtoms(bsAtoms);
            this.setTainted(true);
            this.sm.modifySend(atomIndex, this.ms.at[atomIndex].mi, -4, "OK");
            return n2;
        }
        return this.deleteModels(this.ms.at[atomIndex].mi, bsAtoms);
    }

    public int deleteModels(int modelIndex, BS bsAtoms) {
        this.clearModelDependentObjects();
        this.sm.modifySend(-1, modelIndex, 5, "deleting model " + this.getModelNumberDotted(modelIndex));
        this.setCurrentModelIndexClear(0, false);
        this.am.setAnimationOn(false);
        BS bsD0 = BSUtil.copy(this.slm.bsDeleted);
        BS bsModels = bsAtoms == null ? BSUtil.newAndSetBit(modelIndex) : this.ms.getModelBS(bsAtoms, false);
        BS bsDeleted = this.ms.deleteModels(bsModels);
        this.slm.processDeletedModelAtoms(bsDeleted);
        if (this.eval != null) {
            this.eval.deleteAtomsInVariables(bsDeleted);
        }
        this.setAnimationRange(0, 0);
        this.clearRepaintManager(-1);
        this.am.clear();
        this.am.initializePointers(1);
        this.setCurrentModelIndexClear(this.ms.mc > 1 ? -1 : 0, this.ms.mc > 1);
        this.hoverAtomIndex = -1;
        this.setFileLoadStatus(FIL.DELETED, null, null, null, null, null);
        this.refreshMeasures(true);
        if (bsD0 != null) {
            bsDeleted.andNot(bsD0);
        }
        this.sm.modifySend(-1, modelIndex, -5, "OK");
        return BSUtil.cardinalityOf(bsDeleted);
    }

    public void deleteBonds(BS bsDeleted) {
        short modelIndex = this.ms.bo[bsDeleted.nextSetBit((int)0)].atom1.mi;
        this.sm.modifySend(-1, modelIndex, 2, "delete bonds " + Escape.eBond(bsDeleted));
        this.ms.deleteBonds(bsDeleted, false);
        this.sm.modifySend(-1, modelIndex, -2, "OK");
    }

    public void deleteModelAtoms(int modelIndex, int firstAtomIndex, int nAtoms, BS bsModelAtoms) {
        this.sm.modifySend(-1, modelIndex, 1, "delete atoms " + Escape.eBS(bsModelAtoms));
        BSUtil.deleteBits(this.tm.bsFrameOffsets, bsModelAtoms);
        this.getDataManager().deleteModelAtoms(firstAtomIndex, nAtoms, bsModelAtoms);
        this.sm.modifySend(-1, modelIndex, -1, "OK");
    }

    public char getQuaternionFrame() {
        return this.g.quaternionFrame.charAt(this.g.quaternionFrame.length() == 2 ? 1 : 0);
    }

    public boolean loadImageData(Object image, String nameOrError, String echoName, ScriptContext sc) {
        if (image == null && nameOrError != null) {
            this.scriptEcho(nameOrError);
        }
        if (echoName == null) {
            this.setBackgroundImage(image == null ? null : nameOrError, image);
        } else if (echoName.startsWith("\u0001")) {
            this.sm.showImage(echoName, image);
        } else if (echoName.startsWith("\u0000")) {
            if (image != null) {
                this.setWindowDimensions(new float[]{this.apiPlatform.getImageWidth(image), this.apiPlatform.getImageHeight(image)});
            }
        } else {
            this.shm.loadShape(31);
            this.setShapeProperty(31, "text", nameOrError);
            if (image != null) {
                this.setShapeProperty(31, "image", image);
            }
        }
        if (this.isJS && sc != null) {
            sc.mustResumeEval = true;
            this.eval.resumeEval(sc);
        }
        return false;
    }

    public String cd(String dir) {
        String path;
        if (dir == null) {
            dir = ".";
        } else if (dir.length() == 0) {
            this.setStringProperty("defaultDirectory", "");
            dir = ".";
        }
        dir = this.fm.getDefaultDirectory(dir + (dir.equals("=") ? "" : (dir.endsWith("/") ? "X.spt" : "/X.spt")));
        if (dir.length() > 0) {
            this.setStringProperty("defaultDirectory", dir);
        }
        if ((path = this.fm.getFilePath(dir + "/", true, false)).startsWith("file:/")) {
            FileManager.setLocalPath(this, dir, false);
        }
        return dir;
    }

    public String setErrorMessage(String errMsg, String errMsgUntranslated) {
        this.errorMessageUntranslated = errMsgUntranslated;
        if (errMsg != null) {
            this.eval.stopScriptThreads();
        }
        this.errorMessage = errMsg;
        return this.errorMessage;
    }

    @Override
    public String getErrorMessage() {
        return this.errorMessage;
    }

    @Override
    public String getErrorMessageUn() {
        return this.errorMessageUntranslated == null ? this.errorMessage : this.errorMessageUntranslated;
    }

    public void setShapeErrorState(int shapeID, String state) {
        this.currentShapeID = shapeID;
        this.currentShapeState = state;
    }

    public String getShapeErrorState() {
        if (this.currentShapeID < 0) {
            return "";
        }
        this.shm.releaseShape(this.currentShapeID);
        this.clearRepaintManager(this.currentShapeID);
        return JC.getShapeClassName(this.currentShapeID, false) + " " + this.currentShapeState;
    }

    public void handleError(Error er, boolean doClear) {
        try {
            if (doClear) {
                this.zapMsg("" + er);
            }
            this.undoClear();
            if (Logger.getLogLevel() == 0) {
                Logger.setLogLevel(4);
            }
            this.setCursor(0);
            this.setBooleanProperty("refreshing", true);
            this.fm.setPathForAllFiles("");
            Logger.error("vwr handling error condition: " + er + "  ");
            if (!this.isJS) {
                er.printStackTrace();
            }
            this.notifyError("Error", "doClear=" + doClear + "; " + er, "" + er);
        }
        catch (Throwable e1) {
            try {
                Logger.error("Could not notify error " + er + ": due to " + e1);
            }
            catch (Throwable er2) {
                // empty catch block
            }
        }
    }

    public Map<String, JmolScriptFunction> getFunctions(boolean isStatic) {
        return isStatic ? staticFunctions : this.localFunctions;
    }

    public void removeFunction(String name) {
        JmolScriptFunction function = this.getFunction(name = name.toLowerCase());
        if (function == null) {
            return;
        }
        staticFunctions.remove(name);
        this.localFunctions.remove(name);
    }

    public JmolScriptFunction getFunction(String name) {
        if (name == null) {
            return null;
        }
        JmolScriptFunction function = (Viewer.isStaticFunction(name) ? staticFunctions : this.localFunctions).get(name);
        return function == null || function.geTokens() == null ? null : function;
    }

    private static boolean isStaticFunction(String name) {
        return name.startsWith("static_");
    }

    public boolean isFunction(String name) {
        return (Viewer.isStaticFunction(name) ? staticFunctions : this.localFunctions).containsKey(name);
    }

    public void clearFunctions() {
        staticFunctions.clear();
        this.localFunctions.clear();
    }

    public void addFunction(JmolScriptFunction function) {
        String name = function.getName();
        (Viewer.isStaticFunction(name) ? staticFunctions : this.localFunctions).put(name, function);
    }

    public String getFunctionCalls(String selectedFunction) {
        return this.getStateCreator().getFunctionCalls(selectedFunction);
    }

    public boolean checkPrivateKey(double privateKey) {
        return privateKey == this.privateKey;
    }

    public void bindAction(String desc, String name) {
        if (this.haveDisplay) {
            this.acm.bind(desc, name);
        }
    }

    public void unBindAction(String desc, String name) {
        if (this.haveDisplay) {
            this.acm.unbindAction(desc, name);
        }
    }

    public int calculateStruts(BS bs1, BS bs2) {
        return this.ms.calculateStruts(bs1 == null ? this.bsA() : bs1, bs2 == null ? this.bsA() : bs2);
    }

    public boolean getPreserveState() {
        return this.g.preserveState && this.scm != null;
    }

    boolean isKiosk() {
        return this.isKiosk;
    }

    public boolean hasFocus() {
        return this.haveDisplay && (this.isKiosk || this.apiPlatform.hasFocus(this.display));
    }

    public void setFocus() {
        if (this.haveDisplay && !this.apiPlatform.hasFocus(this.display)) {
            this.apiPlatform.requestFocusInWindow(this.display);
        }
    }

    void stopMinimization() {
        if (this.minimizer != null) {
            this.minimizer.setProperty("stop", null);
        }
    }

    void clearMinimization() {
        if (this.minimizer != null) {
            this.minimizer.setProperty("clear", null);
        }
    }

    public String getMinimizationInfo() {
        return this.minimizer == null ? "" : (String)this.minimizer.getProperty("log", 0);
    }

    private void checkMinimization() {
        this.refreshMeasures(true);
        if (!this.g.monitorEnergy) {
            return;
        }
        try {
            this.minimize(null, 0, 0.0f, this.getAllAtoms(), null, 0.0f, false, false, true, false);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.echoMessage(this.getP("_minimizationForceField") + " Energy = " + this.getP("_minimizationEnergy"));
    }

    public void minimize(JmolScriptEvaluator eval, int steps, float crit, BS bsSelected, BS bsFixed, float rangeFixed, boolean addHydrogen, boolean isOnly, boolean isSilent, boolean isLoad2D) throws Exception {
        block13: {
            boolean haveFixed;
            String ff = this.g.forceField;
            BS bsInFrame = this.getFrameAtoms();
            if (bsSelected == null) {
                bsSelected = this.getModelUndeletedAtomsBitSet(this.getVisibleFramesBitSet().length() - 1);
            } else {
                bsSelected.and(bsInFrame);
            }
            if (rangeFixed <= 0.0f) {
                rangeFixed = 5.0f;
            }
            BS bsMotionFixed = BSUtil.copy(bsFixed == null ? this.slm.getMotionFixedAtoms() : bsFixed);
            boolean bl = haveFixed = bsMotionFixed.cardinality() > 0;
            if (haveFixed) {
                bsSelected.andNot(bsMotionFixed);
            }
            BS bsNearby = isOnly ? new BS() : this.ms.getAtomsWithinRadius(rangeFixed, bsSelected, true, null);
            bsNearby.andNot(bsSelected);
            if (haveFixed) {
                bsMotionFixed.and(bsNearby);
            } else {
                bsMotionFixed = bsNearby;
            }
            bsMotionFixed.and(bsInFrame);
            if (addHydrogen) {
                bsSelected.or(this.addHydrogens(bsSelected, isLoad2D, isSilent));
            }
            if (bsSelected.cardinality() > 200) {
                Logger.error("Too many atoms for minimization (>200)");
                return;
            }
            try {
                if (!isSilent) {
                    Logger.info("Minimizing " + bsSelected.cardinality() + " atoms");
                }
                this.getMinimizer(true).minimize(steps, crit, bsSelected, bsMotionFixed, haveFixed, isSilent, ff);
            }
            catch (JmolAsyncException e) {
                if (eval != null) {
                    eval.loadFileResourceAsync(e.getFileName());
                }
            }
            catch (Exception e) {
                Logger.error("Minimization error: " + e.toString());
                if (this.isJS) break block13;
                e.printStackTrace();
            }
        }
    }

    public void setMotionFixedAtoms(BS bs) {
        this.slm.setMotionFixedAtoms(bs);
    }

    public BS getMotionFixedAtoms() {
        return this.slm.getMotionFixedAtoms();
    }

    void getAtomicPropertyState(SB commands, byte type, BS bs, String name, float[] data) {
        this.getStateCreator().getAtomicPropertyStateBuffer(commands, type, bs, name, data);
    }

    public P3[][] getCenterAndPoints(Lst<Object[]> atomSets, boolean addCenter) {
        return this.ms.getCenterAndPoints(atomSets, addCenter);
    }

    public String writeFileData(String fileName, String type, int modelIndex, Object[] parameters) {
        return this.getOutputManager().writeFileData(fileName, type, modelIndex, parameters);
    }

    public String getPdbData(int modelIndex, String type, BS bsAtoms, Object[] parameters, OC oc, boolean getStructure) {
        return this.getPropertyManager().getPdbData(modelIndex, type, bsAtoms == null ? this.bsA() : bsAtoms, parameters, oc, getStructure);
    }

    public BS getGroupsWithin(int nResidues, BS bs) {
        return this.ms.getGroupsWithin(nResidues, bs);
    }

    public void setShapeSize(int shapeID, int madOrMad10, BS bsSelected) {
        if (bsSelected == null) {
            bsSelected = this.bsA();
        }
        this.shm.setShapeSizeBs(shapeID, madOrMad10, null, bsSelected);
    }

    public void setShapeProperty(int shapeID, String propertyName, Object value) {
        if (shapeID >= 0) {
            this.shm.setShapePropertyBs(shapeID, propertyName, value, null);
        }
    }

    public Object getShapeProperty(int shapeType, String propertyName) {
        return this.shm.getShapePropertyIndex(shapeType, propertyName, Integer.MIN_VALUE);
    }

    private int getShapePropertyAsInt(int shapeID, String propertyName) {
        Object value = this.getShapeProperty(shapeID, propertyName);
        return value == null || !(value instanceof Integer) ? Integer.MIN_VALUE : (Integer)value;
    }

    public void setModelVisibility() {
        if (this.shm != null) {
            this.shm.setModelVisibility();
        }
    }

    public void resetShapes(boolean andCreateNew) {
        this.shm.resetShapes();
        if (andCreateNew) {
            this.shm.loadDefaultShapes(this.ms);
            this.clearRepaintManager(-1);
        }
    }

    public boolean setParallel(boolean TF) {
        this.isParallel = this.g.multiProcessor && TF;
        return this.isParallel;
    }

    public boolean isParallel() {
        return this.g.multiProcessor && this.isParallel;
    }

    private void setAtomPickingOption(String option) {
        if (this.haveDisplay) {
            this.acm.setAtomPickingOption(option);
        }
    }

    private void setBondPickingOption(String option) {
        if (this.haveDisplay) {
            this.acm.setBondPickingOption(option);
        }
    }

    void undoClear() {
        this.actionStates.clear();
        this.actionStatesRedo.clear();
    }

    public void undoMoveAction(int action, int n) {
        this.getStateCreator().undoMoveAction(action, n);
    }

    void undoMoveActionClear(int taintedAtom, int type, boolean clearRedo) {
        if (this.g.preserveState) {
            this.getStateCreator().undoMoveActionClear(taintedAtom, type, clearRedo);
        }
    }

    protected void moveAtomWithHydrogens(int atomIndex, int deltaX, int deltaY, int deltaZ, BS bsAtoms) {
        this.stopMinimization();
        if (bsAtoms == null) {
            Atom atom = this.ms.at[atomIndex];
            bsAtoms = BSUtil.newAndSetBit(atomIndex);
            Bond[] bonds = atom.bonds;
            if (bonds != null) {
                for (int i = 0; i < bonds.length; ++i) {
                    Atom atom2 = bonds[i].getOtherAtom(atom);
                    if (atom2.getElementNumber() != 1) continue;
                    bsAtoms.set(atom2.i);
                }
            }
        }
        this.moveSelected(deltaX, deltaY, deltaZ, Integer.MIN_VALUE, Integer.MIN_VALUE, bsAtoms, true, true);
    }

    public boolean isModelPDB(int i) {
        return this.ms.am[i].isBioModel;
    }

    @Override
    public void deleteMeasurement(int i) {
        this.setShapeProperty(6, "delete", i);
    }

    @Override
    public String getSmiles(BS bs) throws Exception {
        boolean is2D = "2D".equals(this.ms.getInfoM("dimension"));
        return this.getSmilesOpt(bs, -1, -1, (bs == null && Logger.debugging ? 131072 : 0) | (is2D ? 32 : 0), null);
    }

    @Override
    public String getOpenSmiles(BS bs) throws Exception {
        return this.getSmilesOpt(bs, -1, -1, 5 | (bs == null && Logger.debugging ? 131072 : 0), "/openstrict///");
    }

    public String getBioSmiles(BS bs) throws Exception {
        return this.getSmilesOpt(bs, -1, -1, 0x1700000 | (Logger.debugging ? 131072 : 0), null);
    }

    public String getSmilesOpt(BS bsSelected, int index1, int index2, int flags, String options) throws Exception {
        String bioComment = (flags & 0x1100000) == 0x1100000 ? Viewer.getJmolVersion() + " " + this.getModelName(this.am.cmi) : options;
        Node[] atoms = this.ms.at;
        if (bsSelected == null) {
            if (index1 < 0 || index2 < 0) {
                bsSelected = this.bsA();
            } else {
                if ((flags & 0x100000) == 0x100000) {
                    if (index1 > index2) {
                        int i = index1;
                        index1 = index2;
                        index2 = i;
                    }
                    index1 = atoms[index1].group.firstAtomIndex;
                    index2 = ((Atom)atoms[index2]).group.lastAtomIndex;
                }
                bsSelected = new BS();
                bsSelected.setBits(index1, index2 + 1);
            }
        }
        SmilesMatcherInterface sm = this.getSmilesMatcher();
        if (JC.isSmilesCanonical(options)) {
            String smiles = sm.getSmiles(atoms, this.ms.ac, bsSelected, "/noAromatic/", flags);
            return this.getChemicalInfo(smiles, "smiles", null).trim();
        }
        return sm.getSmiles(atoms, this.ms.ac, bsSelected, bioComment, flags);
    }

    public void alert(String msg) {
        this.prompt(msg, "OK", null, true);
    }

    public String prompt(String label, String data, String[] list, boolean asButtons) {
        return this.isKiosk ? "null" : this.apiPlatform.prompt(label, data, list, asButtons);
    }

    public String dialogAsk(String type, String fileName, Map<String, Object> params) {
        return this.isKiosk || !this.haveAccess(ACCESS.ALL) ? null : this.sm.dialogAsk(type, fileName, params);
    }

    public JmolRendererInterface initializeExporter(Map<String, Object> params) {
        JmolRendererInterface export3D;
        boolean isJS = params.get("type").equals("JS");
        if (isJS) {
            if (this.jsExporter3D != null) {
                this.jsExporter3D.initializeOutput(this, this.privateKey, params);
                return this.jsExporter3D;
            }
        } else {
            String[] fullPath;
            String fileName = (String)params.get("fileName");
            OC out = this.getOutputChannel(fileName, fullPath = (String[])params.get("fullPath"));
            if (out == null) {
                return null;
            }
            params.put("outputChannel", out);
        }
        if ((export3D = (JmolRendererInterface)Interface.getOption("export.Export3D", this, "export")) == null) {
            return null;
        }
        Object exporter = export3D.initializeExporter(this, this.privateKey, this.gdata, params);
        if (isJS && exporter != null) {
            this.jsExporter3D = export3D;
        }
        return exporter == null ? null : export3D;
    }

    public boolean getMouseEnabled() {
        return this.refreshing && !this.creatingImage;
    }

    @Override
    public void calcAtomsMinMax(BS bs, BoxInfo boxInfo) {
        this.ms.calcAtomsMinMax(bs, boxInfo);
    }

    public void getObjectMap(Map<String, ?> map, char c) {
        switch (c) {
            case '{': {
                if (this.getScriptManager() != null) {
                    Map<String, Object> m = map;
                    if (this.definedAtomSets != null) {
                        m.putAll(this.definedAtomSets);
                    }
                    T.getTokensType(m, 0x200000);
                }
                return;
            }
            case '$': 
            case '0': {
                this.shm.getObjectMap(map, c == '$');
                return;
            }
        }
    }

    public void setPicked(int atomIndex) {
        SV pickedSet = null;
        SV pickedList = null;
        if (atomIndex >= 0) {
            this.g.setI("_atompicked", atomIndex);
            pickedSet = (SV)this.g.getParam("picked", true);
            pickedList = (SV)this.g.getParam("pickedList", true);
        }
        if (pickedSet == null || pickedSet.tok != 10) {
            pickedSet = SV.newV(10, new BS());
            pickedList = SV.getVariableList(new Lst());
            this.g.setUserVariable("picked", pickedSet);
            this.g.setUserVariable("pickedList", pickedList);
        }
        if (atomIndex < 0) {
            return;
        }
        SV.getBitSet(pickedSet, false).set(atomIndex);
        SV p = pickedList.pushPop(null, null);
        if (p.tok == 10) {
            pickedList.pushPop(p, null);
        }
        if (p.tok != 10 || !((BS)p.value).get(atomIndex)) {
            pickedList.pushPop(SV.newV(10, BSUtil.newAndSetBit(atomIndex)), null);
        }
    }

    @Override
    public String runScript(String script) {
        return "" + this.evaluateExpression(new T[][]{{T.t(134222850), T.t(0x10000010), SV.newS(script), T.t(0x10000011)}});
    }

    @Override
    public String runScriptCautiously(String script) {
        SB outputBuffer = new SB();
        try {
            if (this.getScriptManager() == null) {
                return null;
            }
            this.eval.runScriptBuffer(script, outputBuffer, false);
        }
        catch (Exception e) {
            return this.eval.getErrorMessage();
        }
        return outputBuffer.toString();
    }

    public void setFrameDelayMs(long millis) {
        this.ms.setFrameDelayMs(millis, this.getVisibleFramesBitSet());
    }

    public BS getBaseModelBitSet() {
        return this.ms.getModelAtomBitSetIncludingDeleted(this.getJDXBaseModelIndex(this.am.cmi), true);
    }

    public void clearTimeouts() {
        if (this.timeouts != null) {
            TimeoutThread.clear(this.timeouts);
        }
    }

    public void setTimeout(String name, int mSec, String script) {
        if (!this.haveDisplay || this.headless || this.autoExit) {
            return;
        }
        if (name == null) {
            this.clearTimeouts();
            return;
        }
        if (this.timeouts == null) {
            this.timeouts = new Hashtable<String, Object>();
        }
        TimeoutThread.setTimeout(this, this.timeouts, name, mSec, script);
    }

    public void triggerTimeout(String name) {
        if (!this.haveDisplay || this.timeouts == null) {
            return;
        }
        TimeoutThread.trigger(this.timeouts, name);
    }

    public void clearTimeout(String name) {
        this.setTimeout(name, 0, null);
    }

    public String showTimeout(String name) {
        return this.haveDisplay ? TimeoutThread.showTimeout(this.timeouts, name) : "";
    }

    public float[] getOrCalcPartialCharges(BS bsSelected, BS bsIgnore) throws JmolAsyncException {
        if (bsSelected == null) {
            bsSelected = this.bsA();
        }
        bsSelected = BSUtil.copy(bsSelected);
        BSUtil.andNot(bsSelected, bsIgnore);
        BSUtil.andNot(bsSelected, this.ms.bsPartialCharges);
        if (!bsSelected.isEmpty()) {
            this.calculatePartialCharges(bsSelected);
        }
        return this.ms.getPartialCharges();
    }

    public void calculatePartialCharges(BS bsSelected) throws JmolAsyncException {
        int pt;
        if (bsSelected == null || bsSelected.isEmpty()) {
            bsSelected = this.getModelUndeletedAtomsBitSetBs(this.getVisibleFramesBitSet());
        }
        if ((pt = bsSelected.nextSetBit(0)) < 0) {
            return;
        }
        Logger.info("Calculating MMFF94 partial charges for " + bsSelected.cardinality() + " atoms");
        this.getMinimizer(true).calculatePartialCharges(this.ms, bsSelected);
    }

    public void setCurrentModelID(String id) {
        int modelIndex = this.am.cmi;
        if (modelIndex >= 0) {
            this.ms.setInfo(modelIndex, "modelID", id);
        }
    }

    public void cacheClear() {
        this.fm.cacheClear();
        this.ligandModelSet = null;
        this.ligandModels = null;
        this.ms.clearCache();
    }

    public void cachePut(String key, Object data) {
        Logger.info("Viewer cachePut " + key);
        this.fm.cachePut(key, data);
    }

    public int cacheFileByName(String fileName, boolean isAdd) {
        if (fileName == null) {
            this.cacheClear();
            return -1;
        }
        return this.fm.cacheFileByNameAdd(fileName, isAdd);
    }

    public void clearThreads() {
        if (this.eval != null) {
            this.eval.stopScriptThreads();
        }
        this.stopMinimization();
        this.tm.clearThreads();
        this.setAnimationOn(false);
    }

    public ScriptContext getEvalContextAndHoldQueue(JmolScriptEvaluator eval) {
        if (eval == null || !this.isJS && !this.testAsync) {
            return null;
        }
        eval.pushContextDown("getEvalContextAndHoldQueue");
        ScriptContext sc = eval.getThisContext();
        sc.setMustResume();
        sc.isJSThread = true;
        this.queueOnHold = true;
        return sc;
    }

    @Override
    public int[] resizeInnerPanel(int width, int height) {
        if (!this.autoExit && this.haveDisplay) {
            return this.sm.resizeInnerPanel(width, height);
        }
        this.setScreenDimension(width, height);
        return new int[]{this.dimScreen.width, this.dimScreen.height};
    }

    public String getDefaultPropertyParam(int propertyID) {
        return this.getPropertyManager().getDefaultPropertyParam(propertyID);
    }

    public int getPropertyNumber(String name) {
        return this.getPropertyManager().getPropertyNumber(name);
    }

    public boolean checkPropertyParameter(String name) {
        return this.getPropertyManager().checkPropertyParameter(name);
    }

    public Object extractProperty(Object property, Object args, int pt) {
        return this.getPropertyManager().extractProperty(property, args, pt, null, false);
    }

    public BS addHydrogens(BS bsAtoms, boolean is2DLoad, boolean isSilent) {
        boolean doAll;
        boolean bl = doAll = bsAtoms == null;
        if (bsAtoms == null) {
            bsAtoms = this.getModelUndeletedAtomsBitSet(this.getVisibleFramesBitSet().length() - 1);
        }
        BS bsB = new BS();
        if (bsAtoms.isEmpty()) {
            return bsB;
        }
        short modelIndex = this.ms.at[bsAtoms.nextSetBit((int)0)].mi;
        if (modelIndex != this.ms.mc - 1) {
            return bsB;
        }
        Lst<Atom> vConnections = new Lst<Atom>();
        P3[] pts = this.getAdditionalHydrogens(bsAtoms, doAll, false, vConnections);
        boolean wasAppendNew = false;
        wasAppendNew = this.g.appendNew;
        if (pts.length > 0) {
            this.clearModelDependentObjects();
            try {
                bsB = is2DLoad ? this.ms.addHydrogens(vConnections, pts) : this.addHydrogensInline(bsAtoms, vConnections, pts);
            }
            catch (Exception e) {
                System.out.println(e.toString());
            }
            if (wasAppendNew) {
                this.g.appendNew = true;
            }
        }
        if (!isSilent) {
            this.scriptStatus(GT.i(GT._("{0} hydrogens added"), pts.length));
        }
        return bsB;
    }

    public BS addHydrogensInline(BS bsAtoms, Lst<Atom> vConnections, P3[] pts) throws Exception {
        if (this.getScriptManager() == null) {
            return null;
        }
        return this.scm.addHydrogensInline(bsAtoms, vConnections, pts);
    }

    @Override
    public float evalFunctionFloat(Object func, Object params, float[] values) {
        return this.getScriptManager() == null ? 0.0f : this.eval.evalFunctionFloat(func, params, values);
    }

    public boolean evalParallel(ScriptContext context, ShapeManager shapeManager) {
        this.displayLoadErrors = false;
        boolean isOK = this.getScriptManager() != null && this.eval.evalParallel(context, shapeManager == null ? this.shm : shapeManager);
        this.displayLoadErrors = true;
        return isOK;
    }

    @Override
    public Object evaluateExpression(Object stringOrTokens) {
        return this.getScriptManager() == null ? null : this.eval.evaluateExpression(stringOrTokens, false, false);
    }

    public SV evaluateExpressionAsVariable(Object stringOrTokens) {
        return this.getScriptManager() == null ? null : (SV)this.eval.evaluateExpression(stringOrTokens, true, false);
    }

    public BS getAtomBitSet(Object atomExpression) {
        if (atomExpression instanceof BS) {
            return this.slm.excludeAtoms((BS)atomExpression, false);
        }
        this.getScriptManager();
        return this.getAtomBitSetEval(this.eval, atomExpression);
    }

    public ScriptContext getScriptContext(String why) {
        return this.getScriptManager() == null ? null : this.eval.getScriptContext(why);
    }

    public String getAtomDefs(Map<String, Object> names) {
        Lst<String> keys = new Lst<String>();
        for (Map.Entry<String, Object> e : names.entrySet()) {
            if (!(e.getValue() instanceof BS)) continue;
            keys.addLast("{" + e.getKey() + "} <" + ((BS)e.getValue()).cardinality() + " atoms>\n");
        }
        int n = keys.size();
        Object[] k = new String[n];
        keys.toArray(k);
        Arrays.sort(k);
        SB sb = new SB();
        for (int i = 0; i < n; ++i) {
            sb.append((String)k[i]);
        }
        return sb.append("\n").toString();
    }

    public void setCGO(Lst<Object> info) {
        this.shm.loadShape(23);
        this.shm.setShapePropertyBs(23, "setCGO", info, null);
    }

    public void setModelSet(ModelSet modelSet) {
        this.ms = this.mm.modelSet = modelSet;
    }

    public String setObjectProp(String id, int tokCommand) {
        this.getScriptManager();
        if (id == null) {
            id = "*";
        }
        return this.eval == null ? null : this.eval.setObjectPropSafe(id, tokCommand);
    }

    public void setDihedrals(float[] dihedralList, BS[] bsBranches, float rate) {
        if (bsBranches == null) {
            bsBranches = this.ms.getBsBranches(dihedralList);
        }
        this.ms.setDihedrals(dihedralList, bsBranches, rate);
    }

    public int getChainID(String id, boolean isAssign) {
        Integer iboxed = (Integer)this.chainMap.get(id);
        if (iboxed != null) {
            return iboxed;
        }
        int i = id.charAt(0);
        if (id.length() > 1) {
            i = 300 + this.chainList.size();
        } else if (isAssign && 97 <= i && i <= 122) {
            i += 159;
        }
        if (i >= 256) {
            this.chainCaseSpecified |= isAssign;
            this.chainList.addLast(id);
        }
        iboxed = i;
        this.chainMap.put(iboxed, id);
        this.chainMap.put(id, iboxed);
        return i;
    }

    public String getChainIDStr(int id) {
        return (String)this.chainMap.get(id);
    }

    public Boolean getScriptQueueInfo() {
        return this.scm != null && this.scm.isQueueProcessing() ? Boolean.TRUE : Boolean.FALSE;
    }

    public JmolNMRInterface getNMRCalculation() {
        JmolNMRInterface jmolNMRInterface;
        if (this.nmrCalculation == null) {
            this.nmrCalculation = (JmolNMRInterface)Interface.getOption("quantum.NMRCalculation", this, "script");
            jmolNMRInterface = this.nmrCalculation.setViewer(this);
        } else {
            jmolNMRInterface = this.nmrCalculation;
        }
        return jmolNMRInterface;
    }

    public String getDistanceUnits(String s) {
        int pt;
        if (s == null) {
            s = this.getDefaultMeasurementLabel(2);
        }
        return (pt = s.indexOf("//")) < 0 ? this.g.measureDistanceUnits : s.substring(pt + 2);
    }

    public int calculateFormalCharges(BS bs) {
        return this.ms.fixFormalCharges(bs == null ? this.bsA() : bs);
    }

    public void setModulation(BS bs, boolean isOn, P3 t1, boolean isQ) {
        if (isQ) {
            this.g.setO("_modt", Escape.eP(t1));
        }
        this.ms.setModulation(bs == null ? this.getAllAtoms() : bs, isOn, t1, isQ);
        this.refreshMeasures(true);
    }

    public void checkInMotion(int state) {
        switch (state) {
            case 0: {
                this.setTimeout("_SET_IN_MOTION_", 0, null);
                break;
            }
            case 1: {
                if (this.inMotion) break;
                this.setTimeout("_SET_IN_MOTION_", this.g.hoverDelayMs * 2, "!setInMotion");
                break;
            }
            case 2: {
                this.setInMotion(true);
                this.refresh(3, "timeoutThread set in motion");
            }
        }
    }

    public boolean checkMotionRendering(int tok) {
        if (!(this.getInMotion(true) || this.tm.spinOn || this.tm.vibrationOn || this.am.animationOn)) {
            return true;
        }
        if (this.g.wireframeRotation) {
            return false;
        }
        int n = 0;
        switch (tok) {
            case 0x44000001: 
            case 1677721602: {
                n = 2;
                break;
            }
            case 1112150020: {
                n = 3;
                break;
            }
            case 1112150021: {
                n = 4;
                break;
            }
            case 1112152066: {
                n = 5;
                break;
            }
            case 1073742018: {
                n = 6;
                break;
            }
            case 603979967: {
                n = 7;
                break;
            }
            case 603979786: {
                n = 8;
            }
        }
        return this.g.platformSpeed >= n;
    }

    public OC openExportChannel(double privateKey, String fileName, boolean asWriter) throws IOException {
        return this.getOutputManager().openOutputChannel(privateKey, fileName, asWriter, false);
    }

    @Override
    public void log(String data) {
        if (data != null) {
            this.getOutputManager().logToFile(data);
        }
    }

    public String getLogFileName() {
        return this.logFileName == null ? "" : this.logFileName;
    }

    public String getCommands(Map<String, BS> htDefine, Map<String, BS> htMore, String select) {
        return this.getStateCreator().getCommands(htDefine, htMore, select);
    }

    public boolean allowCapture() {
        return !this.isApplet || this.isSignedApplet;
    }

    public T[] compileExpr(String expr) {
        T[] tArray;
        Object o;
        Object object = o = this.getScriptManager() == null ? null : this.eval.evaluateExpression(expr, false, true);
        if (o instanceof T[]) {
            tArray = (T[])o;
        } else {
            T[] tArray2 = new T[1];
            tArray = tArray2;
            tArray2[0] = T.o(4, expr);
        }
        return tArray;
    }

    public boolean checkSelect(Map<String, SV> h, T[] value) {
        return this.getScriptManager() != null && this.eval.checkSelect(h, value);
    }

    public String getAnnotationInfo(SV d, String match, int type) {
        return this.getAnnotationParser(type == 1111490587).getAnnotationInfo(this, d, match, type, this.am.cmi);
    }

    public Lst<Float> getAtomValidation(String type, Atom atom) {
        return this.getAnnotationParser(false).getAtomValidation(this, type, atom);
    }

    public GenericZipTools getJzt() {
        return this.jzt == null ? (this.jzt = (GenericZipTools)Interface.getInterface("javajs.util.ZipTools", this, "zip")) : this.jzt;
    }

    void dragMinimizeAtom(int iAtom) {
        block2: {
            this.stopMinimization();
            BS bs = this.getMotionFixedAtoms().isEmpty() ? this.ms.getAtoms(this.ms.isAtomPDB(iAtom) ? 1086324742 : 0x41400010, BSUtil.newAndSetBit(iAtom)) : BSUtil.setAll(this.ms.ac);
            try {
                this.minimize(null, Integer.MAX_VALUE, 0.0f, bs, null, 0.0f, false, false, false, false);
            }
            catch (Exception e) {
                if (this.async) break block2;
                return;
            }
        }
    }

    public BioResolver getJBR() {
        return this.jbr == null ? (this.jbr = ((BioResolver)Interface.getInterface("org.jmol.modelsetbio.BioResolver", this, "file")).setViewer(this)) : this.jbr;
    }

    public void checkMenuUpdate() {
        if (this.jmolpopup != null) {
            this.jmolpopup.jpiUpdateComputedMenus();
        }
    }

    public JmolChimeMessenger getChimeMessenger() {
        return this.jcm == null ? (this.jcm = ((JmolChimeMessenger)Interface.getInterface("org.jmol.viewer.ChimeMessenger", this, "script")).set(this)) : this.jcm;
    }

    public Object getAuxiliaryInfoForAtoms(Object atomExpression) {
        return this.ms.getAuxiliaryInfo(this.ms.getModelBS(this.getAtomBitSet(atomExpression), false));
    }

    public Map<String, Object> parseJSON(String ann) {
        if (this.jsonParser == null) {
            this.jsonParser = (JSJSONParser)Interface.getInterface("javajs.util.JSJSONParser", this, "script");
        }
        return this.jsonParser.parseMap(ann, true);
    }

    public SymmetryInterface getSymTemp() {
        return Interface.getSymmetry(this, "ms");
    }

    public void setWindowDimensions(float[] dims) {
        this.resizeInnerPanel((int)dims[0], (int)dims[1]);
    }

    public Triangulator getTriangulator() {
        return this.triangulator == null ? (this.triangulator = (Triangulator)Interface.getUtil("Triangulator", this, "script")) : this.triangulator;
    }

    public void playAudio(String fileNameOrDataURI) {
        this.sm.playAudio(fileNameOrDataURI);
    }

    public Map<String, Object> getCurrentModelAuxInfo() {
        return this.am.cmi >= 0 ? this.ms.getModelAuxiliaryInfo(this.am.cmi) : null;
    }

    public void startNBO(String options) {
        Hashtable<String, Object> htParams = new Hashtable<String, Object>();
        htParams.put("service", "nbo");
        htParams.put("action", "showPanel");
        htParams.put("options", options);
        this.sm.processService(htParams);
    }

    public void startPlugin(String plugin) {
        if ("nbo".equalsIgnoreCase(plugin)) {
            this.startNBO("all");
        }
    }

    public void connectNBO(String type) {
        if (this.am.cmi < 0) {
            return;
        }
        this.getNBOParser().connectNBO(this.am.cmi, type);
    }

    private NBOParser getNBOParser() {
        return this.nboParser == null ? (this.nboParser = ((NBOParser)Interface.getInterface("org.jmol.adapter.readers.quantum.NBOParser", this, "script")).set(this)) : this.nboParser;
    }

    public String getNBOAtomLabel(Atom atom) {
        return this.getNBOParser().getNBOAtomLabel(atom);
    }

    public void calculateChirality(BS bsAtoms) {
        if (bsAtoms == null) {
            bsAtoms = this.bsA();
        }
        this.ms.calculateChiralityForAtoms(bsAtoms);
    }

    static {
        jsDocumentBase = "";
        strJavaVendor = "Java: " + System.getProperty("java.vendor", "j2s");
        strOSName = System.getProperty("os.name", "");
        strJavaVersion = "Java " + System.getProperty("java.version", "");
        staticFunctions = new Hashtable<String, JmolScriptFunction>();
        nProcessors = 1;
        nProcessors = Runtime.getRuntime().availableProcessors();
    }

    public static enum ACCESS {
        NONE,
        READSPT,
        ALL;

    }
}

