/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.notes;

import java.util.Comparator;
import java.util.Date;
import org.openstreetmap.josm.data.notes.Note;
import org.openstreetmap.josm.data.osm.User;

public class NoteComment {
    private final String text;
    private final User user;
    private final Date commentTimestamp;
    private final Action action;
    private boolean isNew;
    public static final Comparator<NoteComment> DATE_COMPARATOR = (noteComment, noteComment2) -> noteComment.commentTimestamp.compareTo(noteComment2.commentTimestamp);

    public NoteComment(Date date, User user, String string, Action action, boolean bl) {
        this.text = string;
        this.user = user;
        this.commentTimestamp = Note.cloneDate(date);
        this.action = action;
        this.isNew = bl;
    }

    public String getText() {
        return this.text;
    }

    public User getUser() {
        return this.user;
    }

    public Date getCommentTimestamp() {
        return Note.cloneDate(this.commentTimestamp);
    }

    public Action getNoteAction() {
        return this.action;
    }

    public void setNew(boolean bl) {
        this.isNew = bl;
    }

    public boolean isNew() {
        return this.isNew;
    }

    public String toString() {
        return this.text;
    }

    public static enum Action {
        OPENED,
        CLOSED,
        REOPENED,
        COMMENTED,
        HIDDEN;

    }
}

