/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.aot;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitResult;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jcodings.Encoding;
import org.jcodings.EncodingDB;
import org.jcodings.util.ArrayReader;
import org.jcodings.util.CaseInsensitiveBytesHash;
import org.jruby.truffle.aot.RootedFileVisitor;
import org.jruby.truffle.aot.SimpleRootedFileVisitor;

public final class JRubySupport {
    public static final Map<String, EncodingInstance> allEncodings = JRubySupport.getEncodings();
    public static final Map<String, byte[]> allJCodingsTables = JRubySupport.getJcodingsTables();

    private static Map<String, EncodingInstance> getEncodings() {
        HashMap<String, EncodingInstance> encodings = new HashMap<String, EncodingInstance>();
        CaseInsensitiveBytesHash<EncodingDB.Entry> encodingdb = EncodingDB.getEncodings();
        for (EncodingDB.Entry entry : encodingdb) {
            String encodingClassName = entry.getEncodingClass();
            Encoding encoding = Encoding.load(encodingClassName);
            encodings.put(encodingClassName, new EncodingInstance(encoding, encoding));
        }
        return encodings;
    }

    private static Map<String, byte[]> getJcodingsTables() {
        HashMap<String, byte[]> jcodingsTables = new HashMap<String, byte[]>();
        final HashSet jcodingsTableNames = new HashSet();
        SimpleRootedFileVisitor<Path> visitor = new SimpleRootedFileVisitor<Path>(){
            Pattern filePattern = Pattern.compile("^tables/(.*)\\.bin$");

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                String fileName = ((Path)this.getRoot()).relativize(file).toString();
                Matcher m = this.filePattern.matcher(fileName);
                if (m.matches()) {
                    jcodingsTableNames.add(m.group(1));
                }
                return FileVisitResult.CONTINUE;
            }
        };
        RootedFileVisitor.visitEachFileOnClassPath((RootedFileVisitor<Path>)visitor);
        for (String name : jcodingsTableNames) {
            String entry = "/tables/" + name + ".bin";
            try {
                InputStream is = ArrayReader.class.getResourceAsStream(entry);
                Throwable throwable = null;
                try {
                    if (is != null) {
                        byte[] buf = new byte[is.available()];
                        new DataInputStream(is).readFully(buf);
                        jcodingsTables.put(name, buf);
                        continue;
                    }
                    throw new Error("Unable to load Jcodings table " + name);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (is == null) continue;
                    if (throwable != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    is.close();
                }
            }
            catch (IOException iOException) {}
        }
        return jcodingsTables;
    }

    static class EncodingInstance {
        Encoding instance;
        Encoding dummy;

        EncodingInstance(Encoding instance, Encoding dummy) {
            this.instance = instance;
            this.dummy = dummy;
        }

        Encoding get(boolean useDummy) {
            if (useDummy && this.dummy != null) {
                return this.dummy;
            }
            return this.instance;
        }
    }
}

