/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.objectspace;

import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleOptions;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.utilities.CyclicAssumption;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.core.thread.ThreadManager;
import org.jruby.truffle.language.control.RaiseException;

public class ObjectSpaceManager {
    private final RubyContext context;
    private final Map<DynamicObject, FinalizerReference> finalizerReferences = new WeakHashMap<DynamicObject, FinalizerReference>();
    private final ReferenceQueue<DynamicObject> finalizerQueue = new ReferenceQueue();
    private DynamicObject finalizerThread;
    private final CyclicAssumption tracingAssumption = new CyclicAssumption("objspace-tracing");
    @CompilerDirectives.CompilationFinal
    private boolean isTracing = false;
    private int tracingAssumptionActivations = 0;
    private boolean tracingPaused = false;
    private final AtomicLong nextObjectID = new AtomicLong(6L);

    public ObjectSpaceManager(RubyContext context) {
        this.context = context;
    }

    @CompilerDirectives.TruffleBoundary
    public synchronized void defineFinalizer(DynamicObject object, Object callable) {
        FinalizerReference finalizerReference = this.finalizerReferences.get(object);
        if (finalizerReference == null) {
            finalizerReference = new FinalizerReference(object, this.finalizerQueue);
            this.finalizerReferences.put(object, finalizerReference);
        }
        finalizerReference.addFinalizer(callable);
        if (this.finalizerThread == null) {
            this.finalizerThread = ThreadManager.createRubyThread(this.context);
            ThreadManager.initialize(this.finalizerThread, this.context, null, "finalizer", () -> this.runFinalizers());
        }
    }

    public synchronized void undefineFinalizer(DynamicObject object) {
        FinalizerReference finalizerReference = this.finalizerReferences.get(object);
        if (finalizerReference != null) {
            finalizerReference.clearFinalizers();
        }
    }

    private void runFinalizers() {
        if (TruffleOptions.AOT) {
            return;
        }
        while (true) {
            FinalizerReference finalizerReference = (FinalizerReference)this.context.getThreadManager().runUntilResult(null, () -> this.finalizerQueue.remove());
            ObjectSpaceManager.runFinalizers(this.context, finalizerReference);
        }
    }

    private static void runFinalizers(RubyContext context, FinalizerReference finalizerReference) {
        try {
            for (Object callable : finalizerReference.getFinalizers()) {
                context.send(callable, "call", null, new Object[0]);
            }
        }
        catch (RaiseException raiseException) {
            // empty catch block
        }
    }

    public List<DynamicObject> getFinalizerHandlers() {
        ArrayList<DynamicObject> handlers = new ArrayList<DynamicObject>();
        for (FinalizerReference finalizer : this.finalizerReferences.values()) {
            for (Object handler : finalizer.getFinalizers()) {
                if (!(handler instanceof DynamicObject)) continue;
                handlers.add((DynamicObject)handler);
            }
        }
        return handlers;
    }

    public void traceAllocationsStart() {
        ++this.tracingAssumptionActivations;
        if (this.tracingAssumptionActivations == 1) {
            this.isTracing = true;
            this.tracingAssumption.invalidate();
        }
    }

    public void traceAllocationsStop() {
        --this.tracingAssumptionActivations;
        if (this.tracingAssumptionActivations == 0) {
            this.isTracing = false;
            this.tracingAssumption.invalidate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void traceAllocation(DynamicObject object, DynamicObject classPath, DynamicObject methodId, DynamicObject sourcefile, int sourceline) {
        if (TruffleOptions.AOT) {
            throw new UnsupportedOperationException("Memory manager is not available with AOT.");
        }
        if (this.tracingPaused) {
            return;
        }
        this.tracingPaused = true;
        try {
            this.context.send(this.context.getCoreLibrary().getObjectSpaceModule(), "trace_allocation", null, object, classPath, methodId, sourcefile, sourceline, ObjectSpaceManager.getCollectionCount());
        }
        finally {
            this.tracingPaused = false;
        }
    }

    public Assumption getTracingAssumption() {
        return this.tracingAssumption.getAssumption();
    }

    public boolean isTracing() {
        return this.isTracing;
    }

    public long getNextObjectID() {
        long id = this.nextObjectID.getAndAdd(2L);
        if (id < 0L) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw new RuntimeException("Object IDs exhausted");
        }
        return id;
    }

    public static int getCollectionCount() {
        int count = 0;
        for (GarbageCollectorMXBean bean : ManagementFactory.getGarbageCollectorMXBeans()) {
            count = (int)((long)count + bean.getCollectionCount());
        }
        return count;
    }

    private static class FinalizerReference
    extends WeakReference<DynamicObject> {
        public List<Object> finalizers = new LinkedList<Object>();

        public FinalizerReference(DynamicObject object, ReferenceQueue<? super DynamicObject> queue) {
            super(object, queue);
        }

        public void addFinalizer(Object callable) {
            this.finalizers.add(callable);
        }

        public List<Object> getFinalizers() {
            return this.finalizers;
        }

        public void clearFinalizers() {
            this.finalizers = new LinkedList<Object>();
        }
    }
}

