/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.debug;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.FrameInstance;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.instrumentation.EventBinding;
import com.oracle.truffle.api.instrumentation.ExecutionEventNode;
import com.oracle.truffle.api.instrumentation.ExecutionEventNodeFactory;
import com.oracle.truffle.api.instrumentation.SourceSectionFilter;
import com.oracle.truffle.api.instrumentation.StandardTags;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import java.util.ArrayList;
import java.util.List;
import org.jcodings.specific.USASCIIEncoding;
import org.jcodings.specific.UTF8Encoding;
import org.jruby.truffle.Layouts;
import org.jruby.truffle.builtins.CoreClass;
import org.jruby.truffle.builtins.CoreMethod;
import org.jruby.truffle.builtins.CoreMethodArrayArgumentsNode;
import org.jruby.truffle.builtins.CoreMethodNode;
import org.jruby.truffle.core.array.ArrayStrategy;
import org.jruby.truffle.core.string.StringOperations;
import org.jruby.truffle.language.backtrace.BacktraceFormatter;
import org.jruby.truffle.language.methods.InternalMethod;
import org.jruby.truffle.language.objects.shared.SharedObjects;
import org.jruby.truffle.language.yield.YieldNode;
import org.jruby.truffle.platform.UnsafeGroup;
import org.jruby.truffle.tools.simpleshell.SimpleShell;

@CoreClass(value="Truffle::Debug")
public abstract class TruffleDebugNodes {

    @CoreMethod(names={"shared?"}, onSingleton=true, required=1)
    public static abstract class IsSharedNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        public boolean isShared(DynamicObject object) {
            return SharedObjects.isShared(object);
        }
    }

    @CoreMethod(names={"array_storage"}, onSingleton=true, required=1)
    public static abstract class ArrayStorageNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization(guards={"isRubyArray(array)"})
        public DynamicObject arrayStorage(DynamicObject array) {
            String storage = ArrayStrategy.of(array).toString();
            return StringOperations.createString(this.getContext(), StringOperations.encodeRope(storage, USASCIIEncoding.INSTANCE));
        }
    }

    @CoreMethod(names={"shape"}, onSingleton=true, required=1)
    public static abstract class ShapeNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        public DynamicObject shape(DynamicObject object) {
            return this.createString(StringOperations.encodeRope(object.getShape().toString(), UTF8Encoding.INSTANCE));
        }
    }

    @CoreMethod(names={"object_type_of"}, onSingleton=true, required=1)
    public static abstract class ObjectTypeOfNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        public DynamicObject objectTypeOf(DynamicObject value) {
            return this.getSymbol(value.getShape().getObjectType().getClass().getSimpleName());
        }
    }

    @CoreMethod(names={"ast"}, onSingleton=true, required=1)
    public static abstract class ASTNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization(guards={"isRubyMethod(method)"})
        public DynamicObject astMethod(DynamicObject method) {
            return this.ast(Layouts.METHOD.getMethod(method));
        }

        @Specialization(guards={"isRubyUnboundMethod(method)"})
        public DynamicObject astUnboundMethod(DynamicObject method) {
            return this.ast(Layouts.UNBOUND_METHOD.getMethod(method));
        }

        @Specialization(guards={"isRubyProc(proc)"})
        public DynamicObject astProc(DynamicObject proc) {
            return this.ast(Layouts.PROC.getMethod(proc));
        }

        @CompilerDirectives.TruffleBoundary
        private DynamicObject ast(InternalMethod method) {
            if (method.getCallTarget() instanceof RootCallTarget) {
                return this.ast(((RootCallTarget)method.getCallTarget()).getRootNode());
            }
            return this.nil();
        }

        private DynamicObject ast(Node node) {
            if (node == null) {
                return this.nil();
            }
            ArrayList<DynamicObject> array = new ArrayList<DynamicObject>();
            array.add(this.getSymbol(node.getClass().getSimpleName()));
            for (Node child : node.getChildren()) {
                array.add(this.ast(child));
            }
            return this.createArray(array.toArray(), array.size());
        }
    }

    @CoreMethod(names={"print_backtrace"}, onSingleton=true, unsafe={UnsafeGroup.IO})
    public static abstract class PrintBacktraceNode
    extends CoreMethodNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        public DynamicObject printBacktrace() {
            List<String> rubyBacktrace = BacktraceFormatter.createDefaultFormatter(this.getContext()).formatBacktrace(this.getContext(), null, this.getContext().getCallStack().getBacktrace(this));
            for (String line : rubyBacktrace) {
                System.err.println(line);
            }
            return this.nil();
        }
    }

    @CoreMethod(names={"simple_shell"}, onSingleton=true, unsafe={UnsafeGroup.IO})
    public static abstract class SimpleShellNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        public DynamicObject simpleShell() {
            new SimpleShell(this.getContext()).run(this.getContext().getCallStack().getCallerFrameIgnoringSend().getFrame(FrameInstance.FrameAccess.MATERIALIZE, true).materialize(), this);
            return this.nil();
        }
    }

    @CoreMethod(names={"java_class_of"}, onSingleton=true, required=1)
    public static abstract class JavaClassOfNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        public DynamicObject javaClassOf(Object value) {
            return this.createString(StringOperations.encodeRope(value.getClass().getSimpleName(), UTF8Encoding.INSTANCE));
        }
    }

    @CoreMethod(names={"remove_handle"}, onSingleton=true, required=1)
    public static abstract class RemoveNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isHandle(handle)"})
        public DynamicObject remove(DynamicObject handle) {
            ((EventBinding)EventBinding.class.cast(Layouts.HANDLE.getObject(handle))).dispose();
            return this.nil();
        }
    }

    @CoreMethod(names={"break_handle"}, onSingleton=true, required=2, needsBlock=true, lowerFixnum={2})
    public static abstract class BreakNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isRubyString(file)"})
        public DynamicObject setBreak(DynamicObject file, int line, final DynamicObject block) {
            String fileString = StringOperations.decodeUTF8(file);
            SourceSectionFilter filter = SourceSectionFilter.newBuilder().mimeTypeIs("application/x-ruby").sourceIs(source -> source != null && source.getPath() != null && source.getPath().equals(fileString)).lineIs(line).tagIs(StandardTags.StatementTag.class).build();
            EventBinding<ExecutionEventNodeFactory> breakpoint = this.getContext().getInstrumenter().attachFactory(filter, eventContext -> new ExecutionEventNode(){
                @Node.Child
                private YieldNode yieldNode = new YieldNode();

                @Override
                protected void onEnter(VirtualFrame frame) {
                    this.yieldNode.dispatch(frame, block, Layouts.BINDING.createBinding(this.getContext().getCoreLibrary().getBindingFactory(), frame.materialize()));
                }
            });
            return Layouts.HANDLE.createHandle(this.coreLibrary().getHandleFactory(), breakpoint);
        }
    }
}

