/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.language.threadlocal;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import org.jruby.truffle.language.RubyGuards;
import org.jruby.truffle.language.RubyNode;
import org.jruby.truffle.language.threadlocal.ThreadLocalObject;

public class GetFromThreadLocalNode
extends RubyNode {
    @Node.Child
    private RubyNode value;

    public GetFromThreadLocalNode(RubyNode value) {
        this.value = value;
    }

    @Override
    public Object isDefined(VirtualFrame frame) {
        return this.value.isDefined(frame);
    }

    @Override
    public Object execute(VirtualFrame frame) {
        Object threadLocalObject = this.value.execute(frame);
        if (RubyGuards.isThreadLocal(threadLocalObject)) {
            return this.getThreadLocalValue((ThreadLocalObject)threadLocalObject);
        }
        return threadLocalObject;
    }

    @CompilerDirectives.TruffleBoundary
    private Object getThreadLocalValue(ThreadLocalObject threadLocalObject) {
        return threadLocalObject.get();
    }
}

