/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.parser;

import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.source.SourceSection;
import java.util.ArrayList;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.core.hash.ConcatHashLiteralNode;
import org.jruby.truffle.core.hash.HashLiteralNode;
import org.jruby.truffle.language.RubyNode;
import org.jruby.truffle.language.SourceIndexLength;
import org.jruby.truffle.language.arguments.MissingArgumentBehavior;
import org.jruby.truffle.language.arguments.ProfileArgumentNode;
import org.jruby.truffle.language.arguments.ReadPreArgumentNode;
import org.jruby.truffle.language.control.SequenceNode;
import org.jruby.truffle.language.literal.ObjectLiteralNode;
import org.jruby.truffle.parser.BodyTranslator;
import org.jruby.truffle.parser.Translator;
import org.jruby.truffle.parser.ast.ArgsParseNode;
import org.jruby.truffle.parser.ast.ArgumentParseNode;
import org.jruby.truffle.parser.ast.AssignableParseNode;
import org.jruby.truffle.parser.ast.KeywordArgParseNode;
import org.jruby.truffle.parser.ast.KeywordRestArgParseNode;
import org.jruby.truffle.parser.ast.MultipleAsgnParseNode;
import org.jruby.truffle.parser.ast.OptArgParseNode;
import org.jruby.truffle.parser.ast.ParseNode;
import org.jruby.truffle.parser.ast.RestArgParseNode;
import org.jruby.truffle.parser.ast.types.INameNode;

public class ReloadArgumentsTranslator
extends Translator {
    private final BodyTranslator methodBodyTranslator;
    private int index = 0;
    private int restParameterIndex = -1;

    public ReloadArgumentsTranslator(Node currentNode, RubyContext context, Source source, BodyTranslator methodBodyTranslator) {
        super(currentNode, context, source);
        this.methodBodyTranslator = methodBodyTranslator;
    }

    public int getRestParameterIndex() {
        return this.restParameterIndex;
    }

    @Override
    public RubyNode visitArgsNode(ArgsParseNode node) {
        int optArgsCount;
        SourceIndexLength sourceSection = node.getPosition();
        ArrayList<RubyNode> sequence = new ArrayList<RubyNode>();
        ParseNode[] args = node.getArgs();
        int preCount = node.getPreCount();
        if (preCount > 0) {
            for (int i = 0; i < preCount; ++i) {
                sequence.add(args[i].accept(this));
                ++this.index;
            }
        }
        if ((optArgsCount = node.getOptionalArgsCount()) > 0) {
            int optArgsIndex = node.getOptArgIndex();
            for (int i = 0; i < optArgsCount; ++i) {
                sequence.add(args[optArgsIndex + i].accept(this));
                ++this.index;
            }
        }
        if (node.hasRestArg()) {
            this.restParameterIndex = node.getPostIndex();
            sequence.add(node.getRestArgNode().accept(this));
        }
        SourceSection sourceSectionX = sourceSection.toSourceSection(this.source);
        if (node.getPostCount() > 0) {
            System.err.printf("WARNING: post args in zsuper not yet implemented at %s:%d%n", sourceSectionX.getSource().getName(), sourceSectionX.getStartLine());
        }
        RubyNode kwArgsNode = null;
        if (node.hasKwargs()) {
            int keywordIndex = node.getKeywordsIndex();
            int keywordCount = node.getKeywordCount();
            RubyNode[] keyValues = new RubyNode[keywordCount * 2];
            for (int i = 0; i < keywordCount; ++i) {
                KeywordArgParseNode kwArg = (KeywordArgParseNode)args[keywordIndex + i];
                RubyNode value = kwArg.accept(this);
                String name = ((INameNode)((Object)kwArg.getAssignable())).getName();
                ObjectLiteralNode key = new ObjectLiteralNode(this.context.getSymbolTable().getSymbol(name));
                keyValues[2 * i] = key;
                keyValues[2 * i + 1] = value;
            }
            kwArgsNode = HashLiteralNode.create(this.context, keyValues);
        }
        if (node.hasKeyRest()) {
            RubyNode keyRest = node.getKeyRest().accept(this);
            kwArgsNode = kwArgsNode == null ? keyRest : new ConcatHashLiteralNode(new RubyNode[]{kwArgsNode, keyRest});
        }
        if (kwArgsNode != null) {
            sequence.add(kwArgsNode);
        }
        return new SequenceNode(sequence.toArray(new RubyNode[sequence.size()]));
    }

    @Override
    public RubyNode visitArgumentNode(ArgumentParseNode node) {
        SourceIndexLength sourceSection = node.getPosition();
        return this.methodBodyTranslator.getEnvironment().findLocalVarNode(node.getName(), this.source, sourceSection);
    }

    @Override
    public RubyNode visitOptArgNode(OptArgParseNode node) {
        SourceIndexLength sourceSection = node.getPosition();
        return this.methodBodyTranslator.getEnvironment().findLocalVarNode(node.getName(), this.source, sourceSection);
    }

    @Override
    public RubyNode visitMultipleAsgnNode(MultipleAsgnParseNode node) {
        return new ProfileArgumentNode(new ReadPreArgumentNode(this.index, MissingArgumentBehavior.NIL));
    }

    @Override
    public RubyNode visitRestArgNode(RestArgParseNode node) {
        SourceIndexLength sourceSection = node.getPosition();
        return this.methodBodyTranslator.getEnvironment().findLocalVarNode(node.getName(), this.source, sourceSection);
    }

    @Override
    public RubyNode visitKeywordArgNode(KeywordArgParseNode node) {
        SourceIndexLength sourceSection = node.getPosition();
        AssignableParseNode asgnNode = node.getAssignable();
        String name = ((INameNode)((Object)asgnNode)).getName();
        return this.methodBodyTranslator.getEnvironment().findLocalVarNode(name, this.source, sourceSection);
    }

    @Override
    public RubyNode visitKeywordRestArgNode(KeywordRestArgParseNode node) {
        SourceIndexLength sourceSection = node.getPosition();
        return this.methodBodyTranslator.getEnvironment().findLocalVarNode(node.getName(), this.source, sourceSection);
    }

    @Override
    protected RubyNode defaultVisit(ParseNode node) {
        SourceIndexLength sourceSection = node.getPosition();
        return this.nilNode(this.source, sourceSection);
    }
}

