/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.parser.ast;

import java.util.List;
import org.jruby.truffle.language.SourceIndexLength;
import org.jruby.truffle.parser.ast.Colon3ParseNode;
import org.jruby.truffle.parser.ast.IScopingNode;
import org.jruby.truffle.parser.ast.NodeType;
import org.jruby.truffle.parser.ast.ParseNode;
import org.jruby.truffle.parser.ast.visitor.NodeVisitor;
import org.jruby.truffle.parser.scope.StaticScope;

public class ClassParseNode
extends ParseNode
implements IScopingNode {
    private final Colon3ParseNode cpath;
    private final StaticScope scope;
    private final ParseNode bodyNode;
    private final ParseNode superNode;

    public ClassParseNode(SourceIndexLength position, Colon3ParseNode cpath, StaticScope scope, ParseNode bodyNode, ParseNode superNode) {
        super(position, cpath.containsVariableAssignment() || bodyNode.containsVariableAssignment() || superNode != null && superNode.containsVariableAssignment());
        assert (cpath != null) : "cpath is not null";
        assert (scope != null) : "scope is not null";
        assert (bodyNode != null) : "bodyNode is not null";
        this.cpath = cpath;
        this.scope = scope;
        this.bodyNode = bodyNode;
        this.superNode = superNode;
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.CLASSNODE;
    }

    @Override
    public <T> T accept(NodeVisitor<T> iVisitor) {
        return iVisitor.visitClassNode(this);
    }

    public ParseNode getBodyNode() {
        return this.bodyNode;
    }

    public StaticScope getScope() {
        return this.scope;
    }

    @Override
    public Colon3ParseNode getCPath() {
        return this.cpath;
    }

    public ParseNode getSuperNode() {
        return this.superNode;
    }

    @Override
    public List<ParseNode> childNodes() {
        return ParseNode.createList((ParseNode)this.cpath, this.bodyNode, this.superNode);
    }
}

