/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.SmartList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.codegen.AsmUtil;
import org.jetbrains.kotlin.codegen.ClassBuilder;
import org.jetbrains.kotlin.codegen.CodegenUtilKt;
import org.jetbrains.kotlin.codegen.CompilationErrorHandler;
import org.jetbrains.kotlin.codegen.MemberCodegen;
import org.jetbrains.kotlin.codegen.PackageCodegen;
import org.jetbrains.kotlin.codegen.PackagePartCodegen;
import org.jetbrains.kotlin.codegen.PackagePartRegistry;
import org.jetbrains.kotlin.codegen.ScriptCodegen;
import org.jetbrains.kotlin.codegen.context.PackageContext;
import org.jetbrains.kotlin.codegen.state.GenerationState;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.diagnostics.DiagnosticUtils;
import org.jetbrains.kotlin.fileClasses.JvmFileClassInfo;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.progress.ProgressIndicatorAndCompilationCanceledStatus;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtScript;
import org.jetbrains.kotlin.psi.KtTypeAlias;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.JvmDeclarationOriginKt;
import org.jetbrains.org.objectweb.asm.Type;

public class PackageCodegenImpl
implements PackageCodegen {
    private final GenerationState state;
    private final Collection<KtFile> files;
    private final PackageFragmentDescriptor packageFragment;
    private final PackagePartRegistry packagePartRegistry;

    public PackageCodegenImpl(@NotNull GenerationState state2, @NotNull Collection<KtFile> files2, @NotNull FqName packageFqName, @NotNull PackagePartRegistry registry) {
        if (state2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/kotlin/codegen/PackageCodegenImpl", "<init>"));
        }
        if (files2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "org/jetbrains/kotlin/codegen/PackageCodegenImpl", "<init>"));
        }
        if (packageFqName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageFqName", "org/jetbrains/kotlin/codegen/PackageCodegenImpl", "<init>"));
        }
        if (registry == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "registry", "org/jetbrains/kotlin/codegen/PackageCodegenImpl", "<init>"));
        }
        this.state = state2;
        this.files = files2;
        this.packageFragment = this.getOnlyPackageFragment(packageFqName);
        this.packagePartRegistry = registry;
    }

    @Override
    public void generate(@NotNull CompilationErrorHandler errorHandler) {
        if (errorHandler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorHandler", "org/jetbrains/kotlin/codegen/PackageCodegenImpl", "generate"));
        }
        for (KtFile file2 : this.files) {
            ProgressIndicatorAndCompilationCanceledStatus.checkCanceled();
            try {
                this.generateFile(file2);
                this.state.afterIndependentPart();
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (Throwable e) {
                VirtualFile vFile = file2.getVirtualFile();
                errorHandler.reportException(e, vFile == null ? "no file" : vFile.getUrl());
                DiagnosticUtils.throwIfRunningOnServer(e);
                if (!ApplicationManager.getApplication().isInternal()) continue;
                e.printStackTrace();
            }
        }
    }

    private void generateClassesAndObjectsInFile(@NotNull List<KtClassOrObject> classOrObjects, @NotNull PackageContext packagePartContext) {
        if (classOrObjects == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classOrObjects", "org/jetbrains/kotlin/codegen/PackageCodegenImpl", "generateClassesAndObjectsInFile"));
        }
        if (packagePartContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packagePartContext", "org/jetbrains/kotlin/codegen/PackageCodegenImpl", "generateClassesAndObjectsInFile"));
        }
        for (KtClassOrObject classOrObject : CodegenUtilKt.sortTopLevelClassesAndPrepareContextForSealedClasses(classOrObjects, packagePartContext, this.state)) {
            this.generateClassOrObject(classOrObject, packagePartContext);
        }
    }

    private void generateFile(@NotNull KtFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/codegen/PackageCodegenImpl", "generateFile"));
        }
        JvmFileClassInfo fileClassInfo = this.state.getFileClassesProvider().getFileClassInfo(file2);
        if (fileClassInfo.getWithJvmMultifileClass()) {
            return;
        }
        Type fileClassType = AsmUtil.asmTypeByFqNameWithoutInnerClasses(fileClassInfo.getFileClassFqName());
        PackageContext packagePartContext = this.state.getRootContext().intoPackagePart(this.packageFragment, fileClassType, file2);
        boolean generatePackagePart = false;
        ArrayList<KtClassOrObject> classOrObjects = new ArrayList<KtClassOrObject>();
        for (KtDeclaration declaration : file2.getDeclarations()) {
            if (declaration.hasModifier(KtTokens.HEADER_KEYWORD)) continue;
            if (declaration instanceof KtProperty || declaration instanceof KtNamedFunction || declaration instanceof KtTypeAlias) {
                generatePackagePart = true;
                continue;
            }
            if (declaration instanceof KtClassOrObject) {
                KtClassOrObject classOrObject = (KtClassOrObject)declaration;
                if (!this.state.getGenerateDeclaredClassFilter().shouldGenerateClass(classOrObject)) continue;
                classOrObjects.add(classOrObject);
                continue;
            }
            if (!(declaration instanceof KtScript)) continue;
            KtScript script = (KtScript)declaration;
            if (!this.state.getGenerateDeclaredClassFilter().shouldGenerateScript(script)) continue;
            ScriptCodegen.createScriptCodegen(script, this.state, packagePartContext).generate();
        }
        this.generateClassesAndObjectsInFile(classOrObjects, packagePartContext);
        if (!generatePackagePart || !this.state.getGenerateDeclaredClassFilter().shouldGeneratePackagePart(file2)) {
            return;
        }
        String name2 = fileClassType.getInternalName();
        this.packagePartRegistry.addPart(StringsKt.substringAfterLast(name2, '/', name2), null);
        ClassBuilder builder = this.state.getFactory().newVisitor(JvmDeclarationOriginKt.PackagePart(file2, this.packageFragment), fileClassType, file2);
        new PackagePartCodegen(builder, file2, fileClassType, packagePartContext, this.state).generate();
    }

    @Nullable
    private PackageFragmentDescriptor getOnlyPackageFragment(@NotNull FqName expectedPackageFqName) {
        if (expectedPackageFqName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expectedPackageFqName", "org/jetbrains/kotlin/codegen/PackageCodegenImpl", "getOnlyPackageFragment"));
        }
        SmartList<PackageFragmentDescriptor> fragments2 = new SmartList<PackageFragmentDescriptor>();
        for (KtFile file2 : this.files) {
            PackageFragmentDescriptor fragment = this.state.getBindingContext().get(BindingContext.FILE_TO_PACKAGE_FRAGMENT, file2);
            assert (fragment != null) : "package fragment is null for " + file2 + "\n" + file2.getText();
            assert (expectedPackageFqName.equals(fragment.getFqName())) : "expected package fq name: " + expectedPackageFqName + ", actual: " + fragment.getFqName();
            if (fragments2.contains(fragment)) continue;
            fragments2.add(fragment);
        }
        if (fragments2.size() > 1) {
            throw new IllegalStateException("More than one package fragment, files: " + this.files + " | fragments: " + fragments2);
        }
        if (fragments2.isEmpty()) {
            return null;
        }
        return (PackageFragmentDescriptor)fragments2.get(0);
    }

    @Override
    public void generateClassOrObject(@NotNull KtClassOrObject classOrObject, @NotNull PackageContext packagePartContext) {
        if (classOrObject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classOrObject", "org/jetbrains/kotlin/codegen/PackageCodegenImpl", "generateClassOrObject"));
        }
        if (packagePartContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packagePartContext", "org/jetbrains/kotlin/codegen/PackageCodegenImpl", "generateClassOrObject"));
        }
        MemberCodegen.genClassOrObject(packagePartContext, classOrObject, this.state, null);
    }

    @Override
    public PackageFragmentDescriptor getPackageFragment() {
        return this.packageFragment;
    }
}

