/*
 * Decompiled with CFR 0.152.
 */
package com.sun.nio.zipfs;

import com.sun.nio.zipfs.ZipFileSystem;
import com.sun.nio.zipfs.ZipPath;
import java.io.IOException;
import java.nio.file.ClosedDirectoryStreamException;
import java.nio.file.DirectoryStream;
import java.nio.file.NotDirectoryException;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class ZipDirectoryStream
implements DirectoryStream<Path> {
    private final ZipFileSystem zipfs;
    private final byte[] path;
    private final DirectoryStream.Filter<? super Path> filter;
    private volatile boolean isClosed;
    private volatile Iterator<Path> itr;

    ZipDirectoryStream(ZipPath zipPath, DirectoryStream.Filter<? super Path> filter) throws IOException {
        this.zipfs = zipPath.getFileSystem();
        this.path = zipPath.getResolvedPath();
        this.filter = filter;
        if (!this.zipfs.isDirectory(this.path)) {
            throw new NotDirectoryException(zipPath.toString());
        }
    }

    @Override
    public synchronized Iterator<Path> iterator() {
        if (this.isClosed) {
            throw new ClosedDirectoryStreamException();
        }
        if (this.itr != null) {
            throw new IllegalStateException("Iterator has already been returned");
        }
        try {
            this.itr = this.zipfs.iteratorOf(this.path, this.filter);
        }
        catch (IOException iOException) {
            throw new IllegalStateException(iOException);
        }
        return new Iterator<Path>(){
            private Path next;

            @Override
            public boolean hasNext() {
                if (ZipDirectoryStream.this.isClosed) {
                    return false;
                }
                return ZipDirectoryStream.this.itr.hasNext();
            }

            @Override
            public synchronized Path next() {
                if (ZipDirectoryStream.this.isClosed) {
                    throw new NoSuchElementException();
                }
                return (Path)ZipDirectoryStream.this.itr.next();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public synchronized void close() throws IOException {
        this.isClosed = true;
    }
}

