/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.net;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousByteChannel;
import java.nio.channels.AsynchronousSocketChannel;
import java.nio.channels.CompletionHandler;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.tomcat.util.net.SecureNio2Channel;
import org.apache.tomcat.util.net.SocketWrapper;

public class Nio2Channel
implements AsynchronousByteChannel {
    protected static ByteBuffer emptyBuf = ByteBuffer.allocate(0);
    protected AsynchronousSocketChannel sc = null;
    protected SocketWrapper<Nio2Channel> socket = null;
    protected SecureNio2Channel.ApplicationBufferHandler bufHandler;
    private static final Future<Boolean> DONE = new Future<Boolean>(){

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            return false;
        }

        @Override
        public boolean isCancelled() {
            return false;
        }

        @Override
        public boolean isDone() {
            return true;
        }

        @Override
        public Boolean get() throws InterruptedException, ExecutionException {
            return Boolean.TRUE;
        }

        @Override
        public Boolean get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            return Boolean.TRUE;
        }
    };

    public Nio2Channel(SecureNio2Channel.ApplicationBufferHandler bufHandler) {
        this.bufHandler = bufHandler;
    }

    public void reset(AsynchronousSocketChannel channel, SocketWrapper<Nio2Channel> socket) throws IOException {
        this.sc = channel;
        this.socket = socket;
        this.bufHandler.getReadBuffer().clear();
        this.bufHandler.getWriteBuffer().clear();
    }

    public SocketWrapper<Nio2Channel> getSocket() {
        return this.socket;
    }

    public int getBufferSize() {
        if (this.bufHandler == null) {
            return 0;
        }
        int size = 0;
        size += this.bufHandler.getReadBuffer() != null ? this.bufHandler.getReadBuffer().capacity() : 0;
        return size += this.bufHandler.getWriteBuffer() != null ? this.bufHandler.getWriteBuffer().capacity() : 0;
    }

    @Override
    public void close() throws IOException {
        this.sc.close();
    }

    public void close(boolean force) throws IOException {
        if (this.isOpen() || force) {
            this.close();
        }
    }

    @Override
    public boolean isOpen() {
        return this.sc.isOpen();
    }

    public SecureNio2Channel.ApplicationBufferHandler getBufHandler() {
        return this.bufHandler;
    }

    public AsynchronousSocketChannel getIOChannel() {
        return this.sc;
    }

    public boolean isClosing() {
        return false;
    }

    public boolean isHandshakeComplete() {
        return true;
    }

    public int handshake() throws IOException {
        return 0;
    }

    public String toString() {
        return super.toString() + ":" + this.sc.toString();
    }

    @Override
    public Future<Integer> read(ByteBuffer dst) {
        return this.sc.read(dst);
    }

    @Override
    public <A> void read(ByteBuffer dst, A attachment, CompletionHandler<Integer, ? super A> handler) {
        this.read(dst, Integer.MAX_VALUE, TimeUnit.MILLISECONDS, attachment, handler);
    }

    public <A> void read(ByteBuffer dst, long timeout, TimeUnit unit, A attachment, CompletionHandler<Integer, ? super A> handler) {
        this.sc.read(dst, timeout, unit, attachment, handler);
    }

    @Override
    public Future<Integer> write(ByteBuffer src) {
        return this.sc.write(src);
    }

    @Override
    public <A> void write(ByteBuffer src, A attachment, CompletionHandler<Integer, ? super A> handler) {
        this.write(src, Integer.MAX_VALUE, TimeUnit.MILLISECONDS, attachment, handler);
    }

    public <A> void write(ByteBuffer src, long timeout, TimeUnit unit, A attachment, CompletionHandler<Integer, ? super A> handler) {
        this.sc.write(src, timeout, unit, attachment, handler);
    }

    public <A> void write(ByteBuffer[] srcs, int offset, int length, long timeout, TimeUnit unit, A attachment, CompletionHandler<Long, ? super A> handler) {
        this.sc.write(srcs, offset, length, timeout, unit, attachment, handler);
    }

    public Future<Boolean> flush() {
        return DONE;
    }
}

