/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.ui.notifications;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.CharConversionException;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.netbeans.core.ui.notifications.NotificationDisplayerImpl;
import org.netbeans.core.ui.notifications.PopupList;
import org.openide.awt.Notification;
import org.openide.awt.NotificationDisplayer;
import org.openide.xml.XMLUtil;

class NotificationImpl
extends Notification
implements Comparable<NotificationImpl> {
    private final String title;
    private final Icon icon;
    private final NotificationDisplayer.Priority priority;
    private JComponent balloonComp;
    private JComponent popupComponent;
    private String detailsText;
    private ActionListener al;

    NotificationImpl(String string, Icon icon, NotificationDisplayer.Priority priority) {
        this.title = string;
        this.icon = icon;
        this.priority = priority;
    }

    public void clear() {
        NotificationDisplayerImpl.getInstance().remove(this);
    }

    @Override
    public int compareTo(NotificationImpl notificationImpl) {
        int n = this.priority.compareTo((Enum)notificationImpl.priority);
        if (0 == n) {
            n = this.title.compareTo(notificationImpl.title);
        }
        return n;
    }

    public JComponent getBalloonComp() {
        return this.balloonComp;
    }

    public Icon getIcon() {
        return this.icon;
    }

    public JComponent getPopupComponent() {
        return this.popupComponent;
    }

    public String getTitle() {
        return this.title;
    }

    boolean showBallon() {
        return this.priority != NotificationDisplayer.Priority.SILENT;
    }

    void setDetails(String string, ActionListener actionListener) {
        this.detailsText = string;
        this.al = actionListener;
    }

    void setDetails(JComponent jComponent, JComponent jComponent2) {
        this.balloonComp = jComponent;
        this.popupComponent = jComponent2;
    }

    void initDecorations() {
        if (null != this.detailsText) {
            this.balloonComp = this.createDetails(this.detailsText, this.al);
            this.popupComponent = this.createDetails(this.detailsText, this.al);
        }
        JComponent jComponent = this.createTitle(this.title);
        JComponent jComponent2 = this.createContent(this.icon, jComponent, this.balloonComp);
        jComponent2.setBorder(BorderFactory.createEmptyBorder(8, 5, 0, 0));
        this.balloonComp = jComponent2;
        jComponent = this.createTitle(this.title);
        this.popupComponent = this.createContent(this.icon, jComponent, this.popupComponent);
    }

    private JComponent createContent(Icon icon, JComponent jComponent, JComponent jComponent2) {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setOpaque(false);
        jPanel.add((Component)new JLabel(icon), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        jPanel.add((Component)jComponent, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
        jPanel.add((Component)jComponent2, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
        jPanel.add((Component)new JLabel(), new GridBagConstraints(2, 2, 1, 1, 1.0, 1.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                NotificationImpl.this.clear();
                PopupList.dismiss();
            }
        };
        this.addActionListener(jComponent2, actionListener);
        return jPanel;
    }

    private void addActionListener(Container container, ActionListener actionListener) {
        if (container instanceof AbstractButton) {
            ((AbstractButton)container).addActionListener(actionListener);
        }
        for (Component component : container.getComponents()) {
            if (!(component instanceof Container)) continue;
            this.addActionListener((Container)component, actionListener);
        }
    }

    private JComponent createTitle(String string) {
        return new JLabel("<html>" + string);
    }

    private JComponent createDetails(String string, ActionListener actionListener) {
        if (null == actionListener) {
            return new JLabel(string);
        }
        try {
            string = "<html><u>" + XMLUtil.toElementContent((String)string);
        }
        catch (CharConversionException charConversionException) {
            throw new IllegalArgumentException(charConversionException);
        }
        JButton jButton = new JButton(string);
        jButton.setFocusable(false);
        jButton.setBorder(BorderFactory.createEmptyBorder());
        jButton.setBorderPainted(false);
        jButton.setFocusPainted(false);
        jButton.setOpaque(false);
        jButton.setContentAreaFilled(false);
        jButton.addActionListener(actionListener);
        jButton.setCursor(Cursor.getPredefinedCursor(12));
        jButton.setForeground(Color.blue);
        return jButton;
    }
}

