/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.delete;

import java.io.IOException;
import org.elasticsearch.action.DocWriteResponse;
import org.elasticsearch.action.support.replication.ReplicationResponse;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.rest.RestStatus;

public class DeleteResponse
extends DocWriteResponse {
    private static final String FOUND = "found";
    private static final ConstructingObjectParser<DeleteResponse, Void> PARSER = new ConstructingObjectParser(DeleteResponse.class.getName(), args -> {
        ShardId shardId = new ShardId(new Index((String)args[0], "_na_"), -1);
        String type = (String)args[1];
        String id = (String)args[2];
        long version = (Long)args[3];
        ReplicationResponse.ShardInfo shardInfo = (ReplicationResponse.ShardInfo)args[5];
        boolean found = (Boolean)args[6];
        DeleteResponse deleteResponse = new DeleteResponse(shardId, type, id, version, found);
        deleteResponse.setShardInfo(shardInfo);
        return deleteResponse;
    });

    public DeleteResponse() {
    }

    public DeleteResponse(ShardId shardId, String type, String id, long version, boolean found) {
        super(shardId, type, id, version, found ? DocWriteResponse.Result.DELETED : DocWriteResponse.Result.NOT_FOUND);
    }

    @Override
    public RestStatus status() {
        return this.result == DocWriteResponse.Result.DELETED ? super.status() : RestStatus.NOT_FOUND;
    }

    @Override
    public XContentBuilder innerToXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field(FOUND, this.result == DocWriteResponse.Result.DELETED);
        super.innerToXContent(builder, params);
        return builder;
    }

    public static DeleteResponse fromXContent(XContentParser parser) {
        return PARSER.apply(parser, null);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("DeleteResponse[");
        builder.append("index=").append(this.getIndex());
        builder.append(",type=").append(this.getType());
        builder.append(",id=").append(this.getId());
        builder.append(",version=").append(this.getVersion());
        builder.append(",result=").append(this.getResult().getLowercase());
        builder.append(",shards=").append(this.getShardInfo());
        return builder.append("]").toString();
    }

    static {
        DocWriteResponse.declareParserFields(PARSER);
        PARSER.declareBoolean(ConstructingObjectParser.constructorArg(), new ParseField(FOUND, new String[0]));
    }
}

