/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.ast;

import org.mozilla.javascript.Token;
import org.mozilla.javascript.ast.AstNode;
import org.mozilla.javascript.ast.NodeVisitor;

public class UnaryExpression
extends AstNode {
    private AstNode operand;
    private boolean isPostfix;

    public UnaryExpression() {
    }

    public UnaryExpression(int n) {
        super(n);
    }

    public UnaryExpression(int n, int n2) {
        super(n, n2);
    }

    public UnaryExpression(int n, int n2, AstNode astNode) {
        this(n, n2, astNode, false);
    }

    public UnaryExpression(int n, int n2, AstNode astNode, boolean bl) {
        this.assertNotNull(astNode);
        int n3 = bl ? astNode.getPosition() : n2;
        int n4 = bl ? n2 + 2 : astNode.getPosition() + astNode.getLength();
        this.setBounds(n3, n4);
        this.setOperator(n);
        this.setOperand(astNode);
        this.isPostfix = bl;
    }

    public int getOperator() {
        return this.type;
    }

    public void setOperator(int n) {
        if (!Token.isValidToken(n)) {
            throw new IllegalArgumentException("Invalid token: " + n);
        }
        this.setType(n);
    }

    public AstNode getOperand() {
        return this.operand;
    }

    public void setOperand(AstNode astNode) {
        this.assertNotNull(astNode);
        this.operand = astNode;
        astNode.setParent(this);
    }

    public boolean isPostfix() {
        return this.isPostfix;
    }

    public boolean isPrefix() {
        return !this.isPostfix;
    }

    public void setIsPostfix(boolean bl) {
        this.isPostfix = bl;
    }

    @Override
    public String toSource(int n) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.makeIndent(n));
        int n2 = this.getType();
        if (!this.isPostfix) {
            stringBuilder.append(UnaryExpression.operatorToString(n2));
            if (n2 == 32 || n2 == 31 || n2 == 126) {
                stringBuilder.append(" ");
            }
        }
        stringBuilder.append(this.operand.toSource());
        if (this.isPostfix) {
            stringBuilder.append(UnaryExpression.operatorToString(n2));
        }
        return stringBuilder.toString();
    }

    @Override
    public void visit(NodeVisitor nodeVisitor) {
        if (nodeVisitor.visit(this)) {
            this.operand.visit(nodeVisitor);
        }
    }
}

