/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.reference;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsExpression;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.general.AbstractTranslator;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;

public abstract class AbstractCallExpressionTranslator
extends AbstractTranslator {
    @NotNull
    protected final KtCallExpression expression;
    @NotNull
    protected final ResolvedCall<? extends FunctionDescriptor> resolvedCall;
    @Nullable
    protected final JsExpression receiver;

    protected AbstractCallExpressionTranslator(@NotNull KtCallExpression expression, @Nullable JsExpression receiver, @NotNull TranslationContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/js/translate/reference/AbstractCallExpressionTranslator", "<init>"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/reference/AbstractCallExpressionTranslator", "<init>"));
        }
        super(context);
        this.expression = expression;
        this.resolvedCall = CallUtilKt.getFunctionResolvedCallWithAssert(expression, this.bindingContext());
        this.receiver = receiver;
    }
}

