/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.process.internal.health.memory;

import org.gradle.internal.jvm.Jvm;
import org.gradle.internal.os.OperatingSystem;
import org.gradle.process.internal.ExecHandleFactory;
import org.gradle.process.internal.health.memory.JvmMemoryStatus;
import org.gradle.process.internal.health.memory.JvmMemoryStatusSnapshot;
import org.gradle.process.internal.health.memory.MBeanAttributeProvider;
import org.gradle.process.internal.health.memory.MBeanAvailableMemory;
import org.gradle.process.internal.health.memory.MeminfoAvailableMemory;
import org.gradle.process.internal.health.memory.OsMemoryStatus;
import org.gradle.process.internal.health.memory.OsMemoryStatusSnapshot;
import org.gradle.process.internal.health.memory.VmstatAvailableMemory;

public class MemoryInfo {
    private final ExecHandleFactory execHandleFactory;
    private final long totalMemory;

    public MemoryInfo(ExecHandleFactory execHandleFactory) {
        this.execHandleFactory = execHandleFactory;
        this.totalMemory = Runtime.getRuntime().maxMemory();
    }

    public long getMaxMemory() {
        return this.totalMemory;
    }

    public long getCommittedMemory() {
        return Runtime.getRuntime().totalMemory();
    }

    public long getTotalPhysicalMemory() throws UnsupportedOperationException {
        String attribute = Jvm.current().isIbmJvm() ? "TotalPhysicalMemory" : "TotalPhysicalMemorySize";
        return MBeanAttributeProvider.getMbeanAttribute("java.lang:type=OperatingSystem", attribute, Long.class);
    }

    public long getFreePhysicalMemory() throws UnsupportedOperationException {
        OperatingSystem operatingSystem = OperatingSystem.current();
        if (operatingSystem.isMacOsX()) {
            return new VmstatAvailableMemory(this.execHandleFactory).get();
        }
        if (operatingSystem.isLinux()) {
            return new MeminfoAvailableMemory().get();
        }
        return new MBeanAvailableMemory().get();
    }

    public JvmMemoryStatus getJvmSnapshot() {
        return new JvmMemoryStatusSnapshot(this.getMaxMemory(), this.getCommittedMemory());
    }

    public OsMemoryStatus getOsSnapshot() throws UnsupportedOperationException {
        return new OsMemoryStatusSnapshot(this.getTotalPhysicalMemory(), this.getFreePhysicalMemory());
    }
}

