/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.cleanup;

import java.io.File;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.internal.file.delete.Deleter;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.internal.FileUtils;
import org.gradle.internal.cleanup.BuildOutputDeleter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultBuildOutputDeleter
implements BuildOutputDeleter {
    private final Logger logger = Logging.getLogger(DefaultBuildOutputDeleter.class);
    private final Deleter deleter;

    public DefaultBuildOutputDeleter(Deleter deleter) {
        this.deleter = deleter;
    }

    @Override
    public void delete(Iterable<File> outputs) {
        for (File output : FileUtils.calculateRoots(outputs)) {
            this.deleteOutput(output);
        }
    }

    private void deleteOutput(File output) {
        try {
            if (output.isDirectory()) {
                this.deleter.delete(output);
                this.logger.quiet("Cleaned up directory '{}'", new Object[]{output});
            } else if (output.isFile()) {
                this.deleter.delete(output);
                this.logger.quiet("Cleaned up file '{}'", new Object[]{output});
            }
        }
        catch (UncheckedIOException e) {
            this.logger.warn("Unable to clean up '{}'", (Object)output);
        }
    }
}

