/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.symmetry;

import java.util.Arrays;
import java.util.Hashtable;
import java.util.Map;
import javajs.util.Lst;
import javajs.util.Measure;
import javajs.util.P3;
import javajs.util.PT;
import javajs.util.V3;
import org.jmol.java.BS;
import org.jmol.modelset.Atom;
import org.jmol.util.BSUtil;
import org.jmol.util.Edge;
import org.jmol.util.Logger;
import org.jmol.util.Node;
import org.jmol.viewer.Viewer;

public class CIPChirality {
    static final int NO_CHIRALITY = 0;
    static final int TIED = 0;
    static final int B_WINS = 1;
    static final int A_WINS = -1;
    static final int NA = -2;
    static final int STEREO_R = 1;
    static final int STEREO_S = 2;
    static final int STEREO_Z = 1;
    static final int STEREO_E = 2;
    private Viewer vwr;
    int ptID;
    CIPAtom root;
    int currentRule = 0;
    Map<String, Integer> htPathPoints;
    static final int[] PRIORITY_SHIFT = new int[]{24, 20, 12, 8, 4, 0};

    public CIPChirality setViewer(Viewer vwr) {
        this.vwr = vwr;
        return this;
    }

    public void getChiralityForAtoms(Node[] atoms, BS bsAtoms) {
        BS bsToDo = BSUtil.copy(bsAtoms);
        int i = bsAtoms.nextSetBit(0);
        while (i >= 0) {
            Node atom = atoms[i];
            String c = atom.getCIPChirality(true);
            if (c.length() > 0) {
                bsToDo.clear(i);
            }
            i = bsAtoms.nextSetBit(i + 1);
        }
        i = bsAtoms.nextSetBit(0);
        while (i >= 0) {
            this.getAtomBondChirality(atoms[i], true);
            i = bsAtoms.nextSetBit(i + 1);
        }
        i = bsToDo.nextSetBit(0);
        while (i >= 0) {
            Node a = atoms[i];
            if (a.getCovalentBondCount() == 4) {
                a.setCIPChirality(0);
                a.setCIPChirality(this.getAtomChiralityLimited(a, null, null, 5, -1));
            }
            i = bsToDo.nextSetBit(i + 1);
        }
    }

    public int getAtomChirality(Node atom) {
        return this.getAtomChiralityLimited(atom, null, null, 3, -1);
    }

    public int getBondChirality(Edge bond) {
        return this.getBondChiralityLimited(bond, 3);
    }

    public void getAtomBondChirality(Node atom, boolean allBonds) {
        Edge[] bonds = atom.getEdges();
        int index = atom.getIndex();
        int j = bonds.length;
        while (--j >= 0) {
            Edge bond = bonds[j];
            if (bond.getCovalentOrder() != 2 || !allBonds && bond.getOtherAtomNode(atom).getIndex() <= index) continue;
            this.getBondChirality(bond);
        }
    }

    private int getAtomChiralityLimited(Node atom, CIPAtom cipAtom, CIPAtom parent, int ruleMax, int iref) {
        int nSubs;
        int rs = 0;
        boolean isChiral = false;
        if (cipAtom != null) {
            atom = cipAtom.atom;
        }
        boolean isAlkene = (nSubs = atom.getCovalentBondCount()) == 3;
        if (nSubs == (parent == null ? 4 : 3)) {
            if (cipAtom == null) {
                this.htPathPoints = new Hashtable<String, Integer>();
                cipAtom = new CIPAtom(atom, null, false);
            }
            this.root = cipAtom;
            cipAtom.parent = parent;
            this.currentRule = 0;
            if (cipAtom.set()) {
                block15: {
                    try {
                        if (iref >= 0) {
                            cipAtom.bsPath.set(iref);
                        }
                        this.currentRule = 0;
                        while (this.currentRule <= ruleMax && !isChiral) {
                            int i;
                            isChiral = false;
                            if (Logger.debugging) {
                                Logger.info("-Rule " + this.currentRule + " CIPChirality for " + cipAtom + "-----");
                            }
                            cipAtom.sortSubstituents();
                            isChiral = true;
                            if (Logger.debugging) {
                                Logger.info(this.currentRule + ">>>>" + cipAtom);
                                for (i = 0; i < nSubs; ++i) {
                                    Logger.info(cipAtom.atoms[i] + " " + Integer.toHexString(cipAtom.prevPriorities[i]));
                                }
                            }
                            for (i = 0; i < nSubs - 1; ++i) {
                                if (cipAtom.prevPriorities[i] != cipAtom.prevPriorities[i + 1]) continue;
                                isChiral = false;
                                break;
                            }
                            ++this.currentRule;
                        }
                        if (isChiral) {
                            rs = !isAlkene ? CIPChirality.checkHandedness(cipAtom) : (cipAtom.atoms[0].isDuplicate ? 2 : 1);
                        }
                    }
                    catch (Throwable e) {
                        System.out.println(e + " in CIPChirality");
                        if (this.vwr.isJS) break block15;
                        e.printStackTrace();
                    }
                }
                if (Logger.debugging) {
                    Logger.info(atom + " " + (isAlkene ? "" + rs : (rs == 1 ? "R" : (rs == 2 ? "S" : ""))));
                }
            }
        }
        if (Logger.debugging) {
            Logger.info("----------------------------------");
        }
        return rs;
    }

    private int getBondChiralityLimited(Edge bond, int ruleMax) {
        if (Logger.debugging) {
            Logger.info("get Bond Chirality " + bond);
        }
        int ez = 0;
        Atom[] atoms = this.vwr.ms.at;
        if (bond.getCovalentOrder() == 2) {
            Atom a = atoms[bond.getAtomIndex1()];
            Atom b = atoms[bond.getAtomIndex2()];
            this.htPathPoints = new Hashtable<String, Integer>();
            CIPAtom a1 = new CIPAtom(a, null, false);
            CIPAtom b1 = new CIPAtom(b, null, false);
            int atop = this.getAtomChiralityLimited(a, a1, b1, ruleMax, -1) - 1;
            this.htPathPoints = new Hashtable<String, Integer>();
            CIPAtom a2 = new CIPAtom(a, null, false);
            CIPAtom b2 = new CIPAtom(b, null, false);
            int btop = this.getAtomChiralityLimited(b, b2, a2, ruleMax, -1) - 1;
            if (atop >= 0 && btop >= 0) {
                int n = ez = CIPChirality.isCIS(b2.atoms[btop], b2, a1, a1.atoms[atop]) ? 1 : 2;
            }
            if (ez != 0) {
                a.setCIPChirality(ez << 3);
                b.setCIPChirality(ez << 3);
            }
            if (Logger.debugging) {
                Logger.info(bond + " " + (ez == 1 ? "Z" : (ez == 2 ? "E" : "_")));
            }
        }
        return ez;
    }

    static int checkHandedness(CIPAtom a) {
        P3 p1 = (P3)((Object)a.atoms[0].atom);
        P3 p2 = (P3)((Object)a.atoms[1].atom);
        P3 p3 = (P3)((Object)a.atoms[2].atom);
        P3 p4 = (P3)((Object)a.atoms[3].atom);
        V3 vNorm = new V3();
        float d = Measure.getNormalThroughPoints(p1, p2, p3, vNorm, new V3());
        return Measure.distanceToPlaneV(vNorm, d, p4) > 0.0f ? 1 : 2;
    }

    static boolean isCIS(CIPAtom me, CIPAtom parent, CIPAtom grandParent, CIPAtom greatGrandParent) {
        V3 vNorm1 = new V3();
        V3 vTemp = new V3();
        Measure.getNormalThroughPoints((P3)((Object)me.atom), (P3)((Object)parent.atom), (P3)((Object)grandParent.atom), vNorm1, vTemp);
        V3 vNorm2 = new V3();
        Measure.getNormalThroughPoints((P3)((Object)parent.atom), (P3)((Object)grandParent.atom), (P3)((Object)greatGrandParent.atom), vNorm2, vTemp);
        return vNorm1.dot(vNorm2) > 0.0f;
    }

    private class CIPAtom
    implements Comparable<CIPAtom>,
    Cloneable {
        Node atom;
        private int id;
        CIPAtom parent;
        private CIPAtom rootSubstituent;
        private int elemNo;
        private int massNo;
        private int sphere;
        BS bsPath;
        private int rootDistance;
        private int nAtoms;
        private int nPriorities;
        private int h1Count;
        private int auxiliaryEZ = -1;
        private String knownAtomChirality = ".";
        private String knownChiralityPath = "";
        private boolean isSet;
        boolean isDuplicate = true;
        private boolean isTerminal;
        private boolean isAlkeneAtom2;
        CIPAtom[] atoms = new CIPAtom[4];
        private int[] priorities = new int[4];
        int[] prevPriorities = new int[4];

        CIPAtom(Node atom, CIPAtom parent, boolean isDuplicate) {
            this.id = ++CIPChirality.this.ptID;
            this.parent = parent;
            if (atom == null) {
                return;
            }
            this.atom = atom;
            this.knownAtomChirality = atom.getCIPChirality(false);
            if (this.knownAtomChirality.equals("")) {
                this.knownAtomChirality = ".";
            }
            if (parent != null) {
                this.knownChiralityPath = parent.knownAtomChirality + this.knownAtomChirality;
                this.sphere = parent.sphere + 1;
            }
            if (this.sphere == 1) {
                this.rootSubstituent = this;
            } else if (parent != null) {
                this.rootSubstituent = parent.rootSubstituent;
            }
            this.isTerminal = atom.getCovalentBondCount() == 1;
            this.elemNo = atom.getElementNumber();
            this.massNo = atom.getNominalMass();
            this.bsPath = parent == null ? new BS() : BSUtil.copy(parent.bsPath);
            int iatom = atom.getIndex();
            if (parent == null) {
                this.bsPath.set(iatom);
                this.rootDistance = 0;
            } else if (atom == CIPChirality.this.root.atom) {
                this.rootDistance = 0;
                isDuplicate = true;
            } else if (this.bsPath.get(iatom)) {
                isDuplicate = true;
                this.rootDistance = CIPChirality.this.htPathPoints.get(this.rootSubstituent.atom.toString() + atom);
            } else {
                this.bsPath.set(iatom);
                this.rootDistance = parent.rootDistance + 1;
                CIPChirality.this.htPathPoints.put(this.rootSubstituent.atom.toString() + atom, new Integer(this.rootDistance));
            }
            this.isDuplicate = isDuplicate;
            if (Logger.debugging) {
                Logger.info("new CIPAtom " + parent + "->" + this);
            }
        }

        boolean set() {
            if (this.isSet) {
                return true;
            }
            this.isSet = true;
            if (this.isTerminal || this.isDuplicate) {
                return true;
            }
            this.atoms = new CIPAtom[4];
            int nBonds = this.atom.getBondCount();
            Edge[] bonds = this.atom.getEdges();
            if (Logger.debugging) {
                Logger.info("set " + this);
            }
            int pt = 0;
            block5: for (int i = 0; i < nBonds; ++i) {
                Edge bond = bonds[i];
                if (!bond.isCovalent()) continue;
                Node other = bond.getOtherAtomNode(this.atom);
                boolean isParent = this.parent != null && this.parent.atom == other;
                int order = bond.getCovalentOrder();
                if (isParent && order == 2) {
                    this.isAlkeneAtom2 = true;
                    this.knownAtomChirality = bond.getCIPChirality(false);
                }
                switch (order) {
                    case 3: {
                        if (this.addAtom(pt++, other, isParent) == null) {
                            this.isTerminal = true;
                            return false;
                        }
                    }
                    case 2: {
                        if (this.addAtom(pt++, other, order != 2 || isParent) == null) {
                            this.isTerminal = true;
                            return false;
                        }
                    }
                    case 1: {
                        if (isParent || this.addAtom(pt++, other, order != 1) != null) continue block5;
                        this.isTerminal = true;
                        return false;
                    }
                    default: {
                        this.isTerminal = true;
                        return false;
                    }
                }
            }
            this.isTerminal = pt == 0;
            this.nAtoms = pt;
            this.fillNull(pt);
            int ruleNow = CIPChirality.this.currentRule;
            CIPChirality.this.currentRule = 0;
            Arrays.sort(this.atoms);
            CIPChirality.this.currentRule = ruleNow;
            return !this.isTerminal;
        }

        private void fillNull(int pt) {
            while (pt < this.atoms.length) {
                this.atoms[pt] = new CIPAtom(null, this, true);
                ++pt;
            }
        }

        private CIPAtom addAtom(int i, Node other, boolean isDuplicate) {
            int atomIsotope;
            if (i >= this.atoms.length) {
                if (Logger.debugging) {
                    Logger.info(" too many bonds on " + this.atom);
                }
                return null;
            }
            if (this.parent == null && (atomIsotope = other.getAtomicAndIsotopeNumber()) == 1 && ++this.h1Count > 1) {
                if (Logger.debugging) {
                    Logger.info(" second H atom found on " + this.atom);
                }
                return null;
            }
            this.atoms[i] = new CIPAtom(other, this, isDuplicate);
            if (CIPChirality.this.currentRule > 2) {
                this.prevPriorities[i] = this.getBasePriority(this.atoms[i]);
            }
            return this.atoms[i];
        }

        /*
         * Enabled aggressive block sorting
         */
        void sortSubstituents() {
            int i;
            int n = 4;
            if (Logger.debugging) {
                Logger.info("---sortSubstituents---" + this.atom);
                for (int i2 = 0; i2 < n; ++i2) {
                    Logger.info(CIPChirality.this.currentRule + ": " + this + "[" + i2 + "]=" + this.atoms[i2] + " " + Integer.toHexString(this.prevPriorities[i2]));
                }
            }
            int[] indices = new int[4];
            for (i = 0; i < n; ++i) {
                this.priorities[i] = 1;
                if (this.prevPriorities[i] != 0 || CIPChirality.this.currentRule <= 1) continue;
                this.prevPriorities[i] = this.getBasePriority(this.atoms[i]);
            }
            i = 0;
            while (true) {
                CIPAtom a;
                if (i < n) {
                    a = this.atoms[i];
                } else {
                    int i3;
                    CIPAtom[] newAtoms = new CIPAtom[n];
                    int[] newPriorities = new int[n];
                    int[] newPrevPriorities = new int[n];
                    BS bs = new BS();
                    int shift = PRIORITY_SHIFT[CIPChirality.this.currentRule];
                    for (i3 = 0; i3 < n; ++i3) {
                        int p;
                        int pt = indices[i3];
                        CIPAtom a2 = newAtoms[pt] = this.atoms[i3];
                        newPriorities[pt] = p = this.priorities[i3];
                        newPrevPriorities[pt] = this.prevPriorities[i3] | p << shift;
                        if (a2.atom == null) continue;
                        bs.set(this.priorities[i3]);
                    }
                    this.atoms = newAtoms;
                    this.priorities = newPriorities;
                    this.prevPriorities = newPrevPriorities;
                    this.nPriorities = bs.cardinality();
                    if (Logger.debugging) {
                        Logger.info(this.atom + " nPriorities = " + this.nPriorities);
                        for (i3 = 0; i3 < n; ++i3) {
                            Logger.info(this.atom + "[" + i3 + "]=" + this.atoms[i3] + " " + this.priorities[i3]);
                        }
                    }
                    return;
                }
                block17: for (int j = i + 1; j < n; ++j) {
                    CIPAtom b = this.atoms[j];
                    if (Logger.debuggingHigh) {
                        Logger.info("ordering " + this.id + "." + i + "." + j + " " + this + "-" + a + " vs " + b + " " + Integer.toHexString(this.prevPriorities[i]) + " " + Integer.toHexString(this.prevPriorities[j]));
                    }
                    int score = this.compareSubs(a, b, i, j);
                    if (Logger.debuggingHigh) {
                        Logger.info("ordering " + this.id + "." + i + "." + j + " " + this + "-" + a + " vs " + b + " = " + score);
                    }
                    switch (score) {
                        case -2: {
                            System.out.println("OHNO");
                            continue block17;
                        }
                        case 1: {
                            int n2 = i;
                            indices[n2] = indices[n2] + 1;
                            int n3 = i;
                            this.priorities[n3] = this.priorities[n3] + 1;
                            if (!Logger.debuggingHigh) continue block17;
                            Logger.info(this.atom + "." + b + " B-beats " + a + " ind=" + indices[i]);
                            continue block17;
                        }
                        case -1: {
                            int n4 = j;
                            indices[n4] = indices[n4] + 1;
                            int n5 = j;
                            this.priorities[n5] = this.priorities[n5] + 1;
                            if (!Logger.debuggingHigh) continue block17;
                            Logger.info(this.atom + "." + a + " A-beats " + b + " ind=" + indices[j]);
                            continue block17;
                        }
                        case 0: {
                            switch (a.breakTie(b)) {
                                case -2: {
                                    System.out.println("OHNO2");
                                    break;
                                }
                                case 0: {
                                    int n6 = i;
                                    indices[n6] = indices[n6] + 1;
                                    if (!Logger.debuggingHigh) break;
                                    Logger.info(this.atom + "." + b + " ends up with tie with " + a + " ind=" + indices[i]);
                                    break;
                                }
                                case 1: {
                                    int n7 = i;
                                    indices[n7] = indices[n7] + 1;
                                    int n8 = i;
                                    this.priorities[n8] = this.priorities[n8] + 1;
                                    if (!Logger.debuggingHigh) break;
                                    Logger.info(this.atom + "." + b + " wins in tie with " + a + " ind=" + indices[i] + "\n");
                                    break;
                                }
                                case -1: {
                                    int n9 = j;
                                    indices[n9] = indices[n9] + 1;
                                    int n10 = j;
                                    this.priorities[n10] = this.priorities[n10] + 1;
                                    if (!Logger.debuggingHigh) break;
                                    Logger.info(this.atom + "." + a + " wins in tie with " + b + " ind=" + indices[j] + "\n");
                                }
                            }
                            continue block17;
                        }
                    }
                }
                ++i;
            }
        }

        private int compareSubs(CIPAtom a, CIPAtom b, int i, int j) {
            return a.atom == null ? 1 : (b.atom == null ? -1 : (this.prevPriorities[i] == this.prevPriorities[j] ? a.compareTo(b) : (this.prevPriorities[j] < this.prevPriorities[i] ? 1 : -1)));
        }

        private int checkDuplicate(CIPAtom b) {
            return b.isDuplicate == this.isDuplicate ? 0 : (b.isDuplicate ? -1 : 1);
        }

        private int breakTie(CIPAtom b) {
            int score = this.checkDuplicate(b);
            if (score != 0) {
                return score;
            }
            if (this.atom == b.atom && (this.atom == null || CIPChirality.this.currentRule < 3)) {
                return 0;
            }
            if (this.atom == null != (b.atom == null)) {
                return this.atom == null ? 1 : -1;
            }
            if (!this.set() || !b.set() || this.isTerminal || b.isTerminal || this.isDuplicate && b.isDuplicate) {
                return 0;
            }
            if (Logger.debugging) {
                Logger.info("tie for " + this + " and " + b);
            }
            if ((score = this.compareWith(b, false)) != 0) {
                return score;
            }
            this.sortSubstituents();
            b.sortSubstituents();
            return this.compareWith(b, true);
        }

        private int compareWith(CIPAtom b, boolean goDeep) {
            for (int i = 0; i < this.nAtoms; ++i) {
                int score;
                CIPAtom ai = this.atoms[i];
                CIPAtom bi = b.atoms[i];
                if (Logger.debugging) {
                    Logger.info("compareAB " + ai.parent + "-" + ai + " with " + bi.parent + "-" + bi + " goDeep=" + goDeep);
                }
                int n = score = goDeep ? ai.breakTie(bi) : ai.checkCurrentRule(bi);
                if (score == -2) {
                    score = 0;
                }
                if (score == 0) continue;
                if (Logger.debugging) {
                    Logger.info("compareAB " + (score == 1 ? bi + " beats " + ai : ai + " beats " + bi) + " " + goDeep);
                }
                return score;
            }
            if (Logger.debugging) {
                Logger.info("compareAB ends in tie for " + this + " vs. " + b);
            }
            return 0;
        }

        @Override
        public int compareTo(CIPAtom b) {
            if (this.atom == null != (b.atom == null)) {
                return this.atom == null ? 1 : -1;
            }
            int score = this.checkCurrentRule(b);
            return score == -2 ? 0 : (score != 0 ? score : this.checkDuplicate(b));
        }

        public int checkCurrentRule(CIPAtom b) {
            switch (CIPChirality.this.currentRule) {
                default: {
                    return this.checkRule1a(b);
                }
                case 1: {
                    return this.checkRule1b(b);
                }
                case 2: {
                    return this.checkRule2(b);
                }
                case 3: {
                    return this.checkRule3(b);
                }
                case 4: {
                    return this.checkRule4(b);
                }
                case 5: 
            }
            return this.checkRule5(b);
        }

        private int checkRule1a(CIPAtom b) {
            return b.atom == this.atom ? 0 : (b.atom == null ? -1 : (this.atom == null ? 1 : (b.elemNo < this.elemNo ? -1 : (b.elemNo > this.elemNo ? 1 : 0))));
        }

        private int checkRule1b(CIPAtom b) {
            return !b.isDuplicate || !this.isDuplicate ? 0 : (b.rootDistance < this.rootDistance ? 1 : (b.rootDistance > this.rootDistance ? -1 : 0));
        }

        private int checkRule2(CIPAtom b) {
            return b.massNo < this.massNo ? -1 : (b.massNo > this.massNo ? 1 : 0);
        }

        private int checkRule3(CIPAtom b) {
            int zb;
            int za;
            return this.parent == null || !this.parent.isAlkeneAtom2 || !b.parent.isAlkeneAtom2 || this.isDuplicate || b.isDuplicate ? -2 : (this.parent == b.parent ? this.breakTie(b) : ((za = this.parent.getZaux()) < (zb = b.parent.getZaux()) ? -1 : (za > zb ? 1 : 0)));
        }

        private int getZaux() {
            if (this.auxiliaryEZ < 0) {
                this.auxiliaryEZ = this.parent.auxiliaryEZ;
            }
            if (this.auxiliaryEZ < 0) {
                CIPAtom winner1 = null;
                CIPAtom winner2 = null;
                CIPAtom atom1 = null;
                this.auxiliaryEZ = 3;
                this.sortSubstituents();
                winner2 = this.getTopAtom();
                if (winner2 != null) {
                    if (Logger.debugging) {
                        Logger.info("reversing path for " + this.parent);
                    }
                    Lst<CIPAtom> path = this.getReturnPath(this.parent);
                    atom1 = (CIPAtom)this.parent.clone();
                    atom1.addReturnPath(this, path);
                    atom1.sortSubstituents();
                    winner1 = atom1.getTopAtom();
                    if (winner1 != null) {
                        int n = this.auxiliaryEZ = CIPChirality.isCIS(winner2, this, atom1, winner1) ? 1 : 2;
                        if (Logger.debugging) {
                            Logger.info("getZaux " + (this.auxiliaryEZ == 1 ? "Z" : "E") + " for " + this.atom + "=" + this.parent.atom + " : " + winner1 + " " + winner2);
                        }
                    }
                }
            }
            this.parent.auxiliaryEZ = this.auxiliaryEZ;
            return this.auxiliaryEZ;
        }

        private Lst<CIPAtom> getReturnPath(CIPAtom a) {
            Lst<CIPAtom> path = new Lst<CIPAtom>();
            while (a.parent != null && a.parent.atoms[0] != null) {
                if (Logger.debugging) {
                    Logger.info("path:" + a.parent.atom + "->" + a.atom);
                }
                a = a.parent;
                path.addLast(a);
            }
            path.addLast(null);
            return path;
        }

        private void addReturnPath(CIPAtom last, Lst<CIPAtom> path) {
            CIPAtom thisAtom = this;
            int n = path.size();
            for (int i = 0; i < n; ++i) {
                CIPAtom p = (CIPAtom)path.get(i);
                p = p == null ? new CIPAtom(null, this, true) : (CIPAtom)p.clone();
                thisAtom.replaceParentSubstituent(last, p);
                last = last.parent;
                thisAtom = p;
            }
        }

        private void replaceParentSubstituent(CIPAtom newParent, CIPAtom newSub) {
            for (int i = 0; i < 4; ++i) {
                if (this.atoms[i] != newParent) continue;
                this.atoms[i] = newSub;
                if (Logger.debugging) {
                    Logger.info("replace " + this + "[" + i + "]=" + newSub);
                }
                this.prevPriorities[i] = this.getBasePriority(this.atoms[i]);
                this.parent = newParent;
                break;
            }
        }

        private CIPAtom getTopAtom() {
            int i;
            int n = i = this.atoms[0].isDuplicate ? 1 : 0;
            return this.priorities[i] == this.priorities[i + 1] ? null : (this.priorities[i] < this.priorities[i + 1] ? this.atoms[i] : this.atoms[i + 1]);
        }

        private int checkRule4(CIPAtom b) {
            int l;
            if (Logger.debugging) {
                Logger.info("Checking Rule 4 for " + this + " and " + b);
            }
            if ((l = this.getCommonAncestor((CIPAtom)b).knownChiralityPath.length()) >= this.knownChiralityPath.length()) {
                return 0;
            }
            String ac = this.knownChiralityPath.substring(l);
            String bc = b.knownChiralityPath.substring(l);
            if (ac != null && ac.length() == bc.length() && !ac.equals(bc)) {
                int n = ac.length();
                for (int i = 0; i < n - 1; ++i) {
                    for (int j = i + 1; j < n; ++j) {
                        boolean blike;
                        boolean alike = ac.charAt(i) == ac.charAt(j);
                        boolean bl = blike = bc.charAt(i) == bc.charAt(j);
                        if (alike == blike) continue;
                        return alike ? -1 : 1;
                    }
                }
            }
            return 0;
        }

        private CIPAtom getCommonAncestor(CIPAtom b) {
            CIPAtom a = this;
            if (a.parent == null != (b.parent == null)) {
                System.out.println("OHOH3");
            }
            while ((a = a.parent) != (b = b.parent)) {
            }
            return a;
        }

        private int checkRule5(CIPAtom b) {
            boolean isRZ = PT.isOneOf(this.knownAtomChirality, ";rRZ;");
            return isRZ == PT.isOneOf(b.knownAtomChirality, ";RZ;") ? 0 : (isRZ ? -1 : 1);
        }

        public Object clone() {
            CIPAtom a = null;
            try {
                a = (CIPAtom)super.clone();
                a.id = CIPChirality.this.ptID++;
            }
            catch (CloneNotSupportedException e) {
                // empty catch block
            }
            a.atoms = new CIPAtom[4];
            a.priorities = new int[4];
            a.prevPriorities = new int[4];
            for (int i = 0; i < 4; ++i) {
                if (this.atoms[i] == null) continue;
                a.atoms[i] = this.atoms[i];
                a.prevPriorities[i] = this.getBasePriority(this.atoms[i]);
            }
            if (Logger.debugging) {
                Logger.info("cloning " + this + " as " + a);
            }
            return a;
        }

        private int getBasePriority(CIPAtom a) {
            int code = 0;
            code = a.atom == null ? 524287 << PRIORITY_SHIFT[2] : 127 - a.elemNo << PRIORITY_SHIFT[0] | 255 - a.massNo << PRIORITY_SHIFT[2];
            return code;
        }

        public String toString() {
            return (this.atom == null ? "<null>" : "[" + this.sphere + "." + this.id + " " + this.atom.toString() + (this.isDuplicate ? "*" : "")) + "]";
        }
    }
}

